/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_GPIO_H
#define __S6J3360_GPIO_H

#include "s6j3360io_basetypes.h"

/* GPIO base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define GPIO	stcGPIO
#else /* __IO_DEFINE */
#define GPIO	(*((volatile stc_gpio_t*)0xB4738000UL))
#endif /* __IO_DEFINE */

/* POSR[0-3] */
#define GPIO_POSR0	(GPIO.unPOSR0.u32Register)  /*@rg@*/
#define GPIO_POSR0_POS0	(*(volatile uint_io8_t*)0xB71C0000UL)  /*@bfbba@*/
#define GPIO_POSR0_POS1	(*(volatile uint_io8_t*)0xB71C0001UL)  /*@bfbba@*/
#define GPIO_POSR0_POS2	(*(volatile uint_io8_t*)0xB71C0002UL)  /*@bfbba@*/
#define GPIO_POSR0_POS3	(*(volatile uint_io8_t*)0xB71C0003UL)  /*@bfbba@*/
#define GPIO_POSR0_POS4	(*(volatile uint_io8_t*)0xB71C0004UL)  /*@bfbba@*/
#define GPIO_POSR0_POS5	(*(volatile uint_io8_t*)0xB71C0005UL)  /*@bfbba@*/
#define GPIO_POSR0_POS6	(*(volatile uint_io8_t*)0xB71C0006UL)  /*@bfbba@*/
#define GPIO_POSR0_POS7	(*(volatile uint_io8_t*)0xB71C0007UL)  /*@bfbba@*/
#define GPIO_POSR0_POS8	(*(volatile uint_io8_t*)0xB71C0008UL)  /*@bfbba@*/
#define GPIO_POSR0_POS9	(*(volatile uint_io8_t*)0xB71C0009UL)  /*@bfbba@*/
#define GPIO_POSR0_POS10	(*(volatile uint_io8_t*)0xB71C000AUL)  /*@bfbba@*/
#define GPIO_POSR0_POS11	(*(volatile uint_io8_t*)0xB71C000BUL)  /*@bfbba@*/
#define GPIO_POSR0_POS12	(*(volatile uint_io8_t*)0xB71C000CUL)  /*@bfbba@*/
#define GPIO_POSR0_POS13	(*(volatile uint_io8_t*)0xB71C000DUL)  /*@bfbba@*/
#define GPIO_POSR0_POS14	(*(volatile uint_io8_t*)0xB71C000EUL)  /*@bfbba@*/
#define GPIO_POSR0_POS15	(*(volatile uint_io8_t*)0xB71C000FUL)  /*@bfbba@*/
#define GPIO_POSR0_POS16	(*(volatile uint_io8_t*)0xB71C0010UL)  /*@bfbba@*/
#define GPIO_POSR0_POS17	(*(volatile uint_io8_t*)0xB71C0011UL)  /*@bfbba@*/
#define GPIO_POSR0_POS18	(*(volatile uint_io8_t*)0xB71C0012UL)  /*@bfbba@*/
#define GPIO_POSR0_POS19	(*(volatile uint_io8_t*)0xB71C0013UL)  /*@bfbba@*/
#define GPIO_POSR0_POS20	(*(volatile uint_io8_t*)0xB71C0014UL)  /*@bfbba@*/
#define GPIO_POSR0_POS21	(*(volatile uint_io8_t*)0xB71C0015UL)  /*@bfbba@*/
#define GPIO_POSR0_POS22	(*(volatile uint_io8_t*)0xB71C0016UL)  /*@bfbba@*/
#define GPIO_POSR0_POS23	(*(volatile uint_io8_t*)0xB71C0017UL)  /*@bfbba@*/
#define GPIO_POSR0_POS24	(*(volatile uint_io8_t*)0xB71C0018UL)  /*@bfbba@*/
#define GPIO_POSR0_POS25	(*(volatile uint_io8_t*)0xB71C0019UL)  /*@bfbba@*/
#define GPIO_POSR0_POS26	(*(volatile uint_io8_t*)0xB71C001AUL)  /*@bfbba@*/
#define GPIO_POSR0_POS27	(*(volatile uint_io8_t*)0xB71C001BUL)  /*@bfbba@*/
#define GPIO_POSR0_POS28	(*(volatile uint_io8_t*)0xB71C001CUL)  /*@bfbba@*/
#define GPIO_POSR0_POS29	(*(volatile uint_io8_t*)0xB71C001DUL)  /*@bfbba@*/
#define GPIO_POSR0_POS30	(*(volatile uint_io8_t*)0xB71C001EUL)  /*@bfbba@*/
#define GPIO_POSR0_POS31	(*(volatile uint_io8_t*)0xB71C001FUL)  /*@bfbba@*/

#define GPIO_POSR1	(GPIO.unPOSR1.u32Register)  /*@rg@*/
#define GPIO_POSR1_POS0	(*(volatile uint_io8_t*)0xB71C0080UL)  /*@bfbba@*/
#define GPIO_POSR1_POS1	(*(volatile uint_io8_t*)0xB71C0081UL)  /*@bfbba@*/
#define GPIO_POSR1_POS2	(*(volatile uint_io8_t*)0xB71C0082UL)  /*@bfbba@*/
#define GPIO_POSR1_POS3	(*(volatile uint_io8_t*)0xB71C0083UL)  /*@bfbba@*/
#define GPIO_POSR1_POS4	(*(volatile uint_io8_t*)0xB71C0084UL)  /*@bfbba@*/
#define GPIO_POSR1_POS5	(*(volatile uint_io8_t*)0xB71C0085UL)  /*@bfbba@*/
#define GPIO_POSR1_POS6	(*(volatile uint_io8_t*)0xB71C0086UL)  /*@bfbba@*/
#define GPIO_POSR1_POS7	(*(volatile uint_io8_t*)0xB71C0087UL)  /*@bfbba@*/
#define GPIO_POSR1_POS8	(*(volatile uint_io8_t*)0xB71C0088UL)  /*@bfbba@*/
#define GPIO_POSR1_POS9	(*(volatile uint_io8_t*)0xB71C0089UL)  /*@bfbba@*/
#define GPIO_POSR1_POS10	(*(volatile uint_io8_t*)0xB71C008AUL)  /*@bfbba@*/
#define GPIO_POSR1_POS11	(*(volatile uint_io8_t*)0xB71C008BUL)  /*@bfbba@*/
#define GPIO_POSR1_POS12	(*(volatile uint_io8_t*)0xB71C008CUL)  /*@bfbba@*/
#define GPIO_POSR1_POS13	(*(volatile uint_io8_t*)0xB71C008DUL)  /*@bfbba@*/
#define GPIO_POSR1_POS14	(*(volatile uint_io8_t*)0xB71C008EUL)  /*@bfbba@*/
#define GPIO_POSR1_POS15	(*(volatile uint_io8_t*)0xB71C008FUL)  /*@bfbba@*/
#define GPIO_POSR1_POS16	(*(volatile uint_io8_t*)0xB71C0090UL)  /*@bfbba@*/
#define GPIO_POSR1_POS17	(*(volatile uint_io8_t*)0xB71C0091UL)  /*@bfbba@*/
#define GPIO_POSR1_POS18	(*(volatile uint_io8_t*)0xB71C0092UL)  /*@bfbba@*/
#define GPIO_POSR1_POS19	(*(volatile uint_io8_t*)0xB71C0093UL)  /*@bfbba@*/
#define GPIO_POSR1_POS20	(*(volatile uint_io8_t*)0xB71C0094UL)  /*@bfbba@*/
#define GPIO_POSR1_POS21	(*(volatile uint_io8_t*)0xB71C0095UL)  /*@bfbba@*/
#define GPIO_POSR1_POS22	(*(volatile uint_io8_t*)0xB71C0096UL)  /*@bfbba@*/
#define GPIO_POSR1_POS23	(*(volatile uint_io8_t*)0xB71C0097UL)  /*@bfbba@*/
#define GPIO_POSR1_POS24	(*(volatile uint_io8_t*)0xB71C0098UL)  /*@bfbba@*/
#define GPIO_POSR1_POS25	(*(volatile uint_io8_t*)0xB71C0099UL)  /*@bfbba@*/
#define GPIO_POSR1_POS26	(*(volatile uint_io8_t*)0xB71C009AUL)  /*@bfbba@*/
#define GPIO_POSR1_POS27	(*(volatile uint_io8_t*)0xB71C009BUL)  /*@bfbba@*/
#define GPIO_POSR1_POS28	(*(volatile uint_io8_t*)0xB71C009CUL)  /*@bfbba@*/
#define GPIO_POSR1_POS29	(*(volatile uint_io8_t*)0xB71C009DUL)  /*@bfbba@*/
#define GPIO_POSR1_POS30	(*(volatile uint_io8_t*)0xB71C009EUL)  /*@bfbba@*/
#define GPIO_POSR1_POS31	(*(volatile uint_io8_t*)0xB71C009FUL)  /*@bfbba@*/

#define GPIO_POSR2	(GPIO.unPOSR2.u32Register)  /*@rg@*/
#define GPIO_POSR2_POS0	(*(volatile uint_io8_t*)0xB71C0100UL)  /*@bfbba@*/
#define GPIO_POSR2_POS1	(*(volatile uint_io8_t*)0xB71C0101UL)  /*@bfbba@*/
#define GPIO_POSR2_POS2	(*(volatile uint_io8_t*)0xB71C0102UL)  /*@bfbba@*/
#define GPIO_POSR2_POS3	(*(volatile uint_io8_t*)0xB71C0103UL)  /*@bfbba@*/
#define GPIO_POSR2_POS4	(*(volatile uint_io8_t*)0xB71C0104UL)  /*@bfbba@*/
#define GPIO_POSR2_POS5	(*(volatile uint_io8_t*)0xB71C0105UL)  /*@bfbba@*/
#define GPIO_POSR2_POS6	(*(volatile uint_io8_t*)0xB71C0106UL)  /*@bfbba@*/
#define GPIO_POSR2_POS7	(*(volatile uint_io8_t*)0xB71C0107UL)  /*@bfbba@*/
#define GPIO_POSR2_POS8	(*(volatile uint_io8_t*)0xB71C0108UL)  /*@bfbba@*/
#define GPIO_POSR2_POS9	(*(volatile uint_io8_t*)0xB71C0109UL)  /*@bfbba@*/
#define GPIO_POSR2_POS10	(*(volatile uint_io8_t*)0xB71C010AUL)  /*@bfbba@*/
#define GPIO_POSR2_POS11	(*(volatile uint_io8_t*)0xB71C010BUL)  /*@bfbba@*/
#define GPIO_POSR2_POS12	(*(volatile uint_io8_t*)0xB71C010CUL)  /*@bfbba@*/
#define GPIO_POSR2_POS13	(*(volatile uint_io8_t*)0xB71C010DUL)  /*@bfbba@*/
#define GPIO_POSR2_POS14	(*(volatile uint_io8_t*)0xB71C010EUL)  /*@bfbba@*/
#define GPIO_POSR2_POS15	(*(volatile uint_io8_t*)0xB71C010FUL)  /*@bfbba@*/
#define GPIO_POSR2_POS16	(*(volatile uint_io8_t*)0xB71C0110UL)  /*@bfbba@*/
#define GPIO_POSR2_POS17	(*(volatile uint_io8_t*)0xB71C0111UL)  /*@bfbba@*/
#define GPIO_POSR2_POS18	(*(volatile uint_io8_t*)0xB71C0112UL)  /*@bfbba@*/
#define GPIO_POSR2_POS19	(*(volatile uint_io8_t*)0xB71C0113UL)  /*@bfbba@*/
#define GPIO_POSR2_POS20	(*(volatile uint_io8_t*)0xB71C0114UL)  /*@bfbba@*/
#define GPIO_POSR2_POS21	(*(volatile uint_io8_t*)0xB71C0115UL)  /*@bfbba@*/
#define GPIO_POSR2_POS22	(*(volatile uint_io8_t*)0xB71C0116UL)  /*@bfbba@*/
#define GPIO_POSR2_POS23	(*(volatile uint_io8_t*)0xB71C0117UL)  /*@bfbba@*/
#define GPIO_POSR2_POS24	(*(volatile uint_io8_t*)0xB71C0118UL)  /*@bfbba@*/
#define GPIO_POSR2_POS25	(*(volatile uint_io8_t*)0xB71C0119UL)  /*@bfbba@*/
#define GPIO_POSR2_POS26	(*(volatile uint_io8_t*)0xB71C011AUL)  /*@bfbba@*/
#define GPIO_POSR2_POS27	(*(volatile uint_io8_t*)0xB71C011BUL)  /*@bfbba@*/
#define GPIO_POSR2_POS28	(*(volatile uint_io8_t*)0xB71C011CUL)  /*@bfbba@*/
#define GPIO_POSR2_POS29	(*(volatile uint_io8_t*)0xB71C011DUL)  /*@bfbba@*/
#define GPIO_POSR2_POS30	(*(volatile uint_io8_t*)0xB71C011EUL)  /*@bfbba@*/
#define GPIO_POSR2_POS31	(*(volatile uint_io8_t*)0xB71C011FUL)  /*@bfbba@*/

#define GPIO_POSR3	(GPIO.unPOSR3.u32Register)  /*@rg@*/
#define GPIO_POSR3_POS0	(*(volatile uint_io8_t*)0xB71C0180UL)  /*@bfbba@*/
#define GPIO_POSR3_POS1	(*(volatile uint_io8_t*)0xB71C0181UL)  /*@bfbba@*/
#define GPIO_POSR3_POS2	(*(volatile uint_io8_t*)0xB71C0182UL)  /*@bfbba@*/
#define GPIO_POSR3_POS3	(*(volatile uint_io8_t*)0xB71C0183UL)  /*@bfbba@*/
#define GPIO_POSR3_POS4	(*(volatile uint_io8_t*)0xB71C0184UL)  /*@bfbba@*/
#define GPIO_POSR3_POS5	(*(volatile uint_io8_t*)0xB71C0185UL)  /*@bfbba@*/
#define GPIO_POSR3_POS6	(*(volatile uint_io8_t*)0xB71C0186UL)  /*@bfbba@*/
#define GPIO_POSR3_POS7	(*(volatile uint_io8_t*)0xB71C0187UL)  /*@bfbba@*/
#define GPIO_POSR3_POS8	(*(volatile uint_io8_t*)0xB71C0188UL)  /*@bfbba@*/
#define GPIO_POSR3_POS9	(*(volatile uint_io8_t*)0xB71C0189UL)  /*@bfbba@*/
#define GPIO_POSR3_POS10	(*(volatile uint_io8_t*)0xB71C018AUL)  /*@bfbba@*/
#define GPIO_POSR3_POS11	(*(volatile uint_io8_t*)0xB71C018BUL)  /*@bfbba@*/
#define GPIO_POSR3_POS12	(*(volatile uint_io8_t*)0xB71C018CUL)  /*@bfbba@*/
#define GPIO_POSR3_POS13	(*(volatile uint_io8_t*)0xB71C018DUL)  /*@bfbba@*/
#define GPIO_POSR3_POS14	(*(volatile uint_io8_t*)0xB71C018EUL)  /*@bfbba@*/
#define GPIO_POSR3_POS15	(*(volatile uint_io8_t*)0xB71C018FUL)  /*@bfbba@*/
#define GPIO_POSR3_POS16	(*(volatile uint_io8_t*)0xB71C0190UL)  /*@bfbba@*/
#define GPIO_POSR3_POS17	(*(volatile uint_io8_t*)0xB71C0191UL)  /*@bfbba@*/
#define GPIO_POSR3_POS18	(*(volatile uint_io8_t*)0xB71C0192UL)  /*@bfbba@*/
#define GPIO_POSR3_POS19	(*(volatile uint_io8_t*)0xB71C0193UL)  /*@bfbba@*/
#define GPIO_POSR3_POS20	(*(volatile uint_io8_t*)0xB71C0194UL)  /*@bfbba@*/
#define GPIO_POSR3_POS21	(*(volatile uint_io8_t*)0xB71C0195UL)  /*@bfbba@*/
#define GPIO_POSR3_POS22	(*(volatile uint_io8_t*)0xB71C0196UL)  /*@bfbba@*/
#define GPIO_POSR3_POS23	(*(volatile uint_io8_t*)0xB71C0197UL)  /*@bfbba@*/
#define GPIO_POSR3_POS24	(*(volatile uint_io8_t*)0xB71C0198UL)  /*@bfbba@*/
#define GPIO_POSR3_POS25	(*(volatile uint_io8_t*)0xB71C0199UL)  /*@bfbba@*/
#define GPIO_POSR3_POS26	(*(volatile uint_io8_t*)0xB71C019AUL)  /*@bfbba@*/
#define GPIO_POSR3_POS27	(*(volatile uint_io8_t*)0xB71C019BUL)  /*@bfbba@*/
#define GPIO_POSR3_POS28	(*(volatile uint_io8_t*)0xB71C019CUL)  /*@bfbba@*/
#define GPIO_POSR3_POS29	(*(volatile uint_io8_t*)0xB71C019DUL)  /*@bfbba@*/
#define GPIO_POSR3_POS30	(*(volatile uint_io8_t*)0xB71C019EUL)  /*@bfbba@*/
#define GPIO_POSR3_POS31	(*(volatile uint_io8_t*)0xB71C019FUL)  /*@bfbba@*/

typedef struct stc_gpio_posrn_field{
    uint_io32_t		u1POS0:1;
    uint_io32_t		u1POS1:1;
    uint_io32_t		u1POS2:1;
    uint_io32_t		u1POS3:1;
    uint_io32_t		u1POS4:1;
    uint_io32_t		u1POS5:1;
    uint_io32_t		u1POS6:1;
    uint_io32_t		u1POS7:1;
    uint_io32_t		u1POS8:1;
    uint_io32_t		u1POS9:1;
    uint_io32_t		u1POS10:1;
    uint_io32_t		u1POS11:1;
    uint_io32_t		u1POS12:1;
    uint_io32_t		u1POS13:1;
    uint_io32_t		u1POS14:1;
    uint_io32_t		u1POS15:1;
    uint_io32_t		u1POS16:1;
    uint_io32_t		u1POS17:1;
    uint_io32_t		u1POS18:1;
    uint_io32_t		u1POS19:1;
    uint_io32_t		u1POS20:1;
    uint_io32_t		u1POS21:1;
    uint_io32_t		u1POS22:1;
    uint_io32_t		u1POS23:1;
    uint_io32_t		u1POS24:1;
    uint_io32_t		u1POS25:1;
    uint_io32_t		u1POS26:1;
    uint_io32_t		u1POS27:1;
    uint_io32_t		u1POS28:1;
    uint_io32_t		u1POS29:1;
    uint_io32_t		u1POS30:1;
    uint_io32_t		u1POS31:1;
}stc_gpio_posrn_field_t;

typedef union un_gpio_posrn{
    uint_io32_t		u32Register;
    stc_gpio_posrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_posrn_t;

/* POCR[0-3] */
#define GPIO_POCR0	(GPIO.unPOCR0.u32Register)  /*@rg@*/
#define GPIO_POCR0_POC0	(*(volatile uint_io8_t*)0xB71C0020UL)  /*@bfbba@*/
#define GPIO_POCR0_POC1	(*(volatile uint_io8_t*)0xB71C0021UL)  /*@bfbba@*/
#define GPIO_POCR0_POC2	(*(volatile uint_io8_t*)0xB71C0022UL)  /*@bfbba@*/
#define GPIO_POCR0_POC3	(*(volatile uint_io8_t*)0xB71C0023UL)  /*@bfbba@*/
#define GPIO_POCR0_POC4	(*(volatile uint_io8_t*)0xB71C0024UL)  /*@bfbba@*/
#define GPIO_POCR0_POC5	(*(volatile uint_io8_t*)0xB71C0025UL)  /*@bfbba@*/
#define GPIO_POCR0_POC6	(*(volatile uint_io8_t*)0xB71C0026UL)  /*@bfbba@*/
#define GPIO_POCR0_POC7	(*(volatile uint_io8_t*)0xB71C0027UL)  /*@bfbba@*/
#define GPIO_POCR0_POC8	(*(volatile uint_io8_t*)0xB71C0028UL)  /*@bfbba@*/
#define GPIO_POCR0_POC9	(*(volatile uint_io8_t*)0xB71C0029UL)  /*@bfbba@*/
#define GPIO_POCR0_POC10	(*(volatile uint_io8_t*)0xB71C002AUL)  /*@bfbba@*/
#define GPIO_POCR0_POC11	(*(volatile uint_io8_t*)0xB71C002BUL)  /*@bfbba@*/
#define GPIO_POCR0_POC12	(*(volatile uint_io8_t*)0xB71C002CUL)  /*@bfbba@*/
#define GPIO_POCR0_POC13	(*(volatile uint_io8_t*)0xB71C002DUL)  /*@bfbba@*/
#define GPIO_POCR0_POC14	(*(volatile uint_io8_t*)0xB71C002EUL)  /*@bfbba@*/
#define GPIO_POCR0_POC15	(*(volatile uint_io8_t*)0xB71C002FUL)  /*@bfbba@*/
#define GPIO_POCR0_POC16	(*(volatile uint_io8_t*)0xB71C0030UL)  /*@bfbba@*/
#define GPIO_POCR0_POC17	(*(volatile uint_io8_t*)0xB71C0031UL)  /*@bfbba@*/
#define GPIO_POCR0_POC18	(*(volatile uint_io8_t*)0xB71C0032UL)  /*@bfbba@*/
#define GPIO_POCR0_POC19	(*(volatile uint_io8_t*)0xB71C0033UL)  /*@bfbba@*/
#define GPIO_POCR0_POC20	(*(volatile uint_io8_t*)0xB71C0034UL)  /*@bfbba@*/
#define GPIO_POCR0_POC21	(*(volatile uint_io8_t*)0xB71C0035UL)  /*@bfbba@*/
#define GPIO_POCR0_POC22	(*(volatile uint_io8_t*)0xB71C0036UL)  /*@bfbba@*/
#define GPIO_POCR0_POC23	(*(volatile uint_io8_t*)0xB71C0037UL)  /*@bfbba@*/
#define GPIO_POCR0_POC24	(*(volatile uint_io8_t*)0xB71C0038UL)  /*@bfbba@*/
#define GPIO_POCR0_POC25	(*(volatile uint_io8_t*)0xB71C0039UL)  /*@bfbba@*/
#define GPIO_POCR0_POC26	(*(volatile uint_io8_t*)0xB71C003AUL)  /*@bfbba@*/
#define GPIO_POCR0_POC27	(*(volatile uint_io8_t*)0xB71C003BUL)  /*@bfbba@*/
#define GPIO_POCR0_POC28	(*(volatile uint_io8_t*)0xB71C003CUL)  /*@bfbba@*/
#define GPIO_POCR0_POC29	(*(volatile uint_io8_t*)0xB71C003DUL)  /*@bfbba@*/
#define GPIO_POCR0_POC30	(*(volatile uint_io8_t*)0xB71C003EUL)  /*@bfbba@*/
#define GPIO_POCR0_POC31	(*(volatile uint_io8_t*)0xB71C003FUL)  /*@bfbba@*/

#define GPIO_POCR1	(GPIO.unPOCR1.u32Register)  /*@rg@*/
#define GPIO_POCR1_POC0	(*(volatile uint_io8_t*)0xB71C00A0UL)  /*@bfbba@*/
#define GPIO_POCR1_POC1	(*(volatile uint_io8_t*)0xB71C00A1UL)  /*@bfbba@*/
#define GPIO_POCR1_POC2	(*(volatile uint_io8_t*)0xB71C00A2UL)  /*@bfbba@*/
#define GPIO_POCR1_POC3	(*(volatile uint_io8_t*)0xB71C00A3UL)  /*@bfbba@*/
#define GPIO_POCR1_POC4	(*(volatile uint_io8_t*)0xB71C00A4UL)  /*@bfbba@*/
#define GPIO_POCR1_POC5	(*(volatile uint_io8_t*)0xB71C00A5UL)  /*@bfbba@*/
#define GPIO_POCR1_POC6	(*(volatile uint_io8_t*)0xB71C00A6UL)  /*@bfbba@*/
#define GPIO_POCR1_POC7	(*(volatile uint_io8_t*)0xB71C00A7UL)  /*@bfbba@*/
#define GPIO_POCR1_POC8	(*(volatile uint_io8_t*)0xB71C00A8UL)  /*@bfbba@*/
#define GPIO_POCR1_POC9	(*(volatile uint_io8_t*)0xB71C00A9UL)  /*@bfbba@*/
#define GPIO_POCR1_POC10	(*(volatile uint_io8_t*)0xB71C00AAUL)  /*@bfbba@*/
#define GPIO_POCR1_POC11	(*(volatile uint_io8_t*)0xB71C00ABUL)  /*@bfbba@*/
#define GPIO_POCR1_POC12	(*(volatile uint_io8_t*)0xB71C00ACUL)  /*@bfbba@*/
#define GPIO_POCR1_POC13	(*(volatile uint_io8_t*)0xB71C00ADUL)  /*@bfbba@*/
#define GPIO_POCR1_POC14	(*(volatile uint_io8_t*)0xB71C00AEUL)  /*@bfbba@*/
#define GPIO_POCR1_POC15	(*(volatile uint_io8_t*)0xB71C00AFUL)  /*@bfbba@*/
#define GPIO_POCR1_POC16	(*(volatile uint_io8_t*)0xB71C00B0UL)  /*@bfbba@*/
#define GPIO_POCR1_POC17	(*(volatile uint_io8_t*)0xB71C00B1UL)  /*@bfbba@*/
#define GPIO_POCR1_POC18	(*(volatile uint_io8_t*)0xB71C00B2UL)  /*@bfbba@*/
#define GPIO_POCR1_POC19	(*(volatile uint_io8_t*)0xB71C00B3UL)  /*@bfbba@*/
#define GPIO_POCR1_POC20	(*(volatile uint_io8_t*)0xB71C00B4UL)  /*@bfbba@*/
#define GPIO_POCR1_POC21	(*(volatile uint_io8_t*)0xB71C00B5UL)  /*@bfbba@*/
#define GPIO_POCR1_POC22	(*(volatile uint_io8_t*)0xB71C00B6UL)  /*@bfbba@*/
#define GPIO_POCR1_POC23	(*(volatile uint_io8_t*)0xB71C00B7UL)  /*@bfbba@*/
#define GPIO_POCR1_POC24	(*(volatile uint_io8_t*)0xB71C00B8UL)  /*@bfbba@*/
#define GPIO_POCR1_POC25	(*(volatile uint_io8_t*)0xB71C00B9UL)  /*@bfbba@*/
#define GPIO_POCR1_POC26	(*(volatile uint_io8_t*)0xB71C00BAUL)  /*@bfbba@*/
#define GPIO_POCR1_POC27	(*(volatile uint_io8_t*)0xB71C00BBUL)  /*@bfbba@*/
#define GPIO_POCR1_POC28	(*(volatile uint_io8_t*)0xB71C00BCUL)  /*@bfbba@*/
#define GPIO_POCR1_POC29	(*(volatile uint_io8_t*)0xB71C00BDUL)  /*@bfbba@*/
#define GPIO_POCR1_POC30	(*(volatile uint_io8_t*)0xB71C00BEUL)  /*@bfbba@*/
#define GPIO_POCR1_POC31	(*(volatile uint_io8_t*)0xB71C00BFUL)  /*@bfbba@*/

#define GPIO_POCR2	(GPIO.unPOCR2.u32Register)  /*@rg@*/
#define GPIO_POCR2_POC0	(*(volatile uint_io8_t*)0xB71C0120UL)  /*@bfbba@*/
#define GPIO_POCR2_POC1	(*(volatile uint_io8_t*)0xB71C0121UL)  /*@bfbba@*/
#define GPIO_POCR2_POC2	(*(volatile uint_io8_t*)0xB71C0122UL)  /*@bfbba@*/
#define GPIO_POCR2_POC3	(*(volatile uint_io8_t*)0xB71C0123UL)  /*@bfbba@*/
#define GPIO_POCR2_POC4	(*(volatile uint_io8_t*)0xB71C0124UL)  /*@bfbba@*/
#define GPIO_POCR2_POC5	(*(volatile uint_io8_t*)0xB71C0125UL)  /*@bfbba@*/
#define GPIO_POCR2_POC6	(*(volatile uint_io8_t*)0xB71C0126UL)  /*@bfbba@*/
#define GPIO_POCR2_POC7	(*(volatile uint_io8_t*)0xB71C0127UL)  /*@bfbba@*/
#define GPIO_POCR2_POC8	(*(volatile uint_io8_t*)0xB71C0128UL)  /*@bfbba@*/
#define GPIO_POCR2_POC9	(*(volatile uint_io8_t*)0xB71C0129UL)  /*@bfbba@*/
#define GPIO_POCR2_POC10	(*(volatile uint_io8_t*)0xB71C012AUL)  /*@bfbba@*/
#define GPIO_POCR2_POC11	(*(volatile uint_io8_t*)0xB71C012BUL)  /*@bfbba@*/
#define GPIO_POCR2_POC12	(*(volatile uint_io8_t*)0xB71C012CUL)  /*@bfbba@*/
#define GPIO_POCR2_POC13	(*(volatile uint_io8_t*)0xB71C012DUL)  /*@bfbba@*/
#define GPIO_POCR2_POC14	(*(volatile uint_io8_t*)0xB71C012EUL)  /*@bfbba@*/
#define GPIO_POCR2_POC15	(*(volatile uint_io8_t*)0xB71C012FUL)  /*@bfbba@*/
#define GPIO_POCR2_POC16	(*(volatile uint_io8_t*)0xB71C0130UL)  /*@bfbba@*/
#define GPIO_POCR2_POC17	(*(volatile uint_io8_t*)0xB71C0131UL)  /*@bfbba@*/
#define GPIO_POCR2_POC18	(*(volatile uint_io8_t*)0xB71C0132UL)  /*@bfbba@*/
#define GPIO_POCR2_POC19	(*(volatile uint_io8_t*)0xB71C0133UL)  /*@bfbba@*/
#define GPIO_POCR2_POC20	(*(volatile uint_io8_t*)0xB71C0134UL)  /*@bfbba@*/
#define GPIO_POCR2_POC21	(*(volatile uint_io8_t*)0xB71C0135UL)  /*@bfbba@*/
#define GPIO_POCR2_POC22	(*(volatile uint_io8_t*)0xB71C0136UL)  /*@bfbba@*/
#define GPIO_POCR2_POC23	(*(volatile uint_io8_t*)0xB71C0137UL)  /*@bfbba@*/
#define GPIO_POCR2_POC24	(*(volatile uint_io8_t*)0xB71C0138UL)  /*@bfbba@*/
#define GPIO_POCR2_POC25	(*(volatile uint_io8_t*)0xB71C0139UL)  /*@bfbba@*/
#define GPIO_POCR2_POC26	(*(volatile uint_io8_t*)0xB71C013AUL)  /*@bfbba@*/
#define GPIO_POCR2_POC27	(*(volatile uint_io8_t*)0xB71C013BUL)  /*@bfbba@*/
#define GPIO_POCR2_POC28	(*(volatile uint_io8_t*)0xB71C013CUL)  /*@bfbba@*/
#define GPIO_POCR2_POC29	(*(volatile uint_io8_t*)0xB71C013DUL)  /*@bfbba@*/
#define GPIO_POCR2_POC30	(*(volatile uint_io8_t*)0xB71C013EUL)  /*@bfbba@*/
#define GPIO_POCR2_POC31	(*(volatile uint_io8_t*)0xB71C013FUL)  /*@bfbba@*/

#define GPIO_POCR3	(GPIO.unPOCR3.u32Register)  /*@rg@*/
#define GPIO_POCR3_POC0	(*(volatile uint_io8_t*)0xB71C01A0UL)  /*@bfbba@*/
#define GPIO_POCR3_POC1	(*(volatile uint_io8_t*)0xB71C01A1UL)  /*@bfbba@*/
#define GPIO_POCR3_POC2	(*(volatile uint_io8_t*)0xB71C01A2UL)  /*@bfbba@*/
#define GPIO_POCR3_POC3	(*(volatile uint_io8_t*)0xB71C01A3UL)  /*@bfbba@*/
#define GPIO_POCR3_POC4	(*(volatile uint_io8_t*)0xB71C01A4UL)  /*@bfbba@*/
#define GPIO_POCR3_POC5	(*(volatile uint_io8_t*)0xB71C01A5UL)  /*@bfbba@*/
#define GPIO_POCR3_POC6	(*(volatile uint_io8_t*)0xB71C01A6UL)  /*@bfbba@*/
#define GPIO_POCR3_POC7	(*(volatile uint_io8_t*)0xB71C01A7UL)  /*@bfbba@*/
#define GPIO_POCR3_POC8	(*(volatile uint_io8_t*)0xB71C01A8UL)  /*@bfbba@*/
#define GPIO_POCR3_POC9	(*(volatile uint_io8_t*)0xB71C01A9UL)  /*@bfbba@*/
#define GPIO_POCR3_POC10	(*(volatile uint_io8_t*)0xB71C01AAUL)  /*@bfbba@*/
#define GPIO_POCR3_POC11	(*(volatile uint_io8_t*)0xB71C01ABUL)  /*@bfbba@*/
#define GPIO_POCR3_POC12	(*(volatile uint_io8_t*)0xB71C01ACUL)  /*@bfbba@*/
#define GPIO_POCR3_POC13	(*(volatile uint_io8_t*)0xB71C01ADUL)  /*@bfbba@*/
#define GPIO_POCR3_POC14	(*(volatile uint_io8_t*)0xB71C01AEUL)  /*@bfbba@*/
#define GPIO_POCR3_POC15	(*(volatile uint_io8_t*)0xB71C01AFUL)  /*@bfbba@*/
#define GPIO_POCR3_POC16	(*(volatile uint_io8_t*)0xB71C01B0UL)  /*@bfbba@*/
#define GPIO_POCR3_POC17	(*(volatile uint_io8_t*)0xB71C01B1UL)  /*@bfbba@*/
#define GPIO_POCR3_POC18	(*(volatile uint_io8_t*)0xB71C01B2UL)  /*@bfbba@*/
#define GPIO_POCR3_POC19	(*(volatile uint_io8_t*)0xB71C01B3UL)  /*@bfbba@*/
#define GPIO_POCR3_POC20	(*(volatile uint_io8_t*)0xB71C01B4UL)  /*@bfbba@*/
#define GPIO_POCR3_POC21	(*(volatile uint_io8_t*)0xB71C01B5UL)  /*@bfbba@*/
#define GPIO_POCR3_POC22	(*(volatile uint_io8_t*)0xB71C01B6UL)  /*@bfbba@*/
#define GPIO_POCR3_POC23	(*(volatile uint_io8_t*)0xB71C01B7UL)  /*@bfbba@*/
#define GPIO_POCR3_POC24	(*(volatile uint_io8_t*)0xB71C01B8UL)  /*@bfbba@*/
#define GPIO_POCR3_POC25	(*(volatile uint_io8_t*)0xB71C01B9UL)  /*@bfbba@*/
#define GPIO_POCR3_POC26	(*(volatile uint_io8_t*)0xB71C01BAUL)  /*@bfbba@*/
#define GPIO_POCR3_POC27	(*(volatile uint_io8_t*)0xB71C01BBUL)  /*@bfbba@*/
#define GPIO_POCR3_POC28	(*(volatile uint_io8_t*)0xB71C01BCUL)  /*@bfbba@*/
#define GPIO_POCR3_POC29	(*(volatile uint_io8_t*)0xB71C01BDUL)  /*@bfbba@*/
#define GPIO_POCR3_POC30	(*(volatile uint_io8_t*)0xB71C01BEUL)  /*@bfbba@*/
#define GPIO_POCR3_POC31	(*(volatile uint_io8_t*)0xB71C01BFUL)  /*@bfbba@*/

typedef struct stc_gpio_pocrn_field{
    uint_io32_t		u1POC0:1;
    uint_io32_t		u1POC1:1;
    uint_io32_t		u1POC2:1;
    uint_io32_t		u1POC3:1;
    uint_io32_t		u1POC4:1;
    uint_io32_t		u1POC5:1;
    uint_io32_t		u1POC6:1;
    uint_io32_t		u1POC7:1;
    uint_io32_t		u1POC8:1;
    uint_io32_t		u1POC9:1;
    uint_io32_t		u1POC10:1;
    uint_io32_t		u1POC11:1;
    uint_io32_t		u1POC12:1;
    uint_io32_t		u1POC13:1;
    uint_io32_t		u1POC14:1;
    uint_io32_t		u1POC15:1;
    uint_io32_t		u1POC16:1;
    uint_io32_t		u1POC17:1;
    uint_io32_t		u1POC18:1;
    uint_io32_t		u1POC19:1;
    uint_io32_t		u1POC20:1;
    uint_io32_t		u1POC21:1;
    uint_io32_t		u1POC22:1;
    uint_io32_t		u1POC23:1;
    uint_io32_t		u1POC24:1;
    uint_io32_t		u1POC25:1;
    uint_io32_t		u1POC26:1;
    uint_io32_t		u1POC27:1;
    uint_io32_t		u1POC28:1;
    uint_io32_t		u1POC29:1;
    uint_io32_t		u1POC30:1;
    uint_io32_t		u1POC31:1;
}stc_gpio_pocrn_field_t;

typedef union un_gpio_pocrn{
    uint_io32_t		u32Register;
    stc_gpio_pocrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_pocrn_t;

/* DDSR[0-3] */
#define GPIO_DDSR0	(GPIO.unDDSR0.u32Register)  /*@rg@*/
#define GPIO_DDSR0_DDS0	(*(volatile uint_io8_t*)0xB71C0040UL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS1	(*(volatile uint_io8_t*)0xB71C0041UL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS2	(*(volatile uint_io8_t*)0xB71C0042UL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS3	(*(volatile uint_io8_t*)0xB71C0043UL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS4	(*(volatile uint_io8_t*)0xB71C0044UL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS5	(*(volatile uint_io8_t*)0xB71C0045UL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS6	(*(volatile uint_io8_t*)0xB71C0046UL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS7	(*(volatile uint_io8_t*)0xB71C0047UL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS8	(*(volatile uint_io8_t*)0xB71C0048UL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS9	(*(volatile uint_io8_t*)0xB71C0049UL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS10	(*(volatile uint_io8_t*)0xB71C004AUL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS11	(*(volatile uint_io8_t*)0xB71C004BUL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS12	(*(volatile uint_io8_t*)0xB71C004CUL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS13	(*(volatile uint_io8_t*)0xB71C004DUL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS14	(*(volatile uint_io8_t*)0xB71C004EUL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS15	(*(volatile uint_io8_t*)0xB71C004FUL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS16	(*(volatile uint_io8_t*)0xB71C0050UL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS17	(*(volatile uint_io8_t*)0xB71C0051UL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS18	(*(volatile uint_io8_t*)0xB71C0052UL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS19	(*(volatile uint_io8_t*)0xB71C0053UL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS20	(*(volatile uint_io8_t*)0xB71C0054UL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS21	(*(volatile uint_io8_t*)0xB71C0055UL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS22	(*(volatile uint_io8_t*)0xB71C0056UL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS23	(*(volatile uint_io8_t*)0xB71C0057UL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS24	(*(volatile uint_io8_t*)0xB71C0058UL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS25	(*(volatile uint_io8_t*)0xB71C0059UL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS26	(*(volatile uint_io8_t*)0xB71C005AUL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS27	(*(volatile uint_io8_t*)0xB71C005BUL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS28	(*(volatile uint_io8_t*)0xB71C005CUL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS29	(*(volatile uint_io8_t*)0xB71C005DUL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS30	(*(volatile uint_io8_t*)0xB71C005EUL)  /*@bfbba@*/
#define GPIO_DDSR0_DDS31	(*(volatile uint_io8_t*)0xB71C005FUL)  /*@bfbba@*/

#define GPIO_DDSR1	(GPIO.unDDSR1.u32Register)  /*@rg@*/
#define GPIO_DDSR1_DDS0	(*(volatile uint_io8_t*)0xB71C00C0UL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS1	(*(volatile uint_io8_t*)0xB71C00C1UL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS2	(*(volatile uint_io8_t*)0xB71C00C2UL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS3	(*(volatile uint_io8_t*)0xB71C00C3UL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS4	(*(volatile uint_io8_t*)0xB71C00C4UL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS5	(*(volatile uint_io8_t*)0xB71C00C5UL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS6	(*(volatile uint_io8_t*)0xB71C00C6UL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS7	(*(volatile uint_io8_t*)0xB71C00C7UL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS8	(*(volatile uint_io8_t*)0xB71C00C8UL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS9	(*(volatile uint_io8_t*)0xB71C00C9UL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS10	(*(volatile uint_io8_t*)0xB71C00CAUL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS11	(*(volatile uint_io8_t*)0xB71C00CBUL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS12	(*(volatile uint_io8_t*)0xB71C00CCUL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS13	(*(volatile uint_io8_t*)0xB71C00CDUL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS14	(*(volatile uint_io8_t*)0xB71C00CEUL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS15	(*(volatile uint_io8_t*)0xB71C00CFUL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS16	(*(volatile uint_io8_t*)0xB71C00D0UL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS17	(*(volatile uint_io8_t*)0xB71C00D1UL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS18	(*(volatile uint_io8_t*)0xB71C00D2UL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS19	(*(volatile uint_io8_t*)0xB71C00D3UL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS20	(*(volatile uint_io8_t*)0xB71C00D4UL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS21	(*(volatile uint_io8_t*)0xB71C00D5UL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS22	(*(volatile uint_io8_t*)0xB71C00D6UL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS23	(*(volatile uint_io8_t*)0xB71C00D7UL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS24	(*(volatile uint_io8_t*)0xB71C00D8UL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS25	(*(volatile uint_io8_t*)0xB71C00D9UL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS26	(*(volatile uint_io8_t*)0xB71C00DAUL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS27	(*(volatile uint_io8_t*)0xB71C00DBUL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS28	(*(volatile uint_io8_t*)0xB71C00DCUL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS29	(*(volatile uint_io8_t*)0xB71C00DDUL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS30	(*(volatile uint_io8_t*)0xB71C00DEUL)  /*@bfbba@*/
#define GPIO_DDSR1_DDS31	(*(volatile uint_io8_t*)0xB71C00DFUL)  /*@bfbba@*/

#define GPIO_DDSR2	(GPIO.unDDSR2.u32Register)  /*@rg@*/
#define GPIO_DDSR2_DDS0	(*(volatile uint_io8_t*)0xB71C0140UL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS1	(*(volatile uint_io8_t*)0xB71C0141UL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS2	(*(volatile uint_io8_t*)0xB71C0142UL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS3	(*(volatile uint_io8_t*)0xB71C0143UL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS4	(*(volatile uint_io8_t*)0xB71C0144UL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS5	(*(volatile uint_io8_t*)0xB71C0145UL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS6	(*(volatile uint_io8_t*)0xB71C0146UL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS7	(*(volatile uint_io8_t*)0xB71C0147UL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS8	(*(volatile uint_io8_t*)0xB71C0148UL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS9	(*(volatile uint_io8_t*)0xB71C0149UL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS10	(*(volatile uint_io8_t*)0xB71C014AUL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS11	(*(volatile uint_io8_t*)0xB71C014BUL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS12	(*(volatile uint_io8_t*)0xB71C014CUL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS13	(*(volatile uint_io8_t*)0xB71C014DUL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS14	(*(volatile uint_io8_t*)0xB71C014EUL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS15	(*(volatile uint_io8_t*)0xB71C014FUL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS16	(*(volatile uint_io8_t*)0xB71C0150UL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS17	(*(volatile uint_io8_t*)0xB71C0151UL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS18	(*(volatile uint_io8_t*)0xB71C0152UL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS19	(*(volatile uint_io8_t*)0xB71C0153UL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS20	(*(volatile uint_io8_t*)0xB71C0154UL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS21	(*(volatile uint_io8_t*)0xB71C0155UL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS22	(*(volatile uint_io8_t*)0xB71C0156UL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS23	(*(volatile uint_io8_t*)0xB71C0157UL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS24	(*(volatile uint_io8_t*)0xB71C0158UL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS25	(*(volatile uint_io8_t*)0xB71C0159UL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS26	(*(volatile uint_io8_t*)0xB71C015AUL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS27	(*(volatile uint_io8_t*)0xB71C015BUL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS28	(*(volatile uint_io8_t*)0xB71C015CUL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS29	(*(volatile uint_io8_t*)0xB71C015DUL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS30	(*(volatile uint_io8_t*)0xB71C015EUL)  /*@bfbba@*/
#define GPIO_DDSR2_DDS31	(*(volatile uint_io8_t*)0xB71C015FUL)  /*@bfbba@*/

#define GPIO_DDSR3	(GPIO.unDDSR3.u32Register)  /*@rg@*/
#define GPIO_DDSR3_DDS0	(*(volatile uint_io8_t*)0xB71C01C0UL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS1	(*(volatile uint_io8_t*)0xB71C01C1UL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS2	(*(volatile uint_io8_t*)0xB71C01C2UL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS3	(*(volatile uint_io8_t*)0xB71C01C3UL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS4	(*(volatile uint_io8_t*)0xB71C01C4UL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS5	(*(volatile uint_io8_t*)0xB71C01C5UL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS6	(*(volatile uint_io8_t*)0xB71C01C6UL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS7	(*(volatile uint_io8_t*)0xB71C01C7UL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS8	(*(volatile uint_io8_t*)0xB71C01C8UL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS9	(*(volatile uint_io8_t*)0xB71C01C9UL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS10	(*(volatile uint_io8_t*)0xB71C01CAUL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS11	(*(volatile uint_io8_t*)0xB71C01CBUL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS12	(*(volatile uint_io8_t*)0xB71C01CCUL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS13	(*(volatile uint_io8_t*)0xB71C01CDUL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS14	(*(volatile uint_io8_t*)0xB71C01CEUL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS15	(*(volatile uint_io8_t*)0xB71C01CFUL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS16	(*(volatile uint_io8_t*)0xB71C01D0UL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS17	(*(volatile uint_io8_t*)0xB71C01D1UL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS18	(*(volatile uint_io8_t*)0xB71C01D2UL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS19	(*(volatile uint_io8_t*)0xB71C01D3UL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS20	(*(volatile uint_io8_t*)0xB71C01D4UL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS21	(*(volatile uint_io8_t*)0xB71C01D5UL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS22	(*(volatile uint_io8_t*)0xB71C01D6UL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS23	(*(volatile uint_io8_t*)0xB71C01D7UL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS24	(*(volatile uint_io8_t*)0xB71C01D8UL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS25	(*(volatile uint_io8_t*)0xB71C01D9UL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS26	(*(volatile uint_io8_t*)0xB71C01DAUL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS27	(*(volatile uint_io8_t*)0xB71C01DBUL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS28	(*(volatile uint_io8_t*)0xB71C01DCUL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS29	(*(volatile uint_io8_t*)0xB71C01DDUL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS30	(*(volatile uint_io8_t*)0xB71C01DEUL)  /*@bfbba@*/
#define GPIO_DDSR3_DDS31	(*(volatile uint_io8_t*)0xB71C01DFUL)  /*@bfbba@*/

typedef struct stc_gpio_ddsrn_field{
    uint_io32_t		u1DDS0:1;
    uint_io32_t		u1DDS1:1;
    uint_io32_t		u1DDS2:1;
    uint_io32_t		u1DDS3:1;
    uint_io32_t		u1DDS4:1;
    uint_io32_t		u1DDS5:1;
    uint_io32_t		u1DDS6:1;
    uint_io32_t		u1DDS7:1;
    uint_io32_t		u1DDS8:1;
    uint_io32_t		u1DDS9:1;
    uint_io32_t		u1DDS10:1;
    uint_io32_t		u1DDS11:1;
    uint_io32_t		u1DDS12:1;
    uint_io32_t		u1DDS13:1;
    uint_io32_t		u1DDS14:1;
    uint_io32_t		u1DDS15:1;
    uint_io32_t		u1DDS16:1;
    uint_io32_t		u1DDS17:1;
    uint_io32_t		u1DDS18:1;
    uint_io32_t		u1DDS19:1;
    uint_io32_t		u1DDS20:1;
    uint_io32_t		u1DDS21:1;
    uint_io32_t		u1DDS22:1;
    uint_io32_t		u1DDS23:1;
    uint_io32_t		u1DDS24:1;
    uint_io32_t		u1DDS25:1;
    uint_io32_t		u1DDS26:1;
    uint_io32_t		u1DDS27:1;
    uint_io32_t		u1DDS28:1;
    uint_io32_t		u1DDS29:1;
    uint_io32_t		u1DDS30:1;
    uint_io32_t		u1DDS31:1;
}stc_gpio_ddsrn_field_t;

typedef union un_gpio_ddsrn{
    uint_io32_t		u32Register;
    stc_gpio_ddsrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_ddsrn_t;

/* DDCR[0-3] */
#define GPIO_DDCR0	(GPIO.unDDCR0.u32Register)  /*@rg@*/
#define GPIO_DDCR0_DDC0	(*(volatile uint_io8_t*)0xB71C0060UL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC1	(*(volatile uint_io8_t*)0xB71C0061UL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC2	(*(volatile uint_io8_t*)0xB71C0062UL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC3	(*(volatile uint_io8_t*)0xB71C0063UL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC4	(*(volatile uint_io8_t*)0xB71C0064UL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC5	(*(volatile uint_io8_t*)0xB71C0065UL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC6	(*(volatile uint_io8_t*)0xB71C0066UL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC7	(*(volatile uint_io8_t*)0xB71C0067UL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC8	(*(volatile uint_io8_t*)0xB71C0068UL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC9	(*(volatile uint_io8_t*)0xB71C0069UL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC10	(*(volatile uint_io8_t*)0xB71C006AUL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC11	(*(volatile uint_io8_t*)0xB71C006BUL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC12	(*(volatile uint_io8_t*)0xB71C006CUL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC13	(*(volatile uint_io8_t*)0xB71C006DUL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC14	(*(volatile uint_io8_t*)0xB71C006EUL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC15	(*(volatile uint_io8_t*)0xB71C006FUL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC16	(*(volatile uint_io8_t*)0xB71C0070UL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC17	(*(volatile uint_io8_t*)0xB71C0071UL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC18	(*(volatile uint_io8_t*)0xB71C0072UL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC19	(*(volatile uint_io8_t*)0xB71C0073UL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC20	(*(volatile uint_io8_t*)0xB71C0074UL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC21	(*(volatile uint_io8_t*)0xB71C0075UL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC22	(*(volatile uint_io8_t*)0xB71C0076UL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC23	(*(volatile uint_io8_t*)0xB71C0077UL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC24	(*(volatile uint_io8_t*)0xB71C0078UL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC25	(*(volatile uint_io8_t*)0xB71C0079UL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC26	(*(volatile uint_io8_t*)0xB71C007AUL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC27	(*(volatile uint_io8_t*)0xB71C007BUL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC28	(*(volatile uint_io8_t*)0xB71C007CUL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC29	(*(volatile uint_io8_t*)0xB71C007DUL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC30	(*(volatile uint_io8_t*)0xB71C007EUL)  /*@bfbba@*/
#define GPIO_DDCR0_DDC31	(*(volatile uint_io8_t*)0xB71C007FUL)  /*@bfbba@*/

#define GPIO_DDCR1	(GPIO.unDDCR1.u32Register)  /*@rg@*/
#define GPIO_DDCR1_DDC0	(*(volatile uint_io8_t*)0xB71C00E0UL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC1	(*(volatile uint_io8_t*)0xB71C00E1UL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC2	(*(volatile uint_io8_t*)0xB71C00E2UL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC3	(*(volatile uint_io8_t*)0xB71C00E3UL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC4	(*(volatile uint_io8_t*)0xB71C00E4UL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC5	(*(volatile uint_io8_t*)0xB71C00E5UL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC6	(*(volatile uint_io8_t*)0xB71C00E6UL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC7	(*(volatile uint_io8_t*)0xB71C00E7UL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC8	(*(volatile uint_io8_t*)0xB71C00E8UL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC9	(*(volatile uint_io8_t*)0xB71C00E9UL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC10	(*(volatile uint_io8_t*)0xB71C00EAUL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC11	(*(volatile uint_io8_t*)0xB71C00EBUL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC12	(*(volatile uint_io8_t*)0xB71C00ECUL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC13	(*(volatile uint_io8_t*)0xB71C00EDUL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC14	(*(volatile uint_io8_t*)0xB71C00EEUL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC15	(*(volatile uint_io8_t*)0xB71C00EFUL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC16	(*(volatile uint_io8_t*)0xB71C00F0UL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC17	(*(volatile uint_io8_t*)0xB71C00F1UL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC18	(*(volatile uint_io8_t*)0xB71C00F2UL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC19	(*(volatile uint_io8_t*)0xB71C00F3UL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC20	(*(volatile uint_io8_t*)0xB71C00F4UL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC21	(*(volatile uint_io8_t*)0xB71C00F5UL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC22	(*(volatile uint_io8_t*)0xB71C00F6UL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC23	(*(volatile uint_io8_t*)0xB71C00F7UL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC24	(*(volatile uint_io8_t*)0xB71C00F8UL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC25	(*(volatile uint_io8_t*)0xB71C00F9UL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC26	(*(volatile uint_io8_t*)0xB71C00FAUL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC27	(*(volatile uint_io8_t*)0xB71C00FBUL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC28	(*(volatile uint_io8_t*)0xB71C00FCUL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC29	(*(volatile uint_io8_t*)0xB71C00FDUL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC30	(*(volatile uint_io8_t*)0xB71C00FEUL)  /*@bfbba@*/
#define GPIO_DDCR1_DDC31	(*(volatile uint_io8_t*)0xB71C00FFUL)  /*@bfbba@*/

#define GPIO_DDCR2	(GPIO.unDDCR2.u32Register)  /*@rg@*/
#define GPIO_DDCR2_DDC0	(*(volatile uint_io8_t*)0xB71C0160UL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC1	(*(volatile uint_io8_t*)0xB71C0161UL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC2	(*(volatile uint_io8_t*)0xB71C0162UL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC3	(*(volatile uint_io8_t*)0xB71C0163UL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC4	(*(volatile uint_io8_t*)0xB71C0164UL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC5	(*(volatile uint_io8_t*)0xB71C0165UL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC6	(*(volatile uint_io8_t*)0xB71C0166UL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC7	(*(volatile uint_io8_t*)0xB71C0167UL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC8	(*(volatile uint_io8_t*)0xB71C0168UL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC9	(*(volatile uint_io8_t*)0xB71C0169UL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC10	(*(volatile uint_io8_t*)0xB71C016AUL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC11	(*(volatile uint_io8_t*)0xB71C016BUL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC12	(*(volatile uint_io8_t*)0xB71C016CUL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC13	(*(volatile uint_io8_t*)0xB71C016DUL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC14	(*(volatile uint_io8_t*)0xB71C016EUL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC15	(*(volatile uint_io8_t*)0xB71C016FUL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC16	(*(volatile uint_io8_t*)0xB71C0170UL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC17	(*(volatile uint_io8_t*)0xB71C0171UL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC18	(*(volatile uint_io8_t*)0xB71C0172UL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC19	(*(volatile uint_io8_t*)0xB71C0173UL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC20	(*(volatile uint_io8_t*)0xB71C0174UL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC21	(*(volatile uint_io8_t*)0xB71C0175UL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC22	(*(volatile uint_io8_t*)0xB71C0176UL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC23	(*(volatile uint_io8_t*)0xB71C0177UL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC24	(*(volatile uint_io8_t*)0xB71C0178UL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC25	(*(volatile uint_io8_t*)0xB71C0179UL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC26	(*(volatile uint_io8_t*)0xB71C017AUL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC27	(*(volatile uint_io8_t*)0xB71C017BUL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC28	(*(volatile uint_io8_t*)0xB71C017CUL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC29	(*(volatile uint_io8_t*)0xB71C017DUL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC30	(*(volatile uint_io8_t*)0xB71C017EUL)  /*@bfbba@*/
#define GPIO_DDCR2_DDC31	(*(volatile uint_io8_t*)0xB71C017FUL)  /*@bfbba@*/

#define GPIO_DDCR3	(GPIO.unDDCR3.u32Register)  /*@rg@*/
#define GPIO_DDCR3_DDC0	(*(volatile uint_io8_t*)0xB71C01E0UL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC1	(*(volatile uint_io8_t*)0xB71C01E1UL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC2	(*(volatile uint_io8_t*)0xB71C01E2UL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC3	(*(volatile uint_io8_t*)0xB71C01E3UL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC4	(*(volatile uint_io8_t*)0xB71C01E4UL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC5	(*(volatile uint_io8_t*)0xB71C01E5UL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC6	(*(volatile uint_io8_t*)0xB71C01E6UL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC7	(*(volatile uint_io8_t*)0xB71C01E7UL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC8	(*(volatile uint_io8_t*)0xB71C01E8UL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC9	(*(volatile uint_io8_t*)0xB71C01E9UL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC10	(*(volatile uint_io8_t*)0xB71C01EAUL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC11	(*(volatile uint_io8_t*)0xB71C01EBUL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC12	(*(volatile uint_io8_t*)0xB71C01ECUL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC13	(*(volatile uint_io8_t*)0xB71C01EDUL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC14	(*(volatile uint_io8_t*)0xB71C01EEUL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC15	(*(volatile uint_io8_t*)0xB71C01EFUL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC16	(*(volatile uint_io8_t*)0xB71C01F0UL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC17	(*(volatile uint_io8_t*)0xB71C01F1UL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC18	(*(volatile uint_io8_t*)0xB71C01F2UL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC19	(*(volatile uint_io8_t*)0xB71C01F3UL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC20	(*(volatile uint_io8_t*)0xB71C01F4UL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC21	(*(volatile uint_io8_t*)0xB71C01F5UL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC22	(*(volatile uint_io8_t*)0xB71C01F6UL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC23	(*(volatile uint_io8_t*)0xB71C01F7UL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC24	(*(volatile uint_io8_t*)0xB71C01F8UL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC25	(*(volatile uint_io8_t*)0xB71C01F9UL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC26	(*(volatile uint_io8_t*)0xB71C01FAUL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC27	(*(volatile uint_io8_t*)0xB71C01FBUL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC28	(*(volatile uint_io8_t*)0xB71C01FCUL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC29	(*(volatile uint_io8_t*)0xB71C01FDUL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC30	(*(volatile uint_io8_t*)0xB71C01FEUL)  /*@bfbba@*/
#define GPIO_DDCR3_DDC31	(*(volatile uint_io8_t*)0xB71C01FFUL)  /*@bfbba@*/

typedef struct stc_gpio_ddcrn_field{
    uint_io32_t		u1DDC0:1;
    uint_io32_t		u1DDC1:1;
    uint_io32_t		u1DDC2:1;
    uint_io32_t		u1DDC3:1;
    uint_io32_t		u1DDC4:1;
    uint_io32_t		u1DDC5:1;
    uint_io32_t		u1DDC6:1;
    uint_io32_t		u1DDC7:1;
    uint_io32_t		u1DDC8:1;
    uint_io32_t		u1DDC9:1;
    uint_io32_t		u1DDC10:1;
    uint_io32_t		u1DDC11:1;
    uint_io32_t		u1DDC12:1;
    uint_io32_t		u1DDC13:1;
    uint_io32_t		u1DDC14:1;
    uint_io32_t		u1DDC15:1;
    uint_io32_t		u1DDC16:1;
    uint_io32_t		u1DDC17:1;
    uint_io32_t		u1DDC18:1;
    uint_io32_t		u1DDC19:1;
    uint_io32_t		u1DDC20:1;
    uint_io32_t		u1DDC21:1;
    uint_io32_t		u1DDC22:1;
    uint_io32_t		u1DDC23:1;
    uint_io32_t		u1DDC24:1;
    uint_io32_t		u1DDC25:1;
    uint_io32_t		u1DDC26:1;
    uint_io32_t		u1DDC27:1;
    uint_io32_t		u1DDC28:1;
    uint_io32_t		u1DDC29:1;
    uint_io32_t		u1DDC30:1;
    uint_io32_t		u1DDC31:1;
}stc_gpio_ddcrn_field_t;

typedef union un_gpio_ddcrn{
    uint_io32_t		u32Register;
    stc_gpio_ddcrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_ddcrn_t;

/* PODR[0-3] */
#define GPIO_PODR0	(GPIO.unPODR0.u32Register)  /*@rg@*/
#define GPIO_PODR0_POD0	(*(volatile uint_io8_t*)0xB71C1000UL)  /*@bfbba@*/
#define GPIO_PODR0_POD1	(*(volatile uint_io8_t*)0xB71C1001UL)  /*@bfbba@*/
#define GPIO_PODR0_POD2	(*(volatile uint_io8_t*)0xB71C1002UL)  /*@bfbba@*/
#define GPIO_PODR0_POD3	(*(volatile uint_io8_t*)0xB71C1003UL)  /*@bfbba@*/
#define GPIO_PODR0_POD4	(*(volatile uint_io8_t*)0xB71C1004UL)  /*@bfbba@*/
#define GPIO_PODR0_POD5	(*(volatile uint_io8_t*)0xB71C1005UL)  /*@bfbba@*/
#define GPIO_PODR0_POD6	(*(volatile uint_io8_t*)0xB71C1006UL)  /*@bfbba@*/
#define GPIO_PODR0_POD7	(*(volatile uint_io8_t*)0xB71C1007UL)  /*@bfbba@*/
#define GPIO_PODR0_POD8	(*(volatile uint_io8_t*)0xB71C1008UL)  /*@bfbba@*/
#define GPIO_PODR0_POD9	(*(volatile uint_io8_t*)0xB71C1009UL)  /*@bfbba@*/
#define GPIO_PODR0_POD10	(*(volatile uint_io8_t*)0xB71C100AUL)  /*@bfbba@*/
#define GPIO_PODR0_POD11	(*(volatile uint_io8_t*)0xB71C100BUL)  /*@bfbba@*/
#define GPIO_PODR0_POD12	(*(volatile uint_io8_t*)0xB71C100CUL)  /*@bfbba@*/
#define GPIO_PODR0_POD13	(*(volatile uint_io8_t*)0xB71C100DUL)  /*@bfbba@*/
#define GPIO_PODR0_POD14	(*(volatile uint_io8_t*)0xB71C100EUL)  /*@bfbba@*/
#define GPIO_PODR0_POD15	(*(volatile uint_io8_t*)0xB71C100FUL)  /*@bfbba@*/
#define GPIO_PODR0_POD16	(*(volatile uint_io8_t*)0xB71C1010UL)  /*@bfbba@*/
#define GPIO_PODR0_POD17	(*(volatile uint_io8_t*)0xB71C1011UL)  /*@bfbba@*/
#define GPIO_PODR0_POD18	(*(volatile uint_io8_t*)0xB71C1012UL)  /*@bfbba@*/
#define GPIO_PODR0_POD19	(*(volatile uint_io8_t*)0xB71C1013UL)  /*@bfbba@*/
#define GPIO_PODR0_POD20	(*(volatile uint_io8_t*)0xB71C1014UL)  /*@bfbba@*/
#define GPIO_PODR0_POD21	(*(volatile uint_io8_t*)0xB71C1015UL)  /*@bfbba@*/
#define GPIO_PODR0_POD22	(*(volatile uint_io8_t*)0xB71C1016UL)  /*@bfbba@*/
#define GPIO_PODR0_POD23	(*(volatile uint_io8_t*)0xB71C1017UL)  /*@bfbba@*/
#define GPIO_PODR0_POD24	(*(volatile uint_io8_t*)0xB71C1018UL)  /*@bfbba@*/
#define GPIO_PODR0_POD25	(*(volatile uint_io8_t*)0xB71C1019UL)  /*@bfbba@*/
#define GPIO_PODR0_POD26	(*(volatile uint_io8_t*)0xB71C101AUL)  /*@bfbba@*/
#define GPIO_PODR0_POD27	(*(volatile uint_io8_t*)0xB71C101BUL)  /*@bfbba@*/
#define GPIO_PODR0_POD28	(*(volatile uint_io8_t*)0xB71C101CUL)  /*@bfbba@*/
#define GPIO_PODR0_POD29	(*(volatile uint_io8_t*)0xB71C101DUL)  /*@bfbba@*/
#define GPIO_PODR0_POD30	(*(volatile uint_io8_t*)0xB71C101EUL)  /*@bfbba@*/
#define GPIO_PODR0_POD31	(*(volatile uint_io8_t*)0xB71C101FUL)  /*@bfbba@*/

#define GPIO_PODR1	(GPIO.unPODR1.u32Register)  /*@rg@*/
#define GPIO_PODR1_POD0	(*(volatile uint_io8_t*)0xB71C1040UL)  /*@bfbba@*/
#define GPIO_PODR1_POD1	(*(volatile uint_io8_t*)0xB71C1041UL)  /*@bfbba@*/
#define GPIO_PODR1_POD2	(*(volatile uint_io8_t*)0xB71C1042UL)  /*@bfbba@*/
#define GPIO_PODR1_POD3	(*(volatile uint_io8_t*)0xB71C1043UL)  /*@bfbba@*/
#define GPIO_PODR1_POD4	(*(volatile uint_io8_t*)0xB71C1044UL)  /*@bfbba@*/
#define GPIO_PODR1_POD5	(*(volatile uint_io8_t*)0xB71C1045UL)  /*@bfbba@*/
#define GPIO_PODR1_POD6	(*(volatile uint_io8_t*)0xB71C1046UL)  /*@bfbba@*/
#define GPIO_PODR1_POD7	(*(volatile uint_io8_t*)0xB71C1047UL)  /*@bfbba@*/
#define GPIO_PODR1_POD8	(*(volatile uint_io8_t*)0xB71C1048UL)  /*@bfbba@*/
#define GPIO_PODR1_POD9	(*(volatile uint_io8_t*)0xB71C1049UL)  /*@bfbba@*/
#define GPIO_PODR1_POD10	(*(volatile uint_io8_t*)0xB71C104AUL)  /*@bfbba@*/
#define GPIO_PODR1_POD11	(*(volatile uint_io8_t*)0xB71C104BUL)  /*@bfbba@*/
#define GPIO_PODR1_POD12	(*(volatile uint_io8_t*)0xB71C104CUL)  /*@bfbba@*/
#define GPIO_PODR1_POD13	(*(volatile uint_io8_t*)0xB71C104DUL)  /*@bfbba@*/
#define GPIO_PODR1_POD14	(*(volatile uint_io8_t*)0xB71C104EUL)  /*@bfbba@*/
#define GPIO_PODR1_POD15	(*(volatile uint_io8_t*)0xB71C104FUL)  /*@bfbba@*/
#define GPIO_PODR1_POD16	(*(volatile uint_io8_t*)0xB71C1050UL)  /*@bfbba@*/
#define GPIO_PODR1_POD17	(*(volatile uint_io8_t*)0xB71C1051UL)  /*@bfbba@*/
#define GPIO_PODR1_POD18	(*(volatile uint_io8_t*)0xB71C1052UL)  /*@bfbba@*/
#define GPIO_PODR1_POD19	(*(volatile uint_io8_t*)0xB71C1053UL)  /*@bfbba@*/
#define GPIO_PODR1_POD20	(*(volatile uint_io8_t*)0xB71C1054UL)  /*@bfbba@*/
#define GPIO_PODR1_POD21	(*(volatile uint_io8_t*)0xB71C1055UL)  /*@bfbba@*/
#define GPIO_PODR1_POD22	(*(volatile uint_io8_t*)0xB71C1056UL)  /*@bfbba@*/
#define GPIO_PODR1_POD23	(*(volatile uint_io8_t*)0xB71C1057UL)  /*@bfbba@*/
#define GPIO_PODR1_POD24	(*(volatile uint_io8_t*)0xB71C1058UL)  /*@bfbba@*/
#define GPIO_PODR1_POD25	(*(volatile uint_io8_t*)0xB71C1059UL)  /*@bfbba@*/
#define GPIO_PODR1_POD26	(*(volatile uint_io8_t*)0xB71C105AUL)  /*@bfbba@*/
#define GPIO_PODR1_POD27	(*(volatile uint_io8_t*)0xB71C105BUL)  /*@bfbba@*/
#define GPIO_PODR1_POD28	(*(volatile uint_io8_t*)0xB71C105CUL)  /*@bfbba@*/
#define GPIO_PODR1_POD29	(*(volatile uint_io8_t*)0xB71C105DUL)  /*@bfbba@*/
#define GPIO_PODR1_POD30	(*(volatile uint_io8_t*)0xB71C105EUL)  /*@bfbba@*/
#define GPIO_PODR1_POD31	(*(volatile uint_io8_t*)0xB71C105FUL)  /*@bfbba@*/

#define GPIO_PODR2	(GPIO.unPODR2.u32Register)  /*@rg@*/
#define GPIO_PODR2_POD0	(*(volatile uint_io8_t*)0xB71C1080UL)  /*@bfbba@*/
#define GPIO_PODR2_POD1	(*(volatile uint_io8_t*)0xB71C1081UL)  /*@bfbba@*/
#define GPIO_PODR2_POD2	(*(volatile uint_io8_t*)0xB71C1082UL)  /*@bfbba@*/
#define GPIO_PODR2_POD3	(*(volatile uint_io8_t*)0xB71C1083UL)  /*@bfbba@*/
#define GPIO_PODR2_POD4	(*(volatile uint_io8_t*)0xB71C1084UL)  /*@bfbba@*/
#define GPIO_PODR2_POD5	(*(volatile uint_io8_t*)0xB71C1085UL)  /*@bfbba@*/
#define GPIO_PODR2_POD6	(*(volatile uint_io8_t*)0xB71C1086UL)  /*@bfbba@*/
#define GPIO_PODR2_POD7	(*(volatile uint_io8_t*)0xB71C1087UL)  /*@bfbba@*/
#define GPIO_PODR2_POD8	(*(volatile uint_io8_t*)0xB71C1088UL)  /*@bfbba@*/
#define GPIO_PODR2_POD9	(*(volatile uint_io8_t*)0xB71C1089UL)  /*@bfbba@*/
#define GPIO_PODR2_POD10	(*(volatile uint_io8_t*)0xB71C108AUL)  /*@bfbba@*/
#define GPIO_PODR2_POD11	(*(volatile uint_io8_t*)0xB71C108BUL)  /*@bfbba@*/
#define GPIO_PODR2_POD12	(*(volatile uint_io8_t*)0xB71C108CUL)  /*@bfbba@*/
#define GPIO_PODR2_POD13	(*(volatile uint_io8_t*)0xB71C108DUL)  /*@bfbba@*/
#define GPIO_PODR2_POD14	(*(volatile uint_io8_t*)0xB71C108EUL)  /*@bfbba@*/
#define GPIO_PODR2_POD15	(*(volatile uint_io8_t*)0xB71C108FUL)  /*@bfbba@*/
#define GPIO_PODR2_POD16	(*(volatile uint_io8_t*)0xB71C1090UL)  /*@bfbba@*/
#define GPIO_PODR2_POD17	(*(volatile uint_io8_t*)0xB71C1091UL)  /*@bfbba@*/
#define GPIO_PODR2_POD18	(*(volatile uint_io8_t*)0xB71C1092UL)  /*@bfbba@*/
#define GPIO_PODR2_POD19	(*(volatile uint_io8_t*)0xB71C1093UL)  /*@bfbba@*/
#define GPIO_PODR2_POD20	(*(volatile uint_io8_t*)0xB71C1094UL)  /*@bfbba@*/
#define GPIO_PODR2_POD21	(*(volatile uint_io8_t*)0xB71C1095UL)  /*@bfbba@*/
#define GPIO_PODR2_POD22	(*(volatile uint_io8_t*)0xB71C1096UL)  /*@bfbba@*/
#define GPIO_PODR2_POD23	(*(volatile uint_io8_t*)0xB71C1097UL)  /*@bfbba@*/
#define GPIO_PODR2_POD24	(*(volatile uint_io8_t*)0xB71C1098UL)  /*@bfbba@*/
#define GPIO_PODR2_POD25	(*(volatile uint_io8_t*)0xB71C1099UL)  /*@bfbba@*/
#define GPIO_PODR2_POD26	(*(volatile uint_io8_t*)0xB71C109AUL)  /*@bfbba@*/
#define GPIO_PODR2_POD27	(*(volatile uint_io8_t*)0xB71C109BUL)  /*@bfbba@*/
#define GPIO_PODR2_POD28	(*(volatile uint_io8_t*)0xB71C109CUL)  /*@bfbba@*/
#define GPIO_PODR2_POD29	(*(volatile uint_io8_t*)0xB71C109DUL)  /*@bfbba@*/
#define GPIO_PODR2_POD30	(*(volatile uint_io8_t*)0xB71C109EUL)  /*@bfbba@*/
#define GPIO_PODR2_POD31	(*(volatile uint_io8_t*)0xB71C109FUL)  /*@bfbba@*/

#define GPIO_PODR3	(GPIO.unPODR3.u32Register)  /*@rg@*/
#define GPIO_PODR3_POD0	(*(volatile uint_io8_t*)0xB71C10C0UL)  /*@bfbba@*/
#define GPIO_PODR3_POD1	(*(volatile uint_io8_t*)0xB71C10C1UL)  /*@bfbba@*/
#define GPIO_PODR3_POD2	(*(volatile uint_io8_t*)0xB71C10C2UL)  /*@bfbba@*/
#define GPIO_PODR3_POD3	(*(volatile uint_io8_t*)0xB71C10C3UL)  /*@bfbba@*/
#define GPIO_PODR3_POD4	(*(volatile uint_io8_t*)0xB71C10C4UL)  /*@bfbba@*/
#define GPIO_PODR3_POD5	(*(volatile uint_io8_t*)0xB71C10C5UL)  /*@bfbba@*/
#define GPIO_PODR3_POD6	(*(volatile uint_io8_t*)0xB71C10C6UL)  /*@bfbba@*/
#define GPIO_PODR3_POD7	(*(volatile uint_io8_t*)0xB71C10C7UL)  /*@bfbba@*/
#define GPIO_PODR3_POD8	(*(volatile uint_io8_t*)0xB71C10C8UL)  /*@bfbba@*/
#define GPIO_PODR3_POD9	(*(volatile uint_io8_t*)0xB71C10C9UL)  /*@bfbba@*/
#define GPIO_PODR3_POD10	(*(volatile uint_io8_t*)0xB71C10CAUL)  /*@bfbba@*/
#define GPIO_PODR3_POD11	(*(volatile uint_io8_t*)0xB71C10CBUL)  /*@bfbba@*/
#define GPIO_PODR3_POD12	(*(volatile uint_io8_t*)0xB71C10CCUL)  /*@bfbba@*/
#define GPIO_PODR3_POD13	(*(volatile uint_io8_t*)0xB71C10CDUL)  /*@bfbba@*/
#define GPIO_PODR3_POD14	(*(volatile uint_io8_t*)0xB71C10CEUL)  /*@bfbba@*/
#define GPIO_PODR3_POD15	(*(volatile uint_io8_t*)0xB71C10CFUL)  /*@bfbba@*/
#define GPIO_PODR3_POD16	(*(volatile uint_io8_t*)0xB71C10D0UL)  /*@bfbba@*/
#define GPIO_PODR3_POD17	(*(volatile uint_io8_t*)0xB71C10D1UL)  /*@bfbba@*/
#define GPIO_PODR3_POD18	(*(volatile uint_io8_t*)0xB71C10D2UL)  /*@bfbba@*/
#define GPIO_PODR3_POD19	(*(volatile uint_io8_t*)0xB71C10D3UL)  /*@bfbba@*/
#define GPIO_PODR3_POD20	(*(volatile uint_io8_t*)0xB71C10D4UL)  /*@bfbba@*/
#define GPIO_PODR3_POD21	(*(volatile uint_io8_t*)0xB71C10D5UL)  /*@bfbba@*/
#define GPIO_PODR3_POD22	(*(volatile uint_io8_t*)0xB71C10D6UL)  /*@bfbba@*/
#define GPIO_PODR3_POD23	(*(volatile uint_io8_t*)0xB71C10D7UL)  /*@bfbba@*/
#define GPIO_PODR3_POD24	(*(volatile uint_io8_t*)0xB71C10D8UL)  /*@bfbba@*/
#define GPIO_PODR3_POD25	(*(volatile uint_io8_t*)0xB71C10D9UL)  /*@bfbba@*/
#define GPIO_PODR3_POD26	(*(volatile uint_io8_t*)0xB71C10DAUL)  /*@bfbba@*/
#define GPIO_PODR3_POD27	(*(volatile uint_io8_t*)0xB71C10DBUL)  /*@bfbba@*/
#define GPIO_PODR3_POD28	(*(volatile uint_io8_t*)0xB71C10DCUL)  /*@bfbba@*/
#define GPIO_PODR3_POD29	(*(volatile uint_io8_t*)0xB71C10DDUL)  /*@bfbba@*/
#define GPIO_PODR3_POD30	(*(volatile uint_io8_t*)0xB71C10DEUL)  /*@bfbba@*/
#define GPIO_PODR3_POD31	(*(volatile uint_io8_t*)0xB71C10DFUL)  /*@bfbba@*/

typedef struct stc_gpio_podrn_field{
    uint_io32_t		u1POD0:1;
    uint_io32_t		u1POD1:1;
    uint_io32_t		u1POD2:1;
    uint_io32_t		u1POD3:1;
    uint_io32_t		u1POD4:1;
    uint_io32_t		u1POD5:1;
    uint_io32_t		u1POD6:1;
    uint_io32_t		u1POD7:1;
    uint_io32_t		u1POD8:1;
    uint_io32_t		u1POD9:1;
    uint_io32_t		u1POD10:1;
    uint_io32_t		u1POD11:1;
    uint_io32_t		u1POD12:1;
    uint_io32_t		u1POD13:1;
    uint_io32_t		u1POD14:1;
    uint_io32_t		u1POD15:1;
    uint_io32_t		u1POD16:1;
    uint_io32_t		u1POD17:1;
    uint_io32_t		u1POD18:1;
    uint_io32_t		u1POD19:1;
    uint_io32_t		u1POD20:1;
    uint_io32_t		u1POD21:1;
    uint_io32_t		u1POD22:1;
    uint_io32_t		u1POD23:1;
    uint_io32_t		u1POD24:1;
    uint_io32_t		u1POD25:1;
    uint_io32_t		u1POD26:1;
    uint_io32_t		u1POD27:1;
    uint_io32_t		u1POD28:1;
    uint_io32_t		u1POD29:1;
    uint_io32_t		u1POD30:1;
    uint_io32_t		u1POD31:1;
}stc_gpio_podrn_field_t;

typedef union un_gpio_podrn{
    uint_io32_t		u32Register;
    stc_gpio_podrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_podrn_t;

/* DDR[0-3] */
#define GPIO_DDR0	(GPIO.unDDR0.u32Register)  /*@rg@*/
#define GPIO_DDR0_DD0	(*(volatile uint_io8_t*)0xB71C1020UL)  /*@bfbba@*/
#define GPIO_DDR0_DD1	(*(volatile uint_io8_t*)0xB71C1021UL)  /*@bfbba@*/
#define GPIO_DDR0_DD2	(*(volatile uint_io8_t*)0xB71C1022UL)  /*@bfbba@*/
#define GPIO_DDR0_DD3	(*(volatile uint_io8_t*)0xB71C1023UL)  /*@bfbba@*/
#define GPIO_DDR0_DD4	(*(volatile uint_io8_t*)0xB71C1024UL)  /*@bfbba@*/
#define GPIO_DDR0_DD5	(*(volatile uint_io8_t*)0xB71C1025UL)  /*@bfbba@*/
#define GPIO_DDR0_DD6	(*(volatile uint_io8_t*)0xB71C1026UL)  /*@bfbba@*/
#define GPIO_DDR0_DD7	(*(volatile uint_io8_t*)0xB71C1027UL)  /*@bfbba@*/
#define GPIO_DDR0_DD8	(*(volatile uint_io8_t*)0xB71C1028UL)  /*@bfbba@*/
#define GPIO_DDR0_DD9	(*(volatile uint_io8_t*)0xB71C1029UL)  /*@bfbba@*/
#define GPIO_DDR0_DD10	(*(volatile uint_io8_t*)0xB71C102AUL)  /*@bfbba@*/
#define GPIO_DDR0_DD11	(*(volatile uint_io8_t*)0xB71C102BUL)  /*@bfbba@*/
#define GPIO_DDR0_DD12	(*(volatile uint_io8_t*)0xB71C102CUL)  /*@bfbba@*/
#define GPIO_DDR0_DD13	(*(volatile uint_io8_t*)0xB71C102DUL)  /*@bfbba@*/
#define GPIO_DDR0_DD14	(*(volatile uint_io8_t*)0xB71C102EUL)  /*@bfbba@*/
#define GPIO_DDR0_DD15	(*(volatile uint_io8_t*)0xB71C102FUL)  /*@bfbba@*/
#define GPIO_DDR0_DD16	(*(volatile uint_io8_t*)0xB71C1030UL)  /*@bfbba@*/
#define GPIO_DDR0_DD17	(*(volatile uint_io8_t*)0xB71C1031UL)  /*@bfbba@*/
#define GPIO_DDR0_DD18	(*(volatile uint_io8_t*)0xB71C1032UL)  /*@bfbba@*/
#define GPIO_DDR0_DD19	(*(volatile uint_io8_t*)0xB71C1033UL)  /*@bfbba@*/
#define GPIO_DDR0_DD20	(*(volatile uint_io8_t*)0xB71C1034UL)  /*@bfbba@*/
#define GPIO_DDR0_DD21	(*(volatile uint_io8_t*)0xB71C1035UL)  /*@bfbba@*/
#define GPIO_DDR0_DD22	(*(volatile uint_io8_t*)0xB71C1036UL)  /*@bfbba@*/
#define GPIO_DDR0_DD23	(*(volatile uint_io8_t*)0xB71C1037UL)  /*@bfbba@*/
#define GPIO_DDR0_DD24	(*(volatile uint_io8_t*)0xB71C1038UL)  /*@bfbba@*/
#define GPIO_DDR0_DD25	(*(volatile uint_io8_t*)0xB71C1039UL)  /*@bfbba@*/
#define GPIO_DDR0_DD26	(*(volatile uint_io8_t*)0xB71C103AUL)  /*@bfbba@*/
#define GPIO_DDR0_DD27	(*(volatile uint_io8_t*)0xB71C103BUL)  /*@bfbba@*/
#define GPIO_DDR0_DD28	(*(volatile uint_io8_t*)0xB71C103CUL)  /*@bfbba@*/
#define GPIO_DDR0_DD29	(*(volatile uint_io8_t*)0xB71C103DUL)  /*@bfbba@*/
#define GPIO_DDR0_DD30	(*(volatile uint_io8_t*)0xB71C103EUL)  /*@bfbba@*/
#define GPIO_DDR0_DD31	(*(volatile uint_io8_t*)0xB71C103FUL)  /*@bfbba@*/

#define GPIO_DDR1	(GPIO.unDDR1.u32Register)  /*@rg@*/
#define GPIO_DDR1_DD0	(*(volatile uint_io8_t*)0xB71C1060UL)  /*@bfbba@*/
#define GPIO_DDR1_DD1	(*(volatile uint_io8_t*)0xB71C1061UL)  /*@bfbba@*/
#define GPIO_DDR1_DD2	(*(volatile uint_io8_t*)0xB71C1062UL)  /*@bfbba@*/
#define GPIO_DDR1_DD3	(*(volatile uint_io8_t*)0xB71C1063UL)  /*@bfbba@*/
#define GPIO_DDR1_DD4	(*(volatile uint_io8_t*)0xB71C1064UL)  /*@bfbba@*/
#define GPIO_DDR1_DD5	(*(volatile uint_io8_t*)0xB71C1065UL)  /*@bfbba@*/
#define GPIO_DDR1_DD6	(*(volatile uint_io8_t*)0xB71C1066UL)  /*@bfbba@*/
#define GPIO_DDR1_DD7	(*(volatile uint_io8_t*)0xB71C1067UL)  /*@bfbba@*/
#define GPIO_DDR1_DD8	(*(volatile uint_io8_t*)0xB71C1068UL)  /*@bfbba@*/
#define GPIO_DDR1_DD9	(*(volatile uint_io8_t*)0xB71C1069UL)  /*@bfbba@*/
#define GPIO_DDR1_DD10	(*(volatile uint_io8_t*)0xB71C106AUL)  /*@bfbba@*/
#define GPIO_DDR1_DD11	(*(volatile uint_io8_t*)0xB71C106BUL)  /*@bfbba@*/
#define GPIO_DDR1_DD12	(*(volatile uint_io8_t*)0xB71C106CUL)  /*@bfbba@*/
#define GPIO_DDR1_DD13	(*(volatile uint_io8_t*)0xB71C106DUL)  /*@bfbba@*/
#define GPIO_DDR1_DD14	(*(volatile uint_io8_t*)0xB71C106EUL)  /*@bfbba@*/
#define GPIO_DDR1_DD15	(*(volatile uint_io8_t*)0xB71C106FUL)  /*@bfbba@*/
#define GPIO_DDR1_DD16	(*(volatile uint_io8_t*)0xB71C1070UL)  /*@bfbba@*/
#define GPIO_DDR1_DD17	(*(volatile uint_io8_t*)0xB71C1071UL)  /*@bfbba@*/
#define GPIO_DDR1_DD18	(*(volatile uint_io8_t*)0xB71C1072UL)  /*@bfbba@*/
#define GPIO_DDR1_DD19	(*(volatile uint_io8_t*)0xB71C1073UL)  /*@bfbba@*/
#define GPIO_DDR1_DD20	(*(volatile uint_io8_t*)0xB71C1074UL)  /*@bfbba@*/
#define GPIO_DDR1_DD21	(*(volatile uint_io8_t*)0xB71C1075UL)  /*@bfbba@*/
#define GPIO_DDR1_DD22	(*(volatile uint_io8_t*)0xB71C1076UL)  /*@bfbba@*/
#define GPIO_DDR1_DD23	(*(volatile uint_io8_t*)0xB71C1077UL)  /*@bfbba@*/
#define GPIO_DDR1_DD24	(*(volatile uint_io8_t*)0xB71C1078UL)  /*@bfbba@*/
#define GPIO_DDR1_DD25	(*(volatile uint_io8_t*)0xB71C1079UL)  /*@bfbba@*/
#define GPIO_DDR1_DD26	(*(volatile uint_io8_t*)0xB71C107AUL)  /*@bfbba@*/
#define GPIO_DDR1_DD27	(*(volatile uint_io8_t*)0xB71C107BUL)  /*@bfbba@*/
#define GPIO_DDR1_DD28	(*(volatile uint_io8_t*)0xB71C107CUL)  /*@bfbba@*/
#define GPIO_DDR1_DD29	(*(volatile uint_io8_t*)0xB71C107DUL)  /*@bfbba@*/
#define GPIO_DDR1_DD30	(*(volatile uint_io8_t*)0xB71C107EUL)  /*@bfbba@*/
#define GPIO_DDR1_DD31	(*(volatile uint_io8_t*)0xB71C107FUL)  /*@bfbba@*/

#define GPIO_DDR2	(GPIO.unDDR2.u32Register)  /*@rg@*/
#define GPIO_DDR2_DD0	(*(volatile uint_io8_t*)0xB71C10A0UL)  /*@bfbba@*/
#define GPIO_DDR2_DD1	(*(volatile uint_io8_t*)0xB71C10A1UL)  /*@bfbba@*/
#define GPIO_DDR2_DD2	(*(volatile uint_io8_t*)0xB71C10A2UL)  /*@bfbba@*/
#define GPIO_DDR2_DD3	(*(volatile uint_io8_t*)0xB71C10A3UL)  /*@bfbba@*/
#define GPIO_DDR2_DD4	(*(volatile uint_io8_t*)0xB71C10A4UL)  /*@bfbba@*/
#define GPIO_DDR2_DD5	(*(volatile uint_io8_t*)0xB71C10A5UL)  /*@bfbba@*/
#define GPIO_DDR2_DD6	(*(volatile uint_io8_t*)0xB71C10A6UL)  /*@bfbba@*/
#define GPIO_DDR2_DD7	(*(volatile uint_io8_t*)0xB71C10A7UL)  /*@bfbba@*/
#define GPIO_DDR2_DD8	(*(volatile uint_io8_t*)0xB71C10A8UL)  /*@bfbba@*/
#define GPIO_DDR2_DD9	(*(volatile uint_io8_t*)0xB71C10A9UL)  /*@bfbba@*/
#define GPIO_DDR2_DD10	(*(volatile uint_io8_t*)0xB71C10AAUL)  /*@bfbba@*/
#define GPIO_DDR2_DD11	(*(volatile uint_io8_t*)0xB71C10ABUL)  /*@bfbba@*/
#define GPIO_DDR2_DD12	(*(volatile uint_io8_t*)0xB71C10ACUL)  /*@bfbba@*/
#define GPIO_DDR2_DD13	(*(volatile uint_io8_t*)0xB71C10ADUL)  /*@bfbba@*/
#define GPIO_DDR2_DD14	(*(volatile uint_io8_t*)0xB71C10AEUL)  /*@bfbba@*/
#define GPIO_DDR2_DD15	(*(volatile uint_io8_t*)0xB71C10AFUL)  /*@bfbba@*/
#define GPIO_DDR2_DD16	(*(volatile uint_io8_t*)0xB71C10B0UL)  /*@bfbba@*/
#define GPIO_DDR2_DD17	(*(volatile uint_io8_t*)0xB71C10B1UL)  /*@bfbba@*/
#define GPIO_DDR2_DD18	(*(volatile uint_io8_t*)0xB71C10B2UL)  /*@bfbba@*/
#define GPIO_DDR2_DD19	(*(volatile uint_io8_t*)0xB71C10B3UL)  /*@bfbba@*/
#define GPIO_DDR2_DD20	(*(volatile uint_io8_t*)0xB71C10B4UL)  /*@bfbba@*/
#define GPIO_DDR2_DD21	(*(volatile uint_io8_t*)0xB71C10B5UL)  /*@bfbba@*/
#define GPIO_DDR2_DD22	(*(volatile uint_io8_t*)0xB71C10B6UL)  /*@bfbba@*/
#define GPIO_DDR2_DD23	(*(volatile uint_io8_t*)0xB71C10B7UL)  /*@bfbba@*/
#define GPIO_DDR2_DD24	(*(volatile uint_io8_t*)0xB71C10B8UL)  /*@bfbba@*/
#define GPIO_DDR2_DD25	(*(volatile uint_io8_t*)0xB71C10B9UL)  /*@bfbba@*/
#define GPIO_DDR2_DD26	(*(volatile uint_io8_t*)0xB71C10BAUL)  /*@bfbba@*/
#define GPIO_DDR2_DD27	(*(volatile uint_io8_t*)0xB71C10BBUL)  /*@bfbba@*/
#define GPIO_DDR2_DD28	(*(volatile uint_io8_t*)0xB71C10BCUL)  /*@bfbba@*/
#define GPIO_DDR2_DD29	(*(volatile uint_io8_t*)0xB71C10BDUL)  /*@bfbba@*/
#define GPIO_DDR2_DD30	(*(volatile uint_io8_t*)0xB71C10BEUL)  /*@bfbba@*/
#define GPIO_DDR2_DD31	(*(volatile uint_io8_t*)0xB71C10BFUL)  /*@bfbba@*/

#define GPIO_DDR3	(GPIO.unDDR3.u32Register)  /*@rg@*/
#define GPIO_DDR3_DD0	(*(volatile uint_io8_t*)0xB71C10E0UL)  /*@bfbba@*/
#define GPIO_DDR3_DD1	(*(volatile uint_io8_t*)0xB71C10E1UL)  /*@bfbba@*/
#define GPIO_DDR3_DD2	(*(volatile uint_io8_t*)0xB71C10E2UL)  /*@bfbba@*/
#define GPIO_DDR3_DD3	(*(volatile uint_io8_t*)0xB71C10E3UL)  /*@bfbba@*/
#define GPIO_DDR3_DD4	(*(volatile uint_io8_t*)0xB71C10E4UL)  /*@bfbba@*/
#define GPIO_DDR3_DD5	(*(volatile uint_io8_t*)0xB71C10E5UL)  /*@bfbba@*/
#define GPIO_DDR3_DD6	(*(volatile uint_io8_t*)0xB71C10E6UL)  /*@bfbba@*/
#define GPIO_DDR3_DD7	(*(volatile uint_io8_t*)0xB71C10E7UL)  /*@bfbba@*/
#define GPIO_DDR3_DD8	(*(volatile uint_io8_t*)0xB71C10E8UL)  /*@bfbba@*/
#define GPIO_DDR3_DD9	(*(volatile uint_io8_t*)0xB71C10E9UL)  /*@bfbba@*/
#define GPIO_DDR3_DD10	(*(volatile uint_io8_t*)0xB71C10EAUL)  /*@bfbba@*/
#define GPIO_DDR3_DD11	(*(volatile uint_io8_t*)0xB71C10EBUL)  /*@bfbba@*/
#define GPIO_DDR3_DD12	(*(volatile uint_io8_t*)0xB71C10ECUL)  /*@bfbba@*/
#define GPIO_DDR3_DD13	(*(volatile uint_io8_t*)0xB71C10EDUL)  /*@bfbba@*/
#define GPIO_DDR3_DD14	(*(volatile uint_io8_t*)0xB71C10EEUL)  /*@bfbba@*/
#define GPIO_DDR3_DD15	(*(volatile uint_io8_t*)0xB71C10EFUL)  /*@bfbba@*/
#define GPIO_DDR3_DD16	(*(volatile uint_io8_t*)0xB71C10F0UL)  /*@bfbba@*/
#define GPIO_DDR3_DD17	(*(volatile uint_io8_t*)0xB71C10F1UL)  /*@bfbba@*/
#define GPIO_DDR3_DD18	(*(volatile uint_io8_t*)0xB71C10F2UL)  /*@bfbba@*/
#define GPIO_DDR3_DD19	(*(volatile uint_io8_t*)0xB71C10F3UL)  /*@bfbba@*/
#define GPIO_DDR3_DD20	(*(volatile uint_io8_t*)0xB71C10F4UL)  /*@bfbba@*/
#define GPIO_DDR3_DD21	(*(volatile uint_io8_t*)0xB71C10F5UL)  /*@bfbba@*/
#define GPIO_DDR3_DD22	(*(volatile uint_io8_t*)0xB71C10F6UL)  /*@bfbba@*/
#define GPIO_DDR3_DD23	(*(volatile uint_io8_t*)0xB71C10F7UL)  /*@bfbba@*/
#define GPIO_DDR3_DD24	(*(volatile uint_io8_t*)0xB71C10F8UL)  /*@bfbba@*/
#define GPIO_DDR3_DD25	(*(volatile uint_io8_t*)0xB71C10F9UL)  /*@bfbba@*/
#define GPIO_DDR3_DD26	(*(volatile uint_io8_t*)0xB71C10FAUL)  /*@bfbba@*/
#define GPIO_DDR3_DD27	(*(volatile uint_io8_t*)0xB71C10FBUL)  /*@bfbba@*/
#define GPIO_DDR3_DD28	(*(volatile uint_io8_t*)0xB71C10FCUL)  /*@bfbba@*/
#define GPIO_DDR3_DD29	(*(volatile uint_io8_t*)0xB71C10FDUL)  /*@bfbba@*/
#define GPIO_DDR3_DD30	(*(volatile uint_io8_t*)0xB71C10FEUL)  /*@bfbba@*/
#define GPIO_DDR3_DD31	(*(volatile uint_io8_t*)0xB71C10FFUL)  /*@bfbba@*/

typedef struct stc_gpio_ddrn_field{
    uint_io32_t		u1DD0:1;
    uint_io32_t		u1DD1:1;
    uint_io32_t		u1DD2:1;
    uint_io32_t		u1DD3:1;
    uint_io32_t		u1DD4:1;
    uint_io32_t		u1DD5:1;
    uint_io32_t		u1DD6:1;
    uint_io32_t		u1DD7:1;
    uint_io32_t		u1DD8:1;
    uint_io32_t		u1DD9:1;
    uint_io32_t		u1DD10:1;
    uint_io32_t		u1DD11:1;
    uint_io32_t		u1DD12:1;
    uint_io32_t		u1DD13:1;
    uint_io32_t		u1DD14:1;
    uint_io32_t		u1DD15:1;
    uint_io32_t		u1DD16:1;
    uint_io32_t		u1DD17:1;
    uint_io32_t		u1DD18:1;
    uint_io32_t		u1DD19:1;
    uint_io32_t		u1DD20:1;
    uint_io32_t		u1DD21:1;
    uint_io32_t		u1DD22:1;
    uint_io32_t		u1DD23:1;
    uint_io32_t		u1DD24:1;
    uint_io32_t		u1DD25:1;
    uint_io32_t		u1DD26:1;
    uint_io32_t		u1DD27:1;
    uint_io32_t		u1DD28:1;
    uint_io32_t		u1DD29:1;
    uint_io32_t		u1DD30:1;
    uint_io32_t		u1DD31:1;
}stc_gpio_ddrn_field_t;

typedef union un_gpio_ddrn{
    uint_io32_t		u32Register;
    stc_gpio_ddrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_ddrn_t;

/* PIDR[0-3] */
#define GPIO_PIDR0	(GPIO.unPIDR0.u32Register)  /*@rg@*/
#define GPIO_PIDR0_PID0	(*(volatile uint_io8_t*)0xB71C1800UL)  /*@bfbba@*/
#define GPIO_PIDR0_PID1	(*(volatile uint_io8_t*)0xB71C1801UL)  /*@bfbba@*/
#define GPIO_PIDR0_PID2	(*(volatile uint_io8_t*)0xB71C1802UL)  /*@bfbba@*/
#define GPIO_PIDR0_PID3	(*(volatile uint_io8_t*)0xB71C1803UL)  /*@bfbba@*/
#define GPIO_PIDR0_PID4	(*(volatile uint_io8_t*)0xB71C1804UL)  /*@bfbba@*/
#define GPIO_PIDR0_PID5	(*(volatile uint_io8_t*)0xB71C1805UL)  /*@bfbba@*/
#define GPIO_PIDR0_PID6	(*(volatile uint_io8_t*)0xB71C1806UL)  /*@bfbba@*/
#define GPIO_PIDR0_PID7	(*(volatile uint_io8_t*)0xB71C1807UL)  /*@bfbba@*/
#define GPIO_PIDR0_PID8	(*(volatile uint_io8_t*)0xB71C1808UL)  /*@bfbba@*/
#define GPIO_PIDR0_PID9	(*(volatile uint_io8_t*)0xB71C1809UL)  /*@bfbba@*/
#define GPIO_PIDR0_PID10	(*(volatile uint_io8_t*)0xB71C180AUL)  /*@bfbba@*/
#define GPIO_PIDR0_PID11	(*(volatile uint_io8_t*)0xB71C180BUL)  /*@bfbba@*/
#define GPIO_PIDR0_PID12	(*(volatile uint_io8_t*)0xB71C180CUL)  /*@bfbba@*/
#define GPIO_PIDR0_PID13	(*(volatile uint_io8_t*)0xB71C180DUL)  /*@bfbba@*/
#define GPIO_PIDR0_PID14	(*(volatile uint_io8_t*)0xB71C180EUL)  /*@bfbba@*/
#define GPIO_PIDR0_PID15	(*(volatile uint_io8_t*)0xB71C180FUL)  /*@bfbba@*/
#define GPIO_PIDR0_PID16	(*(volatile uint_io8_t*)0xB71C1810UL)  /*@bfbba@*/
#define GPIO_PIDR0_PID17	(*(volatile uint_io8_t*)0xB71C1811UL)  /*@bfbba@*/
#define GPIO_PIDR0_PID18	(*(volatile uint_io8_t*)0xB71C1812UL)  /*@bfbba@*/
#define GPIO_PIDR0_PID19	(*(volatile uint_io8_t*)0xB71C1813UL)  /*@bfbba@*/
#define GPIO_PIDR0_PID20	(*(volatile uint_io8_t*)0xB71C1814UL)  /*@bfbba@*/
#define GPIO_PIDR0_PID21	(*(volatile uint_io8_t*)0xB71C1815UL)  /*@bfbba@*/
#define GPIO_PIDR0_PID22	(*(volatile uint_io8_t*)0xB71C1816UL)  /*@bfbba@*/
#define GPIO_PIDR0_PID23	(*(volatile uint_io8_t*)0xB71C1817UL)  /*@bfbba@*/
#define GPIO_PIDR0_PID24	(*(volatile uint_io8_t*)0xB71C1818UL)  /*@bfbba@*/
#define GPIO_PIDR0_PID25	(*(volatile uint_io8_t*)0xB71C1819UL)  /*@bfbba@*/
#define GPIO_PIDR0_PID26	(*(volatile uint_io8_t*)0xB71C181AUL)  /*@bfbba@*/
#define GPIO_PIDR0_PID27	(*(volatile uint_io8_t*)0xB71C181BUL)  /*@bfbba@*/
#define GPIO_PIDR0_PID28	(*(volatile uint_io8_t*)0xB71C181CUL)  /*@bfbba@*/
#define GPIO_PIDR0_PID29	(*(volatile uint_io8_t*)0xB71C181DUL)  /*@bfbba@*/
#define GPIO_PIDR0_PID30	(*(volatile uint_io8_t*)0xB71C181EUL)  /*@bfbba@*/
#define GPIO_PIDR0_PID31	(*(volatile uint_io8_t*)0xB71C181FUL)  /*@bfbba@*/

#define GPIO_PIDR1	(GPIO.unPIDR1.u32Register)  /*@rg@*/
#define GPIO_PIDR1_PID0	(*(volatile uint_io8_t*)0xB71C1820UL)  /*@bfbba@*/
#define GPIO_PIDR1_PID1	(*(volatile uint_io8_t*)0xB71C1821UL)  /*@bfbba@*/
#define GPIO_PIDR1_PID2	(*(volatile uint_io8_t*)0xB71C1822UL)  /*@bfbba@*/
#define GPIO_PIDR1_PID3	(*(volatile uint_io8_t*)0xB71C1823UL)  /*@bfbba@*/
#define GPIO_PIDR1_PID4	(*(volatile uint_io8_t*)0xB71C1824UL)  /*@bfbba@*/
#define GPIO_PIDR1_PID5	(*(volatile uint_io8_t*)0xB71C1825UL)  /*@bfbba@*/
#define GPIO_PIDR1_PID6	(*(volatile uint_io8_t*)0xB71C1826UL)  /*@bfbba@*/
#define GPIO_PIDR1_PID7	(*(volatile uint_io8_t*)0xB71C1827UL)  /*@bfbba@*/
#define GPIO_PIDR1_PID8	(*(volatile uint_io8_t*)0xB71C1828UL)  /*@bfbba@*/
#define GPIO_PIDR1_PID9	(*(volatile uint_io8_t*)0xB71C1829UL)  /*@bfbba@*/
#define GPIO_PIDR1_PID10	(*(volatile uint_io8_t*)0xB71C182AUL)  /*@bfbba@*/
#define GPIO_PIDR1_PID11	(*(volatile uint_io8_t*)0xB71C182BUL)  /*@bfbba@*/
#define GPIO_PIDR1_PID12	(*(volatile uint_io8_t*)0xB71C182CUL)  /*@bfbba@*/
#define GPIO_PIDR1_PID13	(*(volatile uint_io8_t*)0xB71C182DUL)  /*@bfbba@*/
#define GPIO_PIDR1_PID14	(*(volatile uint_io8_t*)0xB71C182EUL)  /*@bfbba@*/
#define GPIO_PIDR1_PID15	(*(volatile uint_io8_t*)0xB71C182FUL)  /*@bfbba@*/
#define GPIO_PIDR1_PID16	(*(volatile uint_io8_t*)0xB71C1830UL)  /*@bfbba@*/
#define GPIO_PIDR1_PID17	(*(volatile uint_io8_t*)0xB71C1831UL)  /*@bfbba@*/
#define GPIO_PIDR1_PID18	(*(volatile uint_io8_t*)0xB71C1832UL)  /*@bfbba@*/
#define GPIO_PIDR1_PID19	(*(volatile uint_io8_t*)0xB71C1833UL)  /*@bfbba@*/
#define GPIO_PIDR1_PID20	(*(volatile uint_io8_t*)0xB71C1834UL)  /*@bfbba@*/
#define GPIO_PIDR1_PID21	(*(volatile uint_io8_t*)0xB71C1835UL)  /*@bfbba@*/
#define GPIO_PIDR1_PID22	(*(volatile uint_io8_t*)0xB71C1836UL)  /*@bfbba@*/
#define GPIO_PIDR1_PID23	(*(volatile uint_io8_t*)0xB71C1837UL)  /*@bfbba@*/
#define GPIO_PIDR1_PID24	(*(volatile uint_io8_t*)0xB71C1838UL)  /*@bfbba@*/
#define GPIO_PIDR1_PID25	(*(volatile uint_io8_t*)0xB71C1839UL)  /*@bfbba@*/
#define GPIO_PIDR1_PID26	(*(volatile uint_io8_t*)0xB71C183AUL)  /*@bfbba@*/
#define GPIO_PIDR1_PID27	(*(volatile uint_io8_t*)0xB71C183BUL)  /*@bfbba@*/
#define GPIO_PIDR1_PID28	(*(volatile uint_io8_t*)0xB71C183CUL)  /*@bfbba@*/
#define GPIO_PIDR1_PID29	(*(volatile uint_io8_t*)0xB71C183DUL)  /*@bfbba@*/
#define GPIO_PIDR1_PID30	(*(volatile uint_io8_t*)0xB71C183EUL)  /*@bfbba@*/
#define GPIO_PIDR1_PID31	(*(volatile uint_io8_t*)0xB71C183FUL)  /*@bfbba@*/

#define GPIO_PIDR2	(GPIO.unPIDR2.u32Register)  /*@rg@*/
#define GPIO_PIDR2_PID0	(*(volatile uint_io8_t*)0xB71C1840UL)  /*@bfbba@*/
#define GPIO_PIDR2_PID1	(*(volatile uint_io8_t*)0xB71C1841UL)  /*@bfbba@*/
#define GPIO_PIDR2_PID2	(*(volatile uint_io8_t*)0xB71C1842UL)  /*@bfbba@*/
#define GPIO_PIDR2_PID3	(*(volatile uint_io8_t*)0xB71C1843UL)  /*@bfbba@*/
#define GPIO_PIDR2_PID4	(*(volatile uint_io8_t*)0xB71C1844UL)  /*@bfbba@*/
#define GPIO_PIDR2_PID5	(*(volatile uint_io8_t*)0xB71C1845UL)  /*@bfbba@*/
#define GPIO_PIDR2_PID6	(*(volatile uint_io8_t*)0xB71C1846UL)  /*@bfbba@*/
#define GPIO_PIDR2_PID7	(*(volatile uint_io8_t*)0xB71C1847UL)  /*@bfbba@*/
#define GPIO_PIDR2_PID8	(*(volatile uint_io8_t*)0xB71C1848UL)  /*@bfbba@*/
#define GPIO_PIDR2_PID9	(*(volatile uint_io8_t*)0xB71C1849UL)  /*@bfbba@*/
#define GPIO_PIDR2_PID10	(*(volatile uint_io8_t*)0xB71C184AUL)  /*@bfbba@*/
#define GPIO_PIDR2_PID11	(*(volatile uint_io8_t*)0xB71C184BUL)  /*@bfbba@*/
#define GPIO_PIDR2_PID12	(*(volatile uint_io8_t*)0xB71C184CUL)  /*@bfbba@*/
#define GPIO_PIDR2_PID13	(*(volatile uint_io8_t*)0xB71C184DUL)  /*@bfbba@*/
#define GPIO_PIDR2_PID14	(*(volatile uint_io8_t*)0xB71C184EUL)  /*@bfbba@*/
#define GPIO_PIDR2_PID15	(*(volatile uint_io8_t*)0xB71C184FUL)  /*@bfbba@*/
#define GPIO_PIDR2_PID16	(*(volatile uint_io8_t*)0xB71C1850UL)  /*@bfbba@*/
#define GPIO_PIDR2_PID17	(*(volatile uint_io8_t*)0xB71C1851UL)  /*@bfbba@*/
#define GPIO_PIDR2_PID18	(*(volatile uint_io8_t*)0xB71C1852UL)  /*@bfbba@*/
#define GPIO_PIDR2_PID19	(*(volatile uint_io8_t*)0xB71C1853UL)  /*@bfbba@*/
#define GPIO_PIDR2_PID20	(*(volatile uint_io8_t*)0xB71C1854UL)  /*@bfbba@*/
#define GPIO_PIDR2_PID21	(*(volatile uint_io8_t*)0xB71C1855UL)  /*@bfbba@*/
#define GPIO_PIDR2_PID22	(*(volatile uint_io8_t*)0xB71C1856UL)  /*@bfbba@*/
#define GPIO_PIDR2_PID23	(*(volatile uint_io8_t*)0xB71C1857UL)  /*@bfbba@*/
#define GPIO_PIDR2_PID24	(*(volatile uint_io8_t*)0xB71C1858UL)  /*@bfbba@*/
#define GPIO_PIDR2_PID25	(*(volatile uint_io8_t*)0xB71C1859UL)  /*@bfbba@*/
#define GPIO_PIDR2_PID26	(*(volatile uint_io8_t*)0xB71C185AUL)  /*@bfbba@*/
#define GPIO_PIDR2_PID27	(*(volatile uint_io8_t*)0xB71C185BUL)  /*@bfbba@*/
#define GPIO_PIDR2_PID28	(*(volatile uint_io8_t*)0xB71C185CUL)  /*@bfbba@*/
#define GPIO_PIDR2_PID29	(*(volatile uint_io8_t*)0xB71C185DUL)  /*@bfbba@*/
#define GPIO_PIDR2_PID30	(*(volatile uint_io8_t*)0xB71C185EUL)  /*@bfbba@*/
#define GPIO_PIDR2_PID31	(*(volatile uint_io8_t*)0xB71C185FUL)  /*@bfbba@*/

#define GPIO_PIDR3	(GPIO.unPIDR3.u32Register)  /*@rg@*/
#define GPIO_PIDR3_PID0	(*(volatile uint_io8_t*)0xB71C1860UL)  /*@bfbba@*/
#define GPIO_PIDR3_PID1	(*(volatile uint_io8_t*)0xB71C1861UL)  /*@bfbba@*/
#define GPIO_PIDR3_PID2	(*(volatile uint_io8_t*)0xB71C1862UL)  /*@bfbba@*/
#define GPIO_PIDR3_PID3	(*(volatile uint_io8_t*)0xB71C1863UL)  /*@bfbba@*/
#define GPIO_PIDR3_PID4	(*(volatile uint_io8_t*)0xB71C1864UL)  /*@bfbba@*/
#define GPIO_PIDR3_PID5	(*(volatile uint_io8_t*)0xB71C1865UL)  /*@bfbba@*/
#define GPIO_PIDR3_PID6	(*(volatile uint_io8_t*)0xB71C1866UL)  /*@bfbba@*/
#define GPIO_PIDR3_PID7	(*(volatile uint_io8_t*)0xB71C1867UL)  /*@bfbba@*/
#define GPIO_PIDR3_PID8	(*(volatile uint_io8_t*)0xB71C1868UL)  /*@bfbba@*/
#define GPIO_PIDR3_PID9	(*(volatile uint_io8_t*)0xB71C1869UL)  /*@bfbba@*/
#define GPIO_PIDR3_PID10	(*(volatile uint_io8_t*)0xB71C186AUL)  /*@bfbba@*/
#define GPIO_PIDR3_PID11	(*(volatile uint_io8_t*)0xB71C186BUL)  /*@bfbba@*/
#define GPIO_PIDR3_PID12	(*(volatile uint_io8_t*)0xB71C186CUL)  /*@bfbba@*/
#define GPIO_PIDR3_PID13	(*(volatile uint_io8_t*)0xB71C186DUL)  /*@bfbba@*/
#define GPIO_PIDR3_PID14	(*(volatile uint_io8_t*)0xB71C186EUL)  /*@bfbba@*/
#define GPIO_PIDR3_PID15	(*(volatile uint_io8_t*)0xB71C186FUL)  /*@bfbba@*/
#define GPIO_PIDR3_PID16	(*(volatile uint_io8_t*)0xB71C1870UL)  /*@bfbba@*/
#define GPIO_PIDR3_PID17	(*(volatile uint_io8_t*)0xB71C1871UL)  /*@bfbba@*/
#define GPIO_PIDR3_PID18	(*(volatile uint_io8_t*)0xB71C1872UL)  /*@bfbba@*/
#define GPIO_PIDR3_PID19	(*(volatile uint_io8_t*)0xB71C1873UL)  /*@bfbba@*/
#define GPIO_PIDR3_PID20	(*(volatile uint_io8_t*)0xB71C1874UL)  /*@bfbba@*/
#define GPIO_PIDR3_PID21	(*(volatile uint_io8_t*)0xB71C1875UL)  /*@bfbba@*/
#define GPIO_PIDR3_PID22	(*(volatile uint_io8_t*)0xB71C1876UL)  /*@bfbba@*/
#define GPIO_PIDR3_PID23	(*(volatile uint_io8_t*)0xB71C1877UL)  /*@bfbba@*/
#define GPIO_PIDR3_PID24	(*(volatile uint_io8_t*)0xB71C1878UL)  /*@bfbba@*/
#define GPIO_PIDR3_PID25	(*(volatile uint_io8_t*)0xB71C1879UL)  /*@bfbba@*/
#define GPIO_PIDR3_PID26	(*(volatile uint_io8_t*)0xB71C187AUL)  /*@bfbba@*/
#define GPIO_PIDR3_PID27	(*(volatile uint_io8_t*)0xB71C187BUL)  /*@bfbba@*/
#define GPIO_PIDR3_PID28	(*(volatile uint_io8_t*)0xB71C187CUL)  /*@bfbba@*/
#define GPIO_PIDR3_PID29	(*(volatile uint_io8_t*)0xB71C187DUL)  /*@bfbba@*/
#define GPIO_PIDR3_PID30	(*(volatile uint_io8_t*)0xB71C187EUL)  /*@bfbba@*/
#define GPIO_PIDR3_PID31	(*(volatile uint_io8_t*)0xB71C187FUL)  /*@bfbba@*/

typedef struct stc_gpio_pidrn_field{
    uint_io32_t		u1PID0:1;
    uint_io32_t		u1PID1:1;
    uint_io32_t		u1PID2:1;
    uint_io32_t		u1PID3:1;
    uint_io32_t		u1PID4:1;
    uint_io32_t		u1PID5:1;
    uint_io32_t		u1PID6:1;
    uint_io32_t		u1PID7:1;
    uint_io32_t		u1PID8:1;
    uint_io32_t		u1PID9:1;
    uint_io32_t		u1PID10:1;
    uint_io32_t		u1PID11:1;
    uint_io32_t		u1PID12:1;
    uint_io32_t		u1PID13:1;
    uint_io32_t		u1PID14:1;
    uint_io32_t		u1PID15:1;
    uint_io32_t		u1PID16:1;
    uint_io32_t		u1PID17:1;
    uint_io32_t		u1PID18:1;
    uint_io32_t		u1PID19:1;
    uint_io32_t		u1PID20:1;
    uint_io32_t		u1PID21:1;
    uint_io32_t		u1PID22:1;
    uint_io32_t		u1PID23:1;
    uint_io32_t		u1PID24:1;
    uint_io32_t		u1PID25:1;
    uint_io32_t		u1PID26:1;
    uint_io32_t		u1PID27:1;
    uint_io32_t		u1PID28:1;
    uint_io32_t		u1PID29:1;
    uint_io32_t		u1PID30:1;
    uint_io32_t		u1PID31:1;
}stc_gpio_pidrn_field_t;

typedef union un_gpio_pidrn{
    uint_io32_t		u32Register;
    stc_gpio_pidrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_pidrn_t;

/* PORTEN */
#define GPIO_PORTEN	(GPIO.unPORTEN.u32Register)  /*@rg@*/
#define GPIO_PORTEN_GPORTEN	(*(volatile uint_io8_t*)0xB71C2000UL)  /*@bfbba@*/

typedef struct stc_gpio_porten_field{
    uint_io32_t		u1GPORTEN:1;
    uint_io32_t		:31;
}stc_gpio_porten_field_t;

typedef union un_gpio_porten{
    uint_io32_t		u32Register;
    stc_gpio_porten_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_porten_t;

/* KEYCDR */
#define GPIO_KEYCDR	(GPIO.unKEYCDR.u32Register)  /*@rg@*/
#define GPIO_KEYCDR_RADR	(GPIO.unKEYCDR.stcField.u15RADR)  /*@bf@*/
#define GPIO_KEYCDR_SIZE	(GPIO.unKEYCDR.stcField.u2SIZE)  /*@bf@*/
#define GPIO_KEYCDR_KEY	(GPIO.unKEYCDR.stcField.u2KEY)  /*@bf@*/

typedef struct stc_gpio_keycdr_field{
    uint_io32_t		u15RADR:15;
    uint_io32_t		:13;
    uint_io32_t		u2SIZE:2;
    uint_io32_t		u2KEY:2;
}stc_gpio_keycdr_field_t;

typedef union un_gpio_keycdr{
    uint_io32_t		u32Register;
    stc_gpio_keycdr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_keycdr_t;


typedef struct stc_gpio{
    un_gpio_posrn_t	unPOSR0;	/* 0x00000000 */
    un_gpio_pocrn_t	unPOCR0;	/* 0x00000004 */
    un_gpio_ddsrn_t	unDDSR0;	/* 0x00000008 */
    un_gpio_ddcrn_t	unDDCR0;	/* 0x0000000C */
    un_gpio_posrn_t	unPOSR1;	/* 0x00000010 */
    un_gpio_pocrn_t	unPOCR1;	/* 0x00000014 */
    un_gpio_ddsrn_t	unDDSR1;	/* 0x00000018 */
    un_gpio_ddcrn_t	unDDCR1;	/* 0x0000001C */
    un_gpio_posrn_t	unPOSR2;	/* 0x00000020 */
    un_gpio_pocrn_t	unPOCR2;	/* 0x00000024 */
    un_gpio_ddsrn_t	unDDSR2;	/* 0x00000028 */
    un_gpio_ddcrn_t	unDDCR2;	/* 0x0000002C */
    un_gpio_posrn_t	unPOSR3;	/* 0x00000030 */
    un_gpio_pocrn_t	unPOCR3;	/* 0x00000034 */
    un_gpio_ddsrn_t	unDDSR3;	/* 0x00000038 */
    un_gpio_ddcrn_t	unDDCR3;	/* 0x0000003C */
    uint_io8_t	au8Reserved0[448];	/* 0x00000040 */
    un_gpio_podrn_t	unPODR0;	/* 0x00000200 */
    un_gpio_ddrn_t	unDDR0;	/* 0x00000204 */
    un_gpio_podrn_t	unPODR1;	/* 0x00000208 */
    un_gpio_ddrn_t	unDDR1;	/* 0x0000020C */
    un_gpio_podrn_t	unPODR2;	/* 0x00000210 */
    un_gpio_ddrn_t	unDDR2;	/* 0x00000214 */
    un_gpio_podrn_t	unPODR3;	/* 0x00000218 */
    un_gpio_ddrn_t	unDDR3;	/* 0x0000021C */
    uint_io8_t	au8Reserved1[224];	/* 0x00000220 */
    un_gpio_pidrn_t	unPIDR0;	/* 0x00000300 */
    un_gpio_pidrn_t	unPIDR1;	/* 0x00000304 */
    un_gpio_pidrn_t	unPIDR2;	/* 0x00000308 */
    un_gpio_pidrn_t	unPIDR3;	/* 0x0000030C */
    uint_io8_t	au8Reserved2[240];	/* 0x00000310 */
    un_gpio_porten_t	unPORTEN;	/* 0x00000400 */
    un_gpio_keycdr_t	unKEYCDR;	/* 0x00000404 */
    uint_io8_t	au8Reserved3[31736];	/* 0x00000408 */
}stc_gpio_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_gpio_t	stcGPIO;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 32768(0x8000) bytes */


#endif /* __S6J3360_GPIO_H */
