/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_PCMPWM_H
#define __S6J3360_PCMPWM_H

#include "s6j3360io_basetypes.h"

/* PCMPWM0 base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define PCMPWM0	stcPCMPWM0
#else /* __IO_DEFINE */
#define PCMPWM0	(*((volatile stc_pcmpwm0_t*)0xB8020800U))
#endif /* __IO_DEFINE */

/* CONTROL */
#define PCMPWM0_CONTROL	(PCMPWM0.unCONTROL.u32Register)  /*@rg@*/
#define PCMPWM0_CONTROL_EN	(PCMPWM0.unCONTROL.stcField.u1EN)  /*@bf@*/
#define PCMPWM0_CONTROL_SILENCE	(PCMPWM0.unCONTROL.stcField.u1SILENCE)  /*@bf@*/
#define PCMPWM0_CONTROL_DMAEN	(PCMPWM0.unCONTROL.stcField.u1DMAEN)  /*@bf@*/
#define PCMPWM0_CONTROL_DBGEN	(PCMPWM0.unCONTROL.stcField.u1DBGEN)  /*@bf@*/
#define PCMPWM0_CONTROL_STEREO	(PCMPWM0.unCONTROL.stcField.u1STEREO)  /*@bf@*/
#define PCMPWM0_CONTROL_MODE	(PCMPWM0.unCONTROL.stcField.u2MODE)  /*@bf@*/
#define PCMPWM0_CONTROL_DOUBLE	(PCMPWM0.unCONTROL.stcField.u1DOUBLE)  /*@bf@*/
#define PCMPWM0_CONTROL_FEST	(PCMPWM0.unCONTROL.stcField.u5FEST)  /*@bf@*/
#define PCMPWM0_CONTROL_DTVAL	(PCMPWM0.unCONTROL.au8Byte[3])  /*@bfbyte@*/

typedef struct stc_pcmpwm0_control_field{
    uint_io32_t		u1EN:1;
    uint_io32_t		u1SILENCE:1;
    uint_io32_t		:6;
    uint_io32_t		u1DMAEN:1;
    uint_io32_t		u1DBGEN:1;
    uint_io32_t		u1STEREO:1;
    uint_io32_t		u2MODE:2;
    uint_io32_t		u1DOUBLE:1;
    uint_io32_t		:2;
    uint_io32_t		u5FEST:5;
    uint_io32_t		:3;
    uint_io32_t		u8DTVAL:8;
}stc_pcmpwm0_control_field_t;

typedef union un_pcmpwm0_control{
    uint_io32_t		u32Register;
    stc_pcmpwm0_control_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_pcmpwm0_control_t;

/* OCTRL */
#define PCMPWM0_OCTRL	(PCMPWM0.unOCTRL.u32Register)  /*@rg@*/
#define PCMPWM0_OCTRL_EN0	(PCMPWM0.unOCTRL.stcField.u1EN0)  /*@bf@*/
#define PCMPWM0_OCTRL_EN1	(PCMPWM0.unOCTRL.stcField.u1EN1)  /*@bf@*/
#define PCMPWM0_OCTRL_LEVL0	(PCMPWM0.unOCTRL.stcField.u1LEVL0)  /*@bf@*/
#define PCMPWM0_OCTRL_LEVL1	(PCMPWM0.unOCTRL.stcField.u1LEVL1)  /*@bf@*/

typedef struct stc_pcmpwm0_octrl_field{
    uint_io32_t		u1EN0:1;
    uint_io32_t		u1EN1:1;
    uint_io32_t		:14;
    uint_io32_t		u1LEVL0:1;
    uint_io32_t		u1LEVL1:1;
    uint_io32_t		:14;
}stc_pcmpwm0_octrl_field_t;

typedef union un_pcmpwm0_octrl{
    uint_io32_t		u32Register;
    stc_pcmpwm0_octrl_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_pcmpwm0_octrl_t;

/* CLKSEL */
#define PCMPWM0_CLKSEL	(PCMPWM0.unCLKSEL.u32Register)  /*@rg@*/
#define PCMPWM0_CLKSEL_CLK_SEL	(PCMPWM0.unCLKSEL.stcField.u2CLK_SEL)  /*@bf@*/

typedef struct stc_pcmpwm0_clksel_field{
    uint_io32_t		u2CLK_SEL:2;
    uint_io32_t		:30;
}stc_pcmpwm0_clksel_field_t;

typedef union un_pcmpwm0_clksel{
    uint_io32_t		u32Register;
    stc_pcmpwm0_clksel_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_pcmpwm0_clksel_t;

/* COUNTP */
#define PCMPWM0_COUNTP	(PCMPWM0.unCOUNTP.u32Register)  /*@rg@*/
#define PCMPWM0_COUNTP_COUNTP	(PCMPWM0.unCOUNTP.au16Halfword[0])  /*@bfhword@*/

typedef struct stc_pcmpwm0_countp_field{
    uint_io32_t		u16COUNTP:16;
    uint_io32_t		:16;
}stc_pcmpwm0_countp_field_t;

typedef union un_pcmpwm0_countp{
    uint_io32_t		u32Register;
    stc_pcmpwm0_countp_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_pcmpwm0_countp_t;

/* PCMOFFS */
#define PCMPWM0_PCMOFFS	(PCMPWM0.unPCMOFFS.u32Register)  /*@rg@*/
#define PCMPWM0_PCMOFFS_PCM_OFFS	(PCMPWM0.unPCMOFFS.au16Halfword[0])  /*@bfhword@*/

typedef struct stc_pcmpwm0_pcmoffs_field{
    uint_io32_t		u16PCM_OFFS:16;
    uint_io32_t		:16;
}stc_pcmpwm0_pcmoffs_field_t;

typedef union un_pcmpwm0_pcmoffs{
    uint_io32_t		u32Register;
    stc_pcmpwm0_pcmoffs_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_pcmpwm0_pcmoffs_t;

/* INTREN */
#define PCMPWM0_INTREN	(PCMPWM0.unINTREN.u32Register)  /*@rg@*/
#define PCMPWM0_INTREN_DREQ	(PCMPWM0.unINTREN.stcField.u1DREQ)  /*@bf@*/
#define PCMPWM0_INTREN_OVFL	(PCMPWM0.unINTREN.stcField.u1OVFL)  /*@bf@*/
#define PCMPWM0_INTREN_UDRN	(PCMPWM0.unINTREN.stcField.u1UDRN)  /*@bf@*/
#define PCMPWM0_INTREN_DMA_ERR	(PCMPWM0.unINTREN.stcField.u1DMA_ERR)  /*@bf@*/

typedef struct stc_pcmpwm0_intren_field{
    uint_io32_t		u1DREQ:1;
    uint_io32_t		u1OVFL:1;
    uint_io32_t		u1UDRN:1;
    uint_io32_t		u1DMA_ERR:1;
    uint_io32_t		:28;
}stc_pcmpwm0_intren_field_t;

typedef union un_pcmpwm0_intren{
    uint_io32_t		u32Register;
    stc_pcmpwm0_intren_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_pcmpwm0_intren_t;

/* INTRSTAT */
#define PCMPWM0_INTRSTAT	(PCMPWM0.unINTRSTAT.u32Register)  /*@rg@*/
#define PCMPWM0_INTRSTAT_DREQ	(PCMPWM0.unINTRSTAT.stcField.u1DREQ)  /*@bf@*/
#define PCMPWM0_INTRSTAT_OVFL	(PCMPWM0.unINTRSTAT.stcField.u1OVFL)  /*@bf@*/
#define PCMPWM0_INTRSTAT_UDRN	(PCMPWM0.unINTRSTAT.stcField.u1UDRN)  /*@bf@*/
#define PCMPWM0_INTRSTAT_DMA_ERR	(PCMPWM0.unINTRSTAT.stcField.u1DMA_ERR)  /*@bf@*/

typedef struct stc_pcmpwm0_intrstat_field{
    uint_io32_t		u1DREQ:1;
    uint_io32_t		u1OVFL:1;
    uint_io32_t		u1UDRN:1;
    uint_io32_t		u1DMA_ERR:1;
    uint_io32_t		:28;
}stc_pcmpwm0_intrstat_field_t;

typedef union un_pcmpwm0_intrstat{
    uint_io32_t		u32Register;
    stc_pcmpwm0_intrstat_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_pcmpwm0_intrstat_t;

/* INTRCLR */
#define PCMPWM0_INTRCLR	(PCMPWM0.unINTRCLR.u32Register)  /*@rg@*/
#define PCMPWM0_INTRCLR_DREQ	(PCMPWM0.unINTRCLR.stcField.u1DREQ)  /*@bf@*/
#define PCMPWM0_INTRCLR_OVFL	(PCMPWM0.unINTRCLR.stcField.u1OVFL)  /*@bf@*/
#define PCMPWM0_INTRCLR_UDRN	(PCMPWM0.unINTRCLR.stcField.u1UDRN)  /*@bf@*/
#define PCMPWM0_INTRCLR_DMA_ERR	(PCMPWM0.unINTRCLR.stcField.u1DMA_ERR)  /*@bf@*/

typedef struct stc_pcmpwm0_intrclr_field{
    uint_io32_t		u1DREQ:1;
    uint_io32_t		u1OVFL:1;
    uint_io32_t		u1UDRN:1;
    uint_io32_t		u1DMA_ERR:1;
    uint_io32_t		:28;
}stc_pcmpwm0_intrclr_field_t;

typedef union un_pcmpwm0_intrclr{
    uint_io32_t		u32Register;
    stc_pcmpwm0_intrclr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_pcmpwm0_intrclr_t;

/* DATA[0-15] */
#define PCMPWM0_DATA0	(PCMPWM0.unDATA0.u32Register)  /*@rg@*/
#define PCMPWM0_DATA0_DATA0	(PCMPWM0.unDATA0.stcField.u16DATA0)  /*@bf@*/
#define PCMPWM0_DATA0_DATA1	(PCMPWM0.unDATA0.stcField.u16DATA1)  /*@bf@*/

#define PCMPWM0_DATA1	(PCMPWM0.unDATA1.u32Register)  /*@rg@*/
#define PCMPWM0_DATA1_DATA0	(PCMPWM0.unDATA1.stcField.u16DATA0)  /*@bf@*/
#define PCMPWM0_DATA1_DATA1	(PCMPWM0.unDATA1.stcField.u16DATA1)  /*@bf@*/

#define PCMPWM0_DATA2	(PCMPWM0.unDATA2.u32Register)  /*@rg@*/
#define PCMPWM0_DATA2_DATA0	(PCMPWM0.unDATA2.stcField.u16DATA0)  /*@bf@*/
#define PCMPWM0_DATA2_DATA1	(PCMPWM0.unDATA2.stcField.u16DATA1)  /*@bf@*/

#define PCMPWM0_DATA3	(PCMPWM0.unDATA3.u32Register)  /*@rg@*/
#define PCMPWM0_DATA3_DATA0	(PCMPWM0.unDATA3.stcField.u16DATA0)  /*@bf@*/
#define PCMPWM0_DATA3_DATA1	(PCMPWM0.unDATA3.stcField.u16DATA1)  /*@bf@*/

#define PCMPWM0_DATA4	(PCMPWM0.unDATA4.u32Register)  /*@rg@*/
#define PCMPWM0_DATA4_DATA0	(PCMPWM0.unDATA4.stcField.u16DATA0)  /*@bf@*/
#define PCMPWM0_DATA4_DATA1	(PCMPWM0.unDATA4.stcField.u16DATA1)  /*@bf@*/

#define PCMPWM0_DATA5	(PCMPWM0.unDATA5.u32Register)  /*@rg@*/
#define PCMPWM0_DATA5_DATA0	(PCMPWM0.unDATA5.stcField.u16DATA0)  /*@bf@*/
#define PCMPWM0_DATA5_DATA1	(PCMPWM0.unDATA5.stcField.u16DATA1)  /*@bf@*/

#define PCMPWM0_DATA6	(PCMPWM0.unDATA6.u32Register)  /*@rg@*/
#define PCMPWM0_DATA6_DATA0	(PCMPWM0.unDATA6.stcField.u16DATA0)  /*@bf@*/
#define PCMPWM0_DATA6_DATA1	(PCMPWM0.unDATA6.stcField.u16DATA1)  /*@bf@*/

#define PCMPWM0_DATA7	(PCMPWM0.unDATA7.u32Register)  /*@rg@*/
#define PCMPWM0_DATA7_DATA0	(PCMPWM0.unDATA7.stcField.u16DATA0)  /*@bf@*/
#define PCMPWM0_DATA7_DATA1	(PCMPWM0.unDATA7.stcField.u16DATA1)  /*@bf@*/

#define PCMPWM0_DATA8	(PCMPWM0.unDATA8.u32Register)  /*@rg@*/
#define PCMPWM0_DATA8_DATA0	(PCMPWM0.unDATA8.stcField.u16DATA0)  /*@bf@*/
#define PCMPWM0_DATA8_DATA1	(PCMPWM0.unDATA8.stcField.u16DATA1)  /*@bf@*/

#define PCMPWM0_DATA9	(PCMPWM0.unDATA9.u32Register)  /*@rg@*/
#define PCMPWM0_DATA9_DATA0	(PCMPWM0.unDATA9.stcField.u16DATA0)  /*@bf@*/
#define PCMPWM0_DATA9_DATA1	(PCMPWM0.unDATA9.stcField.u16DATA1)  /*@bf@*/

#define PCMPWM0_DATA10	(PCMPWM0.unDATA10.u32Register)  /*@rg@*/
#define PCMPWM0_DATA10_DATA0	(PCMPWM0.unDATA10.stcField.u16DATA0)  /*@bf@*/
#define PCMPWM0_DATA10_DATA1	(PCMPWM0.unDATA10.stcField.u16DATA1)  /*@bf@*/

#define PCMPWM0_DATA11	(PCMPWM0.unDATA11.u32Register)  /*@rg@*/
#define PCMPWM0_DATA11_DATA0	(PCMPWM0.unDATA11.stcField.u16DATA0)  /*@bf@*/
#define PCMPWM0_DATA11_DATA1	(PCMPWM0.unDATA11.stcField.u16DATA1)  /*@bf@*/

#define PCMPWM0_DATA12	(PCMPWM0.unDATA12.u32Register)  /*@rg@*/
#define PCMPWM0_DATA12_DATA0	(PCMPWM0.unDATA12.stcField.u16DATA0)  /*@bf@*/
#define PCMPWM0_DATA12_DATA1	(PCMPWM0.unDATA12.stcField.u16DATA1)  /*@bf@*/

#define PCMPWM0_DATA13	(PCMPWM0.unDATA13.u32Register)  /*@rg@*/
#define PCMPWM0_DATA13_DATA0	(PCMPWM0.unDATA13.stcField.u16DATA0)  /*@bf@*/
#define PCMPWM0_DATA13_DATA1	(PCMPWM0.unDATA13.stcField.u16DATA1)  /*@bf@*/

#define PCMPWM0_DATA14	(PCMPWM0.unDATA14.u32Register)  /*@rg@*/
#define PCMPWM0_DATA14_DATA0	(PCMPWM0.unDATA14.stcField.u16DATA0)  /*@bf@*/
#define PCMPWM0_DATA14_DATA1	(PCMPWM0.unDATA14.stcField.u16DATA1)  /*@bf@*/

#define PCMPWM0_DATA15	(PCMPWM0.unDATA15.u32Register)  /*@rg@*/
#define PCMPWM0_DATA15_DATA0	(PCMPWM0.unDATA15.stcField.u16DATA0)  /*@bf@*/
#define PCMPWM0_DATA15_DATA1	(PCMPWM0.unDATA15.stcField.u16DATA1)  /*@bf@*/

typedef struct stc_pcmpwm0_datan_field{
    uint_io32_t		u16DATA0:16;
    uint_io32_t		u16DATA1:16;
}stc_pcmpwm0_datan_field_t;

typedef union un_pcmpwm0_datan{
    uint_io32_t		u32Register;
    stc_pcmpwm0_datan_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_pcmpwm0_datan_t;


typedef struct stc_pcmpwm0{
    un_pcmpwm0_control_t	unCONTROL;	/* 0x00000000 */
    un_pcmpwm0_octrl_t	unOCTRL;	/* 0x00000004 */
    un_pcmpwm0_clksel_t	unCLKSEL;	/* 0x00000008 */
    un_pcmpwm0_countp_t	unCOUNTP;	/* 0x0000000C */
    un_pcmpwm0_pcmoffs_t	unPCMOFFS;	/* 0x00000010 */
    un_pcmpwm0_intren_t	unINTREN;	/* 0x00000014 */
    un_pcmpwm0_intrstat_t	unINTRSTAT;	/* 0x00000018 */
    un_pcmpwm0_intrclr_t	unINTRCLR;	/* 0x0000001C */
    uint_io8_t	au8Reserved0[32];	/* 0x00000020 */
    un_pcmpwm0_datan_t	unDATA0;	/* 0x00000040 */
    un_pcmpwm0_datan_t	unDATA1;	/* 0x00000044 */
    un_pcmpwm0_datan_t	unDATA2;	/* 0x00000048 */
    un_pcmpwm0_datan_t	unDATA3;	/* 0x0000004C */
    un_pcmpwm0_datan_t	unDATA4;	/* 0x00000050 */
    un_pcmpwm0_datan_t	unDATA5;	/* 0x00000054 */
    un_pcmpwm0_datan_t	unDATA6;	/* 0x00000058 */
    un_pcmpwm0_datan_t	unDATA7;	/* 0x0000005C */
    un_pcmpwm0_datan_t	unDATA8;	/* 0x00000060 */
    un_pcmpwm0_datan_t	unDATA9;	/* 0x00000064 */
    un_pcmpwm0_datan_t	unDATA10;	/* 0x00000068 */
    un_pcmpwm0_datan_t	unDATA11;	/* 0x0000006C */
    un_pcmpwm0_datan_t	unDATA12;	/* 0x00000070 */
    un_pcmpwm0_datan_t	unDATA13;	/* 0x00000074 */
    un_pcmpwm0_datan_t	unDATA14;	/* 0x00000078 */
    un_pcmpwm0_datan_t	unDATA15;	/* 0x0000007C */
    uint_io8_t	au8Reserved1[896];	/* 0x00000080 */
}stc_pcmpwm0_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_pcmpwm0_t	stcPCMPWM0;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


#endif /* __S6J3360_PCMPWM_H */
