/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_TCFCFG_H
#define __S6J3360_TCFCFG_H

#include "s6j3360io_basetypes.h"

/* TCFCFG0 base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define TCFCFG0	stcTCFCFG0
#else /* __IO_DEFINE */
#define TCFCFG0	(*((volatile stc_tcfcfg0_t*)0xB0411000UL))
#endif /* __IO_DEFINE */

/* FCPROTKEY */
#define TCFCFG0_FCPROTKEY	(TCFCFG0.unFCPROTKEY.u32Register)  /*@rg@*/
#define TCFCFG0_FCPROTKEY_FCPROTKEY	TCFCFG0_FCPROTKEY  /*@bfrg@*/

typedef union un_tcfcfg0_fcprotkey{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_fcprotkey_t;

/* FCFGR */
#define TCFCFG0_FCFGR	(TCFCFG0.unFCFGR.u32Register)  /*@rg@*/
#define TCFCFG0_FCFGR_FAWC	(TCFCFG0.unFCFGR.stcField.u2FAWC)  /*@bf@*/
#define TCFCFG0_FCFGR_TCMSPEC	(*(volatile uint_io8_t*)0xB1188042UL)  /*@bfbba@*/
#define TCFCFG0_FCFGR_WE	(*(volatile uint_io8_t*)0xB1188044UL)  /*@bfbba@*/
#define TCFCFG0_FCFGR_TCMPR	(*(volatile uint_io8_t*)0xB1188045UL)  /*@bfbba@*/
#define TCFCFG0_FCFGR_SWFRST	(*(volatile uint_io8_t*)0xB1188046UL)  /*@bfbba@*/

typedef struct stc_tcfcfg0_fcfgr_field{
    uint_io32_t		u2FAWC:2;
    uint_io32_t		u1TCMSPEC:1;
    uint_io32_t		:1;
    uint_io32_t		u1WE:1;
    uint_io32_t		u1TCMPR:1;
    uint_io32_t		u1SWFRST:1;
    uint_io32_t		:25;
}stc_tcfcfg0_fcfgr_field_t;

typedef union un_tcfcfg0_fcfgr{
    uint_io32_t		u32Register;
    stc_tcfcfg0_fcfgr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_fcfgr_t;

/* FECCCTRL */
#define TCFCFG0_FECCCTRL	(TCFCFG0.unFECCCTRL.u32Register)  /*@rg@*/
#define TCFCFG0_FECCCTRL_ECCOFF	(*(volatile uint_io8_t*)0xB1188080UL)  /*@bfbba@*/

typedef struct stc_tcfcfg0_feccctrl_field{
    uint_io32_t		u1ECCOFF:1;
    uint_io32_t		:31;
}stc_tcfcfg0_feccctrl_field_t;

typedef union un_tcfcfg0_feccctrl{
    uint_io32_t		u32Register;
    stc_tcfcfg0_feccctrl_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_feccctrl_t;

/* FECCEIR */
#define TCFCFG0_FECCEIR	(TCFCFG0.unFECCEIR.u32Register)  /*@rg@*/
#define TCFCFG0_FECCEIR_FECCEIR	(TCFCFG0.unFECCEIR.au8Byte[0])  /*@bfbyte@*/
#define TCFCFG0_FECCEIR_LMASK	(TCFCFG0.unFECCEIR.stcField.u4LMASK)  /*@bf@*/

typedef struct stc_tcfcfg0_fecceir_field{
    uint_io32_t		u8FECCEIR:8;
    uint_io32_t		:16;
    uint_io32_t		u4LMASK:4;
    uint_io32_t		:4;
}stc_tcfcfg0_fecceir_field_t;

typedef union un_tcfcfg0_fecceir{
    uint_io32_t		u32Register;
    stc_tcfcfg0_fecceir_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_fecceir_t;

/* FICTRL */
#define TCFCFG0_FICTRL	(TCFCFG0.unFICTRL.u32Register)  /*@rg@*/
#define TCFCFG0_FICTRL_RDYIE	(*(volatile uint_io8_t*)0xB1188100UL)  /*@bfbba@*/
#define TCFCFG0_FICTRL_HANGIE	(*(volatile uint_io8_t*)0xB1188101UL)  /*@bfbba@*/
#define TCFCFG0_FICTRL_RDYIC	(*(volatile uint_io8_t*)0xB1188108UL)  /*@bfbba@*/
#define TCFCFG0_FICTRL_HANGIC	(*(volatile uint_io8_t*)0xB1188109UL)  /*@bfbba@*/

typedef struct stc_tcfcfg0_fictrl_field{
    uint_io32_t		u1RDYIE:1;
    uint_io32_t		u1HANGIE:1;
    uint_io32_t		:6;
    uint_io32_t		u1RDYIC:1;
    uint_io32_t		u1HANGIC:1;
    uint_io32_t		:22;
}stc_tcfcfg0_fictrl_field_t;

typedef union un_tcfcfg0_fictrl{
    uint_io32_t		u32Register;
    stc_tcfcfg0_fictrl_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_fictrl_t;

/* FDATEIR_L */
#define TCFCFG0_FDATEIR_L	(TCFCFG0.unFDATEIR_L.u32Register)  /*@rg@*/
#define TCFCFG0_FDATEIR_L_FDATEIR	TCFCFG0_FDATEIR_L  /*@bfrg@*/

typedef union un_tcfcfg0_fdateir_l{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_fdateir_l_t;

/* FDATEIR_H */
#define TCFCFG0_FDATEIR_H	(TCFCFG0.unFDATEIR_H.u32Register)  /*@rg@*/
#define TCFCFG0_FDATEIR_H_FDATEIR	TCFCFG0_FDATEIR_H  /*@bfrg@*/

typedef union un_tcfcfg0_fdateir_h{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_fdateir_h_t;

/* FSTAT */
#define TCFCFG0_FSTAT	(TCFCFG0.unFSTAT.u32Register)  /*@rg@*/
#define TCFCFG0_FSTAT_RDY	(*(volatile uint_io8_t*)0xB11881C0UL)  /*@bfbba@*/
#define TCFCFG0_FSTAT_HANG	(*(volatile uint_io8_t*)0xB11881C1UL)  /*@bfbba@*/
#define TCFCFG0_FSTAT_READ	(*(volatile uint_io8_t*)0xB11881C2UL)  /*@bfbba@*/
#define TCFCFG0_FSTAT_SERS	(*(volatile uint_io8_t*)0xB11881C3UL)  /*@bfbba@*/
#define TCFCFG0_FSTAT_ERSEC	(*(volatile uint_io8_t*)0xB11881C4UL)  /*@bfbba@*/
#define TCFCFG0_FSTAT_ESPS	(*(volatile uint_io8_t*)0xB11881C5UL)  /*@bfbba@*/
#define TCFCFG0_FSTAT_PGMS	(*(volatile uint_io8_t*)0xB11881C6UL)  /*@bfbba@*/
#define TCFCFG0_FSTAT_CERS	(*(volatile uint_io8_t*)0xB11881C7UL)  /*@bfbba@*/
#define TCFCFG0_FSTAT_RDYINT	(*(volatile uint_io8_t*)0xB11881C8UL)  /*@bfbba@*/
#define TCFCFG0_FSTAT_HANGINT	(*(volatile uint_io8_t*)0xB11881C9UL)  /*@bfbba@*/

typedef struct stc_tcfcfg0_fstat_field{
    uint_io32_t		u1RDY:1;
    uint_io32_t		u1HANG:1;
    uint_io32_t		u1READ:1;
    uint_io32_t		u1SERS:1;
    uint_io32_t		u1ERSEC:1;
    uint_io32_t		u1ESPS:1;
    uint_io32_t		u1PGMS:1;
    uint_io32_t		u1CERS:1;
    uint_io32_t		u1RDYINT:1;
    uint_io32_t		u1HANGINT:1;
    uint_io32_t		:22;
}stc_tcfcfg0_fstat_field_t;

typedef union un_tcfcfg0_fstat{
    uint_io32_t		u32Register;
    stc_tcfcfg0_fstat_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_fstat_t;

/* FSECIR */
#define TCFCFG0_FSECIR	(TCFCFG0.unFSECIR.u32Register)  /*@rg@*/
#define TCFCFG0_FSECIR_SECIE	(*(volatile uint_io8_t*)0xB1188280UL)  /*@bfbba@*/
#define TCFCFG0_FSECIR_SECIC	(*(volatile uint_io8_t*)0xB1188288UL)  /*@bfbba@*/
#define TCFCFG0_FSECIR_SECINT	(*(volatile uint_io8_t*)0xB1188290UL)  /*@bfbba@*/

typedef struct stc_tcfcfg0_fsecir_field{
    uint_io32_t		u1SECIE:1;
    uint_io32_t		:7;
    uint_io32_t		u1SECIC:1;
    uint_io32_t		:7;
    uint_io32_t		u1SECINT:1;
    uint_io32_t		:15;
}stc_tcfcfg0_fsecir_field_t;

typedef union un_tcfcfg0_fsecir{
    uint_io32_t		u32Register;
    stc_tcfcfg0_fsecir_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_fsecir_t;

/* FECCEAR */
#define TCFCFG0_FECCEAR	(TCFCFG0.unFECCEAR.u32Register)  /*@rg@*/
#define TCFCFG0_FECCEAR_SELF	(TCFCFG0.unFECCEAR.stcField.u4SELF)  /*@bf@*/
#define TCFCFG0_FECCEAR_FECCEAR_BASE	(TCFCFG0.unFECCEAR.stcField.u27FECCEAR_BASE)  /*@bf@*/

typedef struct stc_tcfcfg0_feccear_field{
    uint_io32_t		u4SELF:4;
    uint_io32_t		:1;
    uint_io32_t		u27FECCEAR_BASE:27;
}stc_tcfcfg0_feccear_field_t;

typedef union un_tcfcfg0_feccear{
    uint_io32_t		u32Register;
    stc_tcfcfg0_feccear_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_feccear_t;

/* FUIDR[0-1] */
#define TCFCFG0_FUIDR0	(TCFCFG0.unFUIDR0.u32Register)  /*@rg@*/
#define TCFCFG0_FUIDR0_UID	TCFCFG0_FUIDR0  /*@bfrg@*/

#define TCFCFG0_FUIDR1	(TCFCFG0.unFUIDR1.u32Register)  /*@rg@*/
#define TCFCFG0_FUIDR1_UID	TCFCFG0_FUIDR1  /*@bfrg@*/

typedef union un_tcfcfg0_fuidrn{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_fuidrn_t;

/* FUCEDIR */
#define TCFCFG0_FUCEDIR	(TCFCFG0.unFUCEDIR.u32Register)  /*@rg@*/
#define TCFCFG0_FUCEDIR_UCEDIC	(*(volatile uint_io8_t*)0xB1188408UL)  /*@bfbba@*/
#define TCFCFG0_FUCEDIR_UCEDINT	(*(volatile uint_io8_t*)0xB1188410UL)  /*@bfbba@*/

typedef struct stc_tcfcfg0_fucedir_field{
    uint_io32_t		:8;
    uint_io32_t		u1UCEDIC:1;
    uint_io32_t		:7;
    uint_io32_t		u1UCEDINT:1;
    uint_io32_t		:15;
}stc_tcfcfg0_fucedir_field_t;

typedef union un_tcfcfg0_fucedir{
    uint_io32_t		u32Register;
    stc_tcfcfg0_fucedir_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_fucedir_t;

/* FUCEAR */
#define TCFCFG0_FUCEAR	(TCFCFG0.unFUCEAR.u32Register)  /*@rg@*/
#define TCFCFG0_FUCEAR_UCELF	(TCFCFG0.unFUCEAR.stcField.u4UCELF)  /*@bf@*/
#define TCFCFG0_FUCEAR_UCEA_BASE	(TCFCFG0.unFUCEAR.stcField.u27UCEA_BASE)  /*@bf@*/

typedef struct stc_tcfcfg0_fucear_field{
    uint_io32_t		u4UCELF:4;
    uint_io32_t		:1;
    uint_io32_t		u27UCEA_BASE:27;
}stc_tcfcfg0_fucear_field_t;

typedef union un_tcfcfg0_fucear{
    uint_io32_t		u32Register;
    stc_tcfcfg0_fucear_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_fucear_t;

/* SYNR */
#define TCFCFG0_SYNR	(TCFCFG0.unSYNR.u32Register)  /*@rg@*/
#define TCFCFG0_SYNR_SYN0	(TCFCFG0.unSYNR.au8Byte[0])  /*@bfbyte@*/
#define TCFCFG0_SYNR_SYN1	(TCFCFG0.unSYNR.au8Byte[1])  /*@bfbyte@*/
#define TCFCFG0_SYNR_SYN2	(TCFCFG0.unSYNR.au8Byte[2])  /*@bfbyte@*/
#define TCFCFG0_SYNR_SYN3	(TCFCFG0.unSYNR.au8Byte[3])  /*@bfbyte@*/

typedef struct stc_tcfcfg0_synr_field{
    uint_io32_t		u8SYN0:8;
    uint_io32_t		u8SYN1:8;
    uint_io32_t		u8SYN2:8;
    uint_io32_t		u8SYN3:8;
}stc_tcfcfg0_synr_field_t;

typedef union un_tcfcfg0_synr{
    uint_io32_t		u32Register;
    stc_tcfcfg0_synr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_synr_t;

/* BRCFG */
#define TCFCFG0_BRCFG	(TCFCFG0.unBRCFG.u32Register)  /*@rg@*/
#define TCFCFG0_BRCFG_ESEC	(TCFCFG0.unBRCFG.au8Byte[0])  /*@bfbyte@*/
#define TCFCFG0_BRCFG_SSEC	(TCFCFG0.unBRCFG.au8Byte[1])  /*@bfbyte@*/
#define TCFCFG0_BRCFG_REGION_END_BUF	(TCFCFG0.unBRCFG.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_tcfcfg0_brcfg_field{
    uint_io32_t		u8ESEC:8;
    uint_io32_t		u8SSEC:8;
    uint_io32_t		u16REGION_END_BUF:16;
}stc_tcfcfg0_brcfg_field_t;

typedef union un_tcfcfg0_brcfg{
    uint_io32_t		u32Register;
    stc_tcfcfg0_brcfg_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_brcfg_t;

/* BRAT */
#define TCFCFG0_BRAT	(TCFCFG0.unBRAT.u32Register)  /*@rg@*/
#define TCFCFG0_BRAT_RGEN	(*(volatile uint_io8_t*)0xB11884C0UL)  /*@bfbba@*/
#define TCFCFG0_BRAT_AM	(TCFCFG0.unBRAT.stcField.u2AM)  /*@bf@*/
#define TCFCFG0_BRAT_VCLR	(*(volatile uint_io8_t*)0xB11884D0UL)  /*@bfbba@*/

typedef struct stc_tcfcfg0_brat_field{
    uint_io32_t		u1RGEN:1;
    uint_io32_t		:7;
    uint_io32_t		u2AM:2;
    uint_io32_t		:6;
    uint_io32_t		u1VCLR:1;
    uint_io32_t		:15;
}stc_tcfcfg0_brat_field_t;

typedef union un_tcfcfg0_brat{
    uint_io32_t		u32Register;
    stc_tcfcfg0_brat_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_brat_t;

/* WSWP[0-3] */
#define TCFCFG0_WSWP0	(TCFCFG0.unWSWP0.u32Register)  /*@rg@*/
#define TCFCFG0_WSWP0_SWP0	(*(volatile uint_io8_t*)0xB1189A00UL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP1	(*(volatile uint_io8_t*)0xB1189A01UL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP2	(*(volatile uint_io8_t*)0xB1189A02UL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP3	(*(volatile uint_io8_t*)0xB1189A03UL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP4	(*(volatile uint_io8_t*)0xB1189A04UL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP5	(*(volatile uint_io8_t*)0xB1189A05UL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP6	(*(volatile uint_io8_t*)0xB1189A06UL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP7	(*(volatile uint_io8_t*)0xB1189A07UL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP8	(*(volatile uint_io8_t*)0xB1189A08UL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP9	(*(volatile uint_io8_t*)0xB1189A09UL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP10	(*(volatile uint_io8_t*)0xB1189A0AUL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP11	(*(volatile uint_io8_t*)0xB1189A0BUL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP12	(*(volatile uint_io8_t*)0xB1189A0CUL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP13	(*(volatile uint_io8_t*)0xB1189A0DUL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP14	(*(volatile uint_io8_t*)0xB1189A0EUL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP15	(*(volatile uint_io8_t*)0xB1189A0FUL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP16	(*(volatile uint_io8_t*)0xB1189A10UL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP17	(*(volatile uint_io8_t*)0xB1189A11UL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP18	(*(volatile uint_io8_t*)0xB1189A12UL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP19	(*(volatile uint_io8_t*)0xB1189A13UL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP20	(*(volatile uint_io8_t*)0xB1189A14UL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP21	(*(volatile uint_io8_t*)0xB1189A15UL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP22	(*(volatile uint_io8_t*)0xB1189A16UL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP23	(*(volatile uint_io8_t*)0xB1189A17UL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP24	(*(volatile uint_io8_t*)0xB1189A18UL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP25	(*(volatile uint_io8_t*)0xB1189A19UL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP26	(*(volatile uint_io8_t*)0xB1189A1AUL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP27	(*(volatile uint_io8_t*)0xB1189A1BUL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP28	(*(volatile uint_io8_t*)0xB1189A1CUL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP29	(*(volatile uint_io8_t*)0xB1189A1DUL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP30	(*(volatile uint_io8_t*)0xB1189A1EUL)  /*@bfbba@*/
#define TCFCFG0_WSWP0_SWP31	(*(volatile uint_io8_t*)0xB1189A1FUL)  /*@bfbba@*/

#define TCFCFG0_WSWP1	(TCFCFG0.unWSWP1.u32Register)  /*@rg@*/
#define TCFCFG0_WSWP1_SWP0	(*(volatile uint_io8_t*)0xB1189A20UL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP1	(*(volatile uint_io8_t*)0xB1189A21UL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP2	(*(volatile uint_io8_t*)0xB1189A22UL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP3	(*(volatile uint_io8_t*)0xB1189A23UL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP4	(*(volatile uint_io8_t*)0xB1189A24UL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP5	(*(volatile uint_io8_t*)0xB1189A25UL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP6	(*(volatile uint_io8_t*)0xB1189A26UL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP7	(*(volatile uint_io8_t*)0xB1189A27UL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP8	(*(volatile uint_io8_t*)0xB1189A28UL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP9	(*(volatile uint_io8_t*)0xB1189A29UL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP10	(*(volatile uint_io8_t*)0xB1189A2AUL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP11	(*(volatile uint_io8_t*)0xB1189A2BUL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP12	(*(volatile uint_io8_t*)0xB1189A2CUL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP13	(*(volatile uint_io8_t*)0xB1189A2DUL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP14	(*(volatile uint_io8_t*)0xB1189A2EUL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP15	(*(volatile uint_io8_t*)0xB1189A2FUL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP16	(*(volatile uint_io8_t*)0xB1189A30UL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP17	(*(volatile uint_io8_t*)0xB1189A31UL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP18	(*(volatile uint_io8_t*)0xB1189A32UL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP19	(*(volatile uint_io8_t*)0xB1189A33UL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP20	(*(volatile uint_io8_t*)0xB1189A34UL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP21	(*(volatile uint_io8_t*)0xB1189A35UL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP22	(*(volatile uint_io8_t*)0xB1189A36UL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP23	(*(volatile uint_io8_t*)0xB1189A37UL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP24	(*(volatile uint_io8_t*)0xB1189A38UL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP25	(*(volatile uint_io8_t*)0xB1189A39UL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP26	(*(volatile uint_io8_t*)0xB1189A3AUL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP27	(*(volatile uint_io8_t*)0xB1189A3BUL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP28	(*(volatile uint_io8_t*)0xB1189A3CUL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP29	(*(volatile uint_io8_t*)0xB1189A3DUL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP30	(*(volatile uint_io8_t*)0xB1189A3EUL)  /*@bfbba@*/
#define TCFCFG0_WSWP1_SWP31	(*(volatile uint_io8_t*)0xB1189A3FUL)  /*@bfbba@*/

#define TCFCFG0_WSWP2	(TCFCFG0.unWSWP2.u32Register)  /*@rg@*/
#define TCFCFG0_WSWP2_SWP0	(*(volatile uint_io8_t*)0xB1189A40UL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP1	(*(volatile uint_io8_t*)0xB1189A41UL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP2	(*(volatile uint_io8_t*)0xB1189A42UL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP3	(*(volatile uint_io8_t*)0xB1189A43UL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP4	(*(volatile uint_io8_t*)0xB1189A44UL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP5	(*(volatile uint_io8_t*)0xB1189A45UL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP6	(*(volatile uint_io8_t*)0xB1189A46UL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP7	(*(volatile uint_io8_t*)0xB1189A47UL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP8	(*(volatile uint_io8_t*)0xB1189A48UL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP9	(*(volatile uint_io8_t*)0xB1189A49UL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP10	(*(volatile uint_io8_t*)0xB1189A4AUL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP11	(*(volatile uint_io8_t*)0xB1189A4BUL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP12	(*(volatile uint_io8_t*)0xB1189A4CUL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP13	(*(volatile uint_io8_t*)0xB1189A4DUL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP14	(*(volatile uint_io8_t*)0xB1189A4EUL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP15	(*(volatile uint_io8_t*)0xB1189A4FUL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP16	(*(volatile uint_io8_t*)0xB1189A50UL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP17	(*(volatile uint_io8_t*)0xB1189A51UL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP18	(*(volatile uint_io8_t*)0xB1189A52UL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP19	(*(volatile uint_io8_t*)0xB1189A53UL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP20	(*(volatile uint_io8_t*)0xB1189A54UL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP21	(*(volatile uint_io8_t*)0xB1189A55UL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP22	(*(volatile uint_io8_t*)0xB1189A56UL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP23	(*(volatile uint_io8_t*)0xB1189A57UL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP24	(*(volatile uint_io8_t*)0xB1189A58UL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP25	(*(volatile uint_io8_t*)0xB1189A59UL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP26	(*(volatile uint_io8_t*)0xB1189A5AUL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP27	(*(volatile uint_io8_t*)0xB1189A5BUL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP28	(*(volatile uint_io8_t*)0xB1189A5CUL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP29	(*(volatile uint_io8_t*)0xB1189A5DUL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP30	(*(volatile uint_io8_t*)0xB1189A5EUL)  /*@bfbba@*/
#define TCFCFG0_WSWP2_SWP31	(*(volatile uint_io8_t*)0xB1189A5FUL)  /*@bfbba@*/

#define TCFCFG0_WSWP3	(TCFCFG0.unWSWP3.u32Register)  /*@rg@*/
#define TCFCFG0_WSWP3_SWP0	(*(volatile uint_io8_t*)0xB1189A60UL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP1	(*(volatile uint_io8_t*)0xB1189A61UL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP2	(*(volatile uint_io8_t*)0xB1189A62UL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP3	(*(volatile uint_io8_t*)0xB1189A63UL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP4	(*(volatile uint_io8_t*)0xB1189A64UL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP5	(*(volatile uint_io8_t*)0xB1189A65UL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP6	(*(volatile uint_io8_t*)0xB1189A66UL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP7	(*(volatile uint_io8_t*)0xB1189A67UL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP8	(*(volatile uint_io8_t*)0xB1189A68UL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP9	(*(volatile uint_io8_t*)0xB1189A69UL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP10	(*(volatile uint_io8_t*)0xB1189A6AUL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP11	(*(volatile uint_io8_t*)0xB1189A6BUL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP12	(*(volatile uint_io8_t*)0xB1189A6CUL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP13	(*(volatile uint_io8_t*)0xB1189A6DUL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP14	(*(volatile uint_io8_t*)0xB1189A6EUL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP15	(*(volatile uint_io8_t*)0xB1189A6FUL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP16	(*(volatile uint_io8_t*)0xB1189A70UL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP17	(*(volatile uint_io8_t*)0xB1189A71UL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP18	(*(volatile uint_io8_t*)0xB1189A72UL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP19	(*(volatile uint_io8_t*)0xB1189A73UL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP20	(*(volatile uint_io8_t*)0xB1189A74UL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP21	(*(volatile uint_io8_t*)0xB1189A75UL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP22	(*(volatile uint_io8_t*)0xB1189A76UL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP23	(*(volatile uint_io8_t*)0xB1189A77UL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP24	(*(volatile uint_io8_t*)0xB1189A78UL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP25	(*(volatile uint_io8_t*)0xB1189A79UL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP26	(*(volatile uint_io8_t*)0xB1189A7AUL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP27	(*(volatile uint_io8_t*)0xB1189A7BUL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP28	(*(volatile uint_io8_t*)0xB1189A7CUL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP29	(*(volatile uint_io8_t*)0xB1189A7DUL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP30	(*(volatile uint_io8_t*)0xB1189A7EUL)  /*@bfbba@*/
#define TCFCFG0_WSWP3_SWP31	(*(volatile uint_io8_t*)0xB1189A7FUL)  /*@bfbba@*/

typedef struct stc_tcfcfg0_wswpn_field{
    uint_io32_t		u1SWP0:1;
    uint_io32_t		u1SWP1:1;
    uint_io32_t		u1SWP2:1;
    uint_io32_t		u1SWP3:1;
    uint_io32_t		u1SWP4:1;
    uint_io32_t		u1SWP5:1;
    uint_io32_t		u1SWP6:1;
    uint_io32_t		u1SWP7:1;
    uint_io32_t		u1SWP8:1;
    uint_io32_t		u1SWP9:1;
    uint_io32_t		u1SWP10:1;
    uint_io32_t		u1SWP11:1;
    uint_io32_t		u1SWP12:1;
    uint_io32_t		u1SWP13:1;
    uint_io32_t		u1SWP14:1;
    uint_io32_t		u1SWP15:1;
    uint_io32_t		u1SWP16:1;
    uint_io32_t		u1SWP17:1;
    uint_io32_t		u1SWP18:1;
    uint_io32_t		u1SWP19:1;
    uint_io32_t		u1SWP20:1;
    uint_io32_t		u1SWP21:1;
    uint_io32_t		u1SWP22:1;
    uint_io32_t		u1SWP23:1;
    uint_io32_t		u1SWP24:1;
    uint_io32_t		u1SWP25:1;
    uint_io32_t		u1SWP26:1;
    uint_io32_t		u1SWP27:1;
    uint_io32_t		u1SWP28:1;
    uint_io32_t		u1SWP29:1;
    uint_io32_t		u1SWP30:1;
    uint_io32_t		u1SWP31:1;
}stc_tcfcfg0_wswpn_field_t;

typedef union un_tcfcfg0_wswpn{
    uint_io32_t		u32Register;
    stc_tcfcfg0_wswpn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_wswpn_t;

/* CSWP[1-8] */
#define TCFCFG0_CSWP1	(TCFCFG0.unCSWP1.u32Register)  /*@rg@*/
#define TCFCFG0_CSWP1_SWP0	(*(volatile uint_io8_t*)0xB1189C00UL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP1	(*(volatile uint_io8_t*)0xB1189C01UL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP2	(*(volatile uint_io8_t*)0xB1189C02UL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP3	(*(volatile uint_io8_t*)0xB1189C03UL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP4	(*(volatile uint_io8_t*)0xB1189C04UL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP5	(*(volatile uint_io8_t*)0xB1189C05UL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP6	(*(volatile uint_io8_t*)0xB1189C06UL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP7	(*(volatile uint_io8_t*)0xB1189C07UL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP8	(*(volatile uint_io8_t*)0xB1189C08UL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP9	(*(volatile uint_io8_t*)0xB1189C09UL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP10	(*(volatile uint_io8_t*)0xB1189C0AUL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP11	(*(volatile uint_io8_t*)0xB1189C0BUL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP12	(*(volatile uint_io8_t*)0xB1189C0CUL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP13	(*(volatile uint_io8_t*)0xB1189C0DUL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP14	(*(volatile uint_io8_t*)0xB1189C0EUL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP15	(*(volatile uint_io8_t*)0xB1189C0FUL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP16	(*(volatile uint_io8_t*)0xB1189C10UL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP17	(*(volatile uint_io8_t*)0xB1189C11UL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP18	(*(volatile uint_io8_t*)0xB1189C12UL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP19	(*(volatile uint_io8_t*)0xB1189C13UL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP20	(*(volatile uint_io8_t*)0xB1189C14UL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP21	(*(volatile uint_io8_t*)0xB1189C15UL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP22	(*(volatile uint_io8_t*)0xB1189C16UL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP23	(*(volatile uint_io8_t*)0xB1189C17UL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP24	(*(volatile uint_io8_t*)0xB1189C18UL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP25	(*(volatile uint_io8_t*)0xB1189C19UL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP26	(*(volatile uint_io8_t*)0xB1189C1AUL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP27	(*(volatile uint_io8_t*)0xB1189C1BUL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP28	(*(volatile uint_io8_t*)0xB1189C1CUL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP29	(*(volatile uint_io8_t*)0xB1189C1DUL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP30	(*(volatile uint_io8_t*)0xB1189C1EUL)  /*@bfbba@*/
#define TCFCFG0_CSWP1_SWP31	(*(volatile uint_io8_t*)0xB1189C1FUL)  /*@bfbba@*/

#define TCFCFG0_CSWP2	(TCFCFG0.unCSWP2.u32Register)  /*@rg@*/
#define TCFCFG0_CSWP2_SWP0	(*(volatile uint_io8_t*)0xB1189C20UL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP1	(*(volatile uint_io8_t*)0xB1189C21UL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP2	(*(volatile uint_io8_t*)0xB1189C22UL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP3	(*(volatile uint_io8_t*)0xB1189C23UL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP4	(*(volatile uint_io8_t*)0xB1189C24UL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP5	(*(volatile uint_io8_t*)0xB1189C25UL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP6	(*(volatile uint_io8_t*)0xB1189C26UL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP7	(*(volatile uint_io8_t*)0xB1189C27UL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP8	(*(volatile uint_io8_t*)0xB1189C28UL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP9	(*(volatile uint_io8_t*)0xB1189C29UL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP10	(*(volatile uint_io8_t*)0xB1189C2AUL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP11	(*(volatile uint_io8_t*)0xB1189C2BUL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP12	(*(volatile uint_io8_t*)0xB1189C2CUL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP13	(*(volatile uint_io8_t*)0xB1189C2DUL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP14	(*(volatile uint_io8_t*)0xB1189C2EUL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP15	(*(volatile uint_io8_t*)0xB1189C2FUL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP16	(*(volatile uint_io8_t*)0xB1189C30UL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP17	(*(volatile uint_io8_t*)0xB1189C31UL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP18	(*(volatile uint_io8_t*)0xB1189C32UL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP19	(*(volatile uint_io8_t*)0xB1189C33UL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP20	(*(volatile uint_io8_t*)0xB1189C34UL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP21	(*(volatile uint_io8_t*)0xB1189C35UL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP22	(*(volatile uint_io8_t*)0xB1189C36UL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP23	(*(volatile uint_io8_t*)0xB1189C37UL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP24	(*(volatile uint_io8_t*)0xB1189C38UL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP25	(*(volatile uint_io8_t*)0xB1189C39UL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP26	(*(volatile uint_io8_t*)0xB1189C3AUL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP27	(*(volatile uint_io8_t*)0xB1189C3BUL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP28	(*(volatile uint_io8_t*)0xB1189C3CUL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP29	(*(volatile uint_io8_t*)0xB1189C3DUL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP30	(*(volatile uint_io8_t*)0xB1189C3EUL)  /*@bfbba@*/
#define TCFCFG0_CSWP2_SWP31	(*(volatile uint_io8_t*)0xB1189C3FUL)  /*@bfbba@*/

#define TCFCFG0_CSWP3	(TCFCFG0.unCSWP3.u32Register)  /*@rg@*/
#define TCFCFG0_CSWP3_SWP0	(*(volatile uint_io8_t*)0xB1189C40UL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP1	(*(volatile uint_io8_t*)0xB1189C41UL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP2	(*(volatile uint_io8_t*)0xB1189C42UL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP3	(*(volatile uint_io8_t*)0xB1189C43UL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP4	(*(volatile uint_io8_t*)0xB1189C44UL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP5	(*(volatile uint_io8_t*)0xB1189C45UL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP6	(*(volatile uint_io8_t*)0xB1189C46UL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP7	(*(volatile uint_io8_t*)0xB1189C47UL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP8	(*(volatile uint_io8_t*)0xB1189C48UL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP9	(*(volatile uint_io8_t*)0xB1189C49UL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP10	(*(volatile uint_io8_t*)0xB1189C4AUL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP11	(*(volatile uint_io8_t*)0xB1189C4BUL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP12	(*(volatile uint_io8_t*)0xB1189C4CUL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP13	(*(volatile uint_io8_t*)0xB1189C4DUL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP14	(*(volatile uint_io8_t*)0xB1189C4EUL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP15	(*(volatile uint_io8_t*)0xB1189C4FUL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP16	(*(volatile uint_io8_t*)0xB1189C50UL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP17	(*(volatile uint_io8_t*)0xB1189C51UL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP18	(*(volatile uint_io8_t*)0xB1189C52UL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP19	(*(volatile uint_io8_t*)0xB1189C53UL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP20	(*(volatile uint_io8_t*)0xB1189C54UL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP21	(*(volatile uint_io8_t*)0xB1189C55UL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP22	(*(volatile uint_io8_t*)0xB1189C56UL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP23	(*(volatile uint_io8_t*)0xB1189C57UL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP24	(*(volatile uint_io8_t*)0xB1189C58UL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP25	(*(volatile uint_io8_t*)0xB1189C59UL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP26	(*(volatile uint_io8_t*)0xB1189C5AUL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP27	(*(volatile uint_io8_t*)0xB1189C5BUL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP28	(*(volatile uint_io8_t*)0xB1189C5CUL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP29	(*(volatile uint_io8_t*)0xB1189C5DUL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP30	(*(volatile uint_io8_t*)0xB1189C5EUL)  /*@bfbba@*/
#define TCFCFG0_CSWP3_SWP31	(*(volatile uint_io8_t*)0xB1189C5FUL)  /*@bfbba@*/

#define TCFCFG0_CSWP4	(TCFCFG0.unCSWP4.u32Register)  /*@rg@*/
#define TCFCFG0_CSWP4_SWP0	(*(volatile uint_io8_t*)0xB1189C60UL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP1	(*(volatile uint_io8_t*)0xB1189C61UL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP2	(*(volatile uint_io8_t*)0xB1189C62UL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP3	(*(volatile uint_io8_t*)0xB1189C63UL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP4	(*(volatile uint_io8_t*)0xB1189C64UL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP5	(*(volatile uint_io8_t*)0xB1189C65UL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP6	(*(volatile uint_io8_t*)0xB1189C66UL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP7	(*(volatile uint_io8_t*)0xB1189C67UL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP8	(*(volatile uint_io8_t*)0xB1189C68UL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP9	(*(volatile uint_io8_t*)0xB1189C69UL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP10	(*(volatile uint_io8_t*)0xB1189C6AUL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP11	(*(volatile uint_io8_t*)0xB1189C6BUL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP12	(*(volatile uint_io8_t*)0xB1189C6CUL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP13	(*(volatile uint_io8_t*)0xB1189C6DUL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP14	(*(volatile uint_io8_t*)0xB1189C6EUL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP15	(*(volatile uint_io8_t*)0xB1189C6FUL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP16	(*(volatile uint_io8_t*)0xB1189C70UL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP17	(*(volatile uint_io8_t*)0xB1189C71UL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP18	(*(volatile uint_io8_t*)0xB1189C72UL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP19	(*(volatile uint_io8_t*)0xB1189C73UL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP20	(*(volatile uint_io8_t*)0xB1189C74UL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP21	(*(volatile uint_io8_t*)0xB1189C75UL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP22	(*(volatile uint_io8_t*)0xB1189C76UL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP23	(*(volatile uint_io8_t*)0xB1189C77UL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP24	(*(volatile uint_io8_t*)0xB1189C78UL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP25	(*(volatile uint_io8_t*)0xB1189C79UL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP26	(*(volatile uint_io8_t*)0xB1189C7AUL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP27	(*(volatile uint_io8_t*)0xB1189C7BUL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP28	(*(volatile uint_io8_t*)0xB1189C7CUL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP29	(*(volatile uint_io8_t*)0xB1189C7DUL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP30	(*(volatile uint_io8_t*)0xB1189C7EUL)  /*@bfbba@*/
#define TCFCFG0_CSWP4_SWP31	(*(volatile uint_io8_t*)0xB1189C7FUL)  /*@bfbba@*/

#define TCFCFG0_CSWP5	(TCFCFG0.unCSWP5.u32Register)  /*@rg@*/
#define TCFCFG0_CSWP5_SWP0	(*(volatile uint_io8_t*)0xB1189C80UL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP1	(*(volatile uint_io8_t*)0xB1189C81UL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP2	(*(volatile uint_io8_t*)0xB1189C82UL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP3	(*(volatile uint_io8_t*)0xB1189C83UL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP4	(*(volatile uint_io8_t*)0xB1189C84UL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP5	(*(volatile uint_io8_t*)0xB1189C85UL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP6	(*(volatile uint_io8_t*)0xB1189C86UL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP7	(*(volatile uint_io8_t*)0xB1189C87UL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP8	(*(volatile uint_io8_t*)0xB1189C88UL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP9	(*(volatile uint_io8_t*)0xB1189C89UL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP10	(*(volatile uint_io8_t*)0xB1189C8AUL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP11	(*(volatile uint_io8_t*)0xB1189C8BUL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP12	(*(volatile uint_io8_t*)0xB1189C8CUL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP13	(*(volatile uint_io8_t*)0xB1189C8DUL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP14	(*(volatile uint_io8_t*)0xB1189C8EUL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP15	(*(volatile uint_io8_t*)0xB1189C8FUL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP16	(*(volatile uint_io8_t*)0xB1189C90UL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP17	(*(volatile uint_io8_t*)0xB1189C91UL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP18	(*(volatile uint_io8_t*)0xB1189C92UL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP19	(*(volatile uint_io8_t*)0xB1189C93UL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP20	(*(volatile uint_io8_t*)0xB1189C94UL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP21	(*(volatile uint_io8_t*)0xB1189C95UL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP22	(*(volatile uint_io8_t*)0xB1189C96UL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP23	(*(volatile uint_io8_t*)0xB1189C97UL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP24	(*(volatile uint_io8_t*)0xB1189C98UL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP25	(*(volatile uint_io8_t*)0xB1189C99UL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP26	(*(volatile uint_io8_t*)0xB1189C9AUL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP27	(*(volatile uint_io8_t*)0xB1189C9BUL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP28	(*(volatile uint_io8_t*)0xB1189C9CUL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP29	(*(volatile uint_io8_t*)0xB1189C9DUL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP30	(*(volatile uint_io8_t*)0xB1189C9EUL)  /*@bfbba@*/
#define TCFCFG0_CSWP5_SWP31	(*(volatile uint_io8_t*)0xB1189C9FUL)  /*@bfbba@*/

#define TCFCFG0_CSWP6	(TCFCFG0.unCSWP6.u32Register)  /*@rg@*/
#define TCFCFG0_CSWP6_SWP0	(*(volatile uint_io8_t*)0xB1189CA0UL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP1	(*(volatile uint_io8_t*)0xB1189CA1UL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP2	(*(volatile uint_io8_t*)0xB1189CA2UL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP3	(*(volatile uint_io8_t*)0xB1189CA3UL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP4	(*(volatile uint_io8_t*)0xB1189CA4UL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP5	(*(volatile uint_io8_t*)0xB1189CA5UL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP6	(*(volatile uint_io8_t*)0xB1189CA6UL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP7	(*(volatile uint_io8_t*)0xB1189CA7UL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP8	(*(volatile uint_io8_t*)0xB1189CA8UL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP9	(*(volatile uint_io8_t*)0xB1189CA9UL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP10	(*(volatile uint_io8_t*)0xB1189CAAUL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP11	(*(volatile uint_io8_t*)0xB1189CABUL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP12	(*(volatile uint_io8_t*)0xB1189CACUL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP13	(*(volatile uint_io8_t*)0xB1189CADUL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP14	(*(volatile uint_io8_t*)0xB1189CAEUL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP15	(*(volatile uint_io8_t*)0xB1189CAFUL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP16	(*(volatile uint_io8_t*)0xB1189CB0UL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP17	(*(volatile uint_io8_t*)0xB1189CB1UL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP18	(*(volatile uint_io8_t*)0xB1189CB2UL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP19	(*(volatile uint_io8_t*)0xB1189CB3UL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP20	(*(volatile uint_io8_t*)0xB1189CB4UL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP21	(*(volatile uint_io8_t*)0xB1189CB5UL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP22	(*(volatile uint_io8_t*)0xB1189CB6UL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP23	(*(volatile uint_io8_t*)0xB1189CB7UL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP24	(*(volatile uint_io8_t*)0xB1189CB8UL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP25	(*(volatile uint_io8_t*)0xB1189CB9UL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP26	(*(volatile uint_io8_t*)0xB1189CBAUL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP27	(*(volatile uint_io8_t*)0xB1189CBBUL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP28	(*(volatile uint_io8_t*)0xB1189CBCUL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP29	(*(volatile uint_io8_t*)0xB1189CBDUL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP30	(*(volatile uint_io8_t*)0xB1189CBEUL)  /*@bfbba@*/
#define TCFCFG0_CSWP6_SWP31	(*(volatile uint_io8_t*)0xB1189CBFUL)  /*@bfbba@*/

#define TCFCFG0_CSWP7	(TCFCFG0.unCSWP7.u32Register)  /*@rg@*/
#define TCFCFG0_CSWP7_SWP0	(*(volatile uint_io8_t*)0xB1189CC0UL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP1	(*(volatile uint_io8_t*)0xB1189CC1UL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP2	(*(volatile uint_io8_t*)0xB1189CC2UL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP3	(*(volatile uint_io8_t*)0xB1189CC3UL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP4	(*(volatile uint_io8_t*)0xB1189CC4UL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP5	(*(volatile uint_io8_t*)0xB1189CC5UL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP6	(*(volatile uint_io8_t*)0xB1189CC6UL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP7	(*(volatile uint_io8_t*)0xB1189CC7UL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP8	(*(volatile uint_io8_t*)0xB1189CC8UL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP9	(*(volatile uint_io8_t*)0xB1189CC9UL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP10	(*(volatile uint_io8_t*)0xB1189CCAUL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP11	(*(volatile uint_io8_t*)0xB1189CCBUL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP12	(*(volatile uint_io8_t*)0xB1189CCCUL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP13	(*(volatile uint_io8_t*)0xB1189CCDUL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP14	(*(volatile uint_io8_t*)0xB1189CCEUL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP15	(*(volatile uint_io8_t*)0xB1189CCFUL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP16	(*(volatile uint_io8_t*)0xB1189CD0UL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP17	(*(volatile uint_io8_t*)0xB1189CD1UL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP18	(*(volatile uint_io8_t*)0xB1189CD2UL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP19	(*(volatile uint_io8_t*)0xB1189CD3UL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP20	(*(volatile uint_io8_t*)0xB1189CD4UL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP21	(*(volatile uint_io8_t*)0xB1189CD5UL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP22	(*(volatile uint_io8_t*)0xB1189CD6UL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP23	(*(volatile uint_io8_t*)0xB1189CD7UL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP24	(*(volatile uint_io8_t*)0xB1189CD8UL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP25	(*(volatile uint_io8_t*)0xB1189CD9UL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP26	(*(volatile uint_io8_t*)0xB1189CDAUL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP27	(*(volatile uint_io8_t*)0xB1189CDBUL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP28	(*(volatile uint_io8_t*)0xB1189CDCUL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP29	(*(volatile uint_io8_t*)0xB1189CDDUL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP30	(*(volatile uint_io8_t*)0xB1189CDEUL)  /*@bfbba@*/
#define TCFCFG0_CSWP7_SWP31	(*(volatile uint_io8_t*)0xB1189CDFUL)  /*@bfbba@*/

#define TCFCFG0_CSWP8	(TCFCFG0.unCSWP8.u32Register)  /*@rg@*/
#define TCFCFG0_CSWP8_SWP0	(*(volatile uint_io8_t*)0xB1189CE0UL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP1	(*(volatile uint_io8_t*)0xB1189CE1UL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP2	(*(volatile uint_io8_t*)0xB1189CE2UL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP3	(*(volatile uint_io8_t*)0xB1189CE3UL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP4	(*(volatile uint_io8_t*)0xB1189CE4UL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP5	(*(volatile uint_io8_t*)0xB1189CE5UL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP6	(*(volatile uint_io8_t*)0xB1189CE6UL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP7	(*(volatile uint_io8_t*)0xB1189CE7UL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP8	(*(volatile uint_io8_t*)0xB1189CE8UL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP9	(*(volatile uint_io8_t*)0xB1189CE9UL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP10	(*(volatile uint_io8_t*)0xB1189CEAUL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP11	(*(volatile uint_io8_t*)0xB1189CEBUL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP12	(*(volatile uint_io8_t*)0xB1189CECUL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP13	(*(volatile uint_io8_t*)0xB1189CEDUL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP14	(*(volatile uint_io8_t*)0xB1189CEEUL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP15	(*(volatile uint_io8_t*)0xB1189CEFUL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP16	(*(volatile uint_io8_t*)0xB1189CF0UL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP17	(*(volatile uint_io8_t*)0xB1189CF1UL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP18	(*(volatile uint_io8_t*)0xB1189CF2UL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP19	(*(volatile uint_io8_t*)0xB1189CF3UL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP20	(*(volatile uint_io8_t*)0xB1189CF4UL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP21	(*(volatile uint_io8_t*)0xB1189CF5UL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP22	(*(volatile uint_io8_t*)0xB1189CF6UL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP23	(*(volatile uint_io8_t*)0xB1189CF7UL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP24	(*(volatile uint_io8_t*)0xB1189CF8UL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP25	(*(volatile uint_io8_t*)0xB1189CF9UL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP26	(*(volatile uint_io8_t*)0xB1189CFAUL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP27	(*(volatile uint_io8_t*)0xB1189CFBUL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP28	(*(volatile uint_io8_t*)0xB1189CFCUL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP29	(*(volatile uint_io8_t*)0xB1189CFDUL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP30	(*(volatile uint_io8_t*)0xB1189CFEUL)  /*@bfbba@*/
#define TCFCFG0_CSWP8_SWP31	(*(volatile uint_io8_t*)0xB1189CFFUL)  /*@bfbba@*/

typedef struct stc_tcfcfg0_cswpn_field{
    uint_io32_t		u1SWP0:1;
    uint_io32_t		u1SWP1:1;
    uint_io32_t		u1SWP2:1;
    uint_io32_t		u1SWP3:1;
    uint_io32_t		u1SWP4:1;
    uint_io32_t		u1SWP5:1;
    uint_io32_t		u1SWP6:1;
    uint_io32_t		u1SWP7:1;
    uint_io32_t		u1SWP8:1;
    uint_io32_t		u1SWP9:1;
    uint_io32_t		u1SWP10:1;
    uint_io32_t		u1SWP11:1;
    uint_io32_t		u1SWP12:1;
    uint_io32_t		u1SWP13:1;
    uint_io32_t		u1SWP14:1;
    uint_io32_t		u1SWP15:1;
    uint_io32_t		u1SWP16:1;
    uint_io32_t		u1SWP17:1;
    uint_io32_t		u1SWP18:1;
    uint_io32_t		u1SWP19:1;
    uint_io32_t		u1SWP20:1;
    uint_io32_t		u1SWP21:1;
    uint_io32_t		u1SWP22:1;
    uint_io32_t		u1SWP23:1;
    uint_io32_t		u1SWP24:1;
    uint_io32_t		u1SWP25:1;
    uint_io32_t		u1SWP26:1;
    uint_io32_t		u1SWP27:1;
    uint_io32_t		u1SWP28:1;
    uint_io32_t		u1SWP29:1;
    uint_io32_t		u1SWP30:1;
    uint_io32_t		u1SWP31:1;
}stc_tcfcfg0_cswpn_field_t;

typedef union un_tcfcfg0_cswpn{
    uint_io32_t		u32Register;
    stc_tcfcfg0_cswpn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_cswpn_t;

/* SECSTAT */
#define TCFCFG0_SECSTAT	(TCFCFG0.unSECSTAT.u32Register)  /*@rg@*/
#define TCFCFG0_SECSTAT_SECEN	(*(volatile uint_io8_t*)0xB1189E00UL)  /*@bfbba@*/
#define TCFCFG0_SECSTAT_SECSC	(*(volatile uint_io8_t*)0xB1189E01UL)  /*@bfbba@*/
#define TCFCFG0_SECSTAT_CEEN	(*(volatile uint_io8_t*)0xB1189E02UL)  /*@bfbba@*/
#define TCFCFG0_SECSTAT_SECOE	(*(volatile uint_io8_t*)0xB1189E03UL)  /*@bfbba@*/
#define TCFCFG0_SECSTAT_SWPOE	(*(volatile uint_io8_t*)0xB1189E04UL)  /*@bfbba@*/
#define TCFCFG0_SECSTAT_SFDONE	(*(volatile uint_io8_t*)0xB1189E05UL)  /*@bfbba@*/
#define TCFCFG0_SECSTAT_UMV	(*(volatile uint_io8_t*)0xB1189E08UL)  /*@bfbba@*/
#define TCFCFG0_SECSTAT_ECCDED	(*(volatile uint_io8_t*)0xB1189E10UL)  /*@bfbba@*/
#define TCFCFG0_SECSTAT_ECCSEC	(*(volatile uint_io8_t*)0xB1189E11UL)  /*@bfbba@*/
#define TCFCFG0_SECSTAT_TBODED	(*(volatile uint_io8_t*)0xB1189E12UL)  /*@bfbba@*/
#define TCFCFG0_SECSTAT_TBOSEC	(*(volatile uint_io8_t*)0xB1189E13UL)  /*@bfbba@*/

typedef struct stc_tcfcfg0_secstat_field{
    uint_io32_t		u1SECEN:1;
    uint_io32_t		u1SECSC:1;
    uint_io32_t		u1CEEN:1;
    uint_io32_t		u1SECOE:1;
    uint_io32_t		u1SWPOE:1;
    uint_io32_t		u1SFDONE:1;
    uint_io32_t		:2;
    uint_io32_t		u1UMV:1;
    uint_io32_t		:7;
    uint_io32_t		u1ECCDED:1;
    uint_io32_t		u1ECCSEC:1;
    uint_io32_t		u1TBODED:1;
    uint_io32_t		u1TBOSEC:1;
    uint_io32_t		:12;
}stc_tcfcfg0_secstat_field_t;

typedef union un_tcfcfg0_secstat{
    uint_io32_t		u32Register;
    stc_tcfcfg0_secstat_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_secstat_t;

/* SER */
#define TCFCFG0_SER	(TCFCFG0.unSER.u32Register)  /*@rg@*/
#define TCFCFG0_SER_SER	TCFCFG0_SER  /*@bfrg@*/

typedef union un_tcfcfg0_ser{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_ser_t;

/* SSR */
#define TCFCFG0_SSR	(TCFCFG0.unSSR.u32Register)  /*@rg@*/
#define TCFCFG0_SSR_SSR	TCFCFG0_SSR  /*@bfrg@*/

typedef union un_tcfcfg0_ssr{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_ssr_t;

/* CEER */
#define TCFCFG0_CEER	(TCFCFG0.unCEER.u32Register)  /*@rg@*/
#define TCFCFG0_CEER_CEER	TCFCFG0_CEER  /*@bfrg@*/

typedef union un_tcfcfg0_ceer{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_ceer_t;

/* SOER */
#define TCFCFG0_SOER	(TCFCFG0.unSOER.u32Register)  /*@rg@*/
#define TCFCFG0_SOER_SOER	TCFCFG0_SOER  /*@bfrg@*/

typedef union un_tcfcfg0_soer{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_soer_t;

/* SWPOER */
#define TCFCFG0_SWPOER	(TCFCFG0.unSWPOER.u32Register)  /*@rg@*/
#define TCFCFG0_SWPOER_SWPOER	TCFCFG0_SWPOER  /*@bfrg@*/

typedef union un_tcfcfg0_swpoer{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_swpoer_t;

/* CSWP0 */
#define TCFCFG0_CSWP0	(TCFCFG0.unCSWP0.u32Register)  /*@rg@*/
#define TCFCFG0_CSWP0_SWP0	(*(volatile uint_io8_t*)0xB1189EE0UL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP1	(*(volatile uint_io8_t*)0xB1189EE1UL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP2	(*(volatile uint_io8_t*)0xB1189EE2UL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP3	(*(volatile uint_io8_t*)0xB1189EE3UL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP4	(*(volatile uint_io8_t*)0xB1189EE4UL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP5	(*(volatile uint_io8_t*)0xB1189EE5UL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP6	(*(volatile uint_io8_t*)0xB1189EE6UL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP7	(*(volatile uint_io8_t*)0xB1189EE7UL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP8	(*(volatile uint_io8_t*)0xB1189EE8UL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP9	(*(volatile uint_io8_t*)0xB1189EE9UL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP10	(*(volatile uint_io8_t*)0xB1189EEAUL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP11	(*(volatile uint_io8_t*)0xB1189EEBUL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP12	(*(volatile uint_io8_t*)0xB1189EECUL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP13	(*(volatile uint_io8_t*)0xB1189EEDUL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP14	(*(volatile uint_io8_t*)0xB1189EEEUL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP15	(*(volatile uint_io8_t*)0xB1189EEFUL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP16	(*(volatile uint_io8_t*)0xB1189EF0UL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP17	(*(volatile uint_io8_t*)0xB1189EF1UL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP18	(*(volatile uint_io8_t*)0xB1189EF2UL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP19	(*(volatile uint_io8_t*)0xB1189EF3UL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP20	(*(volatile uint_io8_t*)0xB1189EF4UL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP21	(*(volatile uint_io8_t*)0xB1189EF5UL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP22	(*(volatile uint_io8_t*)0xB1189EF6UL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP23	(*(volatile uint_io8_t*)0xB1189EF7UL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP24	(*(volatile uint_io8_t*)0xB1189EF8UL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP25	(*(volatile uint_io8_t*)0xB1189EF9UL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP26	(*(volatile uint_io8_t*)0xB1189EFAUL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP27	(*(volatile uint_io8_t*)0xB1189EFBUL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP28	(*(volatile uint_io8_t*)0xB1189EFCUL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP29	(*(volatile uint_io8_t*)0xB1189EFDUL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP30	(*(volatile uint_io8_t*)0xB1189EFEUL)  /*@bfbba@*/
#define TCFCFG0_CSWP0_SWP31	(*(volatile uint_io8_t*)0xB1189EFFUL)  /*@bfbba@*/

typedef struct stc_tcfcfg0_cswp0_field{
    uint_io32_t		u1SWP0:1;
    uint_io32_t		u1SWP1:1;
    uint_io32_t		u1SWP2:1;
    uint_io32_t		u1SWP3:1;
    uint_io32_t		u1SWP4:1;
    uint_io32_t		u1SWP5:1;
    uint_io32_t		u1SWP6:1;
    uint_io32_t		u1SWP7:1;
    uint_io32_t		u1SWP8:1;
    uint_io32_t		u1SWP9:1;
    uint_io32_t		u1SWP10:1;
    uint_io32_t		u1SWP11:1;
    uint_io32_t		u1SWP12:1;
    uint_io32_t		u1SWP13:1;
    uint_io32_t		u1SWP14:1;
    uint_io32_t		u1SWP15:1;
    uint_io32_t		u1SWP16:1;
    uint_io32_t		u1SWP17:1;
    uint_io32_t		u1SWP18:1;
    uint_io32_t		u1SWP19:1;
    uint_io32_t		u1SWP20:1;
    uint_io32_t		u1SWP21:1;
    uint_io32_t		u1SWP22:1;
    uint_io32_t		u1SWP23:1;
    uint_io32_t		u1SWP24:1;
    uint_io32_t		u1SWP25:1;
    uint_io32_t		u1SWP26:1;
    uint_io32_t		u1SWP27:1;
    uint_io32_t		u1SWP28:1;
    uint_io32_t		u1SWP29:1;
    uint_io32_t		u1SWP30:1;
    uint_io32_t		u1SWP31:1;
}stc_tcfcfg0_cswp0_field_t;

typedef union un_tcfcfg0_cswp0{
    uint_io32_t		u32Register;
    stc_tcfcfg0_cswp0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_cswp0_t;

/* TCMBUF[0-15]_W[0-7] */
#define TCFCFG0_TCMBUF0_W0	(TCFCFG0.unTCMBUF0_W0.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF0_W0_BUFDATA	TCFCFG0_TCMBUF0_W0  /*@bfrg@*/

#define TCFCFG0_TCMBUF0_W1	(TCFCFG0.unTCMBUF0_W1.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF0_W1_BUFDATA	TCFCFG0_TCMBUF0_W1  /*@bfrg@*/

#define TCFCFG0_TCMBUF0_W2	(TCFCFG0.unTCMBUF0_W2.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF0_W2_BUFDATA	TCFCFG0_TCMBUF0_W2  /*@bfrg@*/

#define TCFCFG0_TCMBUF0_W3	(TCFCFG0.unTCMBUF0_W3.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF0_W3_BUFDATA	TCFCFG0_TCMBUF0_W3  /*@bfrg@*/

#define TCFCFG0_TCMBUF0_W4	(TCFCFG0.unTCMBUF0_W4.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF0_W4_BUFDATA	TCFCFG0_TCMBUF0_W4  /*@bfrg@*/

#define TCFCFG0_TCMBUF0_W5	(TCFCFG0.unTCMBUF0_W5.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF0_W5_BUFDATA	TCFCFG0_TCMBUF0_W5  /*@bfrg@*/

#define TCFCFG0_TCMBUF0_W6	(TCFCFG0.unTCMBUF0_W6.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF0_W6_BUFDATA	TCFCFG0_TCMBUF0_W6  /*@bfrg@*/

#define TCFCFG0_TCMBUF0_W7	(TCFCFG0.unTCMBUF0_W7.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF0_W7_BUFDATA	TCFCFG0_TCMBUF0_W7  /*@bfrg@*/

#define TCFCFG0_TCMBUF1_W0	(TCFCFG0.unTCMBUF1_W0.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF1_W0_BUFDATA	TCFCFG0_TCMBUF1_W0  /*@bfrg@*/

#define TCFCFG0_TCMBUF1_W1	(TCFCFG0.unTCMBUF1_W1.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF1_W1_BUFDATA	TCFCFG0_TCMBUF1_W1  /*@bfrg@*/

#define TCFCFG0_TCMBUF1_W2	(TCFCFG0.unTCMBUF1_W2.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF1_W2_BUFDATA	TCFCFG0_TCMBUF1_W2  /*@bfrg@*/

#define TCFCFG0_TCMBUF1_W3	(TCFCFG0.unTCMBUF1_W3.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF1_W3_BUFDATA	TCFCFG0_TCMBUF1_W3  /*@bfrg@*/

#define TCFCFG0_TCMBUF1_W4	(TCFCFG0.unTCMBUF1_W4.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF1_W4_BUFDATA	TCFCFG0_TCMBUF1_W4  /*@bfrg@*/

#define TCFCFG0_TCMBUF1_W5	(TCFCFG0.unTCMBUF1_W5.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF1_W5_BUFDATA	TCFCFG0_TCMBUF1_W5  /*@bfrg@*/

#define TCFCFG0_TCMBUF1_W6	(TCFCFG0.unTCMBUF1_W6.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF1_W6_BUFDATA	TCFCFG0_TCMBUF1_W6  /*@bfrg@*/

#define TCFCFG0_TCMBUF1_W7	(TCFCFG0.unTCMBUF1_W7.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF1_W7_BUFDATA	TCFCFG0_TCMBUF1_W7  /*@bfrg@*/

#define TCFCFG0_TCMBUF2_W0	(TCFCFG0.unTCMBUF2_W0.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF2_W0_BUFDATA	TCFCFG0_TCMBUF2_W0  /*@bfrg@*/

#define TCFCFG0_TCMBUF2_W1	(TCFCFG0.unTCMBUF2_W1.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF2_W1_BUFDATA	TCFCFG0_TCMBUF2_W1  /*@bfrg@*/

#define TCFCFG0_TCMBUF2_W2	(TCFCFG0.unTCMBUF2_W2.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF2_W2_BUFDATA	TCFCFG0_TCMBUF2_W2  /*@bfrg@*/

#define TCFCFG0_TCMBUF2_W3	(TCFCFG0.unTCMBUF2_W3.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF2_W3_BUFDATA	TCFCFG0_TCMBUF2_W3  /*@bfrg@*/

#define TCFCFG0_TCMBUF2_W4	(TCFCFG0.unTCMBUF2_W4.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF2_W4_BUFDATA	TCFCFG0_TCMBUF2_W4  /*@bfrg@*/

#define TCFCFG0_TCMBUF2_W5	(TCFCFG0.unTCMBUF2_W5.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF2_W5_BUFDATA	TCFCFG0_TCMBUF2_W5  /*@bfrg@*/

#define TCFCFG0_TCMBUF2_W6	(TCFCFG0.unTCMBUF2_W6.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF2_W6_BUFDATA	TCFCFG0_TCMBUF2_W6  /*@bfrg@*/

#define TCFCFG0_TCMBUF2_W7	(TCFCFG0.unTCMBUF2_W7.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF2_W7_BUFDATA	TCFCFG0_TCMBUF2_W7  /*@bfrg@*/

#define TCFCFG0_TCMBUF3_W0	(TCFCFG0.unTCMBUF3_W0.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF3_W0_BUFDATA	TCFCFG0_TCMBUF3_W0  /*@bfrg@*/

#define TCFCFG0_TCMBUF3_W1	(TCFCFG0.unTCMBUF3_W1.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF3_W1_BUFDATA	TCFCFG0_TCMBUF3_W1  /*@bfrg@*/

#define TCFCFG0_TCMBUF3_W2	(TCFCFG0.unTCMBUF3_W2.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF3_W2_BUFDATA	TCFCFG0_TCMBUF3_W2  /*@bfrg@*/

#define TCFCFG0_TCMBUF3_W3	(TCFCFG0.unTCMBUF3_W3.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF3_W3_BUFDATA	TCFCFG0_TCMBUF3_W3  /*@bfrg@*/

#define TCFCFG0_TCMBUF3_W4	(TCFCFG0.unTCMBUF3_W4.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF3_W4_BUFDATA	TCFCFG0_TCMBUF3_W4  /*@bfrg@*/

#define TCFCFG0_TCMBUF3_W5	(TCFCFG0.unTCMBUF3_W5.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF3_W5_BUFDATA	TCFCFG0_TCMBUF3_W5  /*@bfrg@*/

#define TCFCFG0_TCMBUF3_W6	(TCFCFG0.unTCMBUF3_W6.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF3_W6_BUFDATA	TCFCFG0_TCMBUF3_W6  /*@bfrg@*/

#define TCFCFG0_TCMBUF3_W7	(TCFCFG0.unTCMBUF3_W7.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF3_W7_BUFDATA	TCFCFG0_TCMBUF3_W7  /*@bfrg@*/

#define TCFCFG0_TCMBUF4_W0	(TCFCFG0.unTCMBUF4_W0.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF4_W0_BUFDATA	TCFCFG0_TCMBUF4_W0  /*@bfrg@*/

#define TCFCFG0_TCMBUF4_W1	(TCFCFG0.unTCMBUF4_W1.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF4_W1_BUFDATA	TCFCFG0_TCMBUF4_W1  /*@bfrg@*/

#define TCFCFG0_TCMBUF4_W2	(TCFCFG0.unTCMBUF4_W2.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF4_W2_BUFDATA	TCFCFG0_TCMBUF4_W2  /*@bfrg@*/

#define TCFCFG0_TCMBUF4_W3	(TCFCFG0.unTCMBUF4_W3.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF4_W3_BUFDATA	TCFCFG0_TCMBUF4_W3  /*@bfrg@*/

#define TCFCFG0_TCMBUF4_W4	(TCFCFG0.unTCMBUF4_W4.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF4_W4_BUFDATA	TCFCFG0_TCMBUF4_W4  /*@bfrg@*/

#define TCFCFG0_TCMBUF4_W5	(TCFCFG0.unTCMBUF4_W5.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF4_W5_BUFDATA	TCFCFG0_TCMBUF4_W5  /*@bfrg@*/

#define TCFCFG0_TCMBUF4_W6	(TCFCFG0.unTCMBUF4_W6.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF4_W6_BUFDATA	TCFCFG0_TCMBUF4_W6  /*@bfrg@*/

#define TCFCFG0_TCMBUF4_W7	(TCFCFG0.unTCMBUF4_W7.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF4_W7_BUFDATA	TCFCFG0_TCMBUF4_W7  /*@bfrg@*/

#define TCFCFG0_TCMBUF5_W0	(TCFCFG0.unTCMBUF5_W0.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF5_W0_BUFDATA	TCFCFG0_TCMBUF5_W0  /*@bfrg@*/

#define TCFCFG0_TCMBUF5_W1	(TCFCFG0.unTCMBUF5_W1.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF5_W1_BUFDATA	TCFCFG0_TCMBUF5_W1  /*@bfrg@*/

#define TCFCFG0_TCMBUF5_W2	(TCFCFG0.unTCMBUF5_W2.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF5_W2_BUFDATA	TCFCFG0_TCMBUF5_W2  /*@bfrg@*/

#define TCFCFG0_TCMBUF5_W3	(TCFCFG0.unTCMBUF5_W3.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF5_W3_BUFDATA	TCFCFG0_TCMBUF5_W3  /*@bfrg@*/

#define TCFCFG0_TCMBUF5_W4	(TCFCFG0.unTCMBUF5_W4.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF5_W4_BUFDATA	TCFCFG0_TCMBUF5_W4  /*@bfrg@*/

#define TCFCFG0_TCMBUF5_W5	(TCFCFG0.unTCMBUF5_W5.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF5_W5_BUFDATA	TCFCFG0_TCMBUF5_W5  /*@bfrg@*/

#define TCFCFG0_TCMBUF5_W6	(TCFCFG0.unTCMBUF5_W6.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF5_W6_BUFDATA	TCFCFG0_TCMBUF5_W6  /*@bfrg@*/

#define TCFCFG0_TCMBUF5_W7	(TCFCFG0.unTCMBUF5_W7.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF5_W7_BUFDATA	TCFCFG0_TCMBUF5_W7  /*@bfrg@*/

#define TCFCFG0_TCMBUF6_W0	(TCFCFG0.unTCMBUF6_W0.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF6_W0_BUFDATA	TCFCFG0_TCMBUF6_W0  /*@bfrg@*/

#define TCFCFG0_TCMBUF6_W1	(TCFCFG0.unTCMBUF6_W1.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF6_W1_BUFDATA	TCFCFG0_TCMBUF6_W1  /*@bfrg@*/

#define TCFCFG0_TCMBUF6_W2	(TCFCFG0.unTCMBUF6_W2.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF6_W2_BUFDATA	TCFCFG0_TCMBUF6_W2  /*@bfrg@*/

#define TCFCFG0_TCMBUF6_W3	(TCFCFG0.unTCMBUF6_W3.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF6_W3_BUFDATA	TCFCFG0_TCMBUF6_W3  /*@bfrg@*/

#define TCFCFG0_TCMBUF6_W4	(TCFCFG0.unTCMBUF6_W4.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF6_W4_BUFDATA	TCFCFG0_TCMBUF6_W4  /*@bfrg@*/

#define TCFCFG0_TCMBUF6_W5	(TCFCFG0.unTCMBUF6_W5.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF6_W5_BUFDATA	TCFCFG0_TCMBUF6_W5  /*@bfrg@*/

#define TCFCFG0_TCMBUF6_W6	(TCFCFG0.unTCMBUF6_W6.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF6_W6_BUFDATA	TCFCFG0_TCMBUF6_W6  /*@bfrg@*/

#define TCFCFG0_TCMBUF6_W7	(TCFCFG0.unTCMBUF6_W7.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF6_W7_BUFDATA	TCFCFG0_TCMBUF6_W7  /*@bfrg@*/

#define TCFCFG0_TCMBUF7_W0	(TCFCFG0.unTCMBUF7_W0.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF7_W0_BUFDATA	TCFCFG0_TCMBUF7_W0  /*@bfrg@*/

#define TCFCFG0_TCMBUF7_W1	(TCFCFG0.unTCMBUF7_W1.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF7_W1_BUFDATA	TCFCFG0_TCMBUF7_W1  /*@bfrg@*/

#define TCFCFG0_TCMBUF7_W2	(TCFCFG0.unTCMBUF7_W2.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF7_W2_BUFDATA	TCFCFG0_TCMBUF7_W2  /*@bfrg@*/

#define TCFCFG0_TCMBUF7_W3	(TCFCFG0.unTCMBUF7_W3.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF7_W3_BUFDATA	TCFCFG0_TCMBUF7_W3  /*@bfrg@*/

#define TCFCFG0_TCMBUF7_W4	(TCFCFG0.unTCMBUF7_W4.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF7_W4_BUFDATA	TCFCFG0_TCMBUF7_W4  /*@bfrg@*/

#define TCFCFG0_TCMBUF7_W5	(TCFCFG0.unTCMBUF7_W5.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF7_W5_BUFDATA	TCFCFG0_TCMBUF7_W5  /*@bfrg@*/

#define TCFCFG0_TCMBUF7_W6	(TCFCFG0.unTCMBUF7_W6.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF7_W6_BUFDATA	TCFCFG0_TCMBUF7_W6  /*@bfrg@*/

#define TCFCFG0_TCMBUF7_W7	(TCFCFG0.unTCMBUF7_W7.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF7_W7_BUFDATA	TCFCFG0_TCMBUF7_W7  /*@bfrg@*/

#define TCFCFG0_TCMBUF8_W0	(TCFCFG0.unTCMBUF8_W0.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF8_W0_BUFDATA	TCFCFG0_TCMBUF8_W0  /*@bfrg@*/

#define TCFCFG0_TCMBUF8_W1	(TCFCFG0.unTCMBUF8_W1.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF8_W1_BUFDATA	TCFCFG0_TCMBUF8_W1  /*@bfrg@*/

#define TCFCFG0_TCMBUF8_W2	(TCFCFG0.unTCMBUF8_W2.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF8_W2_BUFDATA	TCFCFG0_TCMBUF8_W2  /*@bfrg@*/

#define TCFCFG0_TCMBUF8_W3	(TCFCFG0.unTCMBUF8_W3.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF8_W3_BUFDATA	TCFCFG0_TCMBUF8_W3  /*@bfrg@*/

#define TCFCFG0_TCMBUF8_W4	(TCFCFG0.unTCMBUF8_W4.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF8_W4_BUFDATA	TCFCFG0_TCMBUF8_W4  /*@bfrg@*/

#define TCFCFG0_TCMBUF8_W5	(TCFCFG0.unTCMBUF8_W5.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF8_W5_BUFDATA	TCFCFG0_TCMBUF8_W5  /*@bfrg@*/

#define TCFCFG0_TCMBUF8_W6	(TCFCFG0.unTCMBUF8_W6.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF8_W6_BUFDATA	TCFCFG0_TCMBUF8_W6  /*@bfrg@*/

#define TCFCFG0_TCMBUF8_W7	(TCFCFG0.unTCMBUF8_W7.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF8_W7_BUFDATA	TCFCFG0_TCMBUF8_W7  /*@bfrg@*/

#define TCFCFG0_TCMBUF9_W0	(TCFCFG0.unTCMBUF9_W0.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF9_W0_BUFDATA	TCFCFG0_TCMBUF9_W0  /*@bfrg@*/

#define TCFCFG0_TCMBUF9_W1	(TCFCFG0.unTCMBUF9_W1.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF9_W1_BUFDATA	TCFCFG0_TCMBUF9_W1  /*@bfrg@*/

#define TCFCFG0_TCMBUF9_W2	(TCFCFG0.unTCMBUF9_W2.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF9_W2_BUFDATA	TCFCFG0_TCMBUF9_W2  /*@bfrg@*/

#define TCFCFG0_TCMBUF9_W3	(TCFCFG0.unTCMBUF9_W3.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF9_W3_BUFDATA	TCFCFG0_TCMBUF9_W3  /*@bfrg@*/

#define TCFCFG0_TCMBUF9_W4	(TCFCFG0.unTCMBUF9_W4.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF9_W4_BUFDATA	TCFCFG0_TCMBUF9_W4  /*@bfrg@*/

#define TCFCFG0_TCMBUF9_W5	(TCFCFG0.unTCMBUF9_W5.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF9_W5_BUFDATA	TCFCFG0_TCMBUF9_W5  /*@bfrg@*/

#define TCFCFG0_TCMBUF9_W6	(TCFCFG0.unTCMBUF9_W6.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF9_W6_BUFDATA	TCFCFG0_TCMBUF9_W6  /*@bfrg@*/

#define TCFCFG0_TCMBUF9_W7	(TCFCFG0.unTCMBUF9_W7.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF9_W7_BUFDATA	TCFCFG0_TCMBUF9_W7  /*@bfrg@*/

#define TCFCFG0_TCMBUF10_W0	(TCFCFG0.unTCMBUF10_W0.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF10_W0_BUFDATA	TCFCFG0_TCMBUF10_W0  /*@bfrg@*/

#define TCFCFG0_TCMBUF10_W1	(TCFCFG0.unTCMBUF10_W1.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF10_W1_BUFDATA	TCFCFG0_TCMBUF10_W1  /*@bfrg@*/

#define TCFCFG0_TCMBUF10_W2	(TCFCFG0.unTCMBUF10_W2.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF10_W2_BUFDATA	TCFCFG0_TCMBUF10_W2  /*@bfrg@*/

#define TCFCFG0_TCMBUF10_W3	(TCFCFG0.unTCMBUF10_W3.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF10_W3_BUFDATA	TCFCFG0_TCMBUF10_W3  /*@bfrg@*/

#define TCFCFG0_TCMBUF10_W4	(TCFCFG0.unTCMBUF10_W4.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF10_W4_BUFDATA	TCFCFG0_TCMBUF10_W4  /*@bfrg@*/

#define TCFCFG0_TCMBUF10_W5	(TCFCFG0.unTCMBUF10_W5.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF10_W5_BUFDATA	TCFCFG0_TCMBUF10_W5  /*@bfrg@*/

#define TCFCFG0_TCMBUF10_W6	(TCFCFG0.unTCMBUF10_W6.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF10_W6_BUFDATA	TCFCFG0_TCMBUF10_W6  /*@bfrg@*/

#define TCFCFG0_TCMBUF10_W7	(TCFCFG0.unTCMBUF10_W7.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF10_W7_BUFDATA	TCFCFG0_TCMBUF10_W7  /*@bfrg@*/

#define TCFCFG0_TCMBUF11_W0	(TCFCFG0.unTCMBUF11_W0.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF11_W0_BUFDATA	TCFCFG0_TCMBUF11_W0  /*@bfrg@*/

#define TCFCFG0_TCMBUF11_W1	(TCFCFG0.unTCMBUF11_W1.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF11_W1_BUFDATA	TCFCFG0_TCMBUF11_W1  /*@bfrg@*/

#define TCFCFG0_TCMBUF11_W2	(TCFCFG0.unTCMBUF11_W2.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF11_W2_BUFDATA	TCFCFG0_TCMBUF11_W2  /*@bfrg@*/

#define TCFCFG0_TCMBUF11_W3	(TCFCFG0.unTCMBUF11_W3.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF11_W3_BUFDATA	TCFCFG0_TCMBUF11_W3  /*@bfrg@*/

#define TCFCFG0_TCMBUF11_W4	(TCFCFG0.unTCMBUF11_W4.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF11_W4_BUFDATA	TCFCFG0_TCMBUF11_W4  /*@bfrg@*/

#define TCFCFG0_TCMBUF11_W5	(TCFCFG0.unTCMBUF11_W5.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF11_W5_BUFDATA	TCFCFG0_TCMBUF11_W5  /*@bfrg@*/

#define TCFCFG0_TCMBUF11_W6	(TCFCFG0.unTCMBUF11_W6.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF11_W6_BUFDATA	TCFCFG0_TCMBUF11_W6  /*@bfrg@*/

#define TCFCFG0_TCMBUF11_W7	(TCFCFG0.unTCMBUF11_W7.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF11_W7_BUFDATA	TCFCFG0_TCMBUF11_W7  /*@bfrg@*/

#define TCFCFG0_TCMBUF12_W0	(TCFCFG0.unTCMBUF12_W0.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF12_W0_BUFDATA	TCFCFG0_TCMBUF12_W0  /*@bfrg@*/

#define TCFCFG0_TCMBUF12_W1	(TCFCFG0.unTCMBUF12_W1.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF12_W1_BUFDATA	TCFCFG0_TCMBUF12_W1  /*@bfrg@*/

#define TCFCFG0_TCMBUF12_W2	(TCFCFG0.unTCMBUF12_W2.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF12_W2_BUFDATA	TCFCFG0_TCMBUF12_W2  /*@bfrg@*/

#define TCFCFG0_TCMBUF12_W3	(TCFCFG0.unTCMBUF12_W3.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF12_W3_BUFDATA	TCFCFG0_TCMBUF12_W3  /*@bfrg@*/

#define TCFCFG0_TCMBUF12_W4	(TCFCFG0.unTCMBUF12_W4.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF12_W4_BUFDATA	TCFCFG0_TCMBUF12_W4  /*@bfrg@*/

#define TCFCFG0_TCMBUF12_W5	(TCFCFG0.unTCMBUF12_W5.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF12_W5_BUFDATA	TCFCFG0_TCMBUF12_W5  /*@bfrg@*/

#define TCFCFG0_TCMBUF12_W6	(TCFCFG0.unTCMBUF12_W6.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF12_W6_BUFDATA	TCFCFG0_TCMBUF12_W6  /*@bfrg@*/

#define TCFCFG0_TCMBUF12_W7	(TCFCFG0.unTCMBUF12_W7.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF12_W7_BUFDATA	TCFCFG0_TCMBUF12_W7  /*@bfrg@*/

#define TCFCFG0_TCMBUF13_W0	(TCFCFG0.unTCMBUF13_W0.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF13_W0_BUFDATA	TCFCFG0_TCMBUF13_W0  /*@bfrg@*/

#define TCFCFG0_TCMBUF13_W1	(TCFCFG0.unTCMBUF13_W1.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF13_W1_BUFDATA	TCFCFG0_TCMBUF13_W1  /*@bfrg@*/

#define TCFCFG0_TCMBUF13_W2	(TCFCFG0.unTCMBUF13_W2.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF13_W2_BUFDATA	TCFCFG0_TCMBUF13_W2  /*@bfrg@*/

#define TCFCFG0_TCMBUF13_W3	(TCFCFG0.unTCMBUF13_W3.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF13_W3_BUFDATA	TCFCFG0_TCMBUF13_W3  /*@bfrg@*/

#define TCFCFG0_TCMBUF13_W4	(TCFCFG0.unTCMBUF13_W4.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF13_W4_BUFDATA	TCFCFG0_TCMBUF13_W4  /*@bfrg@*/

#define TCFCFG0_TCMBUF13_W5	(TCFCFG0.unTCMBUF13_W5.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF13_W5_BUFDATA	TCFCFG0_TCMBUF13_W5  /*@bfrg@*/

#define TCFCFG0_TCMBUF13_W6	(TCFCFG0.unTCMBUF13_W6.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF13_W6_BUFDATA	TCFCFG0_TCMBUF13_W6  /*@bfrg@*/

#define TCFCFG0_TCMBUF13_W7	(TCFCFG0.unTCMBUF13_W7.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF13_W7_BUFDATA	TCFCFG0_TCMBUF13_W7  /*@bfrg@*/

#define TCFCFG0_TCMBUF14_W0	(TCFCFG0.unTCMBUF14_W0.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF14_W0_BUFDATA	TCFCFG0_TCMBUF14_W0  /*@bfrg@*/

#define TCFCFG0_TCMBUF14_W1	(TCFCFG0.unTCMBUF14_W1.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF14_W1_BUFDATA	TCFCFG0_TCMBUF14_W1  /*@bfrg@*/

#define TCFCFG0_TCMBUF14_W2	(TCFCFG0.unTCMBUF14_W2.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF14_W2_BUFDATA	TCFCFG0_TCMBUF14_W2  /*@bfrg@*/

#define TCFCFG0_TCMBUF14_W3	(TCFCFG0.unTCMBUF14_W3.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF14_W3_BUFDATA	TCFCFG0_TCMBUF14_W3  /*@bfrg@*/

#define TCFCFG0_TCMBUF14_W4	(TCFCFG0.unTCMBUF14_W4.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF14_W4_BUFDATA	TCFCFG0_TCMBUF14_W4  /*@bfrg@*/

#define TCFCFG0_TCMBUF14_W5	(TCFCFG0.unTCMBUF14_W5.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF14_W5_BUFDATA	TCFCFG0_TCMBUF14_W5  /*@bfrg@*/

#define TCFCFG0_TCMBUF14_W6	(TCFCFG0.unTCMBUF14_W6.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF14_W6_BUFDATA	TCFCFG0_TCMBUF14_W6  /*@bfrg@*/

#define TCFCFG0_TCMBUF14_W7	(TCFCFG0.unTCMBUF14_W7.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF14_W7_BUFDATA	TCFCFG0_TCMBUF14_W7  /*@bfrg@*/

#define TCFCFG0_TCMBUF15_W0	(TCFCFG0.unTCMBUF15_W0.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF15_W0_BUFDATA	TCFCFG0_TCMBUF15_W0  /*@bfrg@*/

#define TCFCFG0_TCMBUF15_W1	(TCFCFG0.unTCMBUF15_W1.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF15_W1_BUFDATA	TCFCFG0_TCMBUF15_W1  /*@bfrg@*/

#define TCFCFG0_TCMBUF15_W2	(TCFCFG0.unTCMBUF15_W2.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF15_W2_BUFDATA	TCFCFG0_TCMBUF15_W2  /*@bfrg@*/

#define TCFCFG0_TCMBUF15_W3	(TCFCFG0.unTCMBUF15_W3.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF15_W3_BUFDATA	TCFCFG0_TCMBUF15_W3  /*@bfrg@*/

#define TCFCFG0_TCMBUF15_W4	(TCFCFG0.unTCMBUF15_W4.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF15_W4_BUFDATA	TCFCFG0_TCMBUF15_W4  /*@bfrg@*/

#define TCFCFG0_TCMBUF15_W5	(TCFCFG0.unTCMBUF15_W5.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF15_W5_BUFDATA	TCFCFG0_TCMBUF15_W5  /*@bfrg@*/

#define TCFCFG0_TCMBUF15_W6	(TCFCFG0.unTCMBUF15_W6.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF15_W6_BUFDATA	TCFCFG0_TCMBUF15_W6  /*@bfrg@*/

#define TCFCFG0_TCMBUF15_W7	(TCFCFG0.unTCMBUF15_W7.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF15_W7_BUFDATA	TCFCFG0_TCMBUF15_W7  /*@bfrg@*/

typedef union un_tcfcfg0_tcmbufn_wn{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_tcmbufn_wn_t;

/* TCMBUF[0-15]_W8 */
#define TCFCFG0_TCMBUF0_W8	(TCFCFG0.unTCMBUF0_W8.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF0_W8_BUFADD	(TCFCFG0.unTCMBUF0_W8.stcField.u23BUFADD)  /*@bf@*/
#define TCFCFG0_TCMBUF0_W8_Read1	(*(volatile uint_io8_t*)0xB118A117UL)  /*@bfbba@*/
#define TCFCFG0_TCMBUF0_W8_READ1	TCFCFG0_TCMBUF0_W8_Read1  /*@bf2@*/

#define TCFCFG0_TCMBUF1_W8	(TCFCFG0.unTCMBUF1_W8.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF1_W8_BUFADD	(TCFCFG0.unTCMBUF1_W8.stcField.u23BUFADD)  /*@bf@*/
#define TCFCFG0_TCMBUF1_W8_Read1	(*(volatile uint_io8_t*)0xB118A317UL)  /*@bfbba@*/
#define TCFCFG0_TCMBUF1_W8_READ1	TCFCFG0_TCMBUF1_W8_Read1  /*@bf2@*/

#define TCFCFG0_TCMBUF2_W8	(TCFCFG0.unTCMBUF2_W8.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF2_W8_BUFADD	(TCFCFG0.unTCMBUF2_W8.stcField.u23BUFADD)  /*@bf@*/
#define TCFCFG0_TCMBUF2_W8_Read1	(*(volatile uint_io8_t*)0xB118A517UL)  /*@bfbba@*/
#define TCFCFG0_TCMBUF2_W8_READ1	TCFCFG0_TCMBUF2_W8_Read1  /*@bf2@*/

#define TCFCFG0_TCMBUF3_W8	(TCFCFG0.unTCMBUF3_W8.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF3_W8_BUFADD	(TCFCFG0.unTCMBUF3_W8.stcField.u23BUFADD)  /*@bf@*/
#define TCFCFG0_TCMBUF3_W8_Read1	(*(volatile uint_io8_t*)0xB118A717UL)  /*@bfbba@*/
#define TCFCFG0_TCMBUF3_W8_READ1	TCFCFG0_TCMBUF3_W8_Read1  /*@bf2@*/

#define TCFCFG0_TCMBUF4_W8	(TCFCFG0.unTCMBUF4_W8.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF4_W8_BUFADD	(TCFCFG0.unTCMBUF4_W8.stcField.u23BUFADD)  /*@bf@*/
#define TCFCFG0_TCMBUF4_W8_Read1	(*(volatile uint_io8_t*)0xB118A917UL)  /*@bfbba@*/
#define TCFCFG0_TCMBUF4_W8_READ1	TCFCFG0_TCMBUF4_W8_Read1  /*@bf2@*/

#define TCFCFG0_TCMBUF5_W8	(TCFCFG0.unTCMBUF5_W8.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF5_W8_BUFADD	(TCFCFG0.unTCMBUF5_W8.stcField.u23BUFADD)  /*@bf@*/
#define TCFCFG0_TCMBUF5_W8_Read1	(*(volatile uint_io8_t*)0xB118AB17UL)  /*@bfbba@*/
#define TCFCFG0_TCMBUF5_W8_READ1	TCFCFG0_TCMBUF5_W8_Read1  /*@bf2@*/

#define TCFCFG0_TCMBUF6_W8	(TCFCFG0.unTCMBUF6_W8.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF6_W8_BUFADD	(TCFCFG0.unTCMBUF6_W8.stcField.u23BUFADD)  /*@bf@*/
#define TCFCFG0_TCMBUF6_W8_Read1	(*(volatile uint_io8_t*)0xB118AD17UL)  /*@bfbba@*/
#define TCFCFG0_TCMBUF6_W8_READ1	TCFCFG0_TCMBUF6_W8_Read1  /*@bf2@*/

#define TCFCFG0_TCMBUF7_W8	(TCFCFG0.unTCMBUF7_W8.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF7_W8_BUFADD	(TCFCFG0.unTCMBUF7_W8.stcField.u23BUFADD)  /*@bf@*/
#define TCFCFG0_TCMBUF7_W8_Read1	(*(volatile uint_io8_t*)0xB118AF17UL)  /*@bfbba@*/
#define TCFCFG0_TCMBUF7_W8_READ1	TCFCFG0_TCMBUF7_W8_Read1  /*@bf2@*/

#define TCFCFG0_TCMBUF8_W8	(TCFCFG0.unTCMBUF8_W8.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF8_W8_BUFADD	(TCFCFG0.unTCMBUF8_W8.stcField.u23BUFADD)  /*@bf@*/
#define TCFCFG0_TCMBUF8_W8_Read1	(*(volatile uint_io8_t*)0xB118B117UL)  /*@bfbba@*/
#define TCFCFG0_TCMBUF8_W8_READ1	TCFCFG0_TCMBUF8_W8_Read1  /*@bf2@*/

#define TCFCFG0_TCMBUF9_W8	(TCFCFG0.unTCMBUF9_W8.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF9_W8_BUFADD	(TCFCFG0.unTCMBUF9_W8.stcField.u23BUFADD)  /*@bf@*/
#define TCFCFG0_TCMBUF9_W8_Read1	(*(volatile uint_io8_t*)0xB118B317UL)  /*@bfbba@*/
#define TCFCFG0_TCMBUF9_W8_READ1	TCFCFG0_TCMBUF9_W8_Read1  /*@bf2@*/

#define TCFCFG0_TCMBUF10_W8	(TCFCFG0.unTCMBUF10_W8.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF10_W8_BUFADD	(TCFCFG0.unTCMBUF10_W8.stcField.u23BUFADD)  /*@bf@*/
#define TCFCFG0_TCMBUF10_W8_Read1	(*(volatile uint_io8_t*)0xB118B517UL)  /*@bfbba@*/
#define TCFCFG0_TCMBUF10_W8_READ1	TCFCFG0_TCMBUF10_W8_Read1  /*@bf2@*/

#define TCFCFG0_TCMBUF11_W8	(TCFCFG0.unTCMBUF11_W8.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF11_W8_BUFADD	(TCFCFG0.unTCMBUF11_W8.stcField.u23BUFADD)  /*@bf@*/
#define TCFCFG0_TCMBUF11_W8_Read1	(*(volatile uint_io8_t*)0xB118B717UL)  /*@bfbba@*/
#define TCFCFG0_TCMBUF11_W8_READ1	TCFCFG0_TCMBUF11_W8_Read1  /*@bf2@*/

#define TCFCFG0_TCMBUF12_W8	(TCFCFG0.unTCMBUF12_W8.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF12_W8_BUFADD	(TCFCFG0.unTCMBUF12_W8.stcField.u23BUFADD)  /*@bf@*/
#define TCFCFG0_TCMBUF12_W8_Read1	(*(volatile uint_io8_t*)0xB118B917UL)  /*@bfbba@*/
#define TCFCFG0_TCMBUF12_W8_READ1	TCFCFG0_TCMBUF12_W8_Read1  /*@bf2@*/

#define TCFCFG0_TCMBUF13_W8	(TCFCFG0.unTCMBUF13_W8.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF13_W8_BUFADD	(TCFCFG0.unTCMBUF13_W8.stcField.u23BUFADD)  /*@bf@*/
#define TCFCFG0_TCMBUF13_W8_Read1	(*(volatile uint_io8_t*)0xB118BB17UL)  /*@bfbba@*/
#define TCFCFG0_TCMBUF13_W8_READ1	TCFCFG0_TCMBUF13_W8_Read1  /*@bf2@*/

#define TCFCFG0_TCMBUF14_W8	(TCFCFG0.unTCMBUF14_W8.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF14_W8_BUFADD	(TCFCFG0.unTCMBUF14_W8.stcField.u23BUFADD)  /*@bf@*/
#define TCFCFG0_TCMBUF14_W8_Read1	(*(volatile uint_io8_t*)0xB118BD17UL)  /*@bfbba@*/
#define TCFCFG0_TCMBUF14_W8_READ1	TCFCFG0_TCMBUF14_W8_Read1  /*@bf2@*/

#define TCFCFG0_TCMBUF15_W8	(TCFCFG0.unTCMBUF15_W8.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF15_W8_BUFADD	(TCFCFG0.unTCMBUF15_W8.stcField.u23BUFADD)  /*@bf@*/
#define TCFCFG0_TCMBUF15_W8_Read1	(*(volatile uint_io8_t*)0xB118BF17UL)  /*@bfbba@*/
#define TCFCFG0_TCMBUF15_W8_READ1	TCFCFG0_TCMBUF15_W8_Read1  /*@bf2@*/

typedef struct stc_tcfcfg0_tcmbufn_w8_field{
    uint_io32_t		u23BUFADD:23;
    uint_io32_t		u1Read1:1;
    uint_io32_t		:8;
}stc_tcfcfg0_tcmbufn_w8_field_t;

typedef union un_tcfcfg0_tcmbufn_w8{
    uint_io32_t		u32Register;
    stc_tcfcfg0_tcmbufn_w8_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_tcmbufn_w8_t;

/* TCMBUF[0-15]_W9 */
#define TCFCFG0_TCMBUF0_W9	(TCFCFG0.unTCMBUF0_W9.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF0_W9_BVALID	(*(volatile uint_io8_t*)0xB118A120UL)  /*@bfbba@*/

#define TCFCFG0_TCMBUF1_W9	(TCFCFG0.unTCMBUF1_W9.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF1_W9_BVALID	(*(volatile uint_io8_t*)0xB118A320UL)  /*@bfbba@*/

#define TCFCFG0_TCMBUF2_W9	(TCFCFG0.unTCMBUF2_W9.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF2_W9_BVALID	(*(volatile uint_io8_t*)0xB118A520UL)  /*@bfbba@*/

#define TCFCFG0_TCMBUF3_W9	(TCFCFG0.unTCMBUF3_W9.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF3_W9_BVALID	(*(volatile uint_io8_t*)0xB118A720UL)  /*@bfbba@*/

#define TCFCFG0_TCMBUF4_W9	(TCFCFG0.unTCMBUF4_W9.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF4_W9_BVALID	(*(volatile uint_io8_t*)0xB118A920UL)  /*@bfbba@*/

#define TCFCFG0_TCMBUF5_W9	(TCFCFG0.unTCMBUF5_W9.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF5_W9_BVALID	(*(volatile uint_io8_t*)0xB118AB20UL)  /*@bfbba@*/

#define TCFCFG0_TCMBUF6_W9	(TCFCFG0.unTCMBUF6_W9.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF6_W9_BVALID	(*(volatile uint_io8_t*)0xB118AD20UL)  /*@bfbba@*/

#define TCFCFG0_TCMBUF7_W9	(TCFCFG0.unTCMBUF7_W9.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF7_W9_BVALID	(*(volatile uint_io8_t*)0xB118AF20UL)  /*@bfbba@*/

#define TCFCFG0_TCMBUF8_W9	(TCFCFG0.unTCMBUF8_W9.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF8_W9_BVALID	(*(volatile uint_io8_t*)0xB118B120UL)  /*@bfbba@*/

#define TCFCFG0_TCMBUF9_W9	(TCFCFG0.unTCMBUF9_W9.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF9_W9_BVALID	(*(volatile uint_io8_t*)0xB118B320UL)  /*@bfbba@*/

#define TCFCFG0_TCMBUF10_W9	(TCFCFG0.unTCMBUF10_W9.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF10_W9_BVALID	(*(volatile uint_io8_t*)0xB118B520UL)  /*@bfbba@*/

#define TCFCFG0_TCMBUF11_W9	(TCFCFG0.unTCMBUF11_W9.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF11_W9_BVALID	(*(volatile uint_io8_t*)0xB118B720UL)  /*@bfbba@*/

#define TCFCFG0_TCMBUF12_W9	(TCFCFG0.unTCMBUF12_W9.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF12_W9_BVALID	(*(volatile uint_io8_t*)0xB118B920UL)  /*@bfbba@*/

#define TCFCFG0_TCMBUF13_W9	(TCFCFG0.unTCMBUF13_W9.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF13_W9_BVALID	(*(volatile uint_io8_t*)0xB118BB20UL)  /*@bfbba@*/

#define TCFCFG0_TCMBUF14_W9	(TCFCFG0.unTCMBUF14_W9.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF14_W9_BVALID	(*(volatile uint_io8_t*)0xB118BD20UL)  /*@bfbba@*/

#define TCFCFG0_TCMBUF15_W9	(TCFCFG0.unTCMBUF15_W9.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF15_W9_BVALID	(*(volatile uint_io8_t*)0xB118BF20UL)  /*@bfbba@*/

typedef struct stc_tcfcfg0_tcmbufn_w9_field{
    uint_io32_t		u1BVALID:1;
    uint_io32_t		:31;
}stc_tcfcfg0_tcmbufn_w9_field_t;

typedef union un_tcfcfg0_tcmbufn_w9{
    uint_io32_t		u32Register;
    stc_tcfcfg0_tcmbufn_w9_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_tcmbufn_w9_t;

/* TCMBUF[0-15]_W10 */
#define TCFCFG0_TCMBUF0_W10	(TCFCFG0.unTCMBUF0_W10.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF0_W10_ECC_PARITY	TCFCFG0_TCMBUF0_W10  /*@bfrg@*/

#define TCFCFG0_TCMBUF1_W10	(TCFCFG0.unTCMBUF1_W10.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF1_W10_ECC_PARITY	TCFCFG0_TCMBUF1_W10  /*@bfrg@*/

#define TCFCFG0_TCMBUF2_W10	(TCFCFG0.unTCMBUF2_W10.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF2_W10_ECC_PARITY	TCFCFG0_TCMBUF2_W10  /*@bfrg@*/

#define TCFCFG0_TCMBUF3_W10	(TCFCFG0.unTCMBUF3_W10.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF3_W10_ECC_PARITY	TCFCFG0_TCMBUF3_W10  /*@bfrg@*/

#define TCFCFG0_TCMBUF4_W10	(TCFCFG0.unTCMBUF4_W10.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF4_W10_ECC_PARITY	TCFCFG0_TCMBUF4_W10  /*@bfrg@*/

#define TCFCFG0_TCMBUF5_W10	(TCFCFG0.unTCMBUF5_W10.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF5_W10_ECC_PARITY	TCFCFG0_TCMBUF5_W10  /*@bfrg@*/

#define TCFCFG0_TCMBUF6_W10	(TCFCFG0.unTCMBUF6_W10.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF6_W10_ECC_PARITY	TCFCFG0_TCMBUF6_W10  /*@bfrg@*/

#define TCFCFG0_TCMBUF7_W10	(TCFCFG0.unTCMBUF7_W10.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF7_W10_ECC_PARITY	TCFCFG0_TCMBUF7_W10  /*@bfrg@*/

#define TCFCFG0_TCMBUF8_W10	(TCFCFG0.unTCMBUF8_W10.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF8_W10_ECC_PARITY	TCFCFG0_TCMBUF8_W10  /*@bfrg@*/

#define TCFCFG0_TCMBUF9_W10	(TCFCFG0.unTCMBUF9_W10.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF9_W10_ECC_PARITY	TCFCFG0_TCMBUF9_W10  /*@bfrg@*/

#define TCFCFG0_TCMBUF10_W10	(TCFCFG0.unTCMBUF10_W10.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF10_W10_ECC_PARITY	TCFCFG0_TCMBUF10_W10  /*@bfrg@*/

#define TCFCFG0_TCMBUF11_W10	(TCFCFG0.unTCMBUF11_W10.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF11_W10_ECC_PARITY	TCFCFG0_TCMBUF11_W10  /*@bfrg@*/

#define TCFCFG0_TCMBUF12_W10	(TCFCFG0.unTCMBUF12_W10.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF12_W10_ECC_PARITY	TCFCFG0_TCMBUF12_W10  /*@bfrg@*/

#define TCFCFG0_TCMBUF13_W10	(TCFCFG0.unTCMBUF13_W10.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF13_W10_ECC_PARITY	TCFCFG0_TCMBUF13_W10  /*@bfrg@*/

#define TCFCFG0_TCMBUF14_W10	(TCFCFG0.unTCMBUF14_W10.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF14_W10_ECC_PARITY	TCFCFG0_TCMBUF14_W10  /*@bfrg@*/

#define TCFCFG0_TCMBUF15_W10	(TCFCFG0.unTCMBUF15_W10.u32Register)  /*@rg@*/
#define TCFCFG0_TCMBUF15_W10_ECC_PARITY	TCFCFG0_TCMBUF15_W10  /*@bfrg@*/

typedef union un_tcfcfg0_tcmbufn_w10{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_tcmbufn_w10_t;

/* TCMBUF[0-15]_W11 */
#define TCFCFG0_TCMBUF0_W11	(TCFCFG0.unTCMBUF0_W11.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF1_W11	(TCFCFG0.unTCMBUF1_W11.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF2_W11	(TCFCFG0.unTCMBUF2_W11.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF3_W11	(TCFCFG0.unTCMBUF3_W11.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF4_W11	(TCFCFG0.unTCMBUF4_W11.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF5_W11	(TCFCFG0.unTCMBUF5_W11.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF6_W11	(TCFCFG0.unTCMBUF6_W11.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF7_W11	(TCFCFG0.unTCMBUF7_W11.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF8_W11	(TCFCFG0.unTCMBUF8_W11.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF9_W11	(TCFCFG0.unTCMBUF9_W11.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF10_W11	(TCFCFG0.unTCMBUF10_W11.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF11_W11	(TCFCFG0.unTCMBUF11_W11.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF12_W11	(TCFCFG0.unTCMBUF12_W11.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF13_W11	(TCFCFG0.unTCMBUF13_W11.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF14_W11	(TCFCFG0.unTCMBUF14_W11.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF15_W11	(TCFCFG0.unTCMBUF15_W11.u32Register)  /*@rg@*/

typedef union un_tcfcfg0_tcmbufn_w11{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_tcmbufn_w11_t;

/* TCMBUF[0-15]_W12 */
#define TCFCFG0_TCMBUF0_W12	(TCFCFG0.unTCMBUF0_W12.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF1_W12	(TCFCFG0.unTCMBUF1_W12.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF2_W12	(TCFCFG0.unTCMBUF2_W12.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF3_W12	(TCFCFG0.unTCMBUF3_W12.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF4_W12	(TCFCFG0.unTCMBUF4_W12.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF5_W12	(TCFCFG0.unTCMBUF5_W12.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF6_W12	(TCFCFG0.unTCMBUF6_W12.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF7_W12	(TCFCFG0.unTCMBUF7_W12.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF8_W12	(TCFCFG0.unTCMBUF8_W12.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF9_W12	(TCFCFG0.unTCMBUF9_W12.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF10_W12	(TCFCFG0.unTCMBUF10_W12.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF11_W12	(TCFCFG0.unTCMBUF11_W12.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF12_W12	(TCFCFG0.unTCMBUF12_W12.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF13_W12	(TCFCFG0.unTCMBUF13_W12.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF14_W12	(TCFCFG0.unTCMBUF14_W12.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF15_W12	(TCFCFG0.unTCMBUF15_W12.u32Register)  /*@rg@*/

typedef union un_tcfcfg0_tcmbufn_w12{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_tcmbufn_w12_t;

/* TCMBUF[0-15]_W13 */
#define TCFCFG0_TCMBUF0_W13	(TCFCFG0.unTCMBUF0_W13.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF1_W13	(TCFCFG0.unTCMBUF1_W13.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF2_W13	(TCFCFG0.unTCMBUF2_W13.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF3_W13	(TCFCFG0.unTCMBUF3_W13.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF4_W13	(TCFCFG0.unTCMBUF4_W13.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF5_W13	(TCFCFG0.unTCMBUF5_W13.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF6_W13	(TCFCFG0.unTCMBUF6_W13.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF7_W13	(TCFCFG0.unTCMBUF7_W13.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF8_W13	(TCFCFG0.unTCMBUF8_W13.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF9_W13	(TCFCFG0.unTCMBUF9_W13.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF10_W13	(TCFCFG0.unTCMBUF10_W13.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF11_W13	(TCFCFG0.unTCMBUF11_W13.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF12_W13	(TCFCFG0.unTCMBUF12_W13.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF13_W13	(TCFCFG0.unTCMBUF13_W13.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF14_W13	(TCFCFG0.unTCMBUF14_W13.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF15_W13	(TCFCFG0.unTCMBUF15_W13.u32Register)  /*@rg@*/

typedef union un_tcfcfg0_tcmbufn_w13{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_tcmbufn_w13_t;

/* TCMBUF[0-15]_W14 */
#define TCFCFG0_TCMBUF0_W14	(TCFCFG0.unTCMBUF0_W14.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF1_W14	(TCFCFG0.unTCMBUF1_W14.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF2_W14	(TCFCFG0.unTCMBUF2_W14.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF3_W14	(TCFCFG0.unTCMBUF3_W14.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF4_W14	(TCFCFG0.unTCMBUF4_W14.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF5_W14	(TCFCFG0.unTCMBUF5_W14.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF6_W14	(TCFCFG0.unTCMBUF6_W14.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF7_W14	(TCFCFG0.unTCMBUF7_W14.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF8_W14	(TCFCFG0.unTCMBUF8_W14.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF9_W14	(TCFCFG0.unTCMBUF9_W14.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF10_W14	(TCFCFG0.unTCMBUF10_W14.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF11_W14	(TCFCFG0.unTCMBUF11_W14.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF12_W14	(TCFCFG0.unTCMBUF12_W14.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF13_W14	(TCFCFG0.unTCMBUF13_W14.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF14_W14	(TCFCFG0.unTCMBUF14_W14.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF15_W14	(TCFCFG0.unTCMBUF15_W14.u32Register)  /*@rg@*/

typedef union un_tcfcfg0_tcmbufn_w14{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_tcmbufn_w14_t;

/* TCMBUF[0-15]_W15 */
#define TCFCFG0_TCMBUF0_W15	(TCFCFG0.unTCMBUF0_W15.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF1_W15	(TCFCFG0.unTCMBUF1_W15.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF2_W15	(TCFCFG0.unTCMBUF2_W15.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF3_W15	(TCFCFG0.unTCMBUF3_W15.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF4_W15	(TCFCFG0.unTCMBUF4_W15.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF5_W15	(TCFCFG0.unTCMBUF5_W15.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF6_W15	(TCFCFG0.unTCMBUF6_W15.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF7_W15	(TCFCFG0.unTCMBUF7_W15.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF8_W15	(TCFCFG0.unTCMBUF8_W15.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF9_W15	(TCFCFG0.unTCMBUF9_W15.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF10_W15	(TCFCFG0.unTCMBUF10_W15.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF11_W15	(TCFCFG0.unTCMBUF11_W15.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF12_W15	(TCFCFG0.unTCMBUF12_W15.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF13_W15	(TCFCFG0.unTCMBUF13_W15.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF14_W15	(TCFCFG0.unTCMBUF14_W15.u32Register)  /*@rg@*/

#define TCFCFG0_TCMBUF15_W15	(TCFCFG0.unTCMBUF15_W15.u32Register)  /*@rg@*/

typedef union un_tcfcfg0_tcmbufn_w15{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tcfcfg0_tcmbufn_w15_t;


typedef struct stc_tcfcfg0{
    un_tcfcfg0_fcprotkey_t	unFCPROTKEY;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[4];	/* 0x00000004 */
    un_tcfcfg0_fcfgr_t	unFCFGR;	/* 0x00000008 */
    uint_io8_t	au8Reserved1[4];	/* 0x0000000C */
    un_tcfcfg0_feccctrl_t	unFECCCTRL;	/* 0x00000010 */
    uint_io8_t	au8Reserved2[8];	/* 0x00000014 */
    un_tcfcfg0_fecceir_t	unFECCEIR;	/* 0x0000001C */
    un_tcfcfg0_fictrl_t	unFICTRL;	/* 0x00000020 */
    uint_io8_t	au8Reserved3[4];	/* 0x00000024 */
    un_tcfcfg0_fdateir_l_t	unFDATEIR_L;	/* 0x00000028 */
    un_tcfcfg0_fdateir_h_t	unFDATEIR_H;	/* 0x0000002C */
    uint_io8_t	au8Reserved4[8];	/* 0x00000030 */
    un_tcfcfg0_fstat_t	unFSTAT;	/* 0x00000038 */
    uint_io8_t	au8Reserved5[20];	/* 0x0000003C */
    un_tcfcfg0_fsecir_t	unFSECIR;	/* 0x00000050 */
    un_tcfcfg0_feccear_t	unFECCEAR;	/* 0x00000054 */
    uint_io8_t	au8Reserved6[8];	/* 0x00000058 */
    un_tcfcfg0_fuidrn_t	unFUIDR0;	/* 0x00000060 */
    un_tcfcfg0_fuidrn_t	unFUIDR1;	/* 0x00000064 */
    uint_io8_t	au8Reserved7[24];	/* 0x00000068 */
    un_tcfcfg0_fucedir_t	unFUCEDIR;	/* 0x00000080 */
    un_tcfcfg0_fucear_t	unFUCEAR;	/* 0x00000084 */
    un_tcfcfg0_synr_t	unSYNR;	/* 0x00000088 */
    uint_io8_t	au8Reserved8[4];	/* 0x0000008C */
    un_tcfcfg0_brcfg_t	unBRCFG;	/* 0x00000090 */
    uint_io8_t	au8Reserved9[4];	/* 0x00000094 */
    un_tcfcfg0_brat_t	unBRAT;	/* 0x00000098 */
    uint_io8_t	au8Reserved10[676];	/* 0x0000009C */
    un_tcfcfg0_wswpn_t	unWSWP0;	/* 0x00000340 */
    un_tcfcfg0_wswpn_t	unWSWP1;	/* 0x00000344 */
    un_tcfcfg0_wswpn_t	unWSWP2;	/* 0x00000348 */
    un_tcfcfg0_wswpn_t	unWSWP3;	/* 0x0000034C */
    uint_io8_t	au8Reserved11[48];	/* 0x00000350 */
    un_tcfcfg0_cswpn_t	unCSWP1;	/* 0x00000380 */
    un_tcfcfg0_cswpn_t	unCSWP2;	/* 0x00000384 */
    un_tcfcfg0_cswpn_t	unCSWP3;	/* 0x00000388 */
    un_tcfcfg0_cswpn_t	unCSWP4;	/* 0x0000038C */
    un_tcfcfg0_cswpn_t	unCSWP5;	/* 0x00000390 */
    un_tcfcfg0_cswpn_t	unCSWP6;	/* 0x00000394 */
    un_tcfcfg0_cswpn_t	unCSWP7;	/* 0x00000398 */
    un_tcfcfg0_cswpn_t	unCSWP8;	/* 0x0000039C */
    uint_io8_t	au8Reserved12[32];	/* 0x000003A0 */
    un_tcfcfg0_secstat_t	unSECSTAT;	/* 0x000003C0 */
    un_tcfcfg0_ser_t	unSER;	/* 0x000003C4 */
    un_tcfcfg0_ssr_t	unSSR;	/* 0x000003C8 */
    un_tcfcfg0_ceer_t	unCEER;	/* 0x000003CC */
    un_tcfcfg0_soer_t	unSOER;	/* 0x000003D0 */
    un_tcfcfg0_swpoer_t	unSWPOER;	/* 0x000003D4 */
    uint_io8_t	au8Reserved13[4];	/* 0x000003D8 */
    un_tcfcfg0_cswp0_t	unCSWP0;	/* 0x000003DC */
    uint_io8_t	au8Reserved14[32];	/* 0x000003E0 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF0_W0;	/* 0x00000400 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF0_W1;	/* 0x00000404 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF0_W2;	/* 0x00000408 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF0_W3;	/* 0x0000040C */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF0_W4;	/* 0x00000410 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF0_W5;	/* 0x00000414 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF0_W6;	/* 0x00000418 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF0_W7;	/* 0x0000041C */
    un_tcfcfg0_tcmbufn_w8_t	unTCMBUF0_W8;	/* 0x00000420 */
    un_tcfcfg0_tcmbufn_w9_t	unTCMBUF0_W9;	/* 0x00000424 */
    un_tcfcfg0_tcmbufn_w10_t	unTCMBUF0_W10;	/* 0x00000428 */
    un_tcfcfg0_tcmbufn_w11_t	unTCMBUF0_W11;	/* 0x0000042C */
    un_tcfcfg0_tcmbufn_w12_t	unTCMBUF0_W12;	/* 0x00000430 */
    un_tcfcfg0_tcmbufn_w13_t	unTCMBUF0_W13;	/* 0x00000434 */
    un_tcfcfg0_tcmbufn_w14_t	unTCMBUF0_W14;	/* 0x00000438 */
    un_tcfcfg0_tcmbufn_w15_t	unTCMBUF0_W15;	/* 0x0000043C */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF1_W0;	/* 0x00000440 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF1_W1;	/* 0x00000444 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF1_W2;	/* 0x00000448 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF1_W3;	/* 0x0000044C */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF1_W4;	/* 0x00000450 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF1_W5;	/* 0x00000454 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF1_W6;	/* 0x00000458 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF1_W7;	/* 0x0000045C */
    un_tcfcfg0_tcmbufn_w8_t	unTCMBUF1_W8;	/* 0x00000460 */
    un_tcfcfg0_tcmbufn_w9_t	unTCMBUF1_W9;	/* 0x00000464 */
    un_tcfcfg0_tcmbufn_w10_t	unTCMBUF1_W10;	/* 0x00000468 */
    un_tcfcfg0_tcmbufn_w11_t	unTCMBUF1_W11;	/* 0x0000046C */
    un_tcfcfg0_tcmbufn_w12_t	unTCMBUF1_W12;	/* 0x00000470 */
    un_tcfcfg0_tcmbufn_w13_t	unTCMBUF1_W13;	/* 0x00000474 */
    un_tcfcfg0_tcmbufn_w14_t	unTCMBUF1_W14;	/* 0x00000478 */
    un_tcfcfg0_tcmbufn_w15_t	unTCMBUF1_W15;	/* 0x0000047C */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF2_W0;	/* 0x00000480 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF2_W1;	/* 0x00000484 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF2_W2;	/* 0x00000488 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF2_W3;	/* 0x0000048C */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF2_W4;	/* 0x00000490 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF2_W5;	/* 0x00000494 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF2_W6;	/* 0x00000498 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF2_W7;	/* 0x0000049C */
    un_tcfcfg0_tcmbufn_w8_t	unTCMBUF2_W8;	/* 0x000004A0 */
    un_tcfcfg0_tcmbufn_w9_t	unTCMBUF2_W9;	/* 0x000004A4 */
    un_tcfcfg0_tcmbufn_w10_t	unTCMBUF2_W10;	/* 0x000004A8 */
    un_tcfcfg0_tcmbufn_w11_t	unTCMBUF2_W11;	/* 0x000004AC */
    un_tcfcfg0_tcmbufn_w12_t	unTCMBUF2_W12;	/* 0x000004B0 */
    un_tcfcfg0_tcmbufn_w13_t	unTCMBUF2_W13;	/* 0x000004B4 */
    un_tcfcfg0_tcmbufn_w14_t	unTCMBUF2_W14;	/* 0x000004B8 */
    un_tcfcfg0_tcmbufn_w15_t	unTCMBUF2_W15;	/* 0x000004BC */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF3_W0;	/* 0x000004C0 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF3_W1;	/* 0x000004C4 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF3_W2;	/* 0x000004C8 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF3_W3;	/* 0x000004CC */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF3_W4;	/* 0x000004D0 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF3_W5;	/* 0x000004D4 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF3_W6;	/* 0x000004D8 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF3_W7;	/* 0x000004DC */
    un_tcfcfg0_tcmbufn_w8_t	unTCMBUF3_W8;	/* 0x000004E0 */
    un_tcfcfg0_tcmbufn_w9_t	unTCMBUF3_W9;	/* 0x000004E4 */
    un_tcfcfg0_tcmbufn_w10_t	unTCMBUF3_W10;	/* 0x000004E8 */
    un_tcfcfg0_tcmbufn_w11_t	unTCMBUF3_W11;	/* 0x000004EC */
    un_tcfcfg0_tcmbufn_w12_t	unTCMBUF3_W12;	/* 0x000004F0 */
    un_tcfcfg0_tcmbufn_w13_t	unTCMBUF3_W13;	/* 0x000004F4 */
    un_tcfcfg0_tcmbufn_w14_t	unTCMBUF3_W14;	/* 0x000004F8 */
    un_tcfcfg0_tcmbufn_w15_t	unTCMBUF3_W15;	/* 0x000004FC */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF4_W0;	/* 0x00000500 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF4_W1;	/* 0x00000504 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF4_W2;	/* 0x00000508 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF4_W3;	/* 0x0000050C */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF4_W4;	/* 0x00000510 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF4_W5;	/* 0x00000514 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF4_W6;	/* 0x00000518 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF4_W7;	/* 0x0000051C */
    un_tcfcfg0_tcmbufn_w8_t	unTCMBUF4_W8;	/* 0x00000520 */
    un_tcfcfg0_tcmbufn_w9_t	unTCMBUF4_W9;	/* 0x00000524 */
    un_tcfcfg0_tcmbufn_w10_t	unTCMBUF4_W10;	/* 0x00000528 */
    un_tcfcfg0_tcmbufn_w11_t	unTCMBUF4_W11;	/* 0x0000052C */
    un_tcfcfg0_tcmbufn_w12_t	unTCMBUF4_W12;	/* 0x00000530 */
    un_tcfcfg0_tcmbufn_w13_t	unTCMBUF4_W13;	/* 0x00000534 */
    un_tcfcfg0_tcmbufn_w14_t	unTCMBUF4_W14;	/* 0x00000538 */
    un_tcfcfg0_tcmbufn_w15_t	unTCMBUF4_W15;	/* 0x0000053C */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF5_W0;	/* 0x00000540 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF5_W1;	/* 0x00000544 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF5_W2;	/* 0x00000548 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF5_W3;	/* 0x0000054C */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF5_W4;	/* 0x00000550 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF5_W5;	/* 0x00000554 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF5_W6;	/* 0x00000558 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF5_W7;	/* 0x0000055C */
    un_tcfcfg0_tcmbufn_w8_t	unTCMBUF5_W8;	/* 0x00000560 */
    un_tcfcfg0_tcmbufn_w9_t	unTCMBUF5_W9;	/* 0x00000564 */
    un_tcfcfg0_tcmbufn_w10_t	unTCMBUF5_W10;	/* 0x00000568 */
    un_tcfcfg0_tcmbufn_w11_t	unTCMBUF5_W11;	/* 0x0000056C */
    un_tcfcfg0_tcmbufn_w12_t	unTCMBUF5_W12;	/* 0x00000570 */
    un_tcfcfg0_tcmbufn_w13_t	unTCMBUF5_W13;	/* 0x00000574 */
    un_tcfcfg0_tcmbufn_w14_t	unTCMBUF5_W14;	/* 0x00000578 */
    un_tcfcfg0_tcmbufn_w15_t	unTCMBUF5_W15;	/* 0x0000057C */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF6_W0;	/* 0x00000580 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF6_W1;	/* 0x00000584 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF6_W2;	/* 0x00000588 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF6_W3;	/* 0x0000058C */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF6_W4;	/* 0x00000590 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF6_W5;	/* 0x00000594 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF6_W6;	/* 0x00000598 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF6_W7;	/* 0x0000059C */
    un_tcfcfg0_tcmbufn_w8_t	unTCMBUF6_W8;	/* 0x000005A0 */
    un_tcfcfg0_tcmbufn_w9_t	unTCMBUF6_W9;	/* 0x000005A4 */
    un_tcfcfg0_tcmbufn_w10_t	unTCMBUF6_W10;	/* 0x000005A8 */
    un_tcfcfg0_tcmbufn_w11_t	unTCMBUF6_W11;	/* 0x000005AC */
    un_tcfcfg0_tcmbufn_w12_t	unTCMBUF6_W12;	/* 0x000005B0 */
    un_tcfcfg0_tcmbufn_w13_t	unTCMBUF6_W13;	/* 0x000005B4 */
    un_tcfcfg0_tcmbufn_w14_t	unTCMBUF6_W14;	/* 0x000005B8 */
    un_tcfcfg0_tcmbufn_w15_t	unTCMBUF6_W15;	/* 0x000005BC */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF7_W0;	/* 0x000005C0 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF7_W1;	/* 0x000005C4 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF7_W2;	/* 0x000005C8 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF7_W3;	/* 0x000005CC */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF7_W4;	/* 0x000005D0 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF7_W5;	/* 0x000005D4 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF7_W6;	/* 0x000005D8 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF7_W7;	/* 0x000005DC */
    un_tcfcfg0_tcmbufn_w8_t	unTCMBUF7_W8;	/* 0x000005E0 */
    un_tcfcfg0_tcmbufn_w9_t	unTCMBUF7_W9;	/* 0x000005E4 */
    un_tcfcfg0_tcmbufn_w10_t	unTCMBUF7_W10;	/* 0x000005E8 */
    un_tcfcfg0_tcmbufn_w11_t	unTCMBUF7_W11;	/* 0x000005EC */
    un_tcfcfg0_tcmbufn_w12_t	unTCMBUF7_W12;	/* 0x000005F0 */
    un_tcfcfg0_tcmbufn_w13_t	unTCMBUF7_W13;	/* 0x000005F4 */
    un_tcfcfg0_tcmbufn_w14_t	unTCMBUF7_W14;	/* 0x000005F8 */
    un_tcfcfg0_tcmbufn_w15_t	unTCMBUF7_W15;	/* 0x000005FC */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF8_W0;	/* 0x00000600 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF8_W1;	/* 0x00000604 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF8_W2;	/* 0x00000608 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF8_W3;	/* 0x0000060C */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF8_W4;	/* 0x00000610 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF8_W5;	/* 0x00000614 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF8_W6;	/* 0x00000618 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF8_W7;	/* 0x0000061C */
    un_tcfcfg0_tcmbufn_w8_t	unTCMBUF8_W8;	/* 0x00000620 */
    un_tcfcfg0_tcmbufn_w9_t	unTCMBUF8_W9;	/* 0x00000624 */
    un_tcfcfg0_tcmbufn_w10_t	unTCMBUF8_W10;	/* 0x00000628 */
    un_tcfcfg0_tcmbufn_w11_t	unTCMBUF8_W11;	/* 0x0000062C */
    un_tcfcfg0_tcmbufn_w12_t	unTCMBUF8_W12;	/* 0x00000630 */
    un_tcfcfg0_tcmbufn_w13_t	unTCMBUF8_W13;	/* 0x00000634 */
    un_tcfcfg0_tcmbufn_w14_t	unTCMBUF8_W14;	/* 0x00000638 */
    un_tcfcfg0_tcmbufn_w15_t	unTCMBUF8_W15;	/* 0x0000063C */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF9_W0;	/* 0x00000640 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF9_W1;	/* 0x00000644 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF9_W2;	/* 0x00000648 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF9_W3;	/* 0x0000064C */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF9_W4;	/* 0x00000650 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF9_W5;	/* 0x00000654 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF9_W6;	/* 0x00000658 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF9_W7;	/* 0x0000065C */
    un_tcfcfg0_tcmbufn_w8_t	unTCMBUF9_W8;	/* 0x00000660 */
    un_tcfcfg0_tcmbufn_w9_t	unTCMBUF9_W9;	/* 0x00000664 */
    un_tcfcfg0_tcmbufn_w10_t	unTCMBUF9_W10;	/* 0x00000668 */
    un_tcfcfg0_tcmbufn_w11_t	unTCMBUF9_W11;	/* 0x0000066C */
    un_tcfcfg0_tcmbufn_w12_t	unTCMBUF9_W12;	/* 0x00000670 */
    un_tcfcfg0_tcmbufn_w13_t	unTCMBUF9_W13;	/* 0x00000674 */
    un_tcfcfg0_tcmbufn_w14_t	unTCMBUF9_W14;	/* 0x00000678 */
    un_tcfcfg0_tcmbufn_w15_t	unTCMBUF9_W15;	/* 0x0000067C */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF10_W0;	/* 0x00000680 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF10_W1;	/* 0x00000684 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF10_W2;	/* 0x00000688 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF10_W3;	/* 0x0000068C */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF10_W4;	/* 0x00000690 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF10_W5;	/* 0x00000694 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF10_W6;	/* 0x00000698 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF10_W7;	/* 0x0000069C */
    un_tcfcfg0_tcmbufn_w8_t	unTCMBUF10_W8;	/* 0x000006A0 */
    un_tcfcfg0_tcmbufn_w9_t	unTCMBUF10_W9;	/* 0x000006A4 */
    un_tcfcfg0_tcmbufn_w10_t	unTCMBUF10_W10;	/* 0x000006A8 */
    un_tcfcfg0_tcmbufn_w11_t	unTCMBUF10_W11;	/* 0x000006AC */
    un_tcfcfg0_tcmbufn_w12_t	unTCMBUF10_W12;	/* 0x000006B0 */
    un_tcfcfg0_tcmbufn_w13_t	unTCMBUF10_W13;	/* 0x000006B4 */
    un_tcfcfg0_tcmbufn_w14_t	unTCMBUF10_W14;	/* 0x000006B8 */
    un_tcfcfg0_tcmbufn_w15_t	unTCMBUF10_W15;	/* 0x000006BC */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF11_W0;	/* 0x000006C0 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF11_W1;	/* 0x000006C4 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF11_W2;	/* 0x000006C8 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF11_W3;	/* 0x000006CC */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF11_W4;	/* 0x000006D0 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF11_W5;	/* 0x000006D4 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF11_W6;	/* 0x000006D8 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF11_W7;	/* 0x000006DC */
    un_tcfcfg0_tcmbufn_w8_t	unTCMBUF11_W8;	/* 0x000006E0 */
    un_tcfcfg0_tcmbufn_w9_t	unTCMBUF11_W9;	/* 0x000006E4 */
    un_tcfcfg0_tcmbufn_w10_t	unTCMBUF11_W10;	/* 0x000006E8 */
    un_tcfcfg0_tcmbufn_w11_t	unTCMBUF11_W11;	/* 0x000006EC */
    un_tcfcfg0_tcmbufn_w12_t	unTCMBUF11_W12;	/* 0x000006F0 */
    un_tcfcfg0_tcmbufn_w13_t	unTCMBUF11_W13;	/* 0x000006F4 */
    un_tcfcfg0_tcmbufn_w14_t	unTCMBUF11_W14;	/* 0x000006F8 */
    un_tcfcfg0_tcmbufn_w15_t	unTCMBUF11_W15;	/* 0x000006FC */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF12_W0;	/* 0x00000700 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF12_W1;	/* 0x00000704 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF12_W2;	/* 0x00000708 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF12_W3;	/* 0x0000070C */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF12_W4;	/* 0x00000710 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF12_W5;	/* 0x00000714 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF12_W6;	/* 0x00000718 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF12_W7;	/* 0x0000071C */
    un_tcfcfg0_tcmbufn_w8_t	unTCMBUF12_W8;	/* 0x00000720 */
    un_tcfcfg0_tcmbufn_w9_t	unTCMBUF12_W9;	/* 0x00000724 */
    un_tcfcfg0_tcmbufn_w10_t	unTCMBUF12_W10;	/* 0x00000728 */
    un_tcfcfg0_tcmbufn_w11_t	unTCMBUF12_W11;	/* 0x0000072C */
    un_tcfcfg0_tcmbufn_w12_t	unTCMBUF12_W12;	/* 0x00000730 */
    un_tcfcfg0_tcmbufn_w13_t	unTCMBUF12_W13;	/* 0x00000734 */
    un_tcfcfg0_tcmbufn_w14_t	unTCMBUF12_W14;	/* 0x00000738 */
    un_tcfcfg0_tcmbufn_w15_t	unTCMBUF12_W15;	/* 0x0000073C */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF13_W0;	/* 0x00000740 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF13_W1;	/* 0x00000744 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF13_W2;	/* 0x00000748 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF13_W3;	/* 0x0000074C */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF13_W4;	/* 0x00000750 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF13_W5;	/* 0x00000754 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF13_W6;	/* 0x00000758 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF13_W7;	/* 0x0000075C */
    un_tcfcfg0_tcmbufn_w8_t	unTCMBUF13_W8;	/* 0x00000760 */
    un_tcfcfg0_tcmbufn_w9_t	unTCMBUF13_W9;	/* 0x00000764 */
    un_tcfcfg0_tcmbufn_w10_t	unTCMBUF13_W10;	/* 0x00000768 */
    un_tcfcfg0_tcmbufn_w11_t	unTCMBUF13_W11;	/* 0x0000076C */
    un_tcfcfg0_tcmbufn_w12_t	unTCMBUF13_W12;	/* 0x00000770 */
    un_tcfcfg0_tcmbufn_w13_t	unTCMBUF13_W13;	/* 0x00000774 */
    un_tcfcfg0_tcmbufn_w14_t	unTCMBUF13_W14;	/* 0x00000778 */
    un_tcfcfg0_tcmbufn_w15_t	unTCMBUF13_W15;	/* 0x0000077C */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF14_W0;	/* 0x00000780 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF14_W1;	/* 0x00000784 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF14_W2;	/* 0x00000788 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF14_W3;	/* 0x0000078C */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF14_W4;	/* 0x00000790 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF14_W5;	/* 0x00000794 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF14_W6;	/* 0x00000798 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF14_W7;	/* 0x0000079C */
    un_tcfcfg0_tcmbufn_w8_t	unTCMBUF14_W8;	/* 0x000007A0 */
    un_tcfcfg0_tcmbufn_w9_t	unTCMBUF14_W9;	/* 0x000007A4 */
    un_tcfcfg0_tcmbufn_w10_t	unTCMBUF14_W10;	/* 0x000007A8 */
    un_tcfcfg0_tcmbufn_w11_t	unTCMBUF14_W11;	/* 0x000007AC */
    un_tcfcfg0_tcmbufn_w12_t	unTCMBUF14_W12;	/* 0x000007B0 */
    un_tcfcfg0_tcmbufn_w13_t	unTCMBUF14_W13;	/* 0x000007B4 */
    un_tcfcfg0_tcmbufn_w14_t	unTCMBUF14_W14;	/* 0x000007B8 */
    un_tcfcfg0_tcmbufn_w15_t	unTCMBUF14_W15;	/* 0x000007BC */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF15_W0;	/* 0x000007C0 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF15_W1;	/* 0x000007C4 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF15_W2;	/* 0x000007C8 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF15_W3;	/* 0x000007CC */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF15_W4;	/* 0x000007D0 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF15_W5;	/* 0x000007D4 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF15_W6;	/* 0x000007D8 */
    un_tcfcfg0_tcmbufn_wn_t	unTCMBUF15_W7;	/* 0x000007DC */
    un_tcfcfg0_tcmbufn_w8_t	unTCMBUF15_W8;	/* 0x000007E0 */
    un_tcfcfg0_tcmbufn_w9_t	unTCMBUF15_W9;	/* 0x000007E4 */
    un_tcfcfg0_tcmbufn_w10_t	unTCMBUF15_W10;	/* 0x000007E8 */
    un_tcfcfg0_tcmbufn_w11_t	unTCMBUF15_W11;	/* 0x000007EC */
    un_tcfcfg0_tcmbufn_w12_t	unTCMBUF15_W12;	/* 0x000007F0 */
    un_tcfcfg0_tcmbufn_w13_t	unTCMBUF15_W13;	/* 0x000007F4 */
    un_tcfcfg0_tcmbufn_w14_t	unTCMBUF15_W14;	/* 0x000007F8 */
    un_tcfcfg0_tcmbufn_w15_t	unTCMBUF15_W15;	/* 0x000007FC */
    uint_io8_t	au8Reserved15[2048];	/* 0x00000800 */
}stc_tcfcfg0_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_tcfcfg0_t	stcTCFCFG0;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 4096(0x1000) bytes */


#endif /* __S6J3360_TCFCFG_H */
