#include "EOL_Para.h"


_EOL_F101 EOL_F101;
_EOL_F110 EOL_F110;
_EOL_F100 EOL_F100;
_EOL_F102 EOL_F102;
_EOL_7101 EOL_7101;
_EOL_7102 EOL_7102;

void EOL_InitVal(void)
{
    uint8_t i;
    EOL_F101.F101_Byte[0u]  = 0xFFu;

    EOL_F110.F110_Byte[0u] = 0xF7u;/*默认手动*/
    EOL_F110.F110_Byte[1u] = 0xFFu;
    EOL_F110.F110_Byte[2u] = 0xFFu;
    EOL_F110.F110_Byte[3u] = 0xFFu;
    EOL_F110.F110_Byte[4u] = 0xFFu;
    EOL_F110.F110_Byte[5u] = 0xFFu;
    EOL_F110.F110_Byte[6u] = 0xFFu;
    EOL_F110.F110_Byte[7u] = 0xFFu;

    EOL_F100.F100_Byte[0u] = 0xFFu;
    EOL_F100.F100_Byte[1u] = 0xFFu;
    EOL_F100.F100_Byte[2u] = 0xFFu;
    EOL_F100.F100_Byte[3u] = 0xFFu;
    EOL_F100.F100_Byte[4u] = 0xFFu;
    EOL_F100.F100_Byte[5u] = 0xFFu;
    EOL_F100.F100_Byte[6u] = 0xFFu;
    EOL_F100.F100_Byte[7u] = 0xFFu;
    EOL_F100.F100_Byte[8u] = 0xFFu;
    EOL_F100.F100_Byte[9u] = 0xFFu;
    EOL_F100.F100_Byte[10u] = 0xFFu;
    EOL_F100.F100_Byte[11u] = 0xFFu;
    EOL_F100.F100_Byte[12u] = 0xFFu;
    EOL_F100.F100_Byte[13u] = 0xFFu;
    EOL_F100.F100_Byte[14u] = 0xFFu;
    EOL_F100.F100_Byte[15u] = 0xFFu;

    for(i = 0;i < 24;i++)
    {
        EOL_F102.F102_Byte[i] = 0x00u;
    }
    EOL_F102.F102_Byte[21] = 0x53;


}

void EOL_SetF101(uint8_t EOL[], uint8_t len)
{
    uint8_t i;

    if (len == 16u)
    {
        for (i = 0u; i < sizeof(EOL_F101); i++)
        {
            EOL_F101.F101_Byte[i] = EOL[i];
        }
    }
}

void EOL_SetF102(uint8_t EOL[], uint8_t len)
{
    uint8_t i;

    if (len == 24u)
    {
        for (i = 0u; i < sizeof(EOL_F102); i++)
        {
            EOL_F102.F102_Byte[i] = EOL[i];
        }
    }
}

void EOL_SetF110(uint8_t EOL[], uint8_t len)
{
    uint8_t i;
    if (len == 8u)
    {
        for (i = 0u; i < sizeof(EOL_F110); i++)
        {
            EOL_F110.F110_Byte[i] = EOL[i];
        }
    }
}

void EOL_SetF100(uint8_t EOL[], uint8_t len)
{
    uint8_t i;
    if (len == 8u)
    {
        for (i = 0u; i < sizeof(EOL_F100); i++)
        {
            EOL_F100.F100_Byte[i] = EOL[i];
        }
    }
}

void EOL_Set7101(uint8_t EOL[], uint8_t len)
{
    uint8_t i;
    if (len == 8u)
    {
        for (i = 0u; i < sizeof(EOL_7101); i++)
        {
            EOL_7101.F7101_Byte[i] = EOL[i];
        }
    }
}

void EOL_Set7102(uint8_t EOL[], uint8_t len)
{
    uint8_t i;
    if (len == 8u)
    {
        for (i = 0u; i < sizeof(EOL_7102); i++)
        {
            EOL_7102.F7102_Byte[i] = EOL[i];
        }
    }
}
_EOL_F101 EOL_GetF101(void)
{
    return EOL_F101;
}

_EOL_F100 EOL_GetF100(void)
{
    return EOL_F100;
}

_EOL_F110 EOL_GetF110(void)
{
    return EOL_F110;
}

_EOL_F102 EOL_GetF102(void)
{
    return EOL_F102;
}

_EOL_7102 EOL_Get7102(void)
{
    return EOL_7102;
}
/*F101*/

/*BYTE0*/
uint8_t Val_EOL_F101_Engine(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)(EOL_F101.F101_Byte[0u]);
    return Res;
}


/*BYTE1*/
uint8_t Val_EOL_F101_Radar(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[1u] >> 4u) & 0x0Fu);
    return Res;
}


uint8_t     Val_EOL_F101_Language(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[1u]) & 0x0Fu);
    return Res;
}


/*BYTE2*/
uint8_t Val_EOL_F101_Gearbox(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[2u] >> 4u) & 0x0Fu);
    return Res;
}


uint8_t Val_EOL_F101_OverSpeed(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[2u] >> 2u) & 0x03u);
    return Res;
}

uint8_t Val_EOL_F101_HUD(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[2u]) & 0x03u);
    return Res;
}

/*BYTE3*/
uint8_t Val_EOL_F101_Tyre(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[3u] >> 4u) & 0x0Fu);
    return Res;
}

uint8_t Val_EOL_F101_Seat_O(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[3u] >> 2u) & 0x03u);
    return Res;
}

uint8_t Val_EOL_F101_EPSMod(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[3u]) & 0x03u);
    return Res;
}

/*BYTE4*/
uint8_t Val_EOL_F101_Energy(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[4u] >> 4u) & 0x0Fu);
    return Res;
}

uint8_t Val_EOL_F101_FuelTank(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[4u]) & 0x0Fu);
    return Res;
}


/*BYTE5*/
uint8_t Val_EOL_F101_ESCOFF(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[5u] >> 6u) & 0x03u);
    return Res;
}

uint8_t Val_EOL_F101_LIM(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[5u] >> 4u) & 0x03u);
    return Res;
}

uint8_t Val_EOL_F101_TempOut(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[5u] >> 2u) & 0x03u);
    return Res;
}

uint8_t Val_EOL_F101_LightReg(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[5u]) & 0x03u);
    return Res;
}

/*BYTE6*/
uint8_t Val_EOL_F101_HBB(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[6u] >> 6u) & 0x03u);
    return Res;
}

uint8_t Val_EOL_F101_Cruise(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[6u] >> 3u) & 0x07u);
    return Res;
}

uint8_t Val_EOL_F101_Vehicle(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[6u]) & 0x07u);
    return Res;
}

/*BYTE7*/
uint8_t Val_EOL_F101_SLIF(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[7u] >> 6u) & 0x03u);
    return Res;
}

uint8_t Val_EOL_F101_AEB(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[7u] >> 4u) & 0x03u);
    return Res;
}

uint8_t Val_EOL_F101_LKSLDW(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[7u] >> 2u) & 0x03u);
    return Res;
}

uint8_t Val_EOL_F101_BSD(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[7u]) & 0x03u);
    return Res;
}

/*BYTE8*/
uint8_t Val_EOL_F101_HDC(void)
{
    uint8_t Res=0u;
    return Res;
}

uint8_t Val_EOL_F101_RCTA(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[8u] >> 4u) & 0x03u);
    return Res;
}

uint8_t Val_EOL_F101_RCW(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[8u] >> 2u) & 0x03u);
    return Res;
}

uint8_t Val_EOL_F101_IHBC(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[8u]) & 0x03u);
    return Res;
}

/*BYTE9*/
uint8_t Val_EOL_F101_LCA(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[9u] >> 7u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F101_DOW(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[9u] >> 6u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F101_DriverPos(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[9u] >> 5u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F101_APA(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[9u] >> 3u) & 0x03u);
    return Res;
}

uint8_t Val_EOL_F101_Seat(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[9u]) & 0x07u);
    return Res;
}


/*BYTE10*/
uint8_t Val_EOL_F101_Sunroof(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[10u] >> 6u) & 0x03u);
    return Res;
}

uint8_t Val_EOL_F101_Skin(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[10u] >> 4u) & 0x03u);
    return Res;
}

uint8_t Val_EOL_F101_FuelInit(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[10u]) & 0x0fu);
    return Res;
}

/*BYTE11*/
uint8_t Val_EOL_F101_FCW(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[11u] >> 7u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F101_ODOBack(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F101.F101_Byte[0u] >> 0u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F101_BeltDisp(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[11u] >> 5u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F101_IPKGear(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[11u] >> 4u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F101_MMIKey(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[11u] >> 3u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F101_Phone(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[11u] >> 2u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F101_Music(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[11u] >> 1u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F101_Nav(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[11u]) & 0x01u);
    return Res;
}

/*BYTE12*/
uint8_t Val_EOL_F101_Bat(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[12u] >> 4u) & 0x0fu);
    return Res;
}

uint8_t Val_EOL_F101_PEPS(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[12u] >> 2u) & 0x03u);
    return Res;
}

uint8_t Val_EOL_F101_OilPress(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[12u] >> 1u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F101_WipInd(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[12u]) & 0x01u);
    return Res;
}

/*BYTE13*/
uint8_t Val_EOL_F101_ADAS(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[13u] >> 1u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F101_Guid(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[13u]) & 0x01u);
    return Res;
}

/*BYTE15*/
uint8_t Val_EOL_F101_TPMS(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[15u]) & 0xFFu);
    return Res;
}

/*BYTE15*/
uint8_t Val_EOL_F101_MaintainTimeDispiay(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[15u]>>2) & 0x01u);
    return Res;
}


/*BYTE15*/
uint8_t Val_EOL_F101_Jion_P_Gear(void)
{
    uint8_t Res=0u;
    // Res = (uint8_t)((EOL_F101.F101_Byte[15u]) & 0x01u);
    return Res;
}


/****F110***/

/**byte0*/
uint8_t Val_EOL_F110_EPS(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[0u] >> 7u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_PEPS(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[0u] >> 6u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_ESC(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[0u] >> 5u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_ACU(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[0u] >> 4u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_TCU(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[0u] >> 3u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_BCM(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[0u] >> 2u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_IPK(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[0u] >> 1u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F110_EMS(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[0u]) & 0x01u);
    return Res;
}

/**byte1**/
uint8_t Val_EOL_F110_ESCL(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[1u] >> 7u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_TBOX(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[1u] >> 6u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_TPMS(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[1u] >> 5u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_PAS(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[1u] >> 4u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_MMI(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[1u] >> 3u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_AC(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[1u] >> 2u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_FRS(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[1u] >> 1u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F110_SAS(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[1u]) & 0x01u);
    return Res;
}


/**BYTE2*/

uint8_t Val_EOL_F110_4WD(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[2u] >> 7u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_IMMO(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[2u] >> 6u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_ABS(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[2u] >> 5u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_ADB(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[2u] >> 4u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_DSCU2(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[2u] >> 3u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_PTG(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[2u] >> 2u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_FCS(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[2u] >> 1u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F110_EPB(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[2u]) & 0x01u);
    return Res;
}

/*byte3**/

uint8_t Val_EOL_F110_IPU(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[3u] >> 7u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_OBC(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[3u] >> 6u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_VCU(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[3u] >> 5u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_DCDC(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[3u] >> 4u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_BMSH(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[3u] >> 3u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_BSG(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[3u] >> 2u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_EGSM(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[3u] >> 1u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F110_PTGW(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[3u]) & 0x01u);
    return Res;
}
/**BYTE4*/
uint8_t Val_EOL_F110_RSRS(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[4u] >> 7u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_GW(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[4u] >> 6u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_DMS(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[4u] >> 5u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_HVSM(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[4u] >> 4u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_DVR(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[4u] >> 3u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_AVAS(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[4u] >> 2u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_DSCU4(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[4u] >> 1u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F110_ACCM(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[4u]) & 0x01u);
    return Res;
}

/**BYTE5*/


uint8_t Val_EOL_F110_BSD(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u] >> 7u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_TSU(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u] >> 6u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_PCU(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u] >> 5u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_PDM(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u] >> 4u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_DDM(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u] >> 3u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_HUD(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u] >> 2u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_AVM(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u] >> 1u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F110_AGS(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u]) & 0x01u);
    return Res;
}


/**BYTE6**/

uint8_t Val_EOL_F110_IB(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u] >> 7u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_SUM(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u] >> 6u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_RML(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u] >> 5u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_ECS(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u] >> 4u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_TACM(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u] >> 3u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_BMSL(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u] >> 2u) & 0x01u);
    return Res;
}

/****F102***/

/**byte21*/
uint8_t Val_EOL_F102_RadarType(void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F102.F102_Byte[21u] >> 0u) & 0x0Fu);
    return Res;
}

uint8_t Val_EOL_F102_MaximumSpeedLimit (void)
{
    uint8_t Res=0u;
    Res = (uint8_t)((EOL_F102.F102_Byte[21u] >> 4u) & 0x0Fu);
    return Res;
}