#include "UDS_10Service_Internal.h"
#include "Telltales_user.h"
#include "Telltales_Lib.h"

/**
  *10服务重置27服务标志位
  */
void UDS_10Service_S27Init(void)
{
    Ser27_ChangeSessionHandle();
}

/**
  *10服务重置28服务标志位
  */
void UDS_10Service_S28Init(void)
{
    ControlMessageCommunication(networkManagementMsgAndnormalMsg, enableRxAndTx);
}

/**
  *10服务重置2F服务标志位
  */
void UDS_10Service_S2FInit(void)
{
    uint32_t i = 0u;
    for(i = 0u; i < LED_Max; ++i)
    {
        Telltales_DiagRelease(i);
    }
  BuzzerForceCtrlRelease();  
}

/**
  *10服务重置85服务标志位
  */
void UDS_10Service_S85Init(void)
{
    OpenDTCTest();
}

/**
  *写入跳转标志位
  *@param Flag 跳转标志
  */
void WriteJumpBootStatusToDFlash(uint32_t Flag)
{
    DiagFlag.JumpToBootFlag = Flag;
    WriteDFlashData(0x01u, (uint32_t *)&DiagFlag.Flag, sizeof(DiagFlag) / 4u, NeedWait);
}