/**************************************************************************//**
  * \file     Init.c
  * \brief    Initializations during work state switching
  * \details
  * \author   Zhang Xuan
  * \version  V1.0.0
  * \date     18-Jan-2019
  * \par      History:
  *           V1.0.0 Initial release
  * \par      Copyright:
  *           (c) Heilongjiang TYW Electronics co., LTD
******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "Init.h"
#include "PowerManagement.h"
#include "System_Status_Monitor.h"
#include "RTE_CAN.h"
#include "RTE_TIME.h"
#include "RTE_PWM_OUT.h"
#include "MFS_UART.h"
#include "Sound_Scheduler.h"
#include "Popup_Scheduler.h"
#include "Sound_Player.h"
#include "UDS_Common.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/**************************************************************************//**
  * \brief      Initializations during work state switching
  * \attention
  * \retval     None
******************************************************************************/
void Sys_Startup_Pre_Init(void)
{
    /* Now we are running on Fast-CR Clock */

    /* Re-map exception vectors of BootROM's vector table to application specific exception handlers */
    Exceptions_Init();
    Interrupt_Controller_Unlock();

#ifdef __WITHOUT_BOOTLOADER

    /* Configure internal memories */
    Mem_Init();

    /* Start to clear all RAM areas */
    Mem_Clear();

    /* Configure clocks */
    Clock_Init();

    /* Wait for completion of ECC RAM clearing */
    MEM_Wait_Clear_Complete();

#else

    /* Start to clear all RAM areas */
    Mem_Clear();

    /* Wait for completion of ECC RAM clearing */
    MEM_Wait_Clear_Complete();

#endif

    /* Configure MPU */
    CPU_Config_MPU();

    /* Configure cache */
    CPU_Config_Caches();
#ifdef __WITHOUT_BOOTLOADER

    /* Start RTC */
    if (Clock_Get_Startup_Mode() == CLK_STARTUP_PWR_ON)
    {
        RTE_RTC_KL30_Init();
    }

#endif
}

/**************************************************************************//**
  * \brief      Initializations during system power up
  * \attention
  * \retval     None
******************************************************************************/
void Sys_Startup_Init(void)
{
#ifdef __WITHOUT_BOOTLOADER
    WDT_Init();
#endif
    GPIO_Run_Mode_Init();
    //gpio_Port1_pin20();
    Sys_Tick_Timer_Start();
    Analog_Signal_Conv_Init();
    WFlash_Block_Init();
    WFlash_Controller_Init();
    RTE_RTC_Wakeup_Init();
    /*  用户需要在此处添加自己的驱动初始化函数  */
    /* MFS_UART_Init(9u,         */    /*  MFS的通道9  */
    /*               115200u     */    /*  波特率为115200bps  */
    /*              );*/
    MFS_UART_InitWithParity(1u,  4800u ,MFS_UART_EvenParity );
    RTE_PWM_Init();
    Can_Init();
    Can_SetTx_St(CAN_Y_TX);
    Can_SetRx_St(CAN_Y_RX);
    Interrupt_Controller_Lock();
    NMI_ENABLE();
    IRQ_ENABLE();
    ReadAllDFlashData();
    Power_Management_Init();
    RTE_PWM_Start();
    //gpio_Port1_pin20();
}

/**************************************************************************//**
  * \brief      Initializations during work state switch to system sleep
  * \attention
  * \retval     None
******************************************************************************/
void Sys_Sleep_Init(void)
{
    Sys_Tick_Timer_Stop();
    GPIO_Sleep_Mode_Init();
    GPIO_Set_Interrupt_Mode(1U, 7U, GPIO_INT_L_LEVEL, 0U, NULL);
    GPIO_Set_Interrupt_Mode(1U, 2U, GPIO_INT_H_LEVEL, 0U, NULL);
    GPIO_Set_Interrupt_Mode(1U, 10U, GPIO_INT_H_LEVEL, 0U, NULL);
}

/**************************************************************************//**
  * \brief      Initializations during work state switch to system run
  * \attention
  * \retval     None
******************************************************************************/
void Sys_Wakeup_Init(void)
{

}