#ifndef _CAN_APP_H_
#define _CAN_APP_H_

#include "RTE_CAN.h"


/******************************************************************************
Bus-off状态
******************************************************************************/
#define   MSCAN0_BUS_STABLE                 0x00U
#define   MSCAN0_BUS_OFF_LV1                0x01U
#define   MSCAN0_BUS_OFF_LV2                0x02U
#define   MSCAN0_BUS_LIMP                   0x03U
/******************************************************************************
Bus-off设置
******************************************************************************/
#define   MSCAN0_BUS_OFF_AUTO_RECOVERY      0U               /* Bus-off自动恢复使能 */

#define   MSCAN0_BUS_OFF_LV1_RECOVERY_TIME  100U             /* Bus-off恢复时间,单位ms */
#define   MSCAN0_BUS_OFF_LV2_RECOVERY_TIME  1000U            /* Bus-off恢复时间,单位ms */

#define   MSCAN0_BUS_LIMP_MODE_ENABLE       0U               /* 跛行模式使能     */
#define   MSCAN0_BUS_LIMP_MODE_THRESHOLD    11U              /* 进入跛行模式门限 */

void Can_Abort_All(void);
void Can_BusOff_Fun(void);

uint8_t CrcCheckSum(uint8_t data[], uint8_t len);
/*MSG*/

uint8_t getBUS_OFF_Status(void);
uint8_t getBUS_OFF_FLAG(void);
void Can_BusOffRecover(void);
#endif