#ifndef _SERVICE_TripA_H_
#define _SERVICE_TripA_H_

#include "stdint.h"


/*** 控制结构 ***/
typedef struct
{
    uint16_t  Mileage100m;
    uint16_t  RoCBackup;
} DataTripAStruct;

typedef struct
{
    uint8_t  V_Speed_Valid;
    uint16_t Act_V_Speed;
    uint16_t MileageRollingCnt;
} _DataTripAInputStruct;



extern uint16_t                DataTripA;
extern uint8_t                 DataTripAValid;
extern DataTripAStruct         DataTripACalc;
extern _DataTripAInputStruct   Input_TripA_Para;

void Data_InputTripA_KL15Init(void);
/*小计里程的初值,如果车厂不要求掉电存储,默认传0*/
void Data_TripA_KL30Init ( uint16_t Base_TripA );
/*保证在服务函数上方调用*/
void Data_TripA_Set_Para(_DataTripAInputStruct *m_Para);
/*小计里程值读取*/
uint16_t Data_Read_TripA(void);
/*小计里程有效性读取  0-无效;1-有效*/
uint8_t Data_Read_TripAValid(void);
/*小计里程清零函数*/   /*87506-1*/
void Data_Clear_TripA ( void );
/*小计里程服务函数*/
void Data_TripA_Processing ( void );
void Data_TripA_Set_Para(_DataTripAInputStruct *m_Para);
void Services_TripA_SaveCall(uint16_t Val_Trip);
uint16_t Services_TripA_Version(void);
void Services_TripA_100MS_Cbk(void);
void Three_ClearOdo(void);
#endif