

#ifndef _SOUND_TRACKS_H_
#define _SOUND_TRACKS_H_

#include "stdint.h"
/******************************************************************************
单一音轨最大音符数量
******************************************************************************/
#define   SND_TRACK_MAX_NOTE_NUM            4

/******************************************************************************
音符属性结构
******************************************************************************/
typedef struct
{
  uint16_t   Freq;            //声音频率(Hz),0表示静音(休止符)
  uint8_t    Duty;            //声音占空比(%)
  uint16_t   Interval;        //声音长度(ms)
  uint16_t   Fade;            //声音淡出时间(ms)
}SndTrackNoteStruct;

/******************************************************************************
音轨属性结构
******************************************************************************/
typedef struct
{
  uint8_t             NoteNum;         //总音符数
  uint8_t             PreCharge;       //预充电时间(ms),影响第一个音符的播放力度
  SndTrackNoteStruct  Note[SND_TRACK_MAX_NOTE_NUM];
}SndTrackStruct;

/******************************************************************************
音轨属性表
******************************************************************************/
static const SndTrackStruct SndTracks[] = 
{
  {
    /*==============================================================
     音轨编号 | 总长度 |                  描述
    ----------+--------+--------------------------------------------
          000 |  500ms |                                   2kHz长鸣  
    ----------------------------------------------------------------
     总音符数 | 预充电时间(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
     音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
    --------------------------------------------------------------*/
     /*  1  */           2000,         50,       450,           0,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/  
  },

  {
    /*==============================================================
     音轨编号 | 总长度 |                  描述
    ----------+--------+--------------------------------------------
          001 |  980ms |                                   2kHz淡出  
    ----------------------------------------------------------------
     总音符数 | 预充电时间(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
     音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
    --------------------------------------------------------------*/
     /*  1  */           2000,         50,       930,         850,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/  
  },
  
  {
    /*==============================================================
     音轨编号 | 总长度 |                  描述
    ----------+--------+--------------------------------------------
          002 |  550ms |                     长雷达提示音,800Hz长鸣  
    ----------------------------------------------------------------
     总音符数 | 预充电时间(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
     音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
    --------------------------------------------------------------*/
     /*  1  */            800,         50,       500,           0,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/  
  },  
  
  {
    /*==============================================================
     音轨编号 | 总长度 |                  描述
    ----------+--------+--------------------------------------------
          003 |  300ms |                     中雷达提示音,800Hz长鸣
    ----------------------------------------------------------------
     总音符数 | 预充电时间(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
     音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
    --------------------------------------------------------------*/
     /*  1  */            800,         50,       250,           0,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  },  
  
  {
    /*==============================================================
     音轨编号 | 总长度 |                  描述
    ----------+--------+--------------------------------------------
          004 |  175ms |                     短雷达提示音,800Hz长鸣
    ----------------------------------------------------------------
     总音符数 | 预充电时间(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
     音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
    --------------------------------------------------------------*/
     /*  1  */            800,         50,       125,           0,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  },
  
  {
    /*==============================================================
     音轨编号 | 总长度 |                  描述
    ----------+--------+--------------------------------------------
          005 |   53ms |                             转向提示音Tick
    ----------------------------------------------------------------
     总音符数 | 预充电时间(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
     音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
    --------------------------------------------------------------*/
     /*  1  */            780,         50,         3,           0,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  },
  
  {
    /*==============================================================
     音轨编号 | 总长度 |                  描述
    ----------+--------+--------------------------------------------
          006 |   52ms |                             转向提示音Tock
    ----------------------------------------------------------------
     总音符数 | 预充电时间(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
     音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
    --------------------------------------------------------------*/
     /*  1  */            780,         25,         3,           0,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  }, 
  
  {
    /*==============================================================
     音轨编号 | 总长度 |                  描述
    ----------+--------+--------------------------------------------
          007 |  980ms |                       通用提示音,660Hz淡出
    ----------------------------------------------------------------
     总音符数 | 预充电时间(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
     音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
    --------------------------------------------------------------*/
     /*  1  */            660,         50,       930,         850,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  }, 
  
  {
    /*==============================================================
     音轨编号 | 总长度 |                  描述
    ----------+--------+--------------------------------------------
          008 |  980ms |                       通用提示音,784Hz淡出
    ----------------------------------------------------------------
     总音符数 | 预充电时间(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
     音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
    --------------------------------------------------------------*/
     /*  1  */            784,         50,       930,         850,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  }, 
  
  {
    /*==============================================================
     音轨编号 | 总长度 |                  描述
    ----------+--------+--------------------------------------------
          009 |  980ms |                      通用提示音,1000Hz淡出
    ----------------------------------------------------------------
     总音符数 | 预充电时间(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
     音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
    --------------------------------------------------------------*/
     /*  1  */           1000,         50,       930,         850,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  }, 
  
  {
    /*==============================================================
     音轨编号 | 总长度 |                  描述
    ----------+--------+--------------------------------------------
          010 |  980ms |              双音提示音,1000Hz + 784Hz淡出
    ----------------------------------------------------------------
     总音符数 | 预充电时间(ms) |
    --------------------------------------------------------------*/
             3,              50,
    /*--------------------------------------------------------------
     音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
    --------------------------------------------------------------*/
     /*  1  */           1000,         50,       200,         150,
     /*  2  */              0,          0,        20,           0,
     /*  3  */            784,         50,       710,         620,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  },   
  
  {
    /*==============================================================
     音轨编号 | 总长度 |                  描述
    ----------+--------+--------------------------------------------
          011 |  500ms |                                  850Hz长鸣
    ----------------------------------------------------------------
     总音符数 | 预充电时间(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
     音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
    --------------------------------------------------------------*/
     /*  1  */            744,         50,       450,           50,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  },  
  
  {
    /*==============================================================
     音轨编号 | 总长度 |                  描述
    ----------+--------+--------------------------------------------
          012 |  500ms |                      通用提示音,1950Hz淡出
    ----------------------------------------------------------------
     总音符数 | 预充电时间(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
     音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
    --------------------------------------------------------------*/
     /*  1  */           1950,         50,       450,         100,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  },  
  {
    /*==============================================================
     音轨编号 | 总长度 |                  描述
    ----------+--------+--------------------------------------------
          013 |  500ms |                      通用提示音,744Hz淡出
    ----------------------------------------------------------------
     总音符数 | 预充电时间(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
     音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
    --------------------------------------------------------------*/
     /*  1  */            744,         50,       350,          50,
     /*  2  */              0,          0,         0 ,          0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  },  
  {
    /*==============================================================
     音轨编号 | 总长度 |                  描述
    ----------+--------+--------------------------------------------
          014 |  800ms |                      通用提示音,744Hz淡出
    ----------------------------------------------------------------
     总音符数 | 预充电时间(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
     音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
    --------------------------------------------------------------*/
     /*  1  */            744,         50,       700,          400,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  }, 
  {
    /*==============================================================
     音轨编号 | 总长度 |                  描述
    ----------+--------+--------------------------------------------
          015 |  500ms |                      通用提示音,1950Hz淡出
    ----------------------------------------------------------------
     总音符数 | 预充电时间(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
     音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
    --------------------------------------------------------------*/
     /*  1  */           1950,         50,       200,          160,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  }, 

  {
    /*==============================================================
     音轨编号 | 总长度 |                  描述
    ----------+--------+--------------------------------------------
          016 |  500ms |                      通用提示音,744Hz淡出
    ----------------------------------------------------------------
     总音符数 | 预充电时间(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
     音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
    --------------------------------------------------------------*/
     /*  1  */            744,         50,       600,          200,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  },    

  {
    /*==============================================================
     音轨编号 | 总长度 |                  描述
    ----------+--------+--------------------------------------------
          017 |  500ms |                      通用提示音,744Hz淡出
    ----------------------------------------------------------------
     总音符数 | 预充电时间(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
     音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
    --------------------------------------------------------------*/
     /*  1  */            744,         50,       400,          50,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  }, 
  {
    /*==============================================================
     音轨编号 | 总长度 |                  描述
    ----------+--------+--------------------------------------------
          018 |  500ms |                      通用提示音,660Hz淡出
    ----------------------------------------------------------------
     总音符数 | 预充电时间(ms) |
    --------------------------------------------------------------*/
             1,              50,
    /*--------------------------------------------------------------
     音符编号 | 声音频率(Hz) | 占空比(%) | 时长(ms) | 淡出时间(ms)
    --------------------------------------------------------------*/
     /*  1  */            660,         50,       250,          850,
     /*  2  */              0,          0,         0,           0,
     /*  3  */              0,          0,         0,           0,
     /*  4  */              0,          0,         0,           0,
    /*============================================================*/
  }, 

};



/******************************************************************************
音轨总数
******************************************************************************/
#define   SND_TRACK_TOTAL_NUM               (sizeof(SndTracks) / sizeof(SndTrackStruct)) 





#endif