/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_EP_H
#define __S6J3360_EP_H

#include "s6j3360io_basetypes.h"

/* EP base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define EP	stcEP
#else /* __IO_DEFINE */
#define EP	(*((volatile stc_ep_t*)0xB8050000UL))
#endif /* __IO_DEFINE */

/* EXCSVPLL[0-2]CFGR0 */
#define EP_EXCSVPLL0CFGR0	(EP.unEXCSVPLL0CFGR0.u32Register)  /*@rg@*/
#define EP_EXCSVPLL0CFGR0_LOWTHR	(EP.unEXCSVPLL0CFGR0.stcField.u10LOWTHR)  /*@bf@*/
#define EP_EXCSVPLL0CFGR0_UPTHR	(EP.unEXCSVPLL0CFGR0.stcField.u12UPTHR)  /*@bf@*/

#define EP_EXCSVPLL1CFGR0	(EP.unEXCSVPLL1CFGR0.u32Register)  /*@rg@*/
#define EP_EXCSVPLL1CFGR0_LOWTHR	(EP.unEXCSVPLL1CFGR0.stcField.u10LOWTHR)  /*@bf@*/
#define EP_EXCSVPLL1CFGR0_UPTHR	(EP.unEXCSVPLL1CFGR0.stcField.u12UPTHR)  /*@bf@*/

#define EP_EXCSVPLL2CFGR0	(EP.unEXCSVPLL2CFGR0.u32Register)  /*@rg@*/
#define EP_EXCSVPLL2CFGR0_LOWTHR	(EP.unEXCSVPLL2CFGR0.stcField.u10LOWTHR)  /*@bf@*/
#define EP_EXCSVPLL2CFGR0_UPTHR	(EP.unEXCSVPLL2CFGR0.stcField.u12UPTHR)  /*@bf@*/

typedef struct stc_ep_excsvpllncfgr0_field{
    uint_io32_t		u10LOWTHR:10;
    uint_io32_t		:6;
    uint_io32_t		u12UPTHR:12;
    uint_io32_t		:4;
}stc_ep_excsvpllncfgr0_field_t;

typedef union un_ep_excsvpllncfgr0{
    uint_io32_t		u32Register;
    stc_ep_excsvpllncfgr0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ep_excsvpllncfgr0_t;

/* EXCSVPLL[0-2]CFGR1 */
#define EP_EXCSVPLL0CFGR1	(EP.unEXCSVPLL0CFGR1.u32Register)  /*@rg@*/
#define EP_EXCSVPLL0CFGR1_REFCLKWND	(EP.unEXCSVPLL0CFGR1.stcField.u10REFCLKWND)  /*@bf@*/

#define EP_EXCSVPLL1CFGR1	(EP.unEXCSVPLL1CFGR1.u32Register)  /*@rg@*/
#define EP_EXCSVPLL1CFGR1_REFCLKWND	(EP.unEXCSVPLL1CFGR1.stcField.u10REFCLKWND)  /*@bf@*/

#define EP_EXCSVPLL2CFGR1	(EP.unEXCSVPLL2CFGR1.u32Register)  /*@rg@*/
#define EP_EXCSVPLL2CFGR1_REFCLKWND	(EP.unEXCSVPLL2CFGR1.stcField.u10REFCLKWND)  /*@bf@*/

typedef struct stc_ep_excsvpllncfgr1_field{
    uint_io32_t		u10REFCLKWND:10;
    uint_io32_t		:22;
}stc_ep_excsvpllncfgr1_field_t;

typedef union un_ep_excsvpllncfgr1{
    uint_io32_t		u32Register;
    stc_ep_excsvpllncfgr1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ep_excsvpllncfgr1_t;

/* EXCSVCFGR */
#define EP_EXCSVCFGR	(EP.unEXCSVCFGR.u32Register)  /*@rg@*/
#define EP_EXCSVCFGR_EXPLL0CSVE	(EP.unEXCSVCFGR.stcField.u1EXPLL0CSVE)  /*@bf@*/
#define EP_EXCSVCFGR_EXPLL1CSVE	(EP.unEXCSVCFGR.stcField.u1EXPLL1CSVE)  /*@bf@*/
#define EP_EXCSVCFGR_EXPLL2CSVE	(EP.unEXCSVCFGR.stcField.u1EXPLL2CSVE)  /*@bf@*/

typedef struct stc_ep_excsvcfgr_field{
    uint_io32_t		:8;
    uint_io32_t		u1EXPLL0CSVE:1;
    uint_io32_t		u1EXPLL1CSVE:1;
    uint_io32_t		u1EXPLL2CSVE:1;
    uint_io32_t		:21;
}stc_ep_excsvcfgr_field_t;

typedef union un_ep_excsvcfgr{
    uint_io32_t		u32Register;
    stc_ep_excsvcfgr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ep_excsvcfgr_t;

/* EXCSVERR */
#define EP_EXCSVERR	(EP.unEXCSVERR.u32Register)  /*@rg@*/
#define EP_EXCSVERR_EXPLL0IF	(EP.unEXCSVERR.stcField.u1EXPLL0IF)  /*@bf@*/
#define EP_EXCSVERR_EXPLL1IF	(EP.unEXCSVERR.stcField.u1EXPLL1IF)  /*@bf@*/
#define EP_EXCSVERR_EXPLL2IF	(EP.unEXCSVERR.stcField.u1EXPLL2IF)  /*@bf@*/

typedef struct stc_ep_excsverr_field{
    uint_io32_t		:8;
    uint_io32_t		u1EXPLL0IF:1;
    uint_io32_t		u1EXPLL1IF:1;
    uint_io32_t		u1EXPLL2IF:1;
    uint_io32_t		:21;
}stc_ep_excsverr_field_t;

typedef union un_ep_excsverr{
    uint_io32_t		u32Register;
    stc_ep_excsverr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ep_excsverr_t;

/* EXCSVERRCLR */
#define EP_EXCSVERRCLR	(EP.unEXCSVERRCLR.u32Register)  /*@rg@*/
#define EP_EXCSVERRCLR_EXPLL0ICLR	(EP.unEXCSVERRCLR.stcField.u1EXPLL0ICLR)  /*@bf@*/
#define EP_EXCSVERRCLR_EXPLL1ICLR	(EP.unEXCSVERRCLR.stcField.u1EXPLL1ICLR)  /*@bf@*/
#define EP_EXCSVERRCLR_EXPLL2ICLR	(EP.unEXCSVERRCLR.stcField.u1EXPLL2ICLR)  /*@bf@*/

typedef struct stc_ep_excsverrclr_field{
    uint_io32_t		:8;
    uint_io32_t		u1EXPLL0ICLR:1;
    uint_io32_t		u1EXPLL1ICLR:1;
    uint_io32_t		u1EXPLL2ICLR:1;
    uint_io32_t		:21;
}stc_ep_excsverrclr_field_t;

typedef union un_ep_excsverrclr{
    uint_io32_t		u32Register;
    stc_ep_excsverrclr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ep_excsverrclr_t;

/* EXPLL0CNTR */
#define EP_EXPLL0CNTR	(EP.unEXPLL0CNTR.u32Register)  /*@rg@*/
#define EP_EXPLL0CNTR_PLL0DIVL	(EP.unEXPLL0CNTR.stcField.u2PLL0DIVL)  /*@bf@*/
#define EP_EXPLL0CNTR_PLL0DIVM	(EP.unEXPLL0CNTR.stcField.u4PLL0DIVM)  /*@bf@*/
#define EP_EXPLL0CNTR_PLL0DIVN	(EP.unEXPLL0CNTR.au8Byte[2])  /*@bfbyte@*/
#define EP_EXPLL0CNTR_PLL0STABS	(EP.unEXPLL0CNTR.stcField.u4PLL0STABS)  /*@bf@*/

typedef struct stc_ep_expll0cntr_field{
    uint_io32_t		u2PLL0DIVL:2;
    uint_io32_t		:6;
    uint_io32_t		u4PLL0DIVM:4;
    uint_io32_t		:4;
    uint_io32_t		u8PLL0DIVN:8;
    uint_io32_t		u4PLL0STABS:4;
    uint_io32_t		:4;
}stc_ep_expll0cntr_field_t;

typedef union un_ep_expll0cntr{
    uint_io32_t		u32Register;
    stc_ep_expll0cntr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ep_expll0cntr_t;

/* EXPLL1CNTR */
#define EP_EXPLL1CNTR	(EP.unEXPLL1CNTR.u32Register)  /*@rg@*/
#define EP_EXPLL1CNTR_PLL1DIVL	(EP.unEXPLL1CNTR.stcField.u2PLL1DIVL)  /*@bf@*/
#define EP_EXPLL1CNTR_PLL1DIVM	(EP.unEXPLL1CNTR.stcField.u4PLL1DIVM)  /*@bf@*/
#define EP_EXPLL1CNTR_PLL1DIVN	(EP.unEXPLL1CNTR.au8Byte[2])  /*@bfbyte@*/
#define EP_EXPLL1CNTR_PLL1STABS	(EP.unEXPLL1CNTR.stcField.u4PLL1STABS)  /*@bf@*/

typedef struct stc_ep_expll1cntr_field{
    uint_io32_t		u2PLL1DIVL:2;
    uint_io32_t		:6;
    uint_io32_t		u4PLL1DIVM:4;
    uint_io32_t		:4;
    uint_io32_t		u8PLL1DIVN:8;
    uint_io32_t		u4PLL1STABS:4;
    uint_io32_t		:4;
}stc_ep_expll1cntr_field_t;

typedef union un_ep_expll1cntr{
    uint_io32_t		u32Register;
    stc_ep_expll1cntr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ep_expll1cntr_t;

/* EXPLL2CNTR */
#define EP_EXPLL2CNTR	(EP.unEXPLL2CNTR.u32Register)  /*@rg@*/
#define EP_EXPLL2CNTR_PLL2DIVL	(EP.unEXPLL2CNTR.stcField.u2PLL2DIVL)  /*@bf@*/
#define EP_EXPLL2CNTR_PLL2DIVM	(EP.unEXPLL2CNTR.stcField.u4PLL2DIVM)  /*@bf@*/
#define EP_EXPLL2CNTR_PLL21DIVN	(EP.unEXPLL2CNTR.au8Byte[2])  /*@bfbyte@*/
#define EP_EXPLL2CNTR_PLL2STABS	(EP.unEXPLL2CNTR.stcField.u4PLL2STABS)  /*@bf@*/

typedef struct stc_ep_expll2cntr_field{
    uint_io32_t		u2PLL2DIVL:2;
    uint_io32_t		:6;
    uint_io32_t		u4PLL2DIVM:4;
    uint_io32_t		:4;
    uint_io32_t		u8PLL21DIVN:8;
    uint_io32_t		u4PLL2STABS:4;
    uint_io32_t		:4;
}stc_ep_expll2cntr_field_t;

typedef union un_ep_expll2cntr{
    uint_io32_t		u32Register;
    stc_ep_expll2cntr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ep_expll2cntr_t;

/* EXPLLEN */
#define EP_EXPLLEN	(EP.unEXPLLEN.u32Register)  /*@rg@*/
#define EP_EXPLLEN_EXPLL0EN	(EP.unEXPLLEN.stcField.u1EXPLL0EN)  /*@bf@*/
#define EP_EXPLLEN_EXPLL1EN	(EP.unEXPLLEN.stcField.u1EXPLL1EN)  /*@bf@*/
#define EP_EXPLLEN_EXPLL2EN	(EP.unEXPLLEN.stcField.u1EXPLL2EN)  /*@bf@*/
#define EP_EXPLLEN_EXPLL0RDY	(EP.unEXPLLEN.stcField.u1EXPLL0RDY)  /*@bf@*/
#define EP_EXPLLEN_EXPLL1RDY	(EP.unEXPLLEN.stcField.u1EXPLL1RDY)  /*@bf@*/
#define EP_EXPLLEN_EXPLL2RDY	(EP.unEXPLLEN.stcField.u1EXPLL2RDY)  /*@bf@*/

typedef struct stc_ep_expllen_field{
    uint_io32_t		:8;
    uint_io32_t		u1EXPLL0EN:1;
    uint_io32_t		u1EXPLL1EN:1;
    uint_io32_t		u1EXPLL2EN:1;
    uint_io32_t		:13;
    uint_io32_t		u1EXPLL0RDY:1;
    uint_io32_t		u1EXPLL1RDY:1;
    uint_io32_t		u1EXPLL2RDY:1;
    uint_io32_t		:5;
}stc_ep_expllen_field_t;

typedef union un_ep_expllen{
    uint_io32_t		u32Register;
    stc_ep_expllen_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ep_expllen_t;

/* EXCKDIVR0 */
#define EP_EXCKDIVR0	(EP.unEXCKDIVR0.u32Register)  /*@rg@*/
#define EP_EXCKDIVR0_Expand_CLKCD0B	(EP.unEXCKDIVR0.stcField.u4Expand_CLKCD0B)  /*@bf@*/
#define EP_EXCKDIVR0_Expand_CLKCD0A	(EP.unEXCKDIVR0.stcField.u4Expand_CLKCD0A)  /*@bf@*/
#define EP_EXCKDIVR0_Expand_CLKCD0	(EP.unEXCKDIVR0.stcField.u5Expand_CLKCD0)  /*@bf@*/
#define EP_EXCKDIVR0_EXPAND_CLKCD0B	EP_EXCKDIVR0_Expand_CLKCD0B  /*@bf2@*/
#define EP_EXCKDIVR0_EXPAND_CLKCD0A	EP_EXCKDIVR0_Expand_CLKCD0A  /*@bf2@*/
#define EP_EXCKDIVR0_EXPAND_CLKCD0	EP_EXCKDIVR0_Expand_CLKCD0  /*@bf2@*/

typedef struct stc_ep_exckdivr0_field{
    uint_io32_t		:8;
    uint_io32_t		u4Expand_CLKCD0B:4;
    uint_io32_t		:4;
    uint_io32_t		u4Expand_CLKCD0A:4;
    uint_io32_t		:4;
    uint_io32_t		u5Expand_CLKCD0:5;
    uint_io32_t		:3;
}stc_ep_exckdivr0_field_t;

typedef union un_ep_exckdivr0{
    uint_io32_t		u32Register;
    stc_ep_exckdivr0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ep_exckdivr0_t;

/* EXCKDIVR1 */
#define EP_EXCKDIVR1	(EP.unEXCKDIVR1.u32Register)  /*@rg@*/
#define EP_EXCKDIVR1_Expand_CLKCD1B	(EP.unEXCKDIVR1.stcField.u4Expand_CLKCD1B)  /*@bf@*/
#define EP_EXCKDIVR1_Expand_CLKCD1A	(EP.unEXCKDIVR1.stcField.u4Expand_CLKCD1A)  /*@bf@*/
#define EP_EXCKDIVR1_Expand_CLKCD1	(EP.unEXCKDIVR1.stcField.u5Expand_CLKCD1)  /*@bf@*/
#define EP_EXCKDIVR1_EXPAND_CLKCD1B	EP_EXCKDIVR1_Expand_CLKCD1B  /*@bf2@*/
#define EP_EXCKDIVR1_EXPAND_CLKCD1A	EP_EXCKDIVR1_Expand_CLKCD1A  /*@bf2@*/
#define EP_EXCKDIVR1_EXPAND_CLKCD1	EP_EXCKDIVR1_Expand_CLKCD1  /*@bf2@*/

typedef struct stc_ep_exckdivr1_field{
    uint_io32_t		:8;
    uint_io32_t		u4Expand_CLKCD1B:4;
    uint_io32_t		:4;
    uint_io32_t		u4Expand_CLKCD1A:4;
    uint_io32_t		:4;
    uint_io32_t		u5Expand_CLKCD1:5;
    uint_io32_t		:3;
}stc_ep_exckdivr1_field_t;

typedef union un_ep_exckdivr1{
    uint_io32_t		u32Register;
    stc_ep_exckdivr1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ep_exckdivr1_t;

/* EXCKDIVR2 */
#define EP_EXCKDIVR2	(EP.unEXCKDIVR2.u32Register)  /*@rg@*/
#define EP_EXCKDIVR2_Expand_CLKCD2B	(EP.unEXCKDIVR2.stcField.u4Expand_CLKCD2B)  /*@bf@*/
#define EP_EXCKDIVR2_Expand_CLKCD2A	(EP.unEXCKDIVR2.stcField.u4Expand_CLKCD2A)  /*@bf@*/
#define EP_EXCKDIVR2_Expand_CLKCD2	(EP.unEXCKDIVR2.stcField.u5Expand_CLKCD2)  /*@bf@*/
#define EP_EXCKDIVR2_EXPAND_CLKCD2B	EP_EXCKDIVR2_Expand_CLKCD2B  /*@bf2@*/
#define EP_EXCKDIVR2_EXPAND_CLKCD2A	EP_EXCKDIVR2_Expand_CLKCD2A  /*@bf2@*/
#define EP_EXCKDIVR2_EXPAND_CLKCD2	EP_EXCKDIVR2_Expand_CLKCD2  /*@bf2@*/

typedef struct stc_ep_exckdivr2_field{
    uint_io32_t		:8;
    uint_io32_t		u4Expand_CLKCD2B:4;
    uint_io32_t		:4;
    uint_io32_t		u4Expand_CLKCD2A:4;
    uint_io32_t		:4;
    uint_io32_t		u5Expand_CLKCD2:5;
    uint_io32_t		:3;
}stc_ep_exckdivr2_field_t;

typedef union un_ep_exckdivr2{
    uint_io32_t		u32Register;
    stc_ep_exckdivr2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ep_exckdivr2_t;

/* EXPLLSEL */
#define EP_EXPLLSEL	(EP.unEXPLLSEL.u32Register)  /*@rg@*/
#define EP_EXPLLSEL_EXPLLSEL0	(EP.unEXPLLSEL.stcField.u1EXPLLSEL0)  /*@bf@*/
#define EP_EXPLLSEL_EXPLLSEL1	(EP.unEXPLLSEL.stcField.u1EXPLLSEL1)  /*@bf@*/
#define EP_EXPLLSEL_EXPLLSEL2	(EP.unEXPLLSEL.stcField.u1EXPLLSEL2)  /*@bf@*/

typedef struct stc_ep_expllsel_field{
    uint_io32_t		u1EXPLLSEL0:1;
    uint_io32_t		u1EXPLLSEL1:1;
    uint_io32_t		u1EXPLLSEL2:1;
    uint_io32_t		:29;
}stc_ep_expllsel_field_t;

typedef union un_ep_expllsel{
    uint_io32_t		u32Register;
    stc_ep_expllsel_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ep_expllsel_t;


typedef struct stc_ep{
    un_ep_excsvpllncfgr0_t	unEXCSVPLL0CFGR0;	/* 0x00000000 */
    un_ep_excsvpllncfgr1_t	unEXCSVPLL0CFGR1;	/* 0x00000004 */
    un_ep_excsvpllncfgr0_t	unEXCSVPLL1CFGR0;	/* 0x00000008 */
    un_ep_excsvpllncfgr1_t	unEXCSVPLL1CFGR1;	/* 0x0000000C */
    un_ep_excsvpllncfgr0_t	unEXCSVPLL2CFGR0;	/* 0x00000010 */
    un_ep_excsvpllncfgr1_t	unEXCSVPLL2CFGR1;	/* 0x00000014 */
    un_ep_excsvcfgr_t	unEXCSVCFGR;	/* 0x00000018 */
    un_ep_excsverr_t	unEXCSVERR;	/* 0x0000001C */
    un_ep_excsverrclr_t	unEXCSVERRCLR;	/* 0x00000020 */
    uint_io8_t	au8Reserved0[28];	/* 0x00000024 */
    un_ep_expll0cntr_t	unEXPLL0CNTR;	/* 0x00000040 */
    un_ep_expll1cntr_t	unEXPLL1CNTR;	/* 0x00000044 */
    un_ep_expll2cntr_t	unEXPLL2CNTR;	/* 0x00000048 */
    un_ep_expllen_t	unEXPLLEN;	/* 0x0000004C */
    un_ep_exckdivr0_t	unEXCKDIVR0;	/* 0x00000050 */
    un_ep_exckdivr1_t	unEXCKDIVR1;	/* 0x00000054 */
    un_ep_exckdivr2_t	unEXCKDIVR2;	/* 0x00000058 */
    un_ep_expllsel_t	unEXPLLSEL;	/* 0x0000005C */
    uint_io8_t	au8Reserved1[928];	/* 0x00000060 */
}stc_ep_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_ep_t	stcEP;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


#endif /* __S6J3360_EP_H */
