/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_SRCFG_H
#define __S6J3360_SRCFG_H

#include "s6j3360io_basetypes.h"

/* SRCFG base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define SRCFG	stcSRCFG
#else /* __IO_DEFINE */
#define SRCFG	(*((volatile stc_srcfg_t*)0xB0108000UL))
#endif /* __IO_DEFINE */

/* CFG0 */
#define SRCFG_CFG0	(SRCFG.unCFG0.u32Register)  /*@rg@*/
#define SRCFG_CFG0_ERRECC	(SRCFG.unCFG0.stcField.u7ERRECC)  /*@bf@*/
#define SRCFG_CFG0_LOCK_STATUS	(SRCFG.unCFG0.stcField.u1LOCK_STATUS)  /*@bf@*/
#define SRCFG_CFG0_WRWAIT	(SRCFG.unCFG0.stcField.u2WRWAIT)  /*@bf@*/
#define SRCFG_CFG0_RDWAIT	(SRCFG.unCFG0.stcField.u2RDWAIT)  /*@bf@*/

typedef struct stc_srcfg_cfg0_field{
    uint_io32_t		u7ERRECC:7;
    uint_io32_t		:1;
    uint_io32_t		u1LOCK_STATUS:1;
    uint_io32_t		:7;
    uint_io32_t		u2WRWAIT:2;
    uint_io32_t		:6;
    uint_io32_t		u2RDWAIT:2;
    uint_io32_t		:6;
}stc_srcfg_cfg0_field_t;

typedef union un_srcfg_cfg0{
    uint_io32_t		u32Register;
    stc_srcfg_cfg0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_srcfg_cfg0_t;

/* CFG1 */
#define SRCFG_CFG1	(SRCFG.unCFG1.u32Register)  /*@rg@*/
#define SRCFG_CFG1_ERRBIT	SRCFG_CFG1  /*@bfrg@*/

typedef union un_srcfg_cfg1{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_srcfg_cfg1_t;

/* CFG2 */
#define SRCFG_CFG2	(SRCFG.unCFG2.u32Register)  /*@rg@*/
#define SRCFG_CFG2_BYPASSEN	(SRCFG.unCFG2.stcField.u1BYPASSEN)  /*@bf@*/

typedef struct stc_srcfg_cfg2_field{
    uint_io32_t		u1BYPASSEN:1;
    uint_io32_t		:31;
}stc_srcfg_cfg2_field_t;

typedef union un_srcfg_cfg2{
    uint_io32_t		u32Register;
    stc_srcfg_cfg2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_srcfg_cfg2_t;

/* KEY */
#define SRCFG_KEY	(SRCFG.unKEY.u32Register)  /*@rg@*/
#define SRCFG_KEY_UNLOCK	SRCFG_KEY  /*@bfrg@*/

typedef union un_srcfg_key{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_srcfg_key_t;

/* ERRFLG */
#define SRCFG_ERRFLG	(SRCFG.unERRFLG.u32Register)  /*@rg@*/
#define SRCFG_ERRFLG_SECFLG	(SRCFG.unERRFLG.stcField.u1SECFLG)  /*@bf@*/
#define SRCFG_ERRFLG_SECCLR	(SRCFG.unERRFLG.stcField.u1SECCLR)  /*@bf@*/

typedef struct stc_srcfg_errflg_field{
    uint_io32_t		u1SECFLG:1;
    uint_io32_t		:7;
    uint_io32_t		u1SECCLR:1;
    uint_io32_t		:23;
}stc_srcfg_errflg_field_t;

typedef union un_srcfg_errflg{
    uint_io32_t		u32Register;
    stc_srcfg_errflg_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_srcfg_errflg_t;

/* INTE */
#define SRCFG_INTE	(SRCFG.unINTE.u32Register)  /*@rg@*/
#define SRCFG_INTE_SEC_INT_EN	(SRCFG.unINTE.stcField.u1SEC_INT_EN)  /*@bf@*/

typedef struct stc_srcfg_inte_field{
    uint_io32_t		u1SEC_INT_EN:1;
    uint_io32_t		:31;
}stc_srcfg_inte_field_t;

typedef union un_srcfg_inte{
    uint_io32_t		u32Register;
    stc_srcfg_inte_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_srcfg_inte_t;

/* ECCE */
#define SRCFG_ECCE	(SRCFG.unECCE.u32Register)  /*@rg@*/
#define SRCFG_ECCE_ECCEN	(SRCFG.unECCE.stcField.u1ECCEN)  /*@bf@*/

typedef struct stc_srcfg_ecce_field{
    uint_io32_t		u1ECCEN:1;
    uint_io32_t		:31;
}stc_srcfg_ecce_field_t;

typedef union un_srcfg_ecce{
    uint_io32_t		u32Register;
    stc_srcfg_ecce_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_srcfg_ecce_t;

/* ERRADR */
#define SRCFG_ERRADR	(SRCFG.unERRADR.u32Register)  /*@rg@*/
#define SRCFG_ERRADR_ERRADDR	SRCFG_ERRADR  /*@bfrg@*/

typedef union un_srcfg_erradr{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_srcfg_erradr_t;

/* MID */
#define SRCFG_MID	(SRCFG.unMID.u32Register)  /*@rg@*/
#define SRCFG_MID_MID	SRCFG_MID  /*@bfrg@*/

typedef union un_srcfg_mid{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_srcfg_mid_t;


typedef struct stc_srcfg{
    un_srcfg_cfg0_t	unCFG0;	/* 0x00000000 */
    un_srcfg_cfg1_t	unCFG1;	/* 0x00000004 */
    un_srcfg_cfg2_t	unCFG2;	/* 0x00000008 */
    un_srcfg_key_t	unKEY;	/* 0x0000000C */
    un_srcfg_errflg_t	unERRFLG;	/* 0x00000010 */
    un_srcfg_inte_t	unINTE;	/* 0x00000014 */
    un_srcfg_ecce_t	unECCE;	/* 0x00000018 */
    uint_io8_t	au8Reserved0[4];	/* 0x0000001C */
    un_srcfg_erradr_t	unERRADR;	/* 0x00000020 */
    un_srcfg_mid_t	unMID;	/* 0x00000024 */
    uint_io8_t	au8Reserved1[216];	/* 0x00000028 */
}stc_srcfg_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_srcfg_t	stcSRCFG;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 256(0x100) bytes */


#endif /* __S6J3360_SRCFG_H */
