#ifndef _POPUPS_H_
#define _POPUPS_H_

#include "stdint.h"

#include "Popup_Scheduler.h"
#include "Communication_Over_CAN.h"
#include "Sound_Scheduler.h"
#include "EOL_Para.h"
#include "Common_Interface.h"
#include "Flash_synchronizer.h"
#include "Line_In.h"
#include "MBD_Model.h"

#define   IGN_ON 1u
#define   IGN_OFF 0u
#define   TCU_FAILURE_Red 2u
#define   TCU_FAILURE_Yellow 1u
#define   TCU_FAILURE_OFF 0u
#define   Human_Language 10u
#define   Can_Lost 0x55u
#define   Over_Speed_Trigger 1200u
#define   Over_Speed_Remove  1150u
void Popups_Polling(void);
void Popups_Sound_Playing(uint8_t PopupSnd);
void Popups_Management_Service(void);
void SetRADAR_SOUND(uint8_t Level);
uint8_t Get_OverSpeed_Sts(void);/*0为不闪烁，1为闪烁*/
uint8_t Get_OIL_LOW_Sts(void);
uint8_t Get_CPDWarning_Valid(void);
uint8_t Get_CPDWarningSts(void);
uint8_t Get_POP_3S_Clock(void);/*>=30U时可以报警*/
uint8_t PopupGetIGst(void);/*返回报警出发时判断出的电源状态*/
void Popups_KL15_Init(void);
void Popups_IG_OFF_Init(void);

#endif