#ifndef MAINTENANCE_H__
#define MAINTENANCE_H__
//#define MAINTENANCE_PLATFORM_16BIT
#ifdef MAINTENANCE_PLATFORM_16BIT
typedef unsigned char Maint_uint8_t;
typedef unsigned int Maint_uint16_t;
typedef unsigned long Maint_uint32_t;
#else
typedef unsigned char Maint_uint8_t;
typedef unsigned short Maint_uint16_t;
typedef unsigned int Maint_uint32_t;
typedef unsigned long long Maint_uint64_t;
#endif
/**  支持保养里程相关 **/
/**保养里程存储动作，传入长度固定为16个字节***/
typedef void (*Maintenance_Parameter_Save)(Maint_uint8_t *pu8MaintData, Maint_uint8_t u8MaintLen);
typedef struct
{
	Maint_uint32_t u32ODOCurrent; /***当前大计里程，0.1KM 精度**/
	/**传入的是默认值，首次上电未经任何设置时默认的参数**/
	Maint_uint32_t u32DefaultFirstIntervalMileage;	 /**默认的首保间隔里程，0.1KM 精度**/
	Maint_uint32_t u32DefaultSecondIntervalMileage;	 /**默认的次保间隔里程，0.1KM 精度**/
	Maintenance_Parameter_Save pfnMaintSaveCallBack; /**存储动作回调函数，必填**/
} Maint_Init_st_t;
/*--------------------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------------*/
/**
 * KL30和唤醒时调用
 * pstMaintInit:传入初始化相关参数。
 * pu8MaintParameter：传入从存储设备中读取的数据，默认16个长度。
 * **/
extern unsigned int Maintenance_Init(Maint_Init_st_t *pstMaintInit, Maint_uint8_t *pu8MaintParameter);
/**每100ms调用一次***/
extern void Maintenance_Service(void);

/**传入当前ODO，0.1KM**/
extern void Maintenance_Current_ODO_Set(Maint_uint32_t u32ODOCurrent);

/**设定首保时的间隔里程，0.1KM 精度**/
extern void Maintenance_First_Interval_Mileage_Set(Maint_uint32_t u32DataMileage);

/**设定次保时的间隔里程，0.1KM 精度**/
extern void Maintenance_Second_Interval_Mileage_Set(Maint_uint32_t u32DataMileage);

/***设置首保和次保的标志，0：首保   1：次保***/
extern void Maintenance_Flag_Set(Maint_uint8_t u8MaintFlag);

/**保养清零，默认变成次保****/
extern void Maintenance_Reset(void);

/**保养清零之后走动的里程数，0.1KM 精度*/
extern Maint_uint32_t Maintenance_Mileage_Count_Read(void);

/**剩余保养里程，再行驶多少里程后就该保养了，0.1KM精度*/
extern Maint_uint32_t Maintenance_Remaining_Mileage_Read(void);

/***读取首保和次保的标志，0：首保   1：次保***/
extern unsigned int Maintenance_Flag_Read(void);
#endif
