#include "RTE_PWM_OUT.h"

void RTE_PWM_Init(void)
{
    Bt_Pwm_Init(PwmIndexPwm17, PwmDiv1, 0u);/*指示灯5V*/
    Bt_Pwm_Init(PwmIndexPwm18, PwmDiv1, 0u);/*量表背光*/
}

void RTE_PWM_Start(void)
{    
    RTE_PWM_Panel_Start();/*指示灯5V*/
    RTE_PWM_Point_Start();/*量表背光*/
    
}
void RTE_PWM_Stop(void)
{    
    RTE_PWM_Panel_Stop();
    RTE_PWM_Point_Stop();
}

/*指针背光,设置亮度*/
void RTE_PWM_Set_Point(uint16_t m_Cycle, uint16_t m_Duty)
{
    Bt_Pwm_Fast_Update(PwmIndexPwm18, m_Cycle, m_Duty);
}
/*指针背光,开启输出*/
void RTE_PWM_Point_Start(void)
{
    Bt_Pwm_Start(PwmIndexPwm18, 32008u, 0u, 0u);
}
/*指针背光,关闭输出*/
void RTE_PWM_Point_Stop(void)
{
    Bt_Pwm_Stop(PwmIndexPwm18);
}

/*表盘背光更新亮度*/
void RTE_PWM_Set_Panel(uint16_t m_Cycle, uint16_t m_Duty)
{
    Bt_Pwm_Fast_Update(PwmIndexPwm17, m_Cycle, m_Duty);
}
/*表盘背光关闭输出*/
void RTE_PWM_Panel_Stop(void)
{
    Bt_Pwm_Stop(PwmIndexPwm17);
}
/*表盘背光开启输出*/
void RTE_PWM_Panel_Start(void)
{
    Bt_Pwm_Start(PwmIndexPwm17, 32008u,  0u, 0u);
}


/*LCD设置背光*/
void RTE_PWM_Set_LCD(uint16_t m_Cycle, uint16_t m_Duty)
{
    Bt_Pwm_Fast_Update(PwmIndexPwm4, m_Cycle, m_Duty);
}
/*LCD关闭*/
void RTE_PWM_LCD_Stop(void)
{
    Bt_Pwm_Stop(PwmIndexPwm4);
}
/*LCD开启*/
void RTE_PWM_LCD_Start(void)
{
    Bt_Pwm_Start(PwmIndexPwm4, 32008u,  0u, 0u);
}

void RTE_PWM_Set_Speed_Out(uint16_t m_Cycle, uint16_t m_Duty)
{
    Bt_Pwm_Fast_Update(PwmIndexPwm3, m_Cycle, m_Duty);
}
