#include "Services_ODO_Internal.h"



/*KL15初始化,每次上电调用*/
void Data_ODO_KL15Init1 ( void )
{
    Input_ODO_Para1.PowerSts1 = DataPowerOn1;
    DataODOCalc1.UpdateDisable1 = 0u;
}
/*放在EEPROM初始化之后,只调用一次*/
void Data_ODO_KL30Init1 ( uint32_t Val_ODO , uint8_t Valid_ODO)
{


    /*总计里程*/
    DataODOValid1 = Valid_ODO;


}



/******************************************************************************
函数名：Data_ODO_Processing
功  能: 总计里程数据处理
参  数: 无
返回值：无
******************************************************************************/
void Data_ODO_Processing1 ( void )
{
    uint16_t RollingCounter = 0u;
    uint16_t Inc = 0u;
    uint16_t m_Diff = 0u;

    if ( EEPROM_St1 == 0xffu )
    {
        DataODOValid1 = 0u;
    }
    else
    {
        RollingCounter = DataMileageRollingCounter1;

        if ( DataODOCalc1.UpdateDisable1 == 1u)
        {
            if ( ( Input_ODO_Para1.E_Speed_Valid1 ) && ( Input_ODO_Para1.Act_E_Speed1 >= 8000u ) && \
                    ( Input_ODO_Para1.V_Speed_Valid1 ) && ( Input_ODO_Para1.Act_V_Speed1 >= 1880u ) )
            {
                DataODOCalc1.RoCBackup1 = RollingCounter;
            }
            else
            {
                DataODOCalc1.UpdateDisable1 = 0u;
            }
        }
        else
        {
            if ( DataODOValid1 == 0u )
            {
                DataODOCalc1.RoCBackup1 = RollingCounter;
                DataODOValid1 = 1u;
            }

            if ( RollingCounter >= DataODOCalc1.RoCBackup1 )
            {
                m_Diff = RollingCounter - DataODOCalc1.RoCBackup1;
            }
            else
            {
                m_Diff = 65535u - DataODOCalc1.RoCBackup1 + RollingCounter + 1u;
            }

            if ( m_Diff >= 100u )
            {
                Inc = m_Diff / 100u;
                DataODOCalc1.RoCBackup1 += Inc * 100u;

                Data_ODO_Val1 += Inc;
                if ( Data_ODO_Val1 > 9999999ul)
                {
                  Data_ODO_Val1 = 9999999ul;
                }
                if (( Data_ODO_Val1 - DataODOCalc1.LastSaved1) >= 1u)
                {
                    Services_ODO_SaveCall1(Data_ODO_Val1);
                    Services_ODO_PulseCbk1(Inc);
                    DataODOCalc1.LastSaved1 = Data_ODO_Val1;
                }
            }
        }
    }
}

/******************************************************************************
函数名：Data_ODO_Update_Disable
功  能: 禁止总计里程数据更新
参  数: 无
返回值：无
******************************************************************************/
void Data_ODO_Update_Disable1 ( void )
{
    DataODOCalc1.UpdateDisable1 = 1u;
}

void Data_ODO_Modify1 ( uint32_t Val_ODO )
{

    Services_ODO_SaveCall1(Val_ODO);
    Data_ODO_Val1 = Val_ODO;
    DataODOCalc1.LastSaved1     = Data_ODO_Val1;
    DataODOValid1 = 1u;
    DataMileageRollingCounter1 = 0u;
    DataODOCalc1.RoCBackup1 = 0u;
    DataODOCalc1.UpdateDisable1 = 0u;
    DataMileage1.mmRollingCounter1 = 0u;
    DataMileage1.mmRoCBackup1 = 0u;
}
/*保证在中断函数上方调用*/
void Data_Mileage_Set_Para1(_DataODOInputStruct1 *m_Para)
{
    Input_ODO_Para1.PowerSts1 = m_Para->PowerSts1;
    Input_ODO_Para1.V_Speed_Valid1 = m_Para->V_Speed_Valid1;
    Input_ODO_Para1.Act_V_Speed1 = m_Para->Act_V_Speed1;
    Input_ODO_Para1.E_Speed_Valid1 = m_Para->E_Speed_Valid1;
    Input_ODO_Para1.Act_E_Speed1 = m_Para->Act_E_Speed1;
    Input_ODO_Para1.TireSize1 = m_Para->TireSize1;
}


/*Core Process*/
/*place 100ms task*/
void Data_Mileage_Rolling_Counter_Update_ISR1 ( void )
{
    uint16_t Mileage;
    uint16_t m_ActSpeed;
    uint16_t m_diff;

    if ( Input_ODO_Para1.PowerSts1 == DataPowerOn1)
    {
        if ( Input_ODO_Para1.V_Speed_Valid1 )
        {
            m_ActSpeed = Input_ODO_Para1.Act_V_Speed1;
            m_ActSpeed = (uint16_t)((((uint32_t)Input_ODO_Para1.TireSize1) * m_ActSpeed) / 10000u);
            if (( m_ActSpeed >= 20u )&&(m_ActSpeed <= 1880u))
            {
                Mileage = ( m_ActSpeed * 25u ) / 9u;
            }
            else
            {
                Mileage = 0u;
            }
            DataMileage1.mmRollingCounter1 += Mileage;
            /*将原始的mm单位的Rolling Counter变换为以m为单位*/
            if ( DataMileage1.mmRollingCounter1 >= DataMileage1.mmRoCBackup1 )
            {
                m_diff = DataMileage1.mmRollingCounter1 - DataMileage1.mmRoCBackup1;

                if ( m_diff  >= 1000u )
                {
                    Mileage = m_diff;
                    Mileage /= 1000u;
                    DataMileage1.mmRoCBackup1 += Mileage * 1000u;
                    DataMileageRollingCounter1 += Mileage;
                }
            }
            else
            {
                m_diff = 65535u - DataMileage1.mmRoCBackup1 + DataMileage1.mmRollingCounter1 + 1u;

                if ( m_diff >= 1000u )
                {
                    Mileage = m_diff ;
                    Mileage /= 1000u;
                    DataMileage1.mmRoCBackup1 += Mileage * 1000u;
                    DataMileageRollingCounter1 += Mileage;
                }
            }
        }
    }
}


uint32_t Data_ODO_Read1(void)
{
    return Data_ODO_Val1;
}
uint16_t Data_MileageRollingCounter_Read1(void)
{
    return DataMileageRollingCounter1;
}
uint8_t Valid_ODO_Read1(void)
{
    return DataODOValid1;
}

/*
增加回调函数接口
*/
uint16_t Services_ODO_Version1(void)
{
    return 0x0002u;
}

uint16_t Services_ODO_mmRollingCounter1(void)
{
    return DataMileage1.mmRollingCounter1;
}