#include "UDS_22Service_Main.h"

/**
  *22服务函数入口
  *@param A_TA_type 收到数据的地址
  *@param A_Length 收到数据的长度
  *@param A_Data 收到数据的数据
  */
void UDS_Service_22_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC11();                                            /*22服务是否支持功能寻址*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC7F();                                            /*22服务会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC33();                                            /*22服务解锁等级验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC13_MinLengthCheck();                             /*22服务最小长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC31();                                            /*22服务超出请求范围验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC13_TotalLengthCheck();                           /*22服务总长度长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC22();                                            /*22服务条件验证*/
    }
    if(NRC == positiveResponse)         
    {
        UDS_22Service_DID();                                                    /*22服务DID判断*/
    }
    clearDiagMSG();                                                             /*清除诊断信息*/
}

extern const uint8_t Ser22_DID_F113[4];           /*诊断协议版本*/
extern const uint8_t Ser22_DID_F182[16];          /*标定版本号*/
extern const uint8_t Ser22_DID_F18A[6];           /*供应商识别号*/
extern const uint8_t Ser22_DID_F18B[4];           /*ECU制造日期*/
extern const uint8_t Ser22_DID_F18C[4];          /*ECU序列号*/
extern const uint8_t Ser22_DID_F195[9];          /*供应商ECU软件版本号*/

/**
  *22服务子功能
  */
void UDS_22Service_DID(void)
{
    //ReadDFlashData(0x03u, (uint32_t *)&BootToDFlashInfo.Flag, sizeof(BootToDFlashInfo) / 4u, BootToDFlashInfoInit);
    //ReadDFlashData(0x04u, (uint32_t *)&Ser2EToDFlashInfo.Flag, sizeof(Ser2EToDFlashInfo) / 4u, Ser2EToDFlashInfoInit);
    switch(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L))/*22服务DID判断*/
    {
    case 0xF199:
        UDS_22Service_DID_F199();                                               /*ECU软件刷新日期*/
        break;
    case 0xF187:
        UDS_22Service_DID_F187();                                               /*零件BOM号*/
        break;
    case 0xF18A:
        UDS_22Service_DID_F18A();                                               /*供应商识别号*/
        break;
    case 0xF190:
        UDS_22Service_DID_F190();                                               /*车辆VIN码*/
        break;
    case 0xF1A2:
        UDS_22Service_DID_F1A2();                                               /*ECU装配日期*/
        break;
    case 0xF191:
        UDS_22Service_DID_F191();                                               /*主机厂定义的硬件版本编号*/
        break;
    case 0xF189:
        UDS_22Service_DID_F189();                                               /*ECU软件版本号*/
        break;
    case 0xF193:
        UDS_22Service_DID_F193();                                               /*供应商ECU硬件版本号*/
        break;
    case 0xF195:
        UDS_22Service_DID_F195();                                               /*供应商ECU软件版本号*/
        break;
    case 0xF180:
        UDS_22Service_DID_F180();                                               /*引导程序软件识别号*/
        break;
    case 0xF112:
        UDS_22Service_DID_F112();                                               /*车辆名称*/
        break;
    case 0xF198:
        UDS_22Service_DID_F198();                                               /*诊断仪序列号*/
        break;
    case 0xF197:
        UDS_22Service_DID_F197();                                               /*ECU控制器名称*/
        break;
    case 0xF113:
        UDS_22Service_DID_F113();                                               /*诊断协议版本*/
        break;
    case 0xF182:
        UDS_22Service_DID_F182();                                               /*标定版本号*/
        break;
    case 0xF186:
        UDS_22Service_DID_F186();                                               /*诊断活动会话*/
        break;
    case 0xF18B:
        UDS_22Service_DID_F18B();                                               /*ECU制造日期*/
        break;
    case 0xF18C:
        UDS_22Service_DID_F18C();                                               /*ECU序列号*/
        break;
    case 0x0200:
        UDS_22Service_DID_0200();                                               /*成功刷写次数*/
        break;
    case 0x0201:
        UDS_22Service_DID_0201();                                               /*刷写尝试次数*/
        break;
    case 0xDFEC:
        UDS_22Service_DID_DFEC();                                               /*功能配置字备份数据4*/
        break;
    case 0xDFED:
        UDS_22Service_DID_DFED();                                               /*功能配置字备份数据3*/
        break;
    case 0xDFEE:
        UDS_22Service_DID_DFEE();                                               /*功能配置字备份数据2*/
        break;
    case 0xDFEF:
        UDS_22Service_DID_DFEF();                                               /*功能配置字备份数据*/
        break;
    case 0xF101:
        UDS_22Service_DID_F101();                                               /*功能配置字数据*/
        break;
    case 0xF110:
        UDS_22Service_DID_F110();                                               /*网络拓扑配置*/
        break;
    case 0xF102:
        UDS_22Service_DID_F102();                                               /*网络拓扑配置*/
        break;
    case 0x7101:
        UDS_22Service_DID_7101();                                               /*读取首保里程*/
        break;
    case 0x7102:
        UDS_22Service_DID_7102();                                               /*读取非首保里程*/
        break;
    case 0x7103:
        UDS_22Service_DID_7103();                                               /*读取保养重置标志*/
        break;
    default:
        break;
    }
}

/**
  *22服务DID0200
  *成功刷写次数
  */
void UDS_22Service_DID_0200(void)
{
    DiagMSG.msgData.DidDetail.Data[0] = BootToDFlashInfo.DID_0200;
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DID0201
  *刷写尝试次数
  */
void UDS_22Service_DID_0201(void)
{
    DiagMSG.msgData.DidDetail.Data[0] = BootToDFlashInfo.DID_0201;
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDDFEC
  *功能配置字备份数据4
  */
void UDS_22Service_DID_DFEC(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_DFEC, sizeof(Ser2EToDFlashInfo.DID_DFEC));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 64u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDDFED
  *功能配置字备份数据3
  */
void UDS_22Service_DID_DFED(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_DFED, sizeof(Ser2EToDFlashInfo.DID_DFED));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 64u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDDFEE
  *功能配置字备份数据2
  */
void UDS_22Service_DID_DFEE(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_DFEE, sizeof(Ser2EToDFlashInfo.DID_DFEE));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 64u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDDFEF
  *功能配置字备份数据
  */
void UDS_22Service_DID_DFEF(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_DFEF, sizeof(Ser2EToDFlashInfo.DID_DFEF));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 64u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF112
  *车辆名称
  */
void UDS_22Service_DID_F112(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F112, sizeof(Ser2EToDFlashInfo.DID_F112));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 8u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF113
  *诊断协议版本
  */
void UDS_22Service_DID_F113(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser22_DID_F113, sizeof(Ser22_DID_F113));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 4u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF180
  *引导程序软件识别号
  */
void UDS_22Service_DID_F180(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, BootToDFlashInfo.DID_F180, sizeof(BootToDFlashInfo.DID_F180));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 16u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF182
  *标定版本号
  */
void UDS_22Service_DID_F182(void)
{
    memset(DiagMSG.msgData.DidDetail.Data, 0x20, 16u);
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser22_DID_F182, sizeof(Ser22_DID_F182) - 1u);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 16u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF186
  *诊断活动会话
  */
void UDS_22Service_DID_F186(void)
{
    DiagMSG.msgData.DidDetail.Data[0] = getSessionType();
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF187
  *零件BOM号
  */
void UDS_22Service_DID_F187(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, BootToDFlashInfo.DID_F187, sizeof(BootToDFlashInfo.DID_F187));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 21u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF189
  *零件BOM号
  */
void UDS_22Service_DID_F189(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, BootToDFlashInfo.DID_F189, sizeof(BootToDFlashInfo.DID_F189));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 10u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF18A
  *供应商识别号
  */
void UDS_22Service_DID_F18A(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser22_DID_F18A, sizeof(Ser22_DID_F18A));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 6u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF18B
  *ECU制造日期
  */
void UDS_22Service_DID_F18B(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser22_DID_F18B, sizeof(Ser22_DID_F18B));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 4u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF18C
  *ECU序列号
  */
void UDS_22Service_DID_F18C(void)
{
    memset(DiagMSG.msgData.DidDetail.Data, 0x20, 24u);
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser22_DID_F18C, sizeof(Ser22_DID_F18C));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 24u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF190
  *车辆VIN码
  */
void UDS_22Service_DID_F190(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F190, sizeof(Ser2EToDFlashInfo.DID_F190));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 17u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF191
  *主机厂定义的硬件版本编号
  */
extern const uint8_t DID_F191[16];
void UDS_22Service_DID_F191(void)
{
    //memcpy(DiagMSG.msgData.DidDetail.Data, BootToDFlashInfo.DID_F191, sizeof(BootToDFlashInfo.DID_F191));
    memcpy(DiagMSG.msgData.DidDetail.Data, DID_F191, sizeof(DID_F191)); 
  	UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 10u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF193
  *供应商ECU硬件版本号
  */
void UDS_22Service_DID_F193(void)
{
    memset(DiagMSG.msgData.DidDetail.Data, ' ', 16u);
    memcpy(DiagMSG.msgData.DidDetail.Data, BootToDFlashInfo.DID_F193, sizeof(BootToDFlashInfo.DID_F193));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 16u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF195
  *供应商ECU软件版本号
  */
void UDS_22Service_DID_F195(void)
{
    memset(DiagMSG.msgData.DidDetail.Data, ' ', 16u);
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser22_DID_F195, sizeof(Ser22_DID_F195));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 16u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF197
  *ECU控制器名称
  */
void UDS_22Service_DID_F197(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F197, sizeof(Ser2EToDFlashInfo.DID_F197));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 8u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF198
  *诊断仪序列号
  */
void UDS_22Service_DID_F198(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, BootToDFlashInfo.DID_F198, sizeof(BootToDFlashInfo.DID_F198));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 16u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF199
  *ECU软件刷新日期
  */
void UDS_22Service_DID_F199(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, BootToDFlashInfo.DID_F199, sizeof(BootToDFlashInfo.DID_F199));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 4u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF1A2
  *ECU装配日期
  */
void UDS_22Service_DID_F1A2(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F1A2, sizeof(Ser2EToDFlashInfo.DID_F1A2));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 4u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF100
  *网络拓扑配置
  */
void UDS_22Service_DID_F102(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F102, sizeof(Ser2EToDFlashInfo.DID_F102));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 24u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF110
  *网络拓扑配置
  */
void UDS_22Service_DID_F110(void)
{
    _EOL_F110 EOL_F110 = EOL_GetF110();
    memcpy(DiagMSG.msgData.DidDetail.Data, EOL_F110.F110_Byte, sizeof(EOL_F110.F110_Byte));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 8u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF101
  *功能配置字数据
  */
void UDS_22Service_DID_F101(void)
{
    _EOL_F101 EOL_F101 = EOL_GetF101();
    memcpy(DiagMSG.msgData.DidDetail.Data, EOL_F101.F101_Byte, sizeof(EOL_F101.F101_Byte));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 8u, DiagMSG.msgData.Data);
}
/**
  *22服务DIDF701
  *首保里程
 */
 void UDS_22Service_DID_7101(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_7101, sizeof(Ser2EToDFlashInfo.DID_7101));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 3u, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF702
  *非首保里程
 */
 void UDS_22Service_DID_7102(void)
{
    
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_7102, sizeof(Ser2EToDFlashInfo.DID_7102));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 3u, DiagMSG.msgData.Data);
}

 void UDS_22Service_DID_7103(void)
{
    
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_7103, 1);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}
/**
  *22服务DIDF1AA
  *ECU核心总成零部件号

void UDS_22Service_DID_F1AA(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser22_DID_F1AA, sizeof(Ser22_DID_F1AA));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 8u, DiagMSG.msgData.Data);
}
  */
/**
  *22服务DIDF306
  *读取燃油数据
  */
void UDS_22Service_DID_F306(void)
{
//    memcpy(DiagMSG.msgData.DidDetail.Data, Get_RecoderAddr(), Get_RecoderLength());
//    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + (uint16_t)Get_RecoderLength(), DiagMSG.msgData.Data);
}

void UDS_22Service_DID_F307(void)
{
    uint32_t m32;
    
    m32=Read_LED_Flag();
    DiagMSG.msgData.DidDetail.Data[0] =(uint8_t)(m32 >> 24u);
    DiagMSG.msgData.DidDetail.Data[1] =(uint8_t)(m32 >> 16u);
    DiagMSG.msgData.DidDetail.Data[2] =(uint8_t)(m32 >> 8u);
    DiagMSG.msgData.DidDetail.Data[3] =(uint8_t)(m32);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 4u, DiagMSG.msgData.Data);
}
