#include "UDS_2FService_Main.h"

/**
  *2F服务函数入口
  *@param A_TA_type 收到数据的地址
  *@param A_Length 收到数据的长度
  *@param A_Data 收到数据的数据
  */
void UDS_Service_2F_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC11();                                            /*2F服务是否支持功能寻址*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC7F();                                            /*2F服务会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC33();                                            /*2F服务解锁等级验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC13_MinLengthCheck();                             /*2F服务最小长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC31();                                            /*2F服务超出请求范围验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC13_TotalLengthCheck();                           /*2F服务总长度长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC22();                                            /*2F服务条件验证*/
    }
    if(NRC == positiveResponse)
    {
        UDS_2FService_DID();                                                    /*2F服务DID判断*/
    }
    clearDiagMSG();                                                             /*清除诊断信息*/
}

/**
  *2F服务子功能
  */
void UDS_2FService_DID(void)
{
    switch(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L))/*2F服务DID判断*/
    {
    case 0x62E1:
        UDS_2FService_DID_62E1();                                               /*蜂鸣器测试*/
        break;
    case 0x62E2:
        UDS_2FService_DID_62E2();                                               /*指针测试*/
        break;
    case 0x62E4:
        UDS_2FService_DID_62E4();                                               /*报警灯测试*/
        break;
    default:
        break;
    }
}

/**
  *2F服务DID62E1
  *蜂鸣器测试
  */
void UDS_2FService_DID_62E1(void)
{
    BuzzerTest(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);

    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 3u, DiagMSG.msgData.Data); 

    
}

/**
  *2F服务DID62E2
  *指针测试
  */
void UDS_2FService_DID_62E2(void)
{
    GaugeTest(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1], DiagMSG.msgData.DidDetail.Data[2]);
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 5u, DiagMSG.msgData.Data);
}

/**
  *2F服务DID62E4
  *报警灯测试
  */
void UDS_2FService_DID_62E4(void)
{
    LampWarningTest(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);

    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, 3u, DiagMSG.msgData.Data); 

}
