
#ifndef _WORK_FLASH_H_
#define _WORK_FLASH_H_

#include "s6j3360drv.h"

#define   WFLASH_BLOCK_00_SIZE              (16U)
#define   WFLASH_BLOCK_01_SIZE              (24U)
#define   WFLASH_BLOCK_02_SIZE              (20U)
#define   WFLASH_BLOCK_03_SIZE              (116u)
#define   WFLASH_BLOCK_04_SIZE              (400U)
#define   WFLASH_BLOCK_05_SIZE              (400+4)

#define   WFLASH_BLOCK_06_SIZE              (20U)
#define   WFLASH_BLOCK_07_SIZE              (40U)
#define   WFLASH_BLOCK_08_SIZE              (24U)
#define   WFLASH_BLOCK_09_SIZE              (440U)
#define   WFLASH_BLOCK_10_SIZE              (0U)
#define   WFLASH_BLOCK_11_SIZE              (0U)
#define   WFLASH_BLOCK_12_SIZE              (0U)
#define   WFLASH_BLOCK_13_SIZE              (0U)

#define   WFLASH_BLOCK_NUMBER               (14U)
#define   WFLASH_BLOCK_CTRL_BYTE_SIZE       (8U)

/*====================================================================
                              Block Format
                              
  +-----+-----+-----+-----+-----+---//---+-----+-----+-----+-----+
  |  u16Index | ~u16Index |   User Data  |  Reserved |   CRC16   |
  +-----+-----+-----+-----+-----+---//---+-----+-----+-----+-----+
  
  - Block control segment costs 8 bytes In each block.
  - The number of bytes available to user is (block size - 8) bytes.
====================================================================*/

typedef enum
{
  WFLASH_STAT_DISABLE = 0,
  WFLASH_STAT_BLANK,
  WFLASH_STAT_ACTIVE,
  WFLASH_STAT_ERROR,
}WFlash_Block_Status_en_t;

typedef enum
{
  WFLASH_RW_PASS = 0,
  WFLASH_RW_FAIL,
}WFlash_RW_Result_en_t;

typedef enum
{
  WFLASH_STAT_IDLE = 0,
  WFLASH_STAT_BUSY,
}WFlash_Status_en_t;


extern void WFlash_Controller_Init(void);
extern WFlash_Status_en_t WFlash_Get_Controller_Status(void);

extern void WFlash_Block_Init(void);

extern WFlash_Block_Status_en_t WFlash_Get_Block_Status(uint8_t u8BlockNum);
extern WFlash_RW_Result_en_t    WFlash_Read_Block_Data(uint8_t u8BlockNum, uint32_t u32Data[], uint16_t u16Len);
extern WFlash_RW_Result_en_t    WFlash_Write_Block_Data(uint8_t u8BlockNum, uint32_t u32Data[], uint16_t u16Len);

#endif