/******************************************************************************
 * $Revision: 425 $
 * $Date:: 2017-05-19 10:28:09 +0900#$
 *****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/*****************************************************************************/
/** \file interrupts.h
 **
 ** Declaration of IRQ and NMI entry/exit macros, Interrupt Controller
 ** initialization and service functions as well as assignment of interrupt
 ** vectors and levels for IRQs and NMIs.
 **
 ** Please edit the following sections in this file:
 **     1   IRQ
 **     1.1 IRQ Nesting
 **     1.2 IRQ Vectors
 **     1.3 IRQ Priority Levels
 **     1.4 IRQ Numbers
 **     2   NMI
 **     2.1 NMI Vectors
 **     2.2 NMI Numbers
 **     2.3 NMI Priority Levels
 **
 ** The assignment of interrupt (IRQ) and non-maskable interrupt (NMI)
 ** vectors and priority levels can be done here by changing the appropriate
 ** pre-processor symbols:
 **
 ** For IRQ:
 **     - assign the ISR function to INTERRUPTS_IRQ_ISR_???
 **     - set the IRQ level to INTERRUPTS_IRQ_LEVEL_???
 **
 ** For NMI:
 **     - assign the ISR function to INTERRUPTS_NMI_ISR_???
 **     - set the NMI level to INTERRUPTS_NMI_LEVEL_???
 **
 **
 ** It is recommended to follow the guideline below to implement an interrupt
 ** service routine (ISR). Use the macros available for IRQ and NMI function
 ** definition.
 **
 ** For IRQ ISR:
 **     An interrupt service routine (ISR) for IRQs should be implemented according
 **     to the following function skeleton:
 **
 **     When enable interrupt nesting and use GHS compiler:
 **         Currently, GHS compiler does not support interrupt nesting.
 **         Please use nested_interrupt.asm
 **
 **     When enable interrupt nesting and use IAR compiler:
 **
 **         FN_NESTED_IRQ_DEFINE_BEGIN(IrqIsrName, IrqNum)
 **         {
 **             // code to handle the IRQ
 **             // clear IRQ flag at source (peripheral or software interrupt)
 **
 **             // Current mode: System mode using system/user stack
 **             // (in case of default setting with interrupt nesting)
 **         }
 **         FN_NESTED_IRQ_DEFINE_END()
 **
 **     When disable interrupt nesting:
 **         FN_IRQ_DEFINE_BEGIN(IrqIsrName, IrqNum)
 **         {
 **             // code to handle the IRQ
 **             // clear IRQ flag at source (peripheral or software interrupt)
 **
 **             // Current mode: IRQ using IRQ stack
 **         }
 **         FN_IRQ_DEFINE_END()
 **
 **
 ** For NMI ISR:
 **     An interrupt service routine (ISR) for NMIs should be implemented according
 **     to the following function skeleton:
 **
 **     FN_NMI_DEFINE_BEGIN(NmiIsrName, NmiNum)
 **     {
 **         // code to handle the NMI
 **         // clear NMI flag at source (peripheral or software interrupt)
 **
 **         // Current mode: FIQ mode using FIQ stack
 **     }
 **     FN_NMI_DEFINE_END()
 **
 **
 ** History:
 **   - 2015-09-01  0.01  HS  Initial version for Traveo
 *****************************************************************************/

#ifndef __INTERRUPTS_H__
#define __INTERRUPTS_H__

/* File version 0xYYXX = vYY.XX */
#define INTERRUPTS_H_VERSION          0x0001U

#ifndef __FILE_VERSION_CHECK__

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include "s6j3360drv.h"

/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define')                           */
/*****************************************************************************/

/* --------------------------------------------------------------------
   1    I R Q
   --------------------------------------------------------------------
        I R Q   N U M B E R S                
   --------------------------------------------------------------------
   Definition of IRQ numbers. These macros should
   be used as parameter for ISR function definition macros
   FN_[NESTED_]IRQ_DEFINE_BEGIN( ..., IrqNum) to set the IRQ
   number which must be cleared in the Interrupt Controller
   after an IRQ is handled.
   -------------------------------------------------------------------- */

#define INTERRUPTS_IRQ_NUMBER_0             0U          /* < IRQ#0   */
#define INTERRUPTS_IRQ_NUMBER_1             1U          /* < IRQ#1   */
#define INTERRUPTS_IRQ_NUMBER_2             2U          /* < IRQ#2   */
#define INTERRUPTS_IRQ_NUMBER_3             3U          /* < IRQ#3   */
#define INTERRUPTS_IRQ_NUMBER_4             4U          /* < IRQ#4   */
#define INTERRUPTS_IRQ_NUMBER_5             5U          /* < IRQ#5   */
#define INTERRUPTS_IRQ_NUMBER_6             6U          /* < IRQ#6   */
#define INTERRUPTS_IRQ_NUMBER_7             7U          /* < IRQ#7   */
#define INTERRUPTS_IRQ_NUMBER_8             8U          /* < IRQ#8   */
#define INTERRUPTS_IRQ_NUMBER_9             9U          /* < IRQ#9   */
#define INTERRUPTS_IRQ_NUMBER_10            10U         /* < IRQ#10  */
#define INTERRUPTS_IRQ_NUMBER_11            11U         /* < IRQ#11  */
#define INTERRUPTS_IRQ_NUMBER_12            12U         /* < IRQ#12  */
#define INTERRUPTS_IRQ_NUMBER_13            13U         /* < IRQ#13  */
#define INTERRUPTS_IRQ_NUMBER_14            14U         /* < IRQ#14  */
#define INTERRUPTS_IRQ_NUMBER_15            15U         /* < IRQ#15  */
#define INTERRUPTS_IRQ_NUMBER_16            16U         /* < IRQ#16  */
#define INTERRUPTS_IRQ_NUMBER_17            17U         /* < IRQ#17  */
#define INTERRUPTS_IRQ_NUMBER_18            18U         /* < IRQ#18  */
#define INTERRUPTS_IRQ_NUMBER_19            19U         /* < IRQ#19  */
#define INTERRUPTS_IRQ_NUMBER_20            20U         /* < IRQ#20  */
#define INTERRUPTS_IRQ_NUMBER_21            21U         /* < IRQ#21  */
#define INTERRUPTS_IRQ_NUMBER_22            22U         /* < IRQ#22  */
#define INTERRUPTS_IRQ_NUMBER_23            23U         /* < IRQ#23  */
#define INTERRUPTS_IRQ_NUMBER_24            24U         /* < IRQ#24  */
#define INTERRUPTS_IRQ_NUMBER_25            25U         /* < IRQ#25  */
#define INTERRUPTS_IRQ_NUMBER_26            26U         /* < IRQ#26  */
#define INTERRUPTS_IRQ_NUMBER_27            27U         /* < IRQ#27  */
#define INTERRUPTS_IRQ_NUMBER_28            28U         /* < IRQ#28  */
#define INTERRUPTS_IRQ_NUMBER_29            29U         /* < IRQ#29  */
#define INTERRUPTS_IRQ_NUMBER_30            30U         /* < IRQ#30  */
#define INTERRUPTS_IRQ_NUMBER_31            31U         /* < IRQ#31  */
#define INTERRUPTS_IRQ_NUMBER_32            32U         /* < IRQ#32  */
#define INTERRUPTS_IRQ_NUMBER_33            33U         /* < IRQ#33  */
#define INTERRUPTS_IRQ_NUMBER_34            34U         /* < IRQ#34  */
#define INTERRUPTS_IRQ_NUMBER_35            35U         /* < IRQ#35  */
#define INTERRUPTS_IRQ_NUMBER_36            36U         /* < IRQ#36  */
#define INTERRUPTS_IRQ_NUMBER_37            37U         /* < IRQ#37  */
#define INTERRUPTS_IRQ_NUMBER_38            38U         /* < IRQ#38  */
#define INTERRUPTS_IRQ_NUMBER_39            39U         /* < IRQ#39  */
#define INTERRUPTS_IRQ_NUMBER_40            40U         /* < IRQ#40  */
#define INTERRUPTS_IRQ_NUMBER_41            41U         /* < IRQ#41  */
#define INTERRUPTS_IRQ_NUMBER_42            42U         /* < IRQ#42  */
#define INTERRUPTS_IRQ_NUMBER_43            43U         /* < IRQ#43  */
#define INTERRUPTS_IRQ_NUMBER_44            44U         /* < IRQ#44  */
#define INTERRUPTS_IRQ_NUMBER_45            45U         /* < IRQ#45  */
#define INTERRUPTS_IRQ_NUMBER_46            46U         /* < IRQ#46  */
#define INTERRUPTS_IRQ_NUMBER_47            47U         /* < IRQ#47  */
#define INTERRUPTS_IRQ_NUMBER_48            48U         /* < IRQ#48  */
#define INTERRUPTS_IRQ_NUMBER_49            49U         /* < IRQ#49  */
#define INTERRUPTS_IRQ_NUMBER_50            50U         /* < IRQ#50  */
#define INTERRUPTS_IRQ_NUMBER_51            51U         /* < IRQ#51  */
#define INTERRUPTS_IRQ_NUMBER_52            52U         /* < IRQ#52  */
#define INTERRUPTS_IRQ_NUMBER_53            53U         /* < IRQ#53  */
#define INTERRUPTS_IRQ_NUMBER_54            54U         /* < IRQ#54  */
#define INTERRUPTS_IRQ_NUMBER_55            55U         /* < IRQ#55  */
#define INTERRUPTS_IRQ_NUMBER_56            56U         /* < IRQ#56  */
#define INTERRUPTS_IRQ_NUMBER_57            57U         /* < IRQ#57  */
#define INTERRUPTS_IRQ_NUMBER_58            58U         /* < IRQ#58  */
#define INTERRUPTS_IRQ_NUMBER_59            59U         /* < IRQ#59  */
#define INTERRUPTS_IRQ_NUMBER_60            60U         /* < IRQ#60  */
#define INTERRUPTS_IRQ_NUMBER_61            61U         /* < IRQ#61  */
#define INTERRUPTS_IRQ_NUMBER_62            62U         /* < IRQ#62  */
#define INTERRUPTS_IRQ_NUMBER_63            63U         /* < IRQ#63  */
#define INTERRUPTS_IRQ_NUMBER_64            64U         /* < IRQ#64  */
#define INTERRUPTS_IRQ_NUMBER_65            65U         /* < IRQ#65  */
#define INTERRUPTS_IRQ_NUMBER_66            66U         /* < IRQ#66  */
#define INTERRUPTS_IRQ_NUMBER_67            67U         /* < IRQ#67  */
#define INTERRUPTS_IRQ_NUMBER_68            68U         /* < IRQ#68  */
#define INTERRUPTS_IRQ_NUMBER_69            69U         /* < IRQ#69  */
#define INTERRUPTS_IRQ_NUMBER_70            70U         /* < IRQ#70  */
#define INTERRUPTS_IRQ_NUMBER_71            71U         /* < IRQ#71  */
#define INTERRUPTS_IRQ_NUMBER_72            72U         /* < IRQ#72  */
#define INTERRUPTS_IRQ_NUMBER_73            73U         /* < IRQ#73  */
#define INTERRUPTS_IRQ_NUMBER_74            74U         /* < IRQ#74  */
#define INTERRUPTS_IRQ_NUMBER_75            75U         /* < IRQ#75  */
#define INTERRUPTS_IRQ_NUMBER_76            76U         /* < IRQ#76  */
#define INTERRUPTS_IRQ_NUMBER_77            77U         /* < IRQ#77  */
#define INTERRUPTS_IRQ_NUMBER_78            78U         /* < IRQ#78  */
#define INTERRUPTS_IRQ_NUMBER_79            79U         /* < IRQ#79  */
#define INTERRUPTS_IRQ_NUMBER_80            80U         /* < IRQ#80  */
#define INTERRUPTS_IRQ_NUMBER_81            81U         /* < IRQ#81  */
#define INTERRUPTS_IRQ_NUMBER_82            82U         /* < IRQ#82  */
#define INTERRUPTS_IRQ_NUMBER_83            83U         /* < IRQ#83  */
#define INTERRUPTS_IRQ_NUMBER_84            84U         /* < IRQ#84  */
#define INTERRUPTS_IRQ_NUMBER_85            85U         /* < IRQ#85  */
#define INTERRUPTS_IRQ_NUMBER_86            86U         /* < IRQ#86  */
#define INTERRUPTS_IRQ_NUMBER_87            87U         /* < IRQ#87  */
#define INTERRUPTS_IRQ_NUMBER_88            88U         /* < IRQ#88  */
#define INTERRUPTS_IRQ_NUMBER_89            89U         /* < IRQ#89  */
#define INTERRUPTS_IRQ_NUMBER_90            90U         /* < IRQ#90  */
#define INTERRUPTS_IRQ_NUMBER_91            91U         /* < IRQ#91  */
#define INTERRUPTS_IRQ_NUMBER_92            92U         /* < IRQ#92  */
#define INTERRUPTS_IRQ_NUMBER_93            93U         /* < IRQ#93  */
#define INTERRUPTS_IRQ_NUMBER_94            94U         /* < IRQ#94  */
#define INTERRUPTS_IRQ_NUMBER_95            95U         /* < IRQ#95  */
#define INTERRUPTS_IRQ_NUMBER_96            96U         /* < IRQ#96  */
#define INTERRUPTS_IRQ_NUMBER_97            97U         /* < IRQ#97  */
#define INTERRUPTS_IRQ_NUMBER_98            98U         /* < IRQ#98  */
#define INTERRUPTS_IRQ_NUMBER_99            99U         /* < IRQ#99  */
#define INTERRUPTS_IRQ_NUMBER_100           100U        /* < IRQ#100 */
#define INTERRUPTS_IRQ_NUMBER_101           101U        /* < IRQ#101 */
#define INTERRUPTS_IRQ_NUMBER_102           102U        /* < IRQ#102 */
#define INTERRUPTS_IRQ_NUMBER_103           103U        /* < IRQ#103 */
#define INTERRUPTS_IRQ_NUMBER_104           104U        /* < IRQ#104 */
#define INTERRUPTS_IRQ_NUMBER_105           105U        /* < IRQ#105 */
#define INTERRUPTS_IRQ_NUMBER_106           106U        /* < IRQ#106 */
#define INTERRUPTS_IRQ_NUMBER_107           107U        /* < IRQ#107 */
#define INTERRUPTS_IRQ_NUMBER_108           108U        /* < IRQ#108 */
#define INTERRUPTS_IRQ_NUMBER_109           109U        /* < IRQ#109 */
#define INTERRUPTS_IRQ_NUMBER_110           110U        /* < IRQ#110 */
#define INTERRUPTS_IRQ_NUMBER_111           111U        /* < IRQ#111 */
#define INTERRUPTS_IRQ_NUMBER_112           112U        /* < IRQ#112 */
#define INTERRUPTS_IRQ_NUMBER_113           113U        /* < IRQ#113 */
#define INTERRUPTS_IRQ_NUMBER_114           114U        /* < IRQ#114 */
#define INTERRUPTS_IRQ_NUMBER_115           115U        /* < IRQ#115 */
#define INTERRUPTS_IRQ_NUMBER_116           116U        /* < IRQ#116 */
#define INTERRUPTS_IRQ_NUMBER_117           117U        /* < IRQ#117 */
#define INTERRUPTS_IRQ_NUMBER_118           118U        /* < IRQ#118 */
#define INTERRUPTS_IRQ_NUMBER_119           119U        /* < IRQ#119 */
#define INTERRUPTS_IRQ_NUMBER_120           120U        /* < IRQ#120 */
#define INTERRUPTS_IRQ_NUMBER_121           121U        /* < IRQ#121 */
#define INTERRUPTS_IRQ_NUMBER_122           122U        /* < IRQ#122 */
#define INTERRUPTS_IRQ_NUMBER_123           123U        /* < IRQ#123 */
#define INTERRUPTS_IRQ_NUMBER_124           124U        /* < IRQ#124 */
#define INTERRUPTS_IRQ_NUMBER_125           125U        /* < IRQ#125 */
#define INTERRUPTS_IRQ_NUMBER_126           126U        /* < IRQ#126 */
#define INTERRUPTS_IRQ_NUMBER_127           127U        /* < IRQ#127 */
#define INTERRUPTS_IRQ_NUMBER_128           128U        /* < IRQ#128 */
#define INTERRUPTS_IRQ_NUMBER_129           129U        /* < IRQ#129 */
#define INTERRUPTS_IRQ_NUMBER_130           130U        /* < IRQ#130 */
#define INTERRUPTS_IRQ_NUMBER_131           131U        /* < IRQ#131 */
#define INTERRUPTS_IRQ_NUMBER_132           132U        /* < IRQ#132 */
#define INTERRUPTS_IRQ_NUMBER_133           133U        /* < IRQ#133 */
#define INTERRUPTS_IRQ_NUMBER_134           134U        /* < IRQ#134 */
#define INTERRUPTS_IRQ_NUMBER_135           135U        /* < IRQ#135 */
#define INTERRUPTS_IRQ_NUMBER_136           136U        /* < IRQ#136 */
#define INTERRUPTS_IRQ_NUMBER_137           137U        /* < IRQ#137 */
#define INTERRUPTS_IRQ_NUMBER_138           138U        /* < IRQ#138 */
#define INTERRUPTS_IRQ_NUMBER_139           139U        /* < IRQ#139 */
#define INTERRUPTS_IRQ_NUMBER_140           140U        /* < IRQ#140 */
#define INTERRUPTS_IRQ_NUMBER_141           141U        /* < IRQ#141 */
#define INTERRUPTS_IRQ_NUMBER_142           142U        /* < IRQ#142 */
#define INTERRUPTS_IRQ_NUMBER_143           143U        /* < IRQ#143 */
#define INTERRUPTS_IRQ_NUMBER_144           144U        /* < IRQ#144 */
#define INTERRUPTS_IRQ_NUMBER_145           145U        /* < IRQ#145 */
#define INTERRUPTS_IRQ_NUMBER_146           146U        /* < IRQ#146 */
#define INTERRUPTS_IRQ_NUMBER_147           147U        /* < IRQ#147 */
#define INTERRUPTS_IRQ_NUMBER_148           148U        /* < IRQ#148 */
#define INTERRUPTS_IRQ_NUMBER_149           149U        /* < IRQ#149 */
#define INTERRUPTS_IRQ_NUMBER_150           150U        /* < IRQ#150 */
#define INTERRUPTS_IRQ_NUMBER_151           151U        /* < IRQ#151 */
#define INTERRUPTS_IRQ_NUMBER_152           152U        /* < IRQ#152 */
#define INTERRUPTS_IRQ_NUMBER_153           153U        /* < IRQ#153 */
#define INTERRUPTS_IRQ_NUMBER_154           154U        /* < IRQ#154 */
#define INTERRUPTS_IRQ_NUMBER_155           155U        /* < IRQ#155 */
#define INTERRUPTS_IRQ_NUMBER_156           156U        /* < IRQ#156 */
#define INTERRUPTS_IRQ_NUMBER_157           157U        /* < IRQ#157 */
#define INTERRUPTS_IRQ_NUMBER_158           158U        /* < IRQ#158 */
#define INTERRUPTS_IRQ_NUMBER_159           159U        /* < IRQ#159 */
#define INTERRUPTS_IRQ_NUMBER_160           160U        /* < IRQ#160 */
#define INTERRUPTS_IRQ_NUMBER_161           161U        /* < IRQ#161 */
#define INTERRUPTS_IRQ_NUMBER_162           162U        /* < IRQ#162 */
#define INTERRUPTS_IRQ_NUMBER_163           163U        /* < IRQ#163 */
#define INTERRUPTS_IRQ_NUMBER_164           164U        /* < IRQ#164 */
#define INTERRUPTS_IRQ_NUMBER_165           165U        /* < IRQ#165 */
#define INTERRUPTS_IRQ_NUMBER_166           166U        /* < IRQ#166 */
#define INTERRUPTS_IRQ_NUMBER_167           167U        /* < IRQ#167 */
#define INTERRUPTS_IRQ_NUMBER_168           168U        /* < IRQ#168 */
#define INTERRUPTS_IRQ_NUMBER_169           169U        /* < IRQ#169 */
#define INTERRUPTS_IRQ_NUMBER_170           170U        /* < IRQ#170 */
#define INTERRUPTS_IRQ_NUMBER_171           171U        /* < IRQ#171 */
#define INTERRUPTS_IRQ_NUMBER_172           172U        /* < IRQ#172 */
#define INTERRUPTS_IRQ_NUMBER_173           173U        /* < IRQ#173 */
#define INTERRUPTS_IRQ_NUMBER_174           174U        /* < IRQ#174 */
#define INTERRUPTS_IRQ_NUMBER_175           175U        /* < IRQ#175 */
#define INTERRUPTS_IRQ_NUMBER_176           176U        /* < IRQ#176 */
#define INTERRUPTS_IRQ_NUMBER_177           177U        /* < IRQ#177 */
#define INTERRUPTS_IRQ_NUMBER_178           178U        /* < IRQ#178 */
#define INTERRUPTS_IRQ_NUMBER_179           179U        /* < IRQ#179 */
#define INTERRUPTS_IRQ_NUMBER_180           180U        /* < IRQ#180 */
#define INTERRUPTS_IRQ_NUMBER_181           181U        /* < IRQ#181 */
#define INTERRUPTS_IRQ_NUMBER_182           182U        /* < IRQ#182 */
#define INTERRUPTS_IRQ_NUMBER_183           183U        /* < IRQ#183 */
#define INTERRUPTS_IRQ_NUMBER_184           184U        /* < IRQ#184 */
#define INTERRUPTS_IRQ_NUMBER_185           185U        /* < IRQ#185 */
#define INTERRUPTS_IRQ_NUMBER_186           186U        /* < IRQ#186 */
#define INTERRUPTS_IRQ_NUMBER_187           187U        /* < IRQ#187 */
#define INTERRUPTS_IRQ_NUMBER_188           188U        /* < IRQ#188 */
#define INTERRUPTS_IRQ_NUMBER_189           189U        /* < IRQ#189 */
#define INTERRUPTS_IRQ_NUMBER_190           190U        /* < IRQ#190 */
#define INTERRUPTS_IRQ_NUMBER_191           191U        /* < IRQ#191 */
#define INTERRUPTS_IRQ_NUMBER_192           192U        /* < IRQ#192 */
#define INTERRUPTS_IRQ_NUMBER_193           193U        /* < IRQ#193 */
#define INTERRUPTS_IRQ_NUMBER_194           194U        /* < IRQ#194 */
#define INTERRUPTS_IRQ_NUMBER_195           195U        /* < IRQ#195 */
#define INTERRUPTS_IRQ_NUMBER_196           196U        /* < IRQ#196 */
#define INTERRUPTS_IRQ_NUMBER_197           197U        /* < IRQ#197 */
#define INTERRUPTS_IRQ_NUMBER_198           198U        /* < IRQ#198 */
#define INTERRUPTS_IRQ_NUMBER_199           199U        /* < IRQ#199 */
#define INTERRUPTS_IRQ_NUMBER_200           200U        /* < IRQ#200 */
#define INTERRUPTS_IRQ_NUMBER_201           201U        /* < IRQ#201 */
#define INTERRUPTS_IRQ_NUMBER_202           202U        /* < IRQ#202 */
#define INTERRUPTS_IRQ_NUMBER_203           203U        /* < IRQ#203 */
#define INTERRUPTS_IRQ_NUMBER_204           204U        /* < IRQ#204 */
#define INTERRUPTS_IRQ_NUMBER_205           205U        /* < IRQ#205 */
#define INTERRUPTS_IRQ_NUMBER_206           206U        /* < IRQ#206 */
#define INTERRUPTS_IRQ_NUMBER_207           207U        /* < IRQ#207 */
#define INTERRUPTS_IRQ_NUMBER_208           208U        /* < IRQ#208 */
#define INTERRUPTS_IRQ_NUMBER_209           209U        /* < IRQ#209 */
#define INTERRUPTS_IRQ_NUMBER_210           210U        /* < IRQ#210 */
#define INTERRUPTS_IRQ_NUMBER_211           211U        /* < IRQ#211 */
#define INTERRUPTS_IRQ_NUMBER_212           212U        /* < IRQ#212 */
#define INTERRUPTS_IRQ_NUMBER_213           213U        /* < IRQ#213 */
#define INTERRUPTS_IRQ_NUMBER_214           214U        /* < IRQ#214 */
#define INTERRUPTS_IRQ_NUMBER_215           215U        /* < IRQ#215 */
#define INTERRUPTS_IRQ_NUMBER_216           216U        /* < IRQ#216 */
#define INTERRUPTS_IRQ_NUMBER_217           217U        /* < IRQ#217 */
#define INTERRUPTS_IRQ_NUMBER_218           218U        /* < IRQ#218 */
#define INTERRUPTS_IRQ_NUMBER_219           219U        /* < IRQ#219 */
#define INTERRUPTS_IRQ_NUMBER_220           220U        /* < IRQ#220 */
#define INTERRUPTS_IRQ_NUMBER_221           221U        /* < IRQ#221 */
#define INTERRUPTS_IRQ_NUMBER_222           222U        /* < IRQ#222 */
#define INTERRUPTS_IRQ_NUMBER_223           223U        /* < IRQ#223 */
#define INTERRUPTS_IRQ_NUMBER_224           224U        /* < IRQ#224 */
#define INTERRUPTS_IRQ_NUMBER_225           225U        /* < IRQ#225 */
#define INTERRUPTS_IRQ_NUMBER_226           226U        /* < IRQ#226 */
#define INTERRUPTS_IRQ_NUMBER_227           227U        /* < IRQ#227 */
#define INTERRUPTS_IRQ_NUMBER_228           228U        /* < IRQ#228 */
#define INTERRUPTS_IRQ_NUMBER_229           229U        /* < IRQ#229 */
#define INTERRUPTS_IRQ_NUMBER_230           230U        /* < IRQ#230 */
#define INTERRUPTS_IRQ_NUMBER_231           231U        /* < IRQ#231 */
#define INTERRUPTS_IRQ_NUMBER_232           232U        /* < IRQ#232 */
#define INTERRUPTS_IRQ_NUMBER_233           233U        /* < IRQ#233 */
#define INTERRUPTS_IRQ_NUMBER_234           234U        /* < IRQ#234 */
#define INTERRUPTS_IRQ_NUMBER_235           235U        /* < IRQ#235 */
#define INTERRUPTS_IRQ_NUMBER_236           236U        /* < IRQ#236 */
#define INTERRUPTS_IRQ_NUMBER_237           237U        /* < IRQ#237 */
#define INTERRUPTS_IRQ_NUMBER_238           238U        /* < IRQ#238 */
#define INTERRUPTS_IRQ_NUMBER_239           239U        /* < IRQ#239 */
#define INTERRUPTS_IRQ_NUMBER_240           240U        /* < IRQ#240 */
#define INTERRUPTS_IRQ_NUMBER_241           241U        /* < IRQ#241 */
#define INTERRUPTS_IRQ_NUMBER_242           242U        /* < IRQ#242 */
#define INTERRUPTS_IRQ_NUMBER_243           243U        /* < IRQ#243 */
#define INTERRUPTS_IRQ_NUMBER_244           244U        /* < IRQ#244 */
#define INTERRUPTS_IRQ_NUMBER_245           245U        /* < IRQ#245 */
#define INTERRUPTS_IRQ_NUMBER_246           246U        /* < IRQ#246 */
#define INTERRUPTS_IRQ_NUMBER_247           247U        /* < IRQ#247 */
#define INTERRUPTS_IRQ_NUMBER_248           248U        /* < IRQ#248 */
#define INTERRUPTS_IRQ_NUMBER_249           249U        /* < IRQ#249 */
#define INTERRUPTS_IRQ_NUMBER_250           250U        /* < IRQ#250 */
#define INTERRUPTS_IRQ_NUMBER_251           251U        /* < IRQ#251 */
#define INTERRUPTS_IRQ_NUMBER_252           252U        /* < IRQ#252 */
#define INTERRUPTS_IRQ_NUMBER_253           253U        /* < IRQ#253 */
#define INTERRUPTS_IRQ_NUMBER_254           254U        /* < IRQ#254 */
#define INTERRUPTS_IRQ_NUMBER_255           255U        /* < IRQ#255 */
#define INTERRUPTS_IRQ_NUMBER_256           256U        /* < IRQ#256 */
#define INTERRUPTS_IRQ_NUMBER_257           257U        /* < IRQ#257 */
#define INTERRUPTS_IRQ_NUMBER_258           258U        /* < IRQ#258 */
#define INTERRUPTS_IRQ_NUMBER_259           259U        /* < IRQ#259 */
#define INTERRUPTS_IRQ_NUMBER_260           260U        /* < IRQ#260 */
#define INTERRUPTS_IRQ_NUMBER_261           261U        /* < IRQ#261 */
#define INTERRUPTS_IRQ_NUMBER_262           262U        /* < IRQ#262 */
#define INTERRUPTS_IRQ_NUMBER_263           263U        /* < IRQ#263 */
#define INTERRUPTS_IRQ_NUMBER_264           264U        /* < IRQ#264 */
#define INTERRUPTS_IRQ_NUMBER_265           265U        /* < IRQ#265 */
#define INTERRUPTS_IRQ_NUMBER_266           266U        /* < IRQ#266 */
#define INTERRUPTS_IRQ_NUMBER_267           267U        /* < IRQ#267 */
#define INTERRUPTS_IRQ_NUMBER_268           268U        /* < IRQ#268 */
#define INTERRUPTS_IRQ_NUMBER_269           269U        /* < IRQ#269 */
#define INTERRUPTS_IRQ_NUMBER_270           270U        /* < IRQ#270 */
#define INTERRUPTS_IRQ_NUMBER_271           271U        /* < IRQ#271 */
#define INTERRUPTS_IRQ_NUMBER_272           272U        /* < IRQ#272 */
#define INTERRUPTS_IRQ_NUMBER_273           273U        /* < IRQ#273 */
#define INTERRUPTS_IRQ_NUMBER_274           274U        /* < IRQ#274 */
#define INTERRUPTS_IRQ_NUMBER_275           275U        /* < IRQ#275 */
#define INTERRUPTS_IRQ_NUMBER_276           276U        /* < IRQ#276 */
#define INTERRUPTS_IRQ_NUMBER_277           277U        /* < IRQ#277 */
#define INTERRUPTS_IRQ_NUMBER_278           278U        /* < IRQ#278 */
#define INTERRUPTS_IRQ_NUMBER_279           279U        /* < IRQ#279 */
#define INTERRUPTS_IRQ_NUMBER_280           280U        /* < IRQ#280 */
#define INTERRUPTS_IRQ_NUMBER_281           281U        /* < IRQ#281 */
#define INTERRUPTS_IRQ_NUMBER_282           282U        /* < IRQ#282 */
#define INTERRUPTS_IRQ_NUMBER_283           283U        /* < IRQ#283 */
#define INTERRUPTS_IRQ_NUMBER_284           284U        /* < IRQ#284 */
#define INTERRUPTS_IRQ_NUMBER_285           285U        /* < IRQ#285 */
#define INTERRUPTS_IRQ_NUMBER_286           286U        /* < IRQ#286 */
#define INTERRUPTS_IRQ_NUMBER_287           287U        /* < IRQ#287 */
#define INTERRUPTS_IRQ_NUMBER_288           288U        /* < IRQ#288 */
#define INTERRUPTS_IRQ_NUMBER_289           289U        /* < IRQ#289 */
#define INTERRUPTS_IRQ_NUMBER_290           290U        /* < IRQ#290 */
#define INTERRUPTS_IRQ_NUMBER_291           291U        /* < IRQ#291 */
#define INTERRUPTS_IRQ_NUMBER_292           292U        /* < IRQ#292 */
#define INTERRUPTS_IRQ_NUMBER_293           293U        /* < IRQ#293 */
#define INTERRUPTS_IRQ_NUMBER_294           294U        /* < IRQ#294 */
#define INTERRUPTS_IRQ_NUMBER_295           295U        /* < IRQ#295 */
#define INTERRUPTS_IRQ_NUMBER_296           296U        /* < IRQ#296 */
#define INTERRUPTS_IRQ_NUMBER_297           297U        /* < IRQ#297 */
#define INTERRUPTS_IRQ_NUMBER_298           298U        /* < IRQ#298 */
#define INTERRUPTS_IRQ_NUMBER_299           299U        /* < IRQ#299 */
#define INTERRUPTS_IRQ_NUMBER_300           300U        /* < IRQ#300 */
#define INTERRUPTS_IRQ_NUMBER_301           301U        /* < IRQ#301 */
#define INTERRUPTS_IRQ_NUMBER_302           302U        /* < IRQ#302 */
#define INTERRUPTS_IRQ_NUMBER_303           303U        /* < IRQ#303 */
#define INTERRUPTS_IRQ_NUMBER_304           304U        /* < IRQ#304 */
#define INTERRUPTS_IRQ_NUMBER_305           305U        /* < IRQ#305 */
#define INTERRUPTS_IRQ_NUMBER_306           306U        /* < IRQ#306 */
#define INTERRUPTS_IRQ_NUMBER_307           307U        /* < IRQ#307 */
#define INTERRUPTS_IRQ_NUMBER_308           308U        /* < IRQ#308 */
#define INTERRUPTS_IRQ_NUMBER_309           309U        /* < IRQ#309 */
#define INTERRUPTS_IRQ_NUMBER_310           310U        /* < IRQ#310 */
#define INTERRUPTS_IRQ_NUMBER_311           311U        /* < IRQ#311 */
#define INTERRUPTS_IRQ_NUMBER_312           312U        /* < IRQ#312 */
#define INTERRUPTS_IRQ_NUMBER_313           313U        /* < IRQ#313 */
#define INTERRUPTS_IRQ_NUMBER_314           314U        /* < IRQ#314 */
#define INTERRUPTS_IRQ_NUMBER_315           315U        /* < IRQ#315 */
#define INTERRUPTS_IRQ_NUMBER_316           316U        /* < IRQ#316 */
#define INTERRUPTS_IRQ_NUMBER_317           317U        /* < IRQ#317 */
#define INTERRUPTS_IRQ_NUMBER_318           318U        /* < IRQ#318 */
#define INTERRUPTS_IRQ_NUMBER_319           319U        /* < IRQ#319 */
#define INTERRUPTS_IRQ_NUMBER_320           320U        /* < IRQ#320 */
#define INTERRUPTS_IRQ_NUMBER_321           321U        /* < IRQ#321 */
#define INTERRUPTS_IRQ_NUMBER_322           322U        /* < IRQ#322 */
#define INTERRUPTS_IRQ_NUMBER_323           323U        /* < IRQ#323 */
#define INTERRUPTS_IRQ_NUMBER_324           324U        /* < IRQ#324 */
#define INTERRUPTS_IRQ_NUMBER_325           325U        /* < IRQ#325 */
#define INTERRUPTS_IRQ_NUMBER_326           326U        /* < IRQ#326 */
#define INTERRUPTS_IRQ_NUMBER_327           327U        /* < IRQ#327 */
#define INTERRUPTS_IRQ_NUMBER_328           328U        /* < IRQ#328 */
#define INTERRUPTS_IRQ_NUMBER_329           329U        /* < IRQ#329 */
#define INTERRUPTS_IRQ_NUMBER_330           330U        /* < IRQ#330 */
#define INTERRUPTS_IRQ_NUMBER_331           331U        /* < IRQ#331 */
#define INTERRUPTS_IRQ_NUMBER_332           332U        /* < IRQ#332 */
#define INTERRUPTS_IRQ_NUMBER_333           333U        /* < IRQ#333 */
#define INTERRUPTS_IRQ_NUMBER_334           334U        /* < IRQ#334 */
#define INTERRUPTS_IRQ_NUMBER_335           335U        /* < IRQ#335 */
#define INTERRUPTS_IRQ_NUMBER_336           336U        /* < IRQ#336 */
#define INTERRUPTS_IRQ_NUMBER_337           337U        /* < IRQ#337 */
#define INTERRUPTS_IRQ_NUMBER_338           338U        /* < IRQ#338 */
#define INTERRUPTS_IRQ_NUMBER_339           339U        /* < IRQ#339 */
#define INTERRUPTS_IRQ_NUMBER_340           340U        /* < IRQ#340 */
#define INTERRUPTS_IRQ_NUMBER_341           341U        /* < IRQ#341 */
#define INTERRUPTS_IRQ_NUMBER_342           342U        /* < IRQ#342 */
#define INTERRUPTS_IRQ_NUMBER_343           343U        /* < IRQ#343 */
#define INTERRUPTS_IRQ_NUMBER_344           344U        /* < IRQ#344 */
#define INTERRUPTS_IRQ_NUMBER_345           345U        /* < IRQ#345 */
#define INTERRUPTS_IRQ_NUMBER_346           346U        /* < IRQ#346 */
#define INTERRUPTS_IRQ_NUMBER_347           347U        /* < IRQ#347 */
#define INTERRUPTS_IRQ_NUMBER_348           348U        /* < IRQ#348 */
#define INTERRUPTS_IRQ_NUMBER_349           349U        /* < IRQ#349 */
#define INTERRUPTS_IRQ_NUMBER_350           350U        /* < IRQ#350 */
#define INTERRUPTS_IRQ_NUMBER_351           351U        /* < IRQ#351 */
#define INTERRUPTS_IRQ_NUMBER_352           352U        /* < IRQ#352 */
#define INTERRUPTS_IRQ_NUMBER_353           353U        /* < IRQ#353 */
#define INTERRUPTS_IRQ_NUMBER_354           354U        /* < IRQ#354 */
#define INTERRUPTS_IRQ_NUMBER_355           355U        /* < IRQ#355 */
#define INTERRUPTS_IRQ_NUMBER_356           356U        /* < IRQ#356 */
#define INTERRUPTS_IRQ_NUMBER_357           357U        /* < IRQ#357 */
#define INTERRUPTS_IRQ_NUMBER_358           358U        /* < IRQ#358 */
#define INTERRUPTS_IRQ_NUMBER_359           359U        /* < IRQ#359 */
#define INTERRUPTS_IRQ_NUMBER_360           360U        /* < IRQ#360 */
#define INTERRUPTS_IRQ_NUMBER_361           361U        /* < IRQ#361 */
#define INTERRUPTS_IRQ_NUMBER_362           362U        /* < IRQ#362 */
#define INTERRUPTS_IRQ_NUMBER_363           363U        /* < IRQ#363 */
#define INTERRUPTS_IRQ_NUMBER_364           364U        /* < IRQ#364 */
#define INTERRUPTS_IRQ_NUMBER_365           365U        /* < IRQ#365 */
#define INTERRUPTS_IRQ_NUMBER_366           366U        /* < IRQ#366 */
#define INTERRUPTS_IRQ_NUMBER_367           367U        /* < IRQ#367 */
#define INTERRUPTS_IRQ_NUMBER_368           368U        /* < IRQ#368 */
#define INTERRUPTS_IRQ_NUMBER_369           369U        /* < IRQ#369 */
#define INTERRUPTS_IRQ_NUMBER_370           370U        /* < IRQ#370 */
#define INTERRUPTS_IRQ_NUMBER_371           371U        /* < IRQ#371 */
#define INTERRUPTS_IRQ_NUMBER_372           372U        /* < IRQ#372 */
#define INTERRUPTS_IRQ_NUMBER_373           373U        /* < IRQ#373 */
#define INTERRUPTS_IRQ_NUMBER_374           374U        /* < IRQ#374 */
#define INTERRUPTS_IRQ_NUMBER_375           375U        /* < IRQ#375 */
#define INTERRUPTS_IRQ_NUMBER_376           376U        /* < IRQ#376 */
#define INTERRUPTS_IRQ_NUMBER_377           377U        /* < IRQ#377 */
#define INTERRUPTS_IRQ_NUMBER_378           378U        /* < IRQ#378 */
#define INTERRUPTS_IRQ_NUMBER_379           379U        /* < IRQ#379 */
#define INTERRUPTS_IRQ_NUMBER_380           380U        /* < IRQ#380 */
#define INTERRUPTS_IRQ_NUMBER_381           381U        /* < IRQ#381 */
#define INTERRUPTS_IRQ_NUMBER_382           382U        /* < IRQ#382 */
#define INTERRUPTS_IRQ_NUMBER_383           383U        /* < IRQ#383 */
#define INTERRUPTS_IRQ_NUMBER_384           384U        /* < IRQ#384 */
#define INTERRUPTS_IRQ_NUMBER_385           385U        /* < IRQ#385 */
#define INTERRUPTS_IRQ_NUMBER_386           386U        /* < IRQ#386 */
#define INTERRUPTS_IRQ_NUMBER_387           387U        /* < IRQ#387 */
#define INTERRUPTS_IRQ_NUMBER_388           388U        /* < IRQ#388 */
#define INTERRUPTS_IRQ_NUMBER_389           389U        /* < IRQ#389 */
#define INTERRUPTS_IRQ_NUMBER_390           390U        /* < IRQ#390 */
#define INTERRUPTS_IRQ_NUMBER_391           391U        /* < IRQ#391 */
#define INTERRUPTS_IRQ_NUMBER_392           392U        /* < IRQ#392 */
#define INTERRUPTS_IRQ_NUMBER_393           393U        /* < IRQ#393 */
#define INTERRUPTS_IRQ_NUMBER_394           394U        /* < IRQ#394 */
#define INTERRUPTS_IRQ_NUMBER_395           395U        /* < IRQ#395 */
#define INTERRUPTS_IRQ_NUMBER_396           396U        /* < IRQ#396 */
#define INTERRUPTS_IRQ_NUMBER_397           397U        /* < IRQ#397 */
#define INTERRUPTS_IRQ_NUMBER_398           398U        /* < IRQ#398 */
#define INTERRUPTS_IRQ_NUMBER_399           399U        /* < IRQ#399 */
#define INTERRUPTS_IRQ_NUMBER_400           400U        /* < IRQ#400 */
#define INTERRUPTS_IRQ_NUMBER_401           401U        /* < IRQ#401 */
#define INTERRUPTS_IRQ_NUMBER_402           402U        /* < IRQ#402 */
#define INTERRUPTS_IRQ_NUMBER_403           403U        /* < IRQ#403 */
#define INTERRUPTS_IRQ_NUMBER_404           404U        /* < IRQ#404 */
#define INTERRUPTS_IRQ_NUMBER_405           405U        /* < IRQ#405 */
#define INTERRUPTS_IRQ_NUMBER_406           406U        /* < IRQ#406 */
#define INTERRUPTS_IRQ_NUMBER_407           407U        /* < IRQ#407 */
#define INTERRUPTS_IRQ_NUMBER_408           408U        /* < IRQ#408 */
#define INTERRUPTS_IRQ_NUMBER_409           409U        /* < IRQ#409 */
#define INTERRUPTS_IRQ_NUMBER_410           410U        /* < IRQ#410 */
#define INTERRUPTS_IRQ_NUMBER_411           411U        /* < IRQ#411 */
#define INTERRUPTS_IRQ_NUMBER_412           412U        /* < IRQ#412 */
#define INTERRUPTS_IRQ_NUMBER_413           413U        /* < IRQ#413 */
#define INTERRUPTS_IRQ_NUMBER_414           414U        /* < IRQ#414 */
#define INTERRUPTS_IRQ_NUMBER_415           415U        /* < IRQ#415 */
#define INTERRUPTS_IRQ_NUMBER_416           416U        /* < IRQ#416 */
#define INTERRUPTS_IRQ_NUMBER_417           417U        /* < IRQ#417 */
#define INTERRUPTS_IRQ_NUMBER_418           418U        /* < IRQ#418 */
#define INTERRUPTS_IRQ_NUMBER_419           419U        /* < IRQ#419 */
#define INTERRUPTS_IRQ_NUMBER_420           420U        /* < IRQ#420 */
#define INTERRUPTS_IRQ_NUMBER_421           421U        /* < IRQ#421 */
#define INTERRUPTS_IRQ_NUMBER_422           422U        /* < IRQ#422 */
#define INTERRUPTS_IRQ_NUMBER_423           423U        /* < IRQ#423 */
#define INTERRUPTS_IRQ_NUMBER_424           424U        /* < IRQ#424 */
#define INTERRUPTS_IRQ_NUMBER_425           425U        /* < IRQ#425 */
#define INTERRUPTS_IRQ_NUMBER_426           426U        /* < IRQ#426 */
#define INTERRUPTS_IRQ_NUMBER_427           427U        /* < IRQ#427 */
#define INTERRUPTS_IRQ_NUMBER_428           428U        /* < IRQ#428 */
#define INTERRUPTS_IRQ_NUMBER_429           429U        /* < IRQ#429 */
#define INTERRUPTS_IRQ_NUMBER_430           430U        /* < IRQ#430 */
#define INTERRUPTS_IRQ_NUMBER_431           431U        /* < IRQ#431 */
#define INTERRUPTS_IRQ_NUMBER_432           432U        /* < IRQ#432 */
#define INTERRUPTS_IRQ_NUMBER_433           433U        /* < IRQ#433 */
#define INTERRUPTS_IRQ_NUMBER_434           434U        /* < IRQ#434 */
#define INTERRUPTS_IRQ_NUMBER_435           435U        /* < IRQ#435 */
#define INTERRUPTS_IRQ_NUMBER_436           436U        /* < IRQ#436 */
#define INTERRUPTS_IRQ_NUMBER_437           437U        /* < IRQ#437 */
#define INTERRUPTS_IRQ_NUMBER_438           438U        /* < IRQ#438 */
#define INTERRUPTS_IRQ_NUMBER_439           439U        /* < IRQ#439 */
#define INTERRUPTS_IRQ_NUMBER_440           440U        /* < IRQ#440 */
#define INTERRUPTS_IRQ_NUMBER_441           441U        /* < IRQ#441 */
#define INTERRUPTS_IRQ_NUMBER_442           442U        /* < IRQ#442 */
#define INTERRUPTS_IRQ_NUMBER_443           443U        /* < IRQ#443 */
#define INTERRUPTS_IRQ_NUMBER_444           444U        /* < IRQ#444 */
#define INTERRUPTS_IRQ_NUMBER_445           445U        /* < IRQ#445 */
#define INTERRUPTS_IRQ_NUMBER_446           446U        /* < IRQ#446 */
#define INTERRUPTS_IRQ_NUMBER_447           447U        /* < IRQ#447 */
#define INTERRUPTS_IRQ_NUMBER_448           448U        /* < IRQ#448 */
#define INTERRUPTS_IRQ_NUMBER_449           449U        /* < IRQ#449 */
#define INTERRUPTS_IRQ_NUMBER_450           450U        /* < IRQ#450 */
#define INTERRUPTS_IRQ_NUMBER_451           451U        /* < IRQ#451 */
#define INTERRUPTS_IRQ_NUMBER_452           452U        /* < IRQ#452 */
#define INTERRUPTS_IRQ_NUMBER_453           453U        /* < IRQ#453 */
#define INTERRUPTS_IRQ_NUMBER_454           454U        /* < IRQ#454 */
#define INTERRUPTS_IRQ_NUMBER_455           455U        /* < IRQ#455 */
#define INTERRUPTS_IRQ_NUMBER_456           456U        /* < IRQ#456 */
#define INTERRUPTS_IRQ_NUMBER_457           457U        /* < IRQ#457 */
#define INTERRUPTS_IRQ_NUMBER_458           458U        /* < IRQ#458 */
#define INTERRUPTS_IRQ_NUMBER_459           459U        /* < IRQ#459 */
#define INTERRUPTS_IRQ_NUMBER_460           460U        /* < IRQ#460 */
#define INTERRUPTS_IRQ_NUMBER_461           461U        /* < IRQ#461 */
#define INTERRUPTS_IRQ_NUMBER_462           462U        /* < IRQ#462 */
#define INTERRUPTS_IRQ_NUMBER_463           463U        /* < IRQ#463 */
#define INTERRUPTS_IRQ_NUMBER_464           464U        /* < IRQ#464 */
#define INTERRUPTS_IRQ_NUMBER_465           465U        /* < IRQ#465 */
#define INTERRUPTS_IRQ_NUMBER_466           466U        /* < IRQ#466 */
#define INTERRUPTS_IRQ_NUMBER_467           467U        /* < IRQ#467 */
#define INTERRUPTS_IRQ_NUMBER_468           468U        /* < IRQ#468 */
#define INTERRUPTS_IRQ_NUMBER_469           469U        /* < IRQ#469 */
#define INTERRUPTS_IRQ_NUMBER_470           470U        /* < IRQ#470 */
#define INTERRUPTS_IRQ_NUMBER_471           471U        /* < IRQ#471 */
#define INTERRUPTS_IRQ_NUMBER_472           472U        /* < IRQ#472 */
#define INTERRUPTS_IRQ_NUMBER_473           473U        /* < IRQ#473 */
#define INTERRUPTS_IRQ_NUMBER_474           474U        /* < IRQ#474 */
#define INTERRUPTS_IRQ_NUMBER_475           475U        /* < IRQ#475 */
#define INTERRUPTS_IRQ_NUMBER_476           476U        /* < IRQ#476 */
#define INTERRUPTS_IRQ_NUMBER_477           477U        /* < IRQ#477 */
#define INTERRUPTS_IRQ_NUMBER_478           478U        /* < IRQ#478 */
#define INTERRUPTS_IRQ_NUMBER_479           479U        /* < IRQ#479 */
#define INTERRUPTS_IRQ_NUMBER_480           480U        /* < IRQ#480 */
#define INTERRUPTS_IRQ_NUMBER_481           481U        /* < IRQ#481 */
#define INTERRUPTS_IRQ_NUMBER_482           482U        /* < IRQ#482 */
#define INTERRUPTS_IRQ_NUMBER_483           483U        /* < IRQ#483 */
#define INTERRUPTS_IRQ_NUMBER_484           484U        /* < IRQ#484 */
#define INTERRUPTS_IRQ_NUMBER_485           485U        /* < IRQ#485 */
#define INTERRUPTS_IRQ_NUMBER_486           486U        /* < IRQ#486 */
#define INTERRUPTS_IRQ_NUMBER_487           487U        /* < IRQ#487 */
#define INTERRUPTS_IRQ_NUMBER_488           488U        /* < IRQ#488 */
#define INTERRUPTS_IRQ_NUMBER_489           489U        /* < IRQ#489 */
#define INTERRUPTS_IRQ_NUMBER_490           490U        /* < IRQ#490 */
#define INTERRUPTS_IRQ_NUMBER_491           491U        /* < IRQ#491 */
#define INTERRUPTS_IRQ_NUMBER_492           492U        /* < IRQ#492 */
#define INTERRUPTS_IRQ_NUMBER_493           493U        /* < IRQ#493 */
#define INTERRUPTS_IRQ_NUMBER_494           494U        /* < IRQ#494 */
#define INTERRUPTS_IRQ_NUMBER_495           495U        /* < IRQ#495 */
#define INTERRUPTS_IRQ_NUMBER_496           496U        /* < IRQ#496 */
#define INTERRUPTS_IRQ_NUMBER_497           497U        /* < IRQ#497 */
#define INTERRUPTS_IRQ_NUMBER_498           498U        /* < IRQ#498 */
#define INTERRUPTS_IRQ_NUMBER_499           499U        /* < IRQ#499 */
#define INTERRUPTS_IRQ_NUMBER_500           500U        /* < IRQ#500 */
#define INTERRUPTS_IRQ_NUMBER_501           501U        /* < IRQ#501 */
#define INTERRUPTS_IRQ_NUMBER_502           502U        /* < IRQ#502 */
#define INTERRUPTS_IRQ_NUMBER_503           503U        /* < IRQ#503 */
#define INTERRUPTS_IRQ_NUMBER_504           504U        /* < IRQ#504 */
#define INTERRUPTS_IRQ_NUMBER_505           505U        /* < IRQ#505 */
#define INTERRUPTS_IRQ_NUMBER_506           506U        /* < IRQ#506 */
#define INTERRUPTS_IRQ_NUMBER_507           507U        /* < IRQ#507 */
#define INTERRUPTS_IRQ_NUMBER_508           508U        /* < IRQ#508 */
#define INTERRUPTS_IRQ_NUMBER_509           509U        /* < IRQ#509 */
#define INTERRUPTS_IRQ_NUMBER_510           510U        /* < IRQ#510 */
#define INTERRUPTS_IRQ_NUMBER_511           511U        /* < IRQ#511 */

/* --------------------------------------------------------------------
   2    N M I
   --------------------------------------------------------------------
        N M I   N U M B E R S
   --------------------------------------------------------------------
   Definition of NMI numbers. These macros should
   be used as parameter for ISR function definition macros
   FN_NMI_DEFINE_BEGIN( ..., NmiNum) to set the NMI
   number which must be cleared in the Interrupt Controller
   after an NMI is handled.
   -------------------------------------------------------------------- */
#define INTERRUPTS_NMI_NUMBER_0         0U   /* < NMI#0  */
#define INTERRUPTS_NMI_NUMBER_1         1U   /* < NMI#1  */
#define INTERRUPTS_NMI_NUMBER_2         2U   /* < NMI#2  */
#define INTERRUPTS_NMI_NUMBER_3         3U   /* < NMI#3  */
#define INTERRUPTS_NMI_NUMBER_4         4U   /* < NMI#4  */
#define INTERRUPTS_NMI_NUMBER_5         5U   /* < NMI#5  */
#define INTERRUPTS_NMI_NUMBER_6         6U   /* < NMI#6  */
#define INTERRUPTS_NMI_NUMBER_7         7U   /* < NMI#7  */
#define INTERRUPTS_NMI_NUMBER_8         8U   /* < NMI#8  */
#define INTERRUPTS_NMI_NUMBER_9         9U   /* < NMI#9  */
#define INTERRUPTS_NMI_NUMBER_10        10U  /* < NMI#10 */
#define INTERRUPTS_NMI_NUMBER_11        11U  /* < NMI#11 */
#define INTERRUPTS_NMI_NUMBER_12        12U  /* < NMI#12 */
#define INTERRUPTS_NMI_NUMBER_13        13U  /* < NMI#13 */
#define INTERRUPTS_NMI_NUMBER_14        14U  /* < NMI#14 */
#define INTERRUPTS_NMI_NUMBER_15        15U  /* < NMI#15 */
#define INTERRUPTS_NMI_NUMBER_16        16U  /* < NMI#16 */
#define INTERRUPTS_NMI_NUMBER_17        17U  /* < NMI#17 */
#define INTERRUPTS_NMI_NUMBER_18        18U  /* < NMI#18 */
#define INTERRUPTS_NMI_NUMBER_19        19U  /* < NMI#19 */
#define INTERRUPTS_NMI_NUMBER_20        20U  /* < NMI#20 */
#define INTERRUPTS_NMI_NUMBER_21        21U  /* < NMI#21 */
#define INTERRUPTS_NMI_NUMBER_22        22U  /* < NMI#22 */
#define INTERRUPTS_NMI_NUMBER_23        23U  /* < NMI#23 */
#define INTERRUPTS_NMI_NUMBER_24        24U  /* < NMI#24 */
#define INTERRUPTS_NMI_NUMBER_25        25U  /* < NMI#25 */
#define INTERRUPTS_NMI_NUMBER_26        26U  /* < NMI#26 */
#define INTERRUPTS_NMI_NUMBER_27        27U  /* < NMI#27 */
#define INTERRUPTS_NMI_NUMBER_28        28U  /* < NMI#28 */
#define INTERRUPTS_NMI_NUMBER_29        29U  /* < NMI#29 */
#define INTERRUPTS_NMI_NUMBER_30        30U  /* < NMI#30 */
#define INTERRUPTS_NMI_NUMBER_31        31U  /* < NMI#31 */

/*****************************************************************************/
/* Global type definitions ('typedef')                                       */
/*****************************************************************************/

/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source)           */
/*****************************************************************************/

/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source)             */
/*****************************************************************************/
extern void Interrupt_Controller_Unlock(void);
extern void Interrupt_Controller_Lock(void);

extern void Interrupt_NMI_ISR_Register(uint16_t u16NMINum, uint32_t u32ISRAddr, uint8_t u8priority);
extern void Interrupt_NMI_Channel_Disable(uint16_t u16NMINum);
extern void Interrupt_IRQ_ISR_Register(uint16_t u16IRQNum, uint32_t u32ISRAddr, uint8_t u8priority);
extern void Interrupt_IRQ_Channel_Disable(uint16_t u16IRQNum);

#endif /* __FILE_VERSION_CHECK__ */
#endif /* __INTERRUPTS_H__ */
