#include "RTE_CAN.h"
#include "CAN_APP.h"
#include "CAN_Communication_Matrix.h"
#include "AlarmGeneralFilie.h"
#include "Diag_ID_Def.h"
#include "DoCAN_ISO15765.h"
#include "base_types.h"
#include "PowerManagement.h"
#include "UDS_Common.h"



Can_ReceiveType Can_Rx_Sts;
Can_SendType Can_Tx_Sts;
static uint16_t Can_Init_Lock = 0U;

void Can_Lock_Clr(void)
{
    Can_Init_Lock = 0u;
}

Can_ReceiveType Can_ReadRx_St(void)
{
    return Can_Rx_Sts;
}
Can_SendType Can_ReadTx_St(void)
{
    return Can_Tx_Sts;
}

void Can_SetTx_St(Can_SendType Status)
{
    switch (Status)
    {
    case CAN_N_TX:
        Can_Tx_Sts = CAN_N_TX;
        break;
    case CAN_Y_TX:
        Set_Bit(Can_Tx_Sts, 0);
        break;
    case CAN_N_F_TX:
        Set_Bit(Can_Tx_Sts, 0);
        Set_Bit(Can_Tx_Sts, 7);
        break;
    default: Set_Bit(Can_Tx_Sts, 0);
        break;
    }
}
void Can_SetRx_St(Can_ReceiveType Status)
{
    switch (Status)
    {
    case CAN_N_RX:
        Can_Rx_Sts = CAN_N_RX;
        break;
    case CAN_Y_RX:
        Set_Bit(Can_Rx_Sts, 0);
        break;
    case CAN_N_F_RX:
        Set_Bit(Can_Rx_Sts, 0);
        Set_Bit(Can_Rx_Sts, 7);
        break;
    default: Set_Bit(Can_Rx_Sts, 0);
        break;
    }
}

/***Middle***/
void Can_Init(void)
{
    uint16_t i;
    
    /* filter 变量声明 */
    uint32_t  CANLLCCh5NMIDRange[2];
    uint32_t  CANLLCCh5DiagIDList[2];
    uint32_t  CANLLCCh5MsgIDList[ID_TOTAL_MAX] ;
    CANFD_Filter_Init_st_t  CANLLCCh5Filter;
    CoCAN_CanVal_Init();
    if (Can_Init_Lock != 0x55AAu)
    {
        /* Sys_Startup_Init */
        /*50304*/
        CANLLCCh5NMIDRange[0]  = 0x400UL;
        CANLLCCh5NMIDRange[1]  = 0x47FUL;

        CANLLCCh5DiagIDList[0] = 0x18DA17F1UL;
        CANLLCCh5DiagIDList[1] = 0x18DB33F1UL;

        for(i=0;i<ID_TOTAL_MAX;i++)
        {
            CANLLCCh5MsgIDList[i] = CAN_MSG_CONST_ARRAY[i].MSG_Identifier;
        }



        CANLLCCh5Filter.NMStdFilter.CfgType     = CANFD_FILTER_N_A;
        CANLLCCh5Filter.DiagStdFilter.CfgType   = CANFD_FILTER_N_A;
        CANLLCCh5Filter.MsgStdFilter.CfgType    = CANFD_FILTER_N_A;
        
        CANLLCCh5Filter.NMExtFilter.CfgType     = CANFD_FILTER_ID_RANGE;
        CANLLCCh5Filter.NMExtFilter.pIDs        = CANLLCCh5NMIDRange;
        CANLLCCh5Filter.DiagExtFilter.CfgType   = CANFD_FILTER_ID_LIST;
        CANLLCCh5Filter.DiagExtFilter.IDNum     = DIM(CANLLCCh5DiagIDList);
        CANLLCCh5Filter.DiagExtFilter.pIDs      = CANLLCCh5DiagIDList;
        CANLLCCh5Filter.MsgExtFilter.CfgType    = CANFD_FILTER_ID_LIST;
        CANLLCCh5Filter.MsgExtFilter.IDNum      = DIM(CANLLCCh5MsgIDList);
        CANLLCCh5Filter.MsgExtFilter.pIDs       = CANLLCCh5MsgIDList;
        
        CANLLCCh5Filter.pfCANDataIndCb = Can_Read_Msg;
        CANLLCCh5Filter.pfCANDataCfmCb = Can_Confirm;
        CANLLCCh5Filter.pfCANDataAbortCb = Can_Abort_Confirm;
        CANFD_CH0_Init (&CANLLCCh5Filter);


        /* 最后别忘了开启STB */
        CAN0_STB = 0U;
        Can_Init_Lock = 0x55AAu;
    }
}

void Can_DeInit(void)
{

}

void Can_Write(_CAN_Msg *Msg)
{
    CANFD_CH0_L_Data_Request(Msg->MsgID, (uint16_t)Msg->MsgPro, Msg->MsgDLC, Msg->Msg);
}


canlib_uint8_t Can_Write_0(st_CAN_Msg *Msg)
{
    if(Common_Get_IG_Sts() == 1)
    {
        CANFD_CH0_L_Data_Request(Msg->MsgID, (uint16_t)Msg->MsgPro, Msg->MsgDLC, Msg->Msg);
    }
    else
    {
        if((Msg->MsgID == 0x18FEE017ul)||(Msg->MsgID == 0x18FF6F17ul)||(Msg->MsgID == 0x18FEDA17ul))
        {
            return 0;
        }
        else
        {
            CANFD_CH0_L_Data_Request(Msg->MsgID, (uint16_t)Msg->MsgPro, Msg->MsgDLC, Msg->Msg);
        }
    }
    
    
    return 0;
}




void Can_Sleep_Fun(void)
{
    GPIO_Pin_Cfg_st_t CANconfig;
    CAN0_STB = 1U;
    CANconfig.OutputFuncID = 0u;
    CANconfig.OutputDrvCap = 0u;
    CANconfig.InputEnable = 1u;
    CANconfig.InputLevel = 1u;
    CANconfig.PullUpDn = GPIO_PULL_NONE;
    CANconfig.FilterEnable = 0u;
    GPIO_Set_Pin_Config(0u, 25u, &CANconfig);
    GPIO_Set_Interrupt_Mode(0U, 25U, GPIO_INT_FALLING_EDGE, 0U, SetCANModeFlag);
}

//void gpio_Port1_pin20(void)
//{
//    GPIO_Pin_Cfg_st_t GPIOconfig;
//    GPIOconfig.OutputFuncID = 0u;
//    GPIOconfig.OutputDrvCap = 0u;
//    GPIOconfig.InputEnable = 1u;
//    GPIOconfig.InputLevel = 1u;
//    GPIOconfig.PullUpDn = GPIO_PULL_NONE;
//    GPIOconfig.FilterEnable = 0u;
//    GPIO_Set_Pin_Config(1u, 20u, &GPIOconfig);
//}

void Can_SleepController_Fun(void)
{
    CANFD_CH0_Sleep();
}

void Can_Wakeup_Fun(void)
{


}

void Can_Uds_Abort(void)
{


    /*uint32_t cancel;*/
    CANFD_SetTX_Abort(0x02ul);
    /*
    cancel = CANFD_Get_AbortStatus();
    cancel &=0x00000002ul;

    while((cancel &=0x00000002ul) ==0u)
    {
      cancel = CANFD_Get_AbortStatus();
      cancel &=0x00000002ul;
    }
    */
}


void Can_Abort_All(void)
{
    uint32_t cancel;
    cancel = CANFD_ReadTX_Buf();
    CANFD_SetTX_Abort(cancel);
}

/*****Lower*******/
void Can_Read_Msg(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg[])
{

    ReceivedMsg(m_id, m_dlc);
    Co_Can_Buff_Set(Co_Can_ConvertSubID(m_id), m_dlc, m_Msg);
    if ( (m_id == DIAG_ID_Rx_FUN) || (m_id == DIAG_ID_Rx_PHY) )
    {
        /*收到诊断数据之后维持网络管理*/
        DoCAN_L_Data_Indication(m_id, m_dlc, m_Msg);
    }
}

void Can_Confirm(uint32_t Identifier, uint8_t TransferStatus)
{
    if (TransferStatus == CANFD_COMPLETE)
    {
        if (Identifier == 0U)
        {
//            CanNm_Data_Confirm ( 0x402u, COMPLETE);
        }
        if (Identifier == 1U)
        {
            DoCAN_L_Data_Confirm ( DIAG_ID_Tx, DIAG_COMPLETE );
        }
        if (Identifier == 2U)
        {
//            NODE_26D_SET_Confirm();
        }
        if (Identifier == 3U)
        {

        }
        if (Identifier == 4U)
        {

        }
        if (Identifier == 5U)
        {

        }
        if (Identifier == 6U)
        {

        }
        if (Identifier == 7U)
        {

        }
        if (Identifier == 8U)
        {

        }
        if (Identifier == 9U)
        {

        }
        if (Identifier == 10U)
        {

        }
        if (Identifier == 11U)
        {

        }
        if (Identifier == 12U)
        {

        }
        if (Identifier == 13U)
        {

        }
        if (Identifier == 14U)
        {

        }
        if (Identifier == 15U)
        {

        }
        if (Identifier == 16U)
        {

        }
        if (Identifier == 17U)
        {

        }
        if (Identifier == 18U)
        {

        }
        if (Identifier == 19U)
        {

        }
        if (Identifier == 20U)
        {

        }
        if (Identifier == 21U)
        {

        }
        if (Identifier == 22U)
        {

        }
        if (Identifier == 23U)
        {

        }
        if (Identifier == 24U)
        {

        }
        if (Identifier == 25U)
        {
            UDS_S11_Confirm();
        }
        if (Identifier == 26U)
        {

        }
        if (Identifier == 27U)
        {

        }
        if (Identifier == 28U)
        {

        }
        if (Identifier == 29U)
        {

        }
        if (Identifier == 30U)
        {

        }
        if (Identifier == 31U)
        {

        }
    }
    else
    {
        if (Identifier == 0U)
        {
            // CanNm_Data_Confirm ( 0x402u, NO_COMPLETE);
        }
        if (Identifier == 1U)
        {
            DoCAN_L_Data_Confirm ( DIAG_ID_Tx, DIAG_NOT_COMPLETE );
        }
        if (Identifier == 2U)
        {

        }
        if (Identifier == 3U)
        {

        }
        if (Identifier == 4U)
        {

        }
        if (Identifier == 5U)
        {

        }
        if (Identifier == 6U)
        {

        }
        if (Identifier == 7U)
        {

        }
        if (Identifier == 8U)
        {

        }
        if (Identifier == 9U)
        {

        }
        if (Identifier == 10U)
        {

        }
        if (Identifier == 11U)
        {

        }
        if (Identifier == 12U)
        {

        }
        if (Identifier == 13U)
        {

        }
        if (Identifier == 14U)
        {

        }
        if (Identifier == 15U)
        {

        }
        if (Identifier == 16U)
        {

        }
        if (Identifier == 17U)
        {

        }
        if (Identifier == 18U)
        {

        }
        if (Identifier == 19U)
        {

        }
        if (Identifier == 20U)
        {

        }
        if (Identifier == 21U)
        {

        }
        if (Identifier == 22U)
        {

        }
        if (Identifier == 23U)
        {

        }
        if (Identifier == 24U)
        {

        }
        if (Identifier == 26U)
        {

        }
        if (Identifier == 27U)
        {

        }
        if (Identifier == 28U)
        {

        }
        if (Identifier == 29U)
        {

        }
        if (Identifier == 30U)
        {

        }
        if (Identifier == 31U)
        {

        }
    }
}