#include "UDS_22Service_Internal.h"

/**
  *获取当前电压
  *phy = XX *0.1
  *0xFF为无效值
  */
uint8_t getECUPowerSupplyVoltage(void)
{
    return (uint8_t)(getKL30Voltage() / 100u);
}

/**
  *获取当前车速
  *phy = XX *0.05625
  *0x1FFF为无效值
  */
uint16_t getVehicleSpeed(void)
{
    uint16_t Speed = Get_IPK_vSpeed();
    if(Speed > 0x1FFFu)
    {
        Speed = 0x1FFFu;
    }
    return Speed;
}

/**
  *获取当前转速
  *phy = XX *0.25
  *0xFFFF为无效值
  */
uint16_t getEngineSpeed(void)
{
    return 0u;
}

/**
  *获取冷却液温度
  *Phys = XX * 0.75 - 36.8
  */
uint8_t getCoolantTemperature(void)
{
    return 0u;
}

/**
  *获取真实里程
  *Phys = XX * 1
  */
uint32_t getACTOdometer(void)
{
    return Services_Read_ACT_ODO() / 10u;
}

/**
  *获取总里程
  *Phys = XX * 1
  */
uint32_t getTotalOdometer(void)
{
    return Data_ODO_Read() / 10u;
}

/**
  *获取剩余保养里程
  *Phys = XX * 1
  */
uint16_t getDistanceToNextMaintanceService(void)
{
    return (uint16_t)(Get_IntervalKM() / 10u);
}

/**
  *获取仪表里程清零次数
  */
uint8_t getZeroClearingNumberOfOdometer(void)
{
    return (uint8_t)Services_Read_ODO_ClearCnt();
}

/**
  *获取燃油传感器电阻值
  *Phys = XX * 1
  */
uint16_t getFuelSensorResistance(void)
{
    return 0x00u;
}

/**
  *抬头显示屏控制器主开关
  *OX00：OFF
  *0X01：ON
  */
uint8_t getHUDMainSwitch(void)
{
    return 0x00u;
}

/**
  *抬头显示屏控制器上调开关
  *OX00：OFF
  *0X01：ON
  */
uint8_t getHUDUpSwitch(void)
{
    return 0x00u;
}

/**
  *抬头显示屏控制器下调开关
  *OX00：OFF
  *0X01：ON
  */
uint8_t getHUDDownSwitch(void)
{
    return 0x00u;
}
