#include "UDS_31Service_Main.h"

/**
  *31服务函数入口
  *@param A_TA_type 收到数据的地址
  *@param A_Length 收到数据的长度
  *@param A_Data 收到数据的数据
  */
void UDS_Service_31_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_NRC11();                                            /*31服务是否支持功能寻址*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_NRC7F();                                            /*31服务会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_NRC33();                                            /*31服务解锁等级验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_NRC13_MinLengthCheck();                             /*31服务最小长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_NRC31();                                            /*31服务超出请求范围验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_NRC13_TotalLengthCheck();                           /*31服务总长度长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_NRC22();                                            /*31服务条件验证*/
    }
    if(NRC == positiveResponse)
    {
        UDS_31Service_Sub();                                                    /*31服务子功能判断*/
    }
    clearDiagMSG();                                                             /*清除诊断信息*/
}

/**
  *31服务子功能
  */
void UDS_31Service_Sub(void)
{
    uint8_t NRC = positiveResponse;
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_Sub_NRC13_MinLengthCheck();                         /*31服务子功能最小长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_Sub_NRC12();                                        /*31服务子功能是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_Sub_NRC7E();                                        /*31服务子功能会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_Sub_NRC31();                                        /*31服务子功能超出请求范围验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_Sub_NRC13_TotalLengthCheck();                       /*31服务子功能总长度长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_Sub_NRC24();                                        /*31服务子功能请求顺序验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_Sub_NRC22();                                        /*31服务子功能条件验证*/
    }
    if(NRC == positiveResponse)
    {
        switch(DiagMSG.msgData.SidDetail.SubID)                                 /*子服务判断*/
        {
        case startRoutine:
            UDS_31Service_Sub01();                                              /*31服务01子功能*/
            break;
        case stopRoutine:
            UDS_31Service_Sub02();                                              /*31服务02子功能*/
            break;
        case requestRoutineResults:
            UDS_31Service_Sub03();                                              /*31服务03子功能*/
            break;
        default:
            break;
        }
    }
}

/**
  *31服务01子功能
  */
void UDS_31Service_Sub01(void)
{
    switch(getDID(DiagMSG.msgData.S31Detail.DID_H, DiagMSG.msgData.S31Detail.DID_L))/*31服务DID判断*/
    {
    case 0x7103:
        UDS_31Service_Sub01_DID_62F1();                         /*写入保养间隔里程*/
        break;
    case 0x7104:
        UDS_31Service_Sub01_DID_62F2();                         /*里程清零*/
        break;
    case 0x62F4:
        UDS_31Service_Sub01_DID_62F4();                         /*写入保养间隔时间*/
        break;
    case 0xF306:
        UDS_31Service_Sub01_DID_F306();                         /*调试模式*/
        break;
    default:
        break;
    }
}

/**
  *31服务02子功能
  */
void UDS_31Service_Sub02(void)
{
    switch(getDID(DiagMSG.msgData.S31Detail.DID_H, DiagMSG.msgData.S31Detail.DID_L))/*31服务DID判断*/
    {
    case 0x62F3:
        UDS_31Service_Sub02_DID_62F3();                         /*更新GPU*/
        break;
    default:
        break;
    }
}

/**
  *31服务03子功能
  */
void UDS_31Service_Sub03(void)
{
    switch(getDID(DiagMSG.msgData.S31Detail.DID_H, DiagMSG.msgData.S31Detail.DID_L))/*31服务DID判断*/
    {
    case 0x62F3:
        UDS_31Service_Sub03_DID_62F3();                         /*更新GPU*/
        break;
    default:
        break;
    }
}

/**
  *31服务01子功能DID62F0
  *抬头显示屏复位
  */
void UDS_31Service_Sub01_DID_62F0(void)
{

}

/**
  *31服务01子功能DID62F1<br>
  *写入保养间隔里程
  *87607-16*
  */
void UDS_31Service_Sub01_DID_62F1(void)
{
    //uint32_t maintenance = 0u;
   // maintenance = toUint32_t(0x00u,0x00u,DiagMSG.msgData.S31Detail.Data[0],DiagMSG.msgData.S31Detail.Data[1]);
   // Data_interval_Geely_Write(maintenance * 10u);
    //if(Data_ODO_Read() < 5000  )
    //{
    //    Data_interval_Geely_Write(Services_FirstFlag);
    //}
    //else
    //{
    //    Data_interval_Geely_Write(Services_SecondFlag);
    //}
    DiagMSG.msgData.S31Detail.Data[0] = 0x04u;
    UDS_Service_Response(0x31u, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *31服务01子功能DID62F4
  *写入保养间隔时间
  */
void UDS_31Service_Sub01_DID_62F4(void)
{
    //uint32_t maintenanceTimer = 0u;
    //maintenanceTimer = toUint32_t(0x00u,0x00u,DiagMSG.msgData.S31Detail.Data[0],DiagMSG.msgData.S31Detail.Data[1]);
    //Data_interval_Geely_WriteTIMER(maintenanceTimer);
    //DiagMSG.msgData.S31Detail.Data[0] = 0x04u;
    //UDS_Service_Response(0x31u, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *31服务01子功能DID62F2
  *里程清零
  */
void UDS_31Service_Sub01_DID_62F2(void)
{
    uint8_t enResult = 0u;
    enResult = GeelyReset();
    if(enResult == 0u)
    {
        DiagMSG.msgData.S31Detail.Data[0] = 0x04u;
        DiagMSG.msgData.S31Detail.Data[1] = 0x00u;
        UDS_Service_Response(0x31u, POSITIVE_RSP, DIAG_ID_Tx, 5u, DiagMSG.msgData.Data);
    }
    else
    {
        DiagMSG.msgData.S31Detail.Data[0] = 0x05u;
        DiagMSG.msgData.S31Detail.Data[1] = enResult;
        UDS_Service_Response(0x31u, POSITIVE_RSP, DIAG_ID_Tx, 5u, DiagMSG.msgData.Data);
    }
}

/**
  *31服务01子功能DIDF306
  *调试模式
  */
void UDS_31Service_Sub01_DID_F306(void)
{
    uint32_t enResult = 0u;
    enResult = 0;
    if(enResult == 0u)
    {
        DiagMSG.msgData.S31Detail.Data[1] = 0x01u;
    }
    else
    {
        DiagMSG.msgData.S31Detail.Data[1] = 0x00u;
    }
    DiagMSG.msgData.S31Detail.Data[0] = 0x04u;
    UDS_Service_Response(0x31u, POSITIVE_RSP, DIAG_ID_Tx, 5u, DiagMSG.msgData.Data);
}

/**
  *31服务01子功能DID62F3
  *更新GPU
  */
void UDS_31Service_Sub01_DID_62F3(void)
{

}

/**
  *31服务02子功能DID62F3
  *更新GPU
  */
void UDS_31Service_Sub02_DID_62F3(void)
{

}

/**
  *31服务03子功能DID62F3
  *更新GPU
  */
void UDS_31Service_Sub03_DID_62F3(void)
{

}
