#ifndef _POPUP_INTERFACE_H_
#define _POPUP_INTERFACE_H_

#include "stdint.h"
#include "Popup_List.h"
#include "Sound_List.h"

extern void Popup_Scheduler_Init(void);
extern void Popup_Scheduling_Service(void);        
extern void PopupAndSound_Delete(uint8_t PopupID); 
extern void Popup_Request(uint8_t PopupID);
extern void Popup_Delete(uint8_t PopupID);
extern void Popup_Clear(uint8_t PopupID);
extern uint8_t Popup_Get_Status(uint8_t PopupID);

extern void Sound_Scheduler_Init(void);
extern void Sound_Request(uint8_t Sound, uint8_t ReqCode);
extern void Sound_Delete(uint8_t Sound);
extern void Sound_Scheduling_Service(void);
extern uint8_t Popup_Get_Current_Type(void);
extern uint8_t Popup_Get_Current_Message(void);
extern uint8_t Popup_Get_Current_Sound(void);
extern uint8_t Popup_Get_Current_Sound_Req_Code(void);
extern void DteRemind(void);
extern uint8_t GetCurSndSrcIndx(void); /*获取正在播放报警音源号*/
extern uint8_t Get_SoundScheduling_Current(void);/*获取正在播放报警音*/
extern void SetRADAR_SOUND(uint8_t Level);
#endif  /* _POPUP_INTERFACE_H_  */

