#include "Popups.h"
#include "Popup_Interface.h"
#include "Common_Interface.h"
#include "Communication_Over_CAN.h"
#include "Services_ODO.h"
#include "Line_In.h"
#include "Services_Interval.h"
#include "Telltales_Lib.h"
#include "Telltales_user.h"
#include "Gauge_Display.h"
#include "Radar_R3.h"

uint8_t OverSpeed;

uint8_t Over_Speed_Status;
uint8_t OIL_Low_popup_flag;

uint8_t RADAR_SOUND; /*雷达声音*/

uint8_t  LowBrakeFluid_Clock         = 0u;
uint8_t  AirBagError_Clock           = 0u;
uint16_t ODO_last                    = 0u;
uint8_t  TCU_FAILURE_Sts             = 0u;
uint8_t  TCU_FAILURE_Sts_last        = 0u;
uint8_t  ParkBrake_NoRreleased_Clock = 0u;

uint16_t TCU_OVT_5MIN_Clock       = 0u;
uint16_t TCU_OVT_STOP_Clock       = 0u;
uint8_t  FUEL_Low_Check           = 0u;
uint8_t  CPDWarningSts            = 0u;
uint8_t  CPDWarning_Clock         = 0u;
uint8_t  CPDWarning_Valid         = 0u;
uint8_t  Engine_Status_Delay_Flag = 0u;
uint8_t  POP_LowOilPressure_Clock = 0u;
uint8_t  POP_3S_Clock             = 0u;
uint8_t  IGstPopup                = 0u;

uint8_t  TurnTo_Flag    = 0;
uint16_t SelfCheck_time = 50;

uint16_t Door_Warningtimer;

extern uint16_t Over_Speed_Config;


void SetRADAR_SOUND(uint8_t Level)
{
    if ( Level == RADAR_SND_2Hz )
    {
        RADAR_SOUND = RADAR_SND_2Hz;
    }
    else if ( Level == RADAR_SND_4Hz )
    {
        RADAR_SOUND = RADAR_SND_4Hz;
    }
    else if ( Level == RADAR_SND_CONTINUOUS )
    {
        RADAR_SOUND = RADAR_SND_CONTINUOUS;
    }
    else
    {
        RADAR_SOUND = 255u; /*未知取消*/
    }
}

void Popups_KL15_Init(void)
{
    SelfCheck_time = 0;
}

void Popups_IG_OFF_Init(void)
{
    SelfCheck_time = 50u;
}
void Popups_Management_Service(void)
{
    uint8_t PopupSnd;

    /*报警触发*/
    Popups_Polling( );
    /*获取调度的声音报警*/
    PopupSnd = Popup_Get_Current_Sound( ); /*根据报警PopupScheduling.Current取出声音音源*/
    /*执行调度声音*/
    Popups_Sound_Playing(PopupSnd);
}
void Popups_Polling(void)
{
    //    uint8_t ReqCode;
    uint8_t  IGstPopup1;
    uint16_t m_Vspeed;
    
    
    m_Vspeed   = Common_Get_Disp_V_Speed( );
    IGstPopup1 = Common_Get_IG_Sts( );

    if ( SelfCheck_time < (POWERON_SCAN_TIMER / 100) + 5u )
    {
        SelfCheck_time++;
        PopupAndSound_Delete(POPUP_RADAR_CHECK_OK);
        PopupAndSound_Delete(POPUP_RADAR_SENSOR_FAILURE);
        
        PopupAndSound_Delete(POPUP_Radar_Changming);
        PopupAndSound_Delete(POPUP_Radar_1HZ);
        PopupAndSound_Delete(POPUP_Radar_2HZ);
        PopupAndSound_Delete(POPUP_Radar_4HZ);
        PopupAndSound_Delete(POPUP_EPB_Status);
        PopupAndSound_Delete(POPUP_SEATBELT_DR_1HZ);
        PopupAndSound_Delete(POPUP_SEATBELT_DR_2HZ);
        //PopupAndSound_Delete(POPUP_DoorOpen);
        PopupAndSound_Delete(POPUP_DoorOpen_1HZ);
        PopupAndSound_Delete(POPUP_EBD_fault);
        PopupAndSound_Delete(POPUP_ABS);
        PopupAndSound_Delete(POPUP_EPS);
        PopupAndSound_Delete(POPUP_Park_Brak);
        PopupAndSound_Delete(POPUP_MotorFault);
        PopupAndSound_Delete(POPUP_SOC_Fault);
        PopupAndSound_Delete(POPUP_InsulationFault);
        PopupAndSound_Delete(POPUP_SOC_HT);
        PopupAndSound_Delete(POPUP_Energy_Recovery);
        PopupAndSound_Delete(POPUP_Energy_Recovery_1);
        PopupAndSound_Delete(POPUP_ECO);
        PopupAndSound_Delete(POPUP_READY);
        PopupAndSound_Delete(POPUP_PowerLimit);
        PopupAndSound_Delete(POPUP_SOC_LP);
        PopupAndSound_Delete(POPUP_SOC_CF);
        PopupAndSound_Delete(POPUP_SystemFault);
        PopupAndSound_Delete(POPUP_SystemFault1);
        PopupAndSound_Delete(POPUP_GearFault);
        PopupAndSound_Delete(POPUP_WeightOverload);
        PopupAndSound_Delete(POPUP_RemoteLocking);
        PopupAndSound_Delete(POPUP_PositionNotClosed);
        PopupAndSound_Delete(POPUP_DepartureReminder);
        PopupAndSound_Delete(POPUP_OTA_0);
        PopupAndSound_Delete(POPUP_OTA_1);
        PopupAndSound_Delete(POPUP_OTA_2);
        PopupAndSound_Delete(POPUP_OTA_3);
        PopupAndSound_Delete(POPUP_OTA_4);
        PopupAndSound_Delete(POPUP_OTA_5);
        PopupAndSound_Delete(POPUP_ESC);
        PopupAndSound_Delete(POPUP_Over_Speed);
        if ( Get_LINE_IN_Sts(LINE_IN_DOOROPEN) == 1u )
        {
            Popup_Request(POPUP_DoorOpen);
        }

    }
    else
    {
        //制动液位低
        if ( Get_TelltalesLedSts(m_LED_BrakeSystemFault) == 1u )
        {
            Popup_Request(POPUP_EPB_Status);
        }
        else
        {
            PopupAndSound_Delete(POPUP_EPB_Status);
        }
        //驻车制动
        if((Get_ID_18FAB027_Sig_VCUHandbrakeSts() == 1) && (Get_DispVechileSpeed()>50u))
        {
            Popup_Request(POPUP_Park_Brak);
        }
        else
        {
             PopupAndSound_Delete(POPUP_Park_Brak);
        }

        // EBD故障
        if ( CAN_MSG_Status(ID_can0x18F0010B_Msg_Count) == CAN_SIG_NORMAL )
        {
            if ( Get_TelltalesLedSts(m_LED_EBD_fault) == 1u )
            {
                Popup_Request(POPUP_EBD_fault);
            }
            else
            {
                PopupAndSound_Delete(POPUP_EBD_fault);
            }
        }
        else
        {
            PopupAndSound_Delete(POPUP_EBD_fault);
        }
        
       
        
        if ( CAN_MSG_Status(ID_can0x18F0010B_Msg_Count) == CAN_SIG_NORMAL )
        {
            // ABS故障
            if ( Get_TelltalesLedSts(m_LED_ABS) == 1u )
            {
                Popup_Request(POPUP_ABS);
            }
            else
            {
                PopupAndSound_Delete(POPUP_ABS);
            }
        }
        else
        {
            PopupAndSound_Delete(POPUP_ABS);
        }

        if ( Common_Get_IG_Sts() == 1u )
        {
            if ( CAN_MSG_Status(ID_can0x18FECA10_Msg_Count) == CAN_SIG_NORMAL )
            {
                // EPS故障
                if ( Get_ID_18FECA10_Sig_EPSMalfunctionIndicatorLamp( ) == 1u )
                {
                    Popup_Request(POPUP_EPS);
                }
                else
                {
                    PopupAndSound_Delete(POPUP_EPS);
                }
            }
            else
            {
                PopupAndSound_Delete(POPUP_EPS);
            }
        }
        else
        {
            PopupAndSound_Delete(POPUP_EPS);
        }

        //电机故障
        if ( Get_TelltalesLedSts(m_LED_MotorFault) == 1u )
        {
            Popup_Request(POPUP_MotorFault);
        }
        else
        {
            PopupAndSound_Delete(POPUP_MotorFault);
        }

        //动力电池故障

       if ( (Get_TelltalesLedSts(m_LED_SOC_Fault) == 1u) )
       {
           Popup_Request(POPUP_SOC_Fault);
       }
       else
       {
           PopupAndSound_Delete(POPUP_SOC_Fault);
       }

        //高压绝缘故障
        if ( Get_TelltalesLedSts(m_LED_InsulationFault) == 1u )
        {
            Popup_Request(POPUP_InsulationFault);
        }
        else
        {
            PopupAndSound_Delete(POPUP_InsulationFault);
        }

        //电池热失控
        if ( Get_TelltalesLedSts(m_LED_SOC_HT) == 1u )
        {
            Popup_Request(POPUP_SOC_HT);
        }
        else
        {
            PopupAndSound_Delete(POPUP_SOC_HT);
        }
     
        //门开报警
        if ( Get_LINE_IN_Sts(LINE_IN_DOOROPEN) == 1u )
        {
            Popup_Request(POPUP_DoorOpen);
            if ( m_Vspeed >= 100u )
            {
                if ( Door_Warningtimer <= 600u )
                {
                    Door_Warningtimer++;
                    Popup_Request(POPUP_DoorOpen_1HZ);
                }
                else
                {
                    PopupAndSound_Delete(POPUP_DoorOpen_1HZ);
                }
            }
            else
            {
                PopupAndSound_Delete(POPUP_DoorOpen_1HZ);
            }
        }
        else
        {
            Door_Warningtimer = 0u;
            PopupAndSound_Delete(POPUP_DoorOpen_1HZ);
            PopupAndSound_Delete(POPUP_DoorOpen);
        }
        


        
        //Energy_Recovery
        //if ( Get_TelltalesLedSts(m_LED_Energy_Recovery) == 1u )
        //{
        //    Popup_Request(POPUP_Energy_Recovery);
        //}
        //else
        //{
        //    PopupAndSound_Delete(POPUP_Energy_Recovery);
        //}
        // ECO状态激活
        if ( Get_TelltalesLedSts(m_LED_ECO) == 1u )
        {
            Popup_Request(POPUP_ECO);
        }
        else
        {
            PopupAndSound_Delete(POPUP_ECO);
        }
        // READY状态激活
        if ( Get_TelltalesLedSts(m_LED_READY) == 1u )
        {
            Popup_Request(POPUP_READY);
        }
        else
        {
            PopupAndSound_Delete(POPUP_READY);
        }
        //限功率报警
        if ( Get_TelltalesLedSts(m_LED_PowerLimit) == 1u ) 
        {
            Popup_Request(POPUP_PowerLimit);
        }
        else
        {
            PopupAndSound_Delete(POPUP_PowerLimit);
        }
        //蓄电池电量低
        if ( Get_TelltalesLedSts(m_LED_SOC_LP) == 1u )
        {
            Popup_Request(POPUP_SOC_LP);
        }
        else
        {
            PopupAndSound_Delete(POPUP_SOC_LP);
        }
        //蓄电池充电故障
       
        if( Get_TelltalesLedSts(m_LED_SOC_CF)  == 1u )
        
       // if(Get_ID_18FAB027_Sig_VCUDCDCWorkSts( ) == 0)
        {  
             Popup_Request(POPUP_SOC_CF);
        }
        else
        {
            PopupAndSound_Delete(POPUP_SOC_CF);
        }

        //高压互锁指示灯
        if(Get_TelltalesLedSts(m_LED_HighPressureInterlock) == 1u)
        {  
             Popup_Request(POPUP_WeightOverload);
        }
        else
        {
            PopupAndSound_Delete(POPUP_WeightOverload);
        }

        //整车动力系统故障
        if ((Get_TelltalesLedSts(m_LED_SystemFault) == 1u) &&((Get_ID_18FAB027_Sig_VCUVehicleSysErrorLevel()==2u)))
        { 
            Popup_Request(POPUP_SystemFault);  
        }
        else
        {
            PopupAndSound_Delete(POPUP_SystemFault);
            
        }
        if ((Get_TelltalesLedSts(m_LED_SystemFault) == 1u) &&((Get_ID_18FAB027_Sig_VCUVehicleSysErrorLevel()==3u)))
        { 
            Popup_Request(POPUP_SystemFault1);  
        }
        else
        {
            PopupAndSound_Delete(POPUP_SystemFault1);
        }
        //换挡错误
   // if ( (CAN_MSG_Status(ID_PMS_PTInfoIndicate_Msg_Count) == 0u)
    //     && (Get_ID_18FAB027_Sig_PMS_GearOperateErr( ) == 1u) )
    
    //{
    //    Popup_Request(POPUP_GearFault);
    //}
    //else
    //{
    //    PopupAndSound_Delete(POPUP_GearFault);
    //}

        
            
        //远程锁车 
        if ( Common_Get_IG_Sts() == 1u )
        {
            if((Get_ID_18FA1727_Sig_VCU_LockVehPerFlag() == 1)&&(Get_ID_18FA1727_Sig_VCU_VersionConversionFlag() == 1)&&( Get_ID_18FA1727_Sig_VCU_SpdLmtLevel() == 0))
            {
                 Popup_Request(POPUP_RemoteLocking);
            }
            else if ( Get_ID_18FF5D27_Sig_VCU_LockVehSts() == 1u )
            {
                 Popup_Request(POPUP_RemoteLocking); 
            }
            else
            {
                 PopupAndSound_Delete(POPUP_RemoteLocking);  
            } 
        }
        else
        {
             PopupAndSound_Delete(POPUP_RemoteLocking);  
        } 
        
        //小灯未关
        if ( (IGstPopup1 == IGN_OFF) && (Get_LINE_IN_Sts(LINE_IN_DOOROPEN) == 1u)
             && (Get_LINE_IN_Sts(LINE_IN_POSITION) == 1u) )
        {
            
            Popup_Request(POPUP_PositionNotClosed);
            
        }
        else
        {
    
            PopupAndSound_Delete(POPUP_PositionNotClosed);
            
        }
        //驾驶员离车提醒
        if ( (Get_TelltalesLedSts(m_LED_READY) == 1u) && (Get_LINE_IN_Sts(LINE_IN_DOOROPEN) == 1u) )
        {
            Popup_Request(POPUP_DepartureReminder);
        }
        else
        {
            PopupAndSound_Delete(POPUP_DepartureReminder);
        }

        //超速报警  
        if(IGstPopup1 == IGN_ON)
        {
            if ( m_Vspeed > Over_Speed_Config )
            {
                Popup_Request(POPUP_Over_Speed);
                Over_Speed_Status = 1;
            }

            if(Over_Speed_Config >= 30)
            {
                if(m_Vspeed <= (Over_Speed_Config - 30))
                {
                    PopupAndSound_Delete(POPUP_Over_Speed);
                    Over_Speed_Status = 0;
                }
            }
        }
        else
        {
            PopupAndSound_Delete(POPUP_Over_Speed);
            Over_Speed_Status = 0;
        }
        /*雷达距离声音提示*/
        
        if(Val_EOL_F102_RadarType() == 2)//can雷达
        {
            if(IGstPopup1 == IGN_ON)
            {
                if((Get_ID_0CFF1ADA_Sig_PDC_VirtualDisplaySts() == 1u)&&(Get_ID_18FAB027_Sig_VCUGearPositionInd() == 0xDFu))
                {
                    switch ( Get_ID_0CFF1ADA_Sig_PDC_Warning_Frq() )
                    {
                        case 0:
                                RADAR_SOUND = 100;
                                break;
                        case 1:
                                RADAR_SOUND = POPUP_Radar_1HZ;
                                break;
                        case 2:
                                RADAR_SOUND = POPUP_Radar_2HZ;
                                break;
                        case 3:
                                RADAR_SOUND = POPUP_Radar_4HZ;
                                break;
                        case 4:
                                RADAR_SOUND = 100;
                                break;
                        case 5:
                                RADAR_SOUND = POPUP_Radar_Changming;
                                break;
                        default:
                                RADAR_SOUND = 100;
                                break;
                    }
                    if  (RADAR_SOUND == POPUP_Radar_1HZ)  
                    {

                        PopupAndSound_Delete(POPUP_Radar_2HZ);
                        PopupAndSound_Delete(POPUP_Radar_4HZ);
                        PopupAndSound_Delete(POPUP_Radar_Changming);
                        Popup_Request(POPUP_Radar_1HZ);
                    }
                    else if ( RADAR_SOUND == POPUP_Radar_2HZ )
                    {

                        PopupAndSound_Delete(POPUP_Radar_1HZ);
                        PopupAndSound_Delete(POPUP_Radar_4HZ);
                        PopupAndSound_Delete(POPUP_Radar_Changming);
                        Popup_Request(POPUP_Radar_2HZ);
                    }
                    else if ( RADAR_SOUND == POPUP_Radar_4HZ )
                    {
                    
                        PopupAndSound_Delete(POPUP_Radar_2HZ);
                        PopupAndSound_Delete(POPUP_Radar_1HZ);
                        PopupAndSound_Delete(POPUP_Radar_Changming);
                        Popup_Request(POPUP_Radar_4HZ);
                    }
                    else if ( RADAR_SOUND == POPUP_Radar_Changming )
                    {

                        PopupAndSound_Delete(POPUP_Radar_2HZ);
                        PopupAndSound_Delete(POPUP_Radar_4HZ);
                        PopupAndSound_Delete(POPUP_Radar_1HZ);
                        Popup_Request(POPUP_Radar_Changming);
                    }
                    else
                    {
                    
                        PopupAndSound_Delete(POPUP_Radar_2HZ);
                        PopupAndSound_Delete(POPUP_Radar_4HZ);
                        PopupAndSound_Delete(POPUP_Radar_1HZ);
                        PopupAndSound_Delete(POPUP_Radar_Changming);
                    }
                }
                else
                {
                    PopupAndSound_Delete(POPUP_Radar_2HZ);
                    PopupAndSound_Delete(POPUP_Radar_4HZ);
                    PopupAndSound_Delete(POPUP_Radar_1HZ);
                    PopupAndSound_Delete(POPUP_Radar_Changming); 
                }
            }
            else
            {
                PopupAndSound_Delete(POPUP_Radar_2HZ);
                PopupAndSound_Delete(POPUP_Radar_4HZ);
                PopupAndSound_Delete(POPUP_Radar_1HZ);
                PopupAndSound_Delete(POPUP_Radar_Changming); 
            }
        }
        else if(Val_EOL_F102_RadarType() == 3)
        {
            if(IGstPopup1 == IGN_ON)
            {
                switch (Radra_Get_Warning())
                {
                    case 1://2hz
                        PopupAndSound_Delete(POPUP_Radar_4HZ);
                        PopupAndSound_Delete(POPUP_RADAR_CHECK_OK);
                        PopupAndSound_Delete(POPUP_RADAR_SENSOR_FAILURE);
                        PopupAndSound_Delete(POPUP_Radar_Changming);
                        Popup_Request(POPUP_Radar_2HZ);
                        break;
                    case 2://4hz
                        PopupAndSound_Delete(POPUP_Radar_2HZ);
                        PopupAndSound_Delete(POPUP_Radar_Changming);
                        PopupAndSound_Delete(POPUP_RADAR_CHECK_OK);
                        PopupAndSound_Delete(POPUP_RADAR_SENSOR_FAILURE);
                        Popup_Request(POPUP_Radar_4HZ);
                        break;
                    case 3://长鸣
                        PopupAndSound_Delete(POPUP_Radar_2HZ);
                        PopupAndSound_Delete(POPUP_Radar_4HZ);
                        PopupAndSound_Delete(POPUP_RADAR_CHECK_OK);
                        PopupAndSound_Delete(POPUP_RADAR_SENSOR_FAILURE);
                        Popup_Request(POPUP_Radar_Changming);
                        break;
                    case 4://长鸣0.5s
                        PopupAndSound_Delete(POPUP_Radar_2HZ);
                        PopupAndSound_Delete(POPUP_Radar_4HZ);
                        PopupAndSound_Delete(POPUP_Radar_Changming);
                        PopupAndSound_Delete(POPUP_RADAR_SENSOR_FAILURE);
                        Popup_Request(POPUP_RADAR_CHECK_OK);
                        break;
                    case 5://雷达故障 长鸣2s
                        PopupAndSound_Delete(POPUP_Radar_2HZ);
                        PopupAndSound_Delete(POPUP_Radar_4HZ);
                        PopupAndSound_Delete(POPUP_RADAR_CHECK_OK);
                        PopupAndSound_Delete(POPUP_Radar_Changming);
                        Popup_Request(POPUP_RADAR_SENSOR_FAILURE);
                        break;
                    case 6://雷达数据超时 长鸣2s
                        PopupAndSound_Delete(POPUP_Radar_2HZ);
                        PopupAndSound_Delete(POPUP_Radar_4HZ);
                        PopupAndSound_Delete(POPUP_RADAR_CHECK_OK);
                        PopupAndSound_Delete(POPUP_Radar_Changming);
                        Popup_Request(POPUP_RADAR_SENSOR_FAILURE);
                        break;
                    default://0 不报警
                        PopupAndSound_Delete(POPUP_Radar_2HZ);
                        PopupAndSound_Delete(POPUP_Radar_4HZ);
                        PopupAndSound_Delete(POPUP_RADAR_CHECK_OK);
                        PopupAndSound_Delete(POPUP_Radar_Changming);
                        PopupAndSound_Delete(POPUP_RADAR_SENSOR_FAILURE);
                        break;
                }
            }
            else
            {
                PopupAndSound_Delete(POPUP_Radar_2HZ);
                PopupAndSound_Delete(POPUP_Radar_4HZ);
                PopupAndSound_Delete(POPUP_RADAR_CHECK_OK);
                PopupAndSound_Delete(POPUP_Radar_Changming);
                PopupAndSound_Delete(POPUP_RADAR_SENSOR_FAILURE);
            }
        }
        else
        {
            ;
        }

        // OTA处理
        if ( (CAN_MSG_Status(ID_TBOX_OTAStatus_Msg_Count) == 0u) && (IGstPopup1 == IGN_ON) )
        {
            if ( Get_ID_18FF639F_Sig_TBOX_OTA_DownloadRequest( ) == 0x1u )
            {
            }
            if ( (Get_ID_18FF639F_Sig_TBOX_OTA_DownloadState( ) == 0x01u)
                 && (Get_ID_18FF639F_Sig_TBOX_OTA_DownloadProgress( ) <= 0x64u) )
            {
            }
            if ( Get_ID_18FF639F_Sig_TBOX_OTA_DownloadState( ) == 0x03u )
            {
                Popup_Request(POPUP_OTA_0);
            }
            else
            {
                PopupAndSound_Delete(POPUP_OTA_0);
            }

            if ( Get_ID_18FF639F_Sig_TBOX_OTA_UpdateRequest( ) == 0x01u )
            {
                Popup_Request(POPUP_OTA_1);
            }
            else
            {
                PopupAndSound_Delete(POPUP_OTA_1);
            }

            if ( Get_ID_18FF639F_Sig_TBOX_OTA_DisclaimerWarning( ) == 0x01u )
            {
                Popup_Request(POPUP_OTA_2);
            }
            else
            {
                PopupAndSound_Delete(POPUP_OTA_2);
            }

            if ( (Get_ID_18FF639F_Sig_TBOX_OTA_PreConditionDetect( ) == 0x01u)
                 && ((Get_ID_18FF639F_Sig_TBOX_OTA_FailedReason_PowerMode( ) == 0x01u)
                     || (Get_ID_18FF639F_Sig_TBOX_OTA_FailedReason_GearPos( ) == 0x01u)
                     || (Get_ID_18FF639F_Sig_TBOX_OTA_FailedReason_VehicleSpd( ) == 0x01u)
                     || (Get_ID_18FF639F_Sig_TBOX_OTA_FailedReason_BattVol( ) == 0x01u)
                     || (Get_ID_18FF639F_Sig_TBOX_OTA_FailedReason_HandBrake( ) == 0x01u)
                     || (Get_ID_18FF639F_Sig_TBOX_OTA_FailedReason_ChgStatus( ) == 0x01u)) )
            {
            }
            if ( Get_ID_18FF639F_Sig_TBOX_OTA_UpdateState( ) == 0x01u )
            {
            }
            if ( Get_ID_18FF639F_Sig_TBOX_OTA_UpdateState( ) == 0x02u )
            {
                Popup_Request(POPUP_OTA_3);
            }
            else
            {
                PopupAndSound_Delete(POPUP_OTA_3);
            }
            if ( Get_ID_18FF639F_Sig_TBOX_OTA_UpdateState( ) == 0x06u )
            {
                Popup_Request(POPUP_OTA_4);
            }
            else
            {
                PopupAndSound_Delete(POPUP_OTA_4);
            }
            if ( Get_ID_18FF639F_Sig_TBOX_OTA_UpdateState( ) == 0x05u )
            {
                Popup_Request(POPUP_OTA_5);
            }
            else
            {
                PopupAndSound_Delete(POPUP_OTA_5);
            }
        }
        else
        {
            PopupAndSound_Delete(POPUP_OTA_0);
            PopupAndSound_Delete(POPUP_OTA_1);
            PopupAndSound_Delete(POPUP_OTA_2);
            PopupAndSound_Delete(POPUP_OTA_3);
            PopupAndSound_Delete(POPUP_OTA_4);
            PopupAndSound_Delete(POPUP_OTA_5);
        }
    }
}

uint8_t Get_POP_3S_Clock(void)
{
    return POP_3S_Clock;
}

uint8_t Get_CPDWarning_Valid(void)
{
    return CPDWarning_Valid;
}

uint8_t Get_CPDWarningSts(void)
{
    return CPDWarningSts;
}

void Popups_Sound_Playing(uint8_t PopupSnd)
{
    uint8_t ReqCode;
    ReqCode = Popup_Get_Current_Sound_Req_Code( );
    // PopupSnd =SND_RADAR;
    // RADAR_SOUND=RADAR_SND_CONTINUOUS;
    // switch ( PopupSnd )
    // {
        // case SND_RADAR:
        //     if ( RADAR_SOUND == RADAR_SND_CONTINUOUS )
        //     {
        //         Sound_Delete(SND_RADAR_1HZ);
        //         Sound_Delete(SND_RADAR_2HZ);
        //         Sound_Delete(SND_RADAR_4HZ);
        //         Sound_Request(SND_RADAR_Changming, ReqCode);
        //     }
        //     else if ( RADAR_SOUND == RADAR_SND_2Hz )
        //     {
        //         Sound_Delete(SND_RADAR_1HZ);
        //         Sound_Delete(SND_RADAR_4HZ);
        //         Sound_Delete(SND_RADAR_Changming);
        //         Sound_Request(SND_RADAR_2HZ, ReqCode);
        //     }
        //     else if ( RADAR_SOUND == RADAR_SND_4Hz )
        //     {
        //         Sound_Delete(SND_RADAR_1HZ);
        //         Sound_Delete(SND_RADAR_2HZ);
        //         Sound_Delete(SND_RADAR_Changming);
        //         Sound_Request(SND_RADAR_4HZ, ReqCode);
        //     }
        //     else
        //     {
        //         Sound_Delete(SND_RADAR_1HZ);
        //         Sound_Delete(SND_RADAR_2HZ);
        //         Sound_Delete(SND_RADAR_4HZ);
        //         Sound_Delete(SND_RADAR_Changming);
        //     }
        //     break;
        // default:
            if ( ReqCode )
            {
                Sound_Request(PopupSnd, ReqCode);
            }
            else
            {
                Sound_Delete(PopupSnd);
            }
           // break;
    //}
}

uint8_t Get_OIL_LOW_Sts(void)
{
    return OIL_Low_popup_flag;
}
uint8_t Get_OverSpeed_Sts(void)
{
    return OverSpeed;
}
uint8_t PopupGetIGst(void)
{
    return IGstPopup;
}