/**********************************************************************************************************
 * Copyright(C) 2017, HeiLongJiang TYW Co.,Ltd.
 *
 * @Filename:       PowerManagement.h
 *
 * @Description:    电源管理服务文件
 *
 * @Functions List:
 *
 *
 * @History:        Version:            V0.0.1
                              Date:             2018-08-23 15:57:00
                    Author:
                    Modification:
 **********************************************************************************************************/
#ifndef _POWER_MANAGEMENT_H_
#define _POWER_MANAGEMENT_H_

/**********************************************************************************************************
 * Include
*/

#include "stdint.h"

/**********************************************************************************************************
 * Constants and defines
 */

typedef enum
{
    _IGN_OFF_Init,
    _IGN_OFF,
    _IGN_Sleep_Init,
    _IGN_Sleep,
    _IGN_Wakeup,
    _IGN_ON_Init,
    _IGN_ON,
    _IGN_LVP,
    _IGN_OVP,
    _IGN_LIMIT,
} Power_Status_t;
/**********************************************************************************************************
 * Local variables
 */

/**********************************************************************************************************
 * Local functions
 */

/**********************************************************************************************************
 * Global variables
 */

/**********************************************************************************************************
 * Global functions
 */

/**********************************************************************************************************
函数声明
 **********************************************************************************************************/
void Power_Management_Init ( void );
void Power_Management_Service ( void );

void Power_KL30_Init ( void );
void Power_KL15_Init ( void );
void Power_Wakeup_Init ( void );
static void Power_Sleep_Init ( void );
static void  Power_IgnOff_Init(void);

uint16_t GetCANModeFlag(void);
void Clear_CANModeFlag(void);
void SetCANModeFlag(void);
uint8_t MSCAN0_Is_Exist_Frame ( void );


void Sys_Stop_Task(void);
void Power_Sleep_100ms_ISR(void);



static void IGN_OFF_State_Keep ( void );
static void Power_Sleep_Loop ( void ); 
static void Delay_Ms(uint16_t t);
static void Power_Sleep_Rolling_Init(void);
static void Power_Sleep_Rolling_Tack(void);

/**********************************************************************************************************
 **********************************************************************************************************/

extern  Power_Status_t  g_Power_St ;          /*当前实际电源状态*/

extern uint16_t SleepTime_Timing;           /*IGNOFF 到 Sleep 休眠计时*/

#endif