#include "HSSPI0.h"
#include "WDT.h"



static int hsspi_CalibrationDlpSingle(void);
static void hsspi_CheckQuadBitSingle(void);

#define HSSPI_START_ADDRESS   0x80000000
/******************************************************************************
** \brief hsspi_SetSingleQuad
**
** \return Execution result
** \retval 0  :DLP Calibration Successful completion.
** \retval 1  :DLP Calibration failure. There is a line without Pass area.
**
*****************************************************************************/
int hsspi_SetSingleQuad(void)
{
    unsigned int RXFIFO[15];

    hsspi_CheckQuadBitSingle();  /*Check for QUAD bit in Configuration Register of QUAD Flash.*/
    /*If QUAD bit has been already set to 1, this function is unnecessary.*/

    /******** Direct Mode Configuration ********/
    //  DDRHSSPI0_PCC0 =  0x00010020;
    DDRHSSPI0_PCC0_SSELDEASRT = 0;
    DDRHSSPI0_PCC0_CDRS = 0;
    DDRHSSPI0_PCC0_SS2CD = 0;
    /*1.[bit20:16]Slave Selection De-Assertion Timeout = 1: SDR = 4 x SCLK cycle, DDR = 3.5 x SCLK cycle(Minimum setting)*/
    /*  [bit12:9] Clock Division = 0: Divide by 2. SCLK:60MHz*/
    /*  [bit6:5]  Slave Select to Clock Delay = 1: 1.75 SCLK*/
    DDRHSSPI0_MCTRL = 0x00000000;    /*1.[bit1]    Command Sequencer Mode Enable = 0: Direct Mode is enabled. Command Sequencer Mode is disabled.*/
    DDRHSSPI0_DMTRP = 0x0A;
    /*2.[bit5]  =0  SDR Mode*/
    /*  [bit3:0]  Transfer Protocol: TX-Only in Quad Mode is configured.*/
    DDRHSSPI0_DMFIFOCFG = 0x001C0F0F;
    /*3.[bit20]   TX-FIFO Flush = 1: Writing "1" flushes the TX-FIFO and TX Shift Register.*/
    /*  [bit19]   RX-FIFO Flush = 1: Writing "1" flushes the RX-FIFO and RX Shift Register.*/
    /*  [bit18]   TXCTRL Bit to be Written to TX-FIFO*/
    /*  [bit17:16]FIFO Width = 0: TX-FIFO, RX-FIFO and Shift-Register are 8-bit wide.*/
    /*  [bit12:8] TX-FIFO Threshold Level = 15*/
    /*  [bit4:0]  RX-FIFO Threshold Level = 15*/
    DDRHSSPI0_TXE = 0x0;             /*  TX interrupts are not used.*/
    DDRHSSPI0_RXE = 0x0;             /*  RX interrupts are not used.*/
    DDRHSSPI0_TXC = 0x00000077;      /*  TX interrupt flags are cleared.*/
    DDRHSSPI0_RXC = 0x000000FB;      /*  RX interrupt flags are cleared.*/
    DDRHSSPI0_DMPSEL = 0x0;          /*  [bit1:0]  Peripheral Select = 0: oDDRHSSPIn_SSEL0 is asserted.*/
    DDRHSSPI0_MCTRL = 0x00000001;    /*5.[bit0]    Module Enable = 1: DDRHSSPI is enabled.*/
    DDRHSSPI0_DMCFG = 0x02;
    /*Figure 4-10 Programmer's Flowchart: General Steps 3.*/
    /*  [bit1]   Slave Select De-Assertion Control = 1: Byte Counter Mode. DDRHSSPIn_DMBCC.BCC is used to decide when to de-assert the Slave Select.*/
    /******** Command Sequencer modeConfiguration ********/
    /* Set register RDCSDC according to S25FL256S manual "Figure 10.50 Continuous DDR Quad I/O Read Subsequent Access"*/
    DDRHSSPI0_RDCSDC0 = 0x0201;      /*  [bit15:8] RDCSDATA[7:0] Transmit address bits [23:16] of the Serial Flash Memory address*/
    DDRHSSPI0_RDCSDC1 = 0x0101;      /*  [bit15:8] RDCSDATA[7:0] Transmit address bits [15:8] of the Serial Flash Memory address*/
    DDRHSSPI0_RDCSDC2 = 0x0001;      /*  [bit15:8] RDCSDATA[7:0] Transmit address bits [7:0] of the Serial Flash Memory address*/
    DDRHSSPI0_RDCSDC3 = 0x2000;      /*  [bit15:8] RDCSDATA[7:0] If DEC bit is "0", the data byte in RDCSDATA[7:0] is transmitted as Mode*/
    DDRHSSPI0_RDCSDC4 = 0x1C01;      /*  [bit15:8] RDCSDATA[7:0] 4Dummy */
    DDRHSSPI0_RDCSDC5 = 0x0701;      /*  [bit15:8] RDCSDATA[7:0] End of list*/


    while (1)                                  /*Check completion of Software Reset of QUAD Flash*/
    {
        DDRHSSPI0_DMFIFOCFG_TXFLSH = 1;  /*  TX-FIFO Flush = 1: Writing "1" flushes the TX-FIFO and TX Shift Register.*/
        DDRHSSPI0_DMFIFOCFG_RXFLSH = 1;  /*  RX-FIFO Flush = 1: Writing "1" flushes the RX-FIFO and RX Shift Register.*/

    /******** Transfer in Direct Mode (Command:EB)********/
    DDRHSSPI0_DMBCC = 13;        /*2.[bit15:0] Byte Count Control = 12*/
    DDRHSSPI0_TXFIFO0 = 0x00001094;  /*  QUAD Flash. DDR Quad I/O Read (EEh)*/
    DDRHSSPI0_TXFIFO0 = 0x00001200;  /*ADDR*/
    DDRHSSPI0_TXFIFO0 = 0x00001200;  /*ADDR*/
    DDRHSSPI0_TXFIFO0 = 0x00001200;  /*ADDR*/
    DDRHSSPI0_TXFIFO0 = 0x00001200;  /*Mode*/
    DDRHSSPI0_TXFIFO0 = 0x00000000;  /*Dummy*/
    DDRHSSPI0_TXFIFO0 = 0x00000000;  /*Dummy*/
    DDRHSSPI0_TXFIFO0 = 0x00000000;  /*Dummy*/
    DDRHSSPI0_TXFIFO0 = 0x00000000;  /*Dummy*/
    DDRHSSPI0_TXFIFO0 = 0x00001000;  /*ID*/
    DDRHSSPI0_TXFIFO0 = 0x00001000;  /*ID*/
    DDRHSSPI0_TXFIFO0 = 0x00001000;  /*ID*/
    DDRHSSPI0_TXFIFO0 = 0x00001000;  /*ID*/
    DDRHSSPI0_DMSTART_START = 0x01;  /*7.[bit0]    Start Transfer = 1*/
    while (DDRHSSPI0_DMSTART_START)  /* In case of user program, countermeasure of infinite loop is recommended. */
    {
        WDT_Clear();
    }



        RXFIFO[0] = DDRHSSPI0_RXFIFO0;  /*Read Instruction part*/
        RXFIFO[1] = DDRHSSPI0_RXFIFO1;  /*Read Configuration Register part*/
        RXFIFO[2] = DDRHSSPI0_RXFIFO2;  /*Read Instruction part*/
        RXFIFO[3] = DDRHSSPI0_RXFIFO3;  /*Read Configuration Register part*/
        RXFIFO[4] = DDRHSSPI0_RXFIFO4;  /*Read Instruction part*/
        RXFIFO[5] = DDRHSSPI0_RXFIFO5;  /*Read Configuration Register part*/
        RXFIFO[6] = DDRHSSPI0_RXFIFO6;  /*Read Configuration Register part*/
        RXFIFO[7] = DDRHSSPI0_RXFIFO7;  /*Read Configuration Register part*/
        RXFIFO[8] = DDRHSSPI0_RXFIFO8;  /*Read Configuration Register part*/
        RXFIFO[9] = DDRHSSPI0_RXFIFO9;  /*Read Configuration Register part*/
        RXFIFO[10] = DDRHSSPI0_RXFIFO10;  /*Read Configuration Register part*/
        RXFIFO[11] = DDRHSSPI0_RXFIFO11;  /*Read Configuration Register part*/
        RXFIFO[12] = DDRHSSPI0_RXFIFO12;  /*Read Configuration Register part*/
        RXFIFO[13]= DDRHSSPI0_RXFIFO13;  /*Read Configuration Register part*/

        if ((RXFIFO[1] & 0x01) == 0x0)
        {
            break;
        }
        WDT_Clear();
    }
    /******** Transfer in Direct Mode (Command:EB)********/
    DDRHSSPI0_DMBCC = 13;        /*2.[bit15:0] Byte Count Control = 12*/
    DDRHSSPI0_TXFIFO0 = 0x000010Eb;  /*  QUAD Flash. DDR Quad I/O Read (EEh)*/
    DDRHSSPI0_TXFIFO0 = 0x00001200;  /*ADDR*/
    DDRHSSPI0_TXFIFO0 = 0x00001200;  /*ADDR*/
    DDRHSSPI0_TXFIFO0 = 0x00001200;  /*ADDR*/
    DDRHSSPI0_TXFIFO0 = 0x00001220;  /*Mode*/
    DDRHSSPI0_TXFIFO0 = 0x00000000;  /*Dummy*/
    DDRHSSPI0_TXFIFO0 = 0x00000000;  /*Dummy*/
    DDRHSSPI0_TXFIFO0 = 0x00000000;  /*Dummy*/
    DDRHSSPI0_TXFIFO0 = 0x00000000;  /*Dummy*/
    DDRHSSPI0_TXFIFO0 = 0x00001000;  /*ID*/
    DDRHSSPI0_TXFIFO0 = 0x00001000;  /*ID*/
    DDRHSSPI0_TXFIFO0 = 0x00001000;  /*ID*/
    DDRHSSPI0_TXFIFO0 = 0x00001000;  /*ID*/
    DDRHSSPI0_DMSTART_START = 0x01;  /*7.[bit0]    Start Transfer = 1*/
    while (DDRHSSPI0_DMSTART_START)  /* In case of user program, countermeasure of infinite loop is recommended. */
    {
        WDT_Clear();
    }

    /******** DLP Calibration ********/
    DDRHSSPI0_CSCFG = 0x008F0104;
    /*3.[bit23]    ITIMER is enabled. SSEL is de-asserted after the time expiration, that has been programmed in DDRHSSPIn_CSITIME Register.*/
    /*  [bit19:16] Slave Select MSEL0~3*/
    /*  [bit8]     Slave Select 0 Enable*/
    /*  [bit3]     SDR Mode in Command Sequencer Mode.*/
    /*  [bit2:1]   Serial transfer works at Quad Protocol. Read data is sampled on SDATA[3:0].*/
    //DDRHSSPI0_DLP = 0x34;     无DLP       /*It must be set the same as QUAD Flash.*/
    /*  [bit7:0]   Data Learning Pattern*/
    return hsspi_CalibrationDlpSingle();

}

/******************************************************************************
** \brief hsspi_CheckQuadBitSingle
**
** \note
**
** \post
**
*****************************************************************************/
void hsspi_CheckQuadBitSingle(void)
{
    unsigned int RXFIFO[7];

    /*DDRHSSPI    Cypress S25FL256S*/
    /******** Direct Mode Configuration ********   Figure 4-11 Programmer's Flowchart: DDRHSSPI in Direct Mode of Operation*/
    //  DDRHSSPI0_PCC0 =  0x00010020;
    DDRHSSPI0_PCC0_SSELDEASRT = 1;
    DDRHSSPI0_PCC0_CDRS = 15;
    DDRHSSPI0_PCC0_SS2CD = 3;
    /*1.[bit20:16]Slave Selection De-Assertion Timeout = 1: SDR = 4 x SCLK cycle, DDR = 3.5 x SCLK cycle(Minimum setting)*/
    /*  [bit12:9] Clock Division = 1: Divide by 4. SCLK:60MHz*/
    /*  [bit6:5]  Slave Select to Clock Delay = 1: 1.75 SCLK*/
    DDRHSSPI0_MCTRL = 0x00000000;    /*1.[bit1]    Command Sequencer Mode Enable = 0: Direct Mode is enabled. Command Sequencer Mode is disabled.*/
    DDRHSSPI0_DMTRP = 0x00;          /*2.[bit5]    SDR Mode*/
    /*  [bit3:0]  Transfer Protocol: TX-and-RX in Legacy Mode is configured.*/
    DDRHSSPI0_DMFIFOCFG = 0x001C080F;/*3.[bit20]   TX-FIFO Flush = 1: Writing "1" flushes the TX-FIFO and TX Shift Register.*/
    /*  [bit19]   RX-FIFO Flush = 1: Writing "1" flushes the RX-FIFO and RX Shift Register.*/
    /*  [bit18]   TXCTRL Bit to be Written to TX-FIFO*/
    /*  [bit17:16]FIFO Width = 0: TX-FIFO, RX-FIFO and Shift-Register are 8-bit wide.*/
    /*  [bit12:8] TX-FIFO Threshold Level = 8*/
    /*  [bit4:0]  RX-FIFO Threshold Level = 15*/
    DDRHSSPI0_TXE = 0x0;             /*  TX interrupts are not used.*/
    DDRHSSPI0_RXE = 0x0;             /*  RX interrupts are not used.*/
    DDRHSSPI0_TXC = 0x00000077;      /*  TX interrupt flags are cleared.*/
    DDRHSSPI0_RXC = 0x000000FB;      /*  RX interrupt flags are cleared.*/
    DDRHSSPI0_DMPSEL = 0x0;          /*  [bit1:0]  Peripheral Select = 0: oDDRHSSPIn_SSEL0 is asserted.*/
    DDRHSSPI0_MCTRL = 0x00000001;    /*5.[bit0]    Module Enable = 1: DDRHSSPI is enabled.*/
    DDRHSSPI0_DMCFG = 0x02;          /*Figure 4-10 Programmer's Flowchart: General Steps 3.*/
    /*  [bit1]   Slave Select De-Assertion Control = 1: Byte Counter Mode. DDRHSSPIn_DMBCC.BCC is used to decide when to de-assert the Slave Select.*/

    WDT_Clear();

    /******** Transfer in Direct Mode (Command:F0)********/
    //DDRHSSPI0_DMBCC = 0x0001;        /*2.[bit15:0] Byte Count Control = 1*/
    //DDRHSSPI0_TXFIFO0 = 0x000010F0;  /*  QUAD Flash. Software Reset Command (RESET F0h)*/
    //DDRHSSPI0_DMSTART_START = 0x01;  /*7.[bit0]    Start Transfer = 1*/
    //while(DDRHSSPI0_DMSTART_START){  /* In case of user program, countermeasure of infinite loop is recommended. */
    //    ClearWatchdog();
    //}

    while (1)                                  /*Check completion of Software Reset of QUAD Flash*/
    {
        DDRHSSPI0_DMFIFOCFG_TXFLSH = 1;  /*  TX-FIFO Flush = 1: Writing "1" flushes the TX-FIFO and TX Shift Register.*/
        DDRHSSPI0_DMFIFOCFG_RXFLSH = 1;  /*  RX-FIFO Flush = 1: Writing "1" flushes the RX-FIFO and RX Shift Register.*/

        /******** Transfer in Direct Mode (Command:05)********/
        DDRHSSPI0_DMBCC = 0x0004;        /*2.[bit15:0] Byte Count Control = 2*/
        DDRHSSPI0_TXFIFO0 = 0x00001005;  /*  QUAD Flash. Read Status Register-1 (RDSR1 05h)   WIP(Write in Progress) bit is checked.*/
        DDRHSSPI0_TXFIFO0 = 0x00001000;  /*  Get 1 byte of register data.*/
        DDRHSSPI0_TXFIFO0 = 0x00001000;  /*  QUAD Flash. Read Status Register-1 (RDSR1 05h)   WIP(Write in Progress) bit is checked.*/
        DDRHSSPI0_TXFIFO0 = 0x00001000;  /*  Get 1 byte of register data.*/

        DDRHSSPI0_DMSTART_START = 0x01;  /*7.[bit0]    Start Transfer = 1*/
        while (DDRHSSPI0_DMSTART_START)  /* In case of user program, countermeasure of infinite loop is recommended. */
        {
            WDT_Clear();
        }

        RXFIFO[0] = DDRHSSPI0_RXFIFO0;  /*Read Instruction part*/
        RXFIFO[1] = DDRHSSPI0_RXFIFO1;  /*Read Configuration Register part*/
        RXFIFO[2] = DDRHSSPI0_RXFIFO2;  /*Read Instruction part*/
        RXFIFO[3] = DDRHSSPI0_RXFIFO3;  /*Read Configuration Register part*/
        RXFIFO[4] = DDRHSSPI0_RXFIFO4;  /*Read Instruction part*/
        RXFIFO[5] = DDRHSSPI0_RXFIFO5;  /*Read Configuration Register part*/

        if ((RXFIFO[1] & 0x01) == 0x0)
        {
            break;
        }
        WDT_Clear();
    }


    while (1)                                  /*Check completion of Software Reset of QUAD Flash*/
    {
        DDRHSSPI0_DMFIFOCFG_TXFLSH = 1;  /*  TX-FIFO Flush = 1: Writing "1" flushes the TX-FIFO and TX Shift Register.*/
        DDRHSSPI0_DMFIFOCFG_RXFLSH = 1;  /*  RX-FIFO Flush = 1: Writing "1" flushes the RX-FIFO and RX Shift Register.*/

        /******** Transfer in Direct Mode (Command:05)********/
        DDRHSSPI0_DMBCC = 0x0007;        /*2.[bit15:0] Byte Count Control = 2*/
        DDRHSSPI0_TXFIFO0 = 0x00001090;  /*  QUAD Flash. Read Status Register-1 (RDSR1 05h)   WIP(Write in Progress) bit is checked.*/
        DDRHSSPI0_TXFIFO0 = 0x00001000;  /*  Get 1 byte of register data.*/
        DDRHSSPI0_TXFIFO0 = 0x00001000;  /*  QUAD Flash. Read Status Register-1 (RDSR1 05h)   WIP(Write in Progress) bit is checked.*/
        DDRHSSPI0_TXFIFO0 = 0x00001000;  /*  Get 1 byte of register data.*/
        DDRHSSPI0_TXFIFO0 = 0x00001000;  /*  Get 1 byte of register data.*/
        DDRHSSPI0_TXFIFO0 = 0x00001000;  /*  QUAD Flash. Read Status Register-1 (RDSR1 05h)   WIP(Write in Progress) bit is checked.*/
        DDRHSSPI0_TXFIFO0 = 0x00001000;  /*  Get 1 byte of register data.*/
        DDRHSSPI0_DMSTART_START = 0x01;  /*7.[bit0]    Start Transfer = 1*/
        while (DDRHSSPI0_DMSTART_START)  /* In case of user program, countermeasure of infinite loop is recommended. */
        {
            WDT_Clear();
        }

        RXFIFO[0] = DDRHSSPI0_RXFIFO0;  /*Read Instruction part*/
        RXFIFO[1] = DDRHSSPI0_RXFIFO1;  /*Read Configuration Register part*/
        RXFIFO[2] = DDRHSSPI0_RXFIFO2;  /*Read Instruction part*/
        RXFIFO[3] = DDRHSSPI0_RXFIFO3;  /*Read Configuration Register part*/
        RXFIFO[4] = DDRHSSPI0_RXFIFO4;  /*Read Configuration Register part*/
        RXFIFO[5] = DDRHSSPI0_RXFIFO5;  /*Read Instruction part*/
        RXFIFO[6] = DDRHSSPI0_RXFIFO6;  /*Read Configuration Register part*/

        if ((RXFIFO[1] & 0x01) == 0x0)
        {
            break;
        }
        WDT_Clear();
    }

    /******** Transfer in Direct Mode (Command:35)********/
    //DDRHSSPI0_DMBCC = 0x0002;        /*2.[bit15:0] Byte Count Control = 2*/
    //DDRHSSPI0_TXFIFO0 = 0x00001035;  /*  QUAD Flash. Read Configuration Register-1 (RDCR 35h)   Latency Code and QUAD bit are checked.*/
    //DDRHSSPI0_TXFIFO0 = 0x00001000;  /*  Get 1 byte of register data.*/
    //DDRHSSPI0_DMSTART_START = 0x01;  /*7.[bit0]    Start Transfer = 1*/
    //while(DDRHSSPI0_DMSTART_START){  /* In case of user program, countermeasure of infinite loop is recommended. */
    //    ClearWatchdog();
    //}
    //
    //RXFIFO[0] = DDRHSSPI0_RXFIFO0;   /*Read Instruction part*/
    //RXFIFO[1] = DDRHSSPI0_RXFIFO1;   /*Read Status Register part*/
    //
    //if((RXFIFO[1] & 0xC2) != 0x2 )     /*Check for QUAD bit in Configuration Register of a QUAD Flash.*/
    {

        /******** Transfer in Direct Mode (Command:06)********/
        DDRHSSPI0_DMBCC = 0x01;          /*2.[bit15:0] Byte Count Control = 1*/
        DDRHSSPI0_TXFIFO0 = 0x00001006;  /*  QUAD Flash. Write Enable (WREN 06h)   Required command before Write Registers (WRR 01h)*/
        DDRHSSPI0_DMSTART_START = 0x01;  /*7.[bit0]    Start Transfer = 1*/
        while (DDRHSSPI0_DMSTART_START)  /* In case of user program, countermeasure of infinite loop is recommended. */
        {
            WDT_Clear();
        }

        /******** Transfer in Direct Mode (Command:01)********   LC[7:6]=0 EEh:Dummy=6 , QUAD[1]=1 Quad*/
        DDRHSSPI0_DMBCC = 0x02;          /*2.[bit15:0] Byte Count Control = 3*/
        DDRHSSPI0_TXFIFO0 = 0x00001031;  /*  QUAD Flash. Write Registers (WRR 01h)*/
        DDRHSSPI0_TXFIFO0 = 0x00001002;  /*LC[7:6]=0*/
        //DDRHSSPI0_TXFIFO0 = 0x00001002;  /*QUAD[1]=1*/
        DDRHSSPI0_DMSTART_START = 0x01;  /*7.[bit0]    Start Transfer = 1*/
        while (DDRHSSPI0_DMSTART_START)  /* In case of user program, countermeasure of infinite loop is recommended. */
        {
            WDT_Clear();
        }



        while (1)                                     /*Check completion of writing of a QUAD Flash*/
        {
            DDRHSSPI0_DMFIFOCFG_TXFLSH = 1;  /*  TX-FIFO Flush = 1: Writing "1" flushes the TX-FIFO and TX Shift Register.*/
            DDRHSSPI0_DMFIFOCFG_RXFLSH = 1;  /*  RX-FIFO Flush = 1: Writing "1" flushes the RX-FIFO and RX Shift Register.*/

            /******** Transfer in Direct Mode (Command:05)********/
            DDRHSSPI0_DMBCC = 0x0003;        /*2.[bit15:0] Byte Count Control = 2*/
            DDRHSSPI0_TXFIFO0 = 0x00001035;  /*  QUAD Flash. Read Status Register-1 (RDSR1 05h)   WIP(Write in Progress) bit is checked.*/
            DDRHSSPI0_TXFIFO0 = 0x00001000;  /*  Get 1 byte of register data. Read Status Register*/
            DDRHSSPI0_TXFIFO0 = 0x00001000;  /*  Get 1 byte of register data. Read Status Register*/
            DDRHSSPI0_DMSTART_START = 0x01;  /*7.[bit0]    Start Transfer = 1*/
            while (DDRHSSPI0_DMSTART_START)  /* In case of user program, countermeasure of infinite loop is recommended. */
            {
                WDT_Clear();
            }

            RXFIFO[0] = DDRHSSPI0_RXFIFO0;  /*Read Instruction part*/
            RXFIFO[1] = DDRHSSPI0_RXFIFO1;  /*Read Status Register part*/
            RXFIFO[2] = DDRHSSPI0_RXFIFO2;  /*Read Status Register part*/
            if ((RXFIFO[1] & 0x01) == 0x0)
            {
                break;
            }
            WDT_Clear();
        }
    }
}
/******************************************************************************
** \brief hsspi_CalibrationDlpSingle
**
** \return Execution result
** \retval 0  :DLP Calibration Successful completion.
** \retval 1  :DLP Calibration failure. There is a line without Pass area.
**
*****************************************************************************/
static int hsspi_CalibrationDlpSingle(void)
{

    /* NOTE: Please execute "GRPSUB_BUSM_MonitorInterruptEnable = 0x0;" at main() only once */

    unsigned char i_SamplingPoints, i_BitLanes;
    //unsigned int passWindowSize=0;
    volatile unsigned int test = 0;
    volatile unsigned int dummyRead = 0;
    unsigned int dlpStatus[64];
    unsigned int passWindowTotal[4];
    volatile unsigned int *data;
    volatile unsigned int *dlpCheckAddress;


    DDRHSSPI0_SDATASAMPLEPTCNT0 = 21;//passWindowTotal[0];  /*  [bit6:0]  This field defines, for an incoming SDATA0 port, sample clock delay.*/
    DDRHSSPI0_SDATASAMPLEPTCNT1 = 21;//passWindowTotal[0];  /*  [bit6:0]  This field defines, for an incoming SDATA1 port, sample clock delay.*/
    DDRHSSPI0_SDATASAMPLEPTCNT2 = 21;//passWindowTotal[0];  /*  [bit6:0]  This field defines, for an incoming SDATA2 port, sample clock delay.*/
    DDRHSSPI0_SDATASAMPLEPTCNT3 = 21;//passWindowTotal[0];
    data = (unsigned int *)HSSPI_START_ADDRESS;

    /*Command Sequencer mode*/
    DDRHSSPI0_MCTRL = 0x00000003;    /*  [bit5]    Data Learning Pattern Enable = 0: DLP is disabled.*/
    /*  [bit1]    Command Sequencer Mode Enable = 1: Command Sequencer Mode is enabled. Direct Mode is disabled.*/
    /*  [bit0]    Module Enable = 1: DDRHSSPI is enabled.*/


    DDRHSSPI0_SDATASAMPLEPTCNT0 = 21;//passWindowTotal[0];  /*  [bit6:0]  This field defines, for an incoming SDATA0 port, sample clock delay.*/
    DDRHSSPI0_SDATASAMPLEPTCNT1 = 21;//passWindowTotal[0];  /*  [bit6:0]  This field defines, for an incoming SDATA1 port, sample clock delay.*/
    DDRHSSPI0_SDATASAMPLEPTCNT2 = 21;//passWindowTotal[0];  /*  [bit6:0]  This field defines, for an incoming SDATA2 port, sample clock delay.*/
    DDRHSSPI0_SDATASAMPLEPTCNT3 = 21;//passWindowTotal[0];

    DDRHSSPI0_SDATASAMPLEPTLFT0 = DDRHSSPI0_SDATASAMPLEPTCNT0;  /*  [bit6:0]  SDATA0 Left Clock Sample Point Control*/
    DDRHSSPI0_SDATASAMPLEPTLFT1 = DDRHSSPI0_SDATASAMPLEPTCNT1;  /*  [bit6:0]  SDATA1 Left Clock Sample Point Control*/
    DDRHSSPI0_SDATASAMPLEPTLFT2 = DDRHSSPI0_SDATASAMPLEPTCNT2;  /*  [bit6:0]  SDATA2 Left Clock Sample Point Control*/
    DDRHSSPI0_SDATASAMPLEPTLFT3 = DDRHSSPI0_SDATASAMPLEPTCNT3;

    DDRHSSPI0_SDATASAMPLEPTRGH0 = DDRHSSPI0_SDATASAMPLEPTCNT0;  /*  [bit6:0]  SDATA0 Right Clock Sample Point Control*/
    DDRHSSPI0_SDATASAMPLEPTRGH1 = DDRHSSPI0_SDATASAMPLEPTCNT1;  /*  [bit6:0]  SDATA1 Right Clock Sample Point Control*/
    DDRHSSPI0_SDATASAMPLEPTRGH2 = DDRHSSPI0_SDATASAMPLEPTCNT2;  /*  [bit6:0]  SDATA2 Right Clock Sample Point Control*/
    DDRHSSPI0_SDATASAMPLEPTRGH3 = DDRHSSPI0_SDATASAMPLEPTCNT3;

    /*When the software runs a Calibration sequence to adjust the SDATA Sampling Points, it is important to see*/
    /*if the following two addresses are different at least by 8 bytes (assuming 32-bits access).*/
    /*  - The last address of Calibration sequence*/
    /*  (The last Memory Read access in the Calibration is expected to be an error.)*/
    /*  - The start address of Memory Read access in the normal process*/
    dlpCheckAddress = (unsigned int *)HSSPI_START_ADDRESS;
    dummyRead = *dlpCheckAddress;
    return HSSPI_PASS;
}