
#ifndef _AlarmGeneralFile_H_
#define _AlarmGeneralFile_H_

#include "stdint.h"

#define Clr_Bit(p, b)           (p) &= (~(1u << (b)))
#define Set_Bit(p, b)           (p) |= (1u << (b))
#define Bit_Is_Set(p, b)        ((p) &(1u << (b)))
#define Bit_Is_Clr(p, b)       (!((p) & (1u << (b))))



extern const uint8_t OSUnMapTbl[256u];
extern const uint8_t OSMapTbl[8u];

void General_Set_MapBit(uint8_t p8[], uint8_t m_index);
void General_Clr_MapBit(uint8_t p8[], uint8_t m_index);

void General_AlarmSt_Set(uint8_t m_Idx, uint8_t m_bit);
void General_AlarmSt_Clr(uint8_t m_Idx, uint8_t m_bit);

uint8_t General_AlarmSt_False(uint8_t m_Idx, uint8_t m_bit);
uint8_t General_AlarmSt_True(uint8_t m_Idx, uint8_t m_bit);
uint8_t General_AlarmSt_Value(uint8_t m_Idx);

uint8_t General_Get_PowerSt(void);
void General_Set_PowerSt(uint8_t PowerSt);

#endif
