
#include "Sound_List.h"
#include "Sound_Player.h"
#include "Sound_Scheduler.h"

#define SND_PLAYER_IDLE     0x00u
#define SND_PLAYER_PLAY_REQ 0x01u
#define SND_PLAYER_PLAYING  0x02u
#define SND_PLAYER_STOP_REQ 0x03u

/******************************************************************************
声音属性列表
******************************************************************************/
const SoundAttributeStruct SoundList [ SND_TOTAL_NUM ] = {
    /*=====================================================================================
                 声音名称                 |              音源              |        模式
    -------------------------------------------------------------------------------------*/
    {/*tick                                */  SND_SRC_TICK,                     SND_TYPE_NORMAL,  },
    {/*tock                                */  SND_SRC_TOCK,                     SND_TYPE_NORMAL,  },
    {/*雷达长鸣                              */SND_SRC_Radar_Changming,          SND_TYPE_RADAR,  },
    {/*雷达 1HZ                            */  SND_SRC_Radar_1HZ,                SND_TYPE_RADAR,  },
    {/*雷达 2HZ                            */  SND_SRC_Radar_2HZ,                SND_TYPE_RADAR,  },
    {/*雷达 4HZ                            */  SND_SRC_Radar_4HZ,                SND_TYPE_RADAR,  },
    {/*雷达 2S                             */  SND_SRC_Radar_2S,                 SND_TYPE_RADAR,  },
    {/*雷达 4S                             */  SND_SRC_Radar_4S,                 SND_TYPE_RADAR,  },
    {/*雷达 0.5S                           */  SND_SRC_Radar_0S,                 SND_TYPE_RADAR,  },
    {/*雷达 0.5S                           */  SND_SRC_Radar_OK0S,               SND_TYPE_RADAR,  },
    {/*制动液位低                          */  SND_SRC_EPB_Status,               SND_TYPE_NORMAL,  },
    {/*安全带未系                          */  SND_SRC_SEATBELT_DR_1HZ,          SND_TYPE_NORMAL,  },
    {/*安全带未系                          */  SND_SRC_SEATBELT_DR_2HZ,          SND_TYPE_NORMAL,  },
    {/*车门开报警                          */  SND_SRC_DoorOpen,                 SND_TYPE_NORMAL,  },
    {/*车门开报警 1HZ                      */  SND_SRC_DoorOpen_1HZ,             SND_TYPE_NORMAL,  },
    {/*EBD故障                             */  SND_SRC_EBD_fault,                SND_TYPE_NORMAL,  },
    {/*ABS故障                             */  SND_SRC_ABS,                      SND_TYPE_NORMAL,  },
    {/*EPS故障                             */  SND_SRC_EPS,                      SND_TYPE_NORMAL,  },
    {/*驻车制动                             */  SND_SRC_Park_Brak,                    SND_TYPE_NORMAL,  },
    {/*电机故障                            */  SND_SRC_MotorFault,               SND_TYPE_NORMAL,  },
    {/*动力电池报警                        */  SND_SRC_SOC_Fault,                SND_TYPE_NORMAL,  },
    {/*高压绝缘故障                        */  SND_SRC_InsulationFault,          SND_TYPE_NORMAL,  },
    {/*电池热失控                          */  SND_SRC_SOC_HT,                   SND_TYPE_NORMAL,  },
    {/*单踏板功能激活                      */  SND_SRC_Energy_Recovery,          SND_TYPE_NORMAL,  },
    {/*单踏板功能激活1                     */  SND_SRC_Energy_Recovery_1,        SND_TYPE_NORMAL,  },
    {/*ECO状态激活                         */  SND_SRC_ECO,                      SND_TYPE_NORMAL,  },
    {/*READY状态激活                       */  SND_SRC_READY,                    SND_TYPE_NORMAL,  },
    {/*限功率报警                          */  SND_SRC_PowerLimit,               SND_TYPE_NORMAL,  },
    {/*蓄电池电量低                        */  SND_SRC_SOC_LP,                   SND_TYPE_NORMAL,  },
    {/*蓄电池充电故障                      */  SND_SRC_SOC_CF,                   SND_TYPE_NORMAL,  },
    {/*动力系统故障                        */  SND_SRC_SystemFault,              SND_TYPE_NORMAL,  },
    {/*动力系统故障                        */  SND_SRC_SystemFault1,              SND_TYPE_NORMAL,  },
    {/*换挡错误                            */  SND_SRC_GearFault,                SND_TYPE_NORMAL,  },
    {/*超载报警                            */  SND_SRC_WeightOverload,           SND_TYPE_NORMAL,  },
    {/*超载报警                            */  SND_SRC_WeightOverload2,           SND_TYPE_NORMAL,  },
    {/*远程锁车                            */  SND_SRC_RemoteLocking,            SND_TYPE_NORMAL,  },
    {/*小灯未关                            */  SND_SRC_PositionNotClosed,        SND_TYPE_NORMAL,  },
    {/*驾驶员离车提醒                      */  SND_SRC_DepartureReminder,        SND_TYPE_NORMAL,  },
    {/*OTA 报警0                           */  SND_SRC_OTA_0,                    SND_TYPE_NORMAL,  },
    {/*OTA 报警1                           */  SND_SRC_OTA_1,                    SND_TYPE_NORMAL,  },
    {/*OTA 报警2                           */  SND_SRC_OTA_2,                    SND_TYPE_NORMAL,  },
    {/*OTA 报警3                           */  SND_SRC_OTA_3,                    SND_TYPE_NORMAL,  },
    {/*OTA 报警4                           */  SND_SRC_OTA_4,                    SND_TYPE_NORMAL,  },
    {/*OTA 报警5                           */  SND_SRC_OTA_5,                    SND_TYPE_NORMAL,  },
    {/*EPS 报警5                           */  SND_SRC_ESC,                      SND_TYPE_NORMAL,  },
    {/*超速报警                             */  SND_SRC_Over_Speed,             SND_TYPE_NORMAL,  },

    /*====================================================================================*/
};

/******************************************************************************
音源属性表  组合音
******************************************************************************/
const SndAttributeStruct SndAttributeTable [ SND_SRC_TOTAL_NUM ] = {
    /*============================================================================================================================================
            音源名称                |           音源                | 优先级 |     循环次数               |   播放模式          | 周期(ms)
    ---------------------------------------------------------------------------------------------------------------------------------------------*/
    {        /*  tock              */         0x05,     1u,        1u,                        SND_MODE_SINGLE,        100,      },
    {        /*  tick              */         0x06,     2u,        1u,                        SND_MODE_SINGLE,        100,      },
    {        /*  雷达长鸣          */          0x02,     12u,        SND_CYCLE_NONSTOP,        SND_MODE_LOOP,          0u,    },
    {        /*  雷达 1HZ          */         0x03,     12u,        SND_CYCLE_NONSTOP,        SND_MODE_SINGLE,          1000u,    },
    {        /*  雷达 2HZ          */         0x03,     12u,        SND_CYCLE_NONSTOP,        SND_MODE_SINGLE,          500u,    },
    {        /*  雷达 4HZ          */         0x04,     12u,        SND_CYCLE_NONSTOP,        SND_MODE_SINGLE,          250u,    },
    {        /*  雷达 2S           */         0x02,     3u,        1u,                        SND_MODE_SINGLE,        2000u,    },
    {        /*  雷达 4S           */         0x02,     3u,        1u,                        SND_MODE_SINGLE,        4000u,    },
    {        /*  雷达 0.5S         */         0x02,     3u,        1u,                        SND_MODE_SINGLE,        500u,    },
    {        /*  雷达 0.5S         */         0x02,     3u,        1u,                        SND_MODE_SINGLE,        500u,    },
    {        /*  制动液位低        */          0x07,     2u,        1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  安全带未系 1HZ    */          0x03,     3u,        SND_CYCLE_NONSTOP,         SND_MODE_SINGLE,        1000u,    },
    {        /*  安全带未系 2HZ    */          0x03,     3u,        SND_CYCLE_NONSTOP,         SND_MODE_SINGLE,        500u,    },
    {        /*  车门开报警        */          0x07,     4u,        1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  车门开报警 1HZ    */          0x07,     4u,        SND_CYCLE_NONSTOP,         SND_MODE_SINGLE,        1000u,    },
    {        /*  EBD故障           */         0x07,     6u,        1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  ABS故障           */         0x07,     7u,        1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  EPS故障           */         0x07,     8u,        1u,                        SND_MODE_SINGLE,        1000u,    },
     {        /*  驻车制动           */         0x07,     5u,        1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  电机故障          */          0x07,     9u,       1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  动力电池报警      */          0x07,     10u,       1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  高压绝缘故障      */          0x07,     11u,       1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  电池热失控        */          13,     1u,       SND_CYCLE_NONSTOP,         SND_MODE_SINGLE,        500u,    },
    {        /*  单踏板功能激活    */           0x07,     13u,       1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  单踏板功能激活 1  */           0x07,     13u,       3u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  ECO状态激活       */          0x07,     14u,       1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  READY状态激活     */          0x07,     15u,       1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  限功率报警        */          0x07,     16u,       1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  蓄电池电量低      */          0x07,     17u,       1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  蓄电池充电故障    */           0x07,     17u,       1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  动力系统故障      */           0x07,     18u,       10u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  动力系统故障      */           0x07,     18u,       SND_CYCLE_NONSTOP,          SND_MODE_SINGLE,        1000u,    },

    {        /*  换挡错误          */          0x07,     20u,       1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  超载报警          */          0x07,     20u,       1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  超载报警2         */          0x07,     20u,       1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  远程锁车          */          0x07,     21u,       1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  小灯未关          */          0x07,     22u,       10u,                       SND_MODE_SINGLE,        1000u,    },
    {        /*  驾驶员离车提醒    */             13,     23u,       3u,                        SND_MODE_SINGLE,        500u,    },
    {        /*  OTA 报警0         */          0x07,     4u,        SND_CYCLE_NONSTOP,         SND_MODE_SINGLE,        1000u,    },
    {        /*  OTA 报警1         */          0x07,     4u,        1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  OTA 报警2         */          0x07,     4u,        3u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  OTA 报警3         */          0x07,     4u,        1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  OTA 报警4         */          0x07,     4u,        1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  OTA 报警5         */          0x07,     4u,        240u,                      SND_MODE_SINGLE,        250u,    },
    {        /*  ESC 报警4         */          0x07,     4u,        1u,                        SND_MODE_SINGLE,        1000u,    },
    {        /*  超速报警 1HZ      */          0x07,     13u,        4,                        SND_MODE_SINGLE,        1000u,    },
    /*===========================================================================================================================================*/
};

/******************************************************************************
伪音源名称列表
******************************************************************************/
#define   SND_SRC_NONE                      0xFFu    /*没有声音*/
#define   SND_SRC_CURRENT                   0xFEu    /*当前播放的声音*/

/******************************************************************************
音源循环次数
******************************************************************************/
#define   SND_CYCLE_NONSTOP                 0xFFu    /*不停播放*/

/******************************************************************************
音源播放模式
******************************************************************************/
#define   SND_MODE_SINGLE                   0x00u    /*使用ISD_Play_Vp方法播放*/
#define   SND_MODE_LOOP                     0x01u    /*使用ISD_Play_Vp_Loop方法播放*/


uint8_t   SoundEnableCode[SND_TOTAL_NUM];
SoundSchedulingStruct       SoundScheduling;


void Sound_Scheduler_Init(void)
{
    uint8_t i;

    for (i = 0u; i < SND_TOTAL_NUM; i++)
    {
        SoundEnableCode[i] = 0u;
    }

    Sound_Clear();
    SoundScheduling.Current = SND_NONE;
    SoundScheduling.Next    = SND_NONE;
    SoundScheduling.ReqCode = 0u;
    SoundScheduling.StopReq = 0u;
}

/*****************************************************************************
ReqCode：请求码,0 - 表示无效请求,不请求播放声音
                非0值 - 请求播放声音,该请求码将被记录,对于只播放一次的声音,
                如果与上一次请求播放该声音的请求码相同声音就不会再被重复播放
*****************************************************************************/
void Sound_Request(uint8_t Sound, uint8_t ReqCode)
{
    uint8_t PriorityRef;
    uint8_t PriorityNew;

    if ((Sound < SND_TOTAL_NUM) && (ReqCode))
    {
        if ((SoundEnableCode[Sound] != ReqCode) || (SoundList[Sound].Type != SND_TYPE_NORMAL))
        {

            if (SoundScheduling.Next < SND_TOTAL_NUM)             /*如果已有即将要播放的声音*/
            {
                if (Sound != SoundScheduling.Next)
                {
                    PriorityRef = Sound_Priority_Query(SoundList[SoundScheduling.Next].Src);
                    PriorityNew = Sound_Priority_Query(SoundList[Sound].Src);

                    if (PriorityNew < PriorityRef)
                    {
                        SoundScheduling.Next = Sound;             /*请求的声音具有更高的优先级*/
                        SoundScheduling.ReqCode = ReqCode;
                    }
                    else if (PriorityNew == PriorityRef)
                    {
                        if (SoundList[Sound].Type == SND_TYPE_RADAR)
                        {
                            SoundScheduling.Next = Sound;         /*同优先级雷达声可相互打断*/
                            SoundScheduling.ReqCode = ReqCode;
                        }
                    }
                    else
                    {}
                }
            }
            else                                                  /*如果没有即将要播放的声音*/
            {
                if (Sound != SoundScheduling.Current)
                {
                    PriorityRef = Sound_Priority_Query(SND_SRC_CURRENT);
                    PriorityNew = Sound_Priority_Query(SoundList[Sound].Src);

                    if (PriorityNew < PriorityRef)
                    {
                        SoundScheduling.Next = Sound;             /*请求的声音具有更高的优先级*/
                        SoundScheduling.ReqCode = ReqCode;
                        if(SoundScheduling.Current<SND_TOTAL_NUM) 
                        {
                          if(SoundEnableCode[SoundScheduling.Current]>0u)
                          {
                            SoundEnableCode[SoundScheduling.Current]=0U;/*lmj：20200821不加报警被打断后无法重播，只需要不同不需要准数*/
                          }
                        }
                    }
                    else if (PriorityNew == PriorityRef)
                    {
                        if (SoundList[Sound].Type == SND_TYPE_RADAR)
                        {
                            SoundScheduling.Next = Sound;         /*同优先级雷达声可相互打断*/
                            SoundScheduling.ReqCode = ReqCode;
                        }
                    }
                    else
                    {}
                }
            }
        }
    }
}



void Sound_Delete(uint8_t Sound)
{
    if (Sound < SND_TOTAL_NUM)
    {
        if (SoundEnableCode[Sound])                      /*是已播放过的声音*/
        {
            if (Sound == SoundScheduling.Current)
            {
                SoundScheduling.StopReq = 1u;
            }
            else
            {
                if (Sound == SoundScheduling.Next)
                {
                    SoundScheduling.Next = SND_NONE;
                }

                SoundEnableCode[Sound] = 0u;
            }

        }
    }
}

/*50ms*/
void Sound_Scheduling_Service(void)
{
    /*处理声音停止请求*/
    if (SoundScheduling.StopReq)
    {
        if (SoundScheduling.Current < SND_TOTAL_NUM)
        {
            if (Sound_Stop(SoundList[SoundScheduling.Current].Src) == 0u)
            {
                SoundScheduling.StopReq = 0u;
                SoundEnableCode[SoundScheduling.Current] = 0u;
                SoundScheduling.Current = SND_NONE;
            }
        }
    }

    /*使用查询优先级方法查看当前声音是否还在播放*/
    if (SoundScheduling.Current < SND_TOTAL_NUM)
    {
        if (Sound_Priority_Query(SND_SRC_CURRENT) == 0xFFu)
        {
            SoundScheduling.Current = SND_NONE;
        }
    }

    /*播放请求的声音*/
    if (SoundScheduling.Next < SND_TOTAL_NUM)
    {
        if (SoundScheduling.Current < SND_TOTAL_NUM)   /*如果当前有声音正在播放,则停止播放该声音*/
        {
            Sound_Stop(SoundList[SoundScheduling.Current].Src);
        }

        if (Sound_Play(SoundList[SoundScheduling.Next].Src) == 0u)            /*如果请求的声音播放成功*/
        {
            SoundEnableCode[SoundScheduling.Next] = SoundScheduling.ReqCode;  /*声音已播放*/
            SoundScheduling.Current = SoundScheduling.Next;
            SoundScheduling.Next    = SND_NONE;
        }
    }

}

uint8_t Get_SoundScheduling_Current(void)
{
    return SoundScheduling.Current;
}
