
#ifndef _SOUND_SCHEDULER_H_
#define _SOUND_SCHEDULER_H_

#include "stdint.h"
#include "Sound_List.h"
typedef struct
{
    uint8_t   Current;
    uint8_t   Next;
    uint8_t   ReqCode;
    uint8_t   StopReq;
} SoundSchedulingStruct;

/******************************************************************************
声音属性结构
******************************************************************************/
typedef struct
{
    uint8_t Src;    /*音源*/
    uint8_t Type;   /*类型*/
} SoundAttributeStruct;
/******************************************************************************
声音属性结构
******************************************************************************/
typedef struct
{
    uint8_t  Index;
    uint8_t   Priority;
    uint8_t   Cycle;
    uint8_t   Mode;
    uint16_t  Period;
} SndAttributeStruct;
/*声音列表*/
extern  const SoundAttributeStruct SoundList[SND_TOTAL_NUM];
extern  const SndAttributeStruct   SndAttributeTable[SND_SRC_TOTAL_NUM] ;

#define SND_NONE   0xFFu

#define   SND_SEATBELT_DISABLE              0x00u
#define   SND_SEATBELT_TIMING               0x01u
#define   SND_SEATBELT_TIME_UP              0x02u
#define   SND_SEATBELT_CONTINUOUS           0x03u


void Sound_Scheduler_Init(void);
void Sound_Request(uint8_t Sound, uint8_t ReqCode);
void Sound_Delete(uint8_t Sound);
void Sound_Scheduling_Service(void);
uint8_t Get_SoundScheduling_Current(void);
#endif

