#ifndef _LINE_IN_H_
#define _LINE_IN_H_
/******************************************************************************

                           线路输入IO管脚名称定义

-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
    线路输入              | 有效电平  |      功能
-------------------------------------------------------------------------------
LINE_IN_OIL_PRESS          LOW			机油压力低
LINE_IN_PARKING            LOW			驻车制动
LINE_IN_BREAKFLUID         LOW			制动液位
LINE_IN_R_SINGAL           HIGH			倒挡信号
LINE_IN_BATTERY_SIGNAL     LOW			蓄电池充放电
-------------------------------------------------------------------------------
******************************************************************************/

#include "CommonFun.h"
#include "RTE_LINE_IN.h"

/*如果枚举修改,对应C文件的数字内容需要同步修改*/
typedef enum
{
	LINE_IN_MaintainWarning,
	LINE_IN_BRAKEFLUID,
	LINE_IN_OTA_SWITCH,
	LINE_IN_TRIP_SWITCH,
	LINE_IN_SEATBELT_DR,
	LINE_IN_TURNLEFT,
	LINE_IN_TURNRIGHT,
	LINE_IN_HBEAM,
	LINE_IN_LBEAM,
	LINE_IN_POSITION,
	LINE_IN_REARFOG,
	LINE_IN_DAYLIGHT,
	LINE_IN_HANDBRAKE,
	LINE_IN_SOC_CC,
	LINE_IN_DOOROPEN,
	LINE_IN_ENERGY_RECOVERY,//sh
	LINE_MAX,
} _LINE_IN_NAME_;

#define   LINE_IN_DEBOUNCE_CYCLE            20u
#define   Trigger                            1u
#define   Remove                             0u
void Line_In_Enable(uint8_t Enable);
void Line_In_Status_Reset(void);
void Line_In_Debounce(_LINE_IN_NAME_ LINE_NAME, _LINE_IN_TriggerLevel_ m_Level);
void Line_In_Debounce_Service(void);
_LINE_IN_TriggerLevel_ Get_LINE_IN_Sts(_LINE_IN_NAME_ LINE_NAME);



#endif