#include "Key.h"
#include "HW_Key.h"
#include "RTE_LINE_IN.h"
#include "Communication_Over_CAN.h"
#include "System_Status_Monitor.h"
#include "Line_In.h"

MMIKeyStruct MMIKey;
uint8_t      Key_SW_OTA;
uint8_t      Key_SW_EnergyRecovery;
uint8_t      Key_SW_EnergyRecovery0;
uint8_t      Int_Trip;
uint8_t      Ext_Trip;
uint8_t      Key_OTA;
uint8_t      Key_EnergyRecovery;
uint8_t      Key_EnergyRecovery0;

uint8_t OTA_Key;
uint8_t      EnergyRecovery_Key;
uint8_t      EnergyRecovery0_Key;
uint8_t Key_SW_OTA_Timer;
uint8_t Key_SW_EnergyRecovery_Timer;
uint8_t Key_SW_EnergyRecovery0_Timer;
uint8_t     EnergyRecovery_Level = 2;

/*uint8_t Key_sts;
static void btn_Int_Trip_cb(button_event_t event);*/

static void btn_Ext_Trip_cb(button_event_t event);

void ClearNOuseButton(void)
{
    Int_Trip = MMI_KEY_IDLE;
    Ext_Trip = MMI_KEY_IDLE;
    OTA_Key  = MMI_KEY_IDLE;

    Key_SW_OTA_Timer = 0u;

    MMI_KEY_CONFIRM = MMI_KEY_IDLE;
    MMI_KEY_LEFT    = MMI_KEY_IDLE;
    MMI_KEY_RIGHT   = MMI_KEY_IDLE;
    MMI_KEY_UP      = MMI_KEY_IDLE;
    MMI_KEY_DOWN    = MMI_KEY_IDLE;
}

void OTA_Key_Status(void)
{
    if ( Key_OTA != MMI_KEY_IDLE )
    {
        OTA_Key = Key_OTA;
    }
    else
    {
    }
}

void EnergyRecovery0_Key_Status(void)
{
    if ( Key_EnergyRecovery0 != MMI_KEY_IDLE )
    {
        EnergyRecovery0_Key = Key_EnergyRecovery0;
    }
    else
    {
    }
}

void EnergyRecovery_Key_Status(void)
{
    if ( Key_EnergyRecovery != MMI_KEY_IDLE )
    {
        EnergyRecovery_Key = Key_EnergyRecovery;
    }
    else
    {
    }
}

void MMIKeyVarInit(void)
{
    MMIKey.RightSw   = 0u;
    MMIKey.LeftSw    = 0u;
    MMIKey.UpSw      = 0u;
    MMIKey.DownSw    = 0u;
    MMIKey.ConfirmSw = 0u;

    MMIKey.RightBck   = 0u;
    MMIKey.LeftBck    = 0u;
    MMIKey.UpBck      = 0u;
    MMIKey.DownBck    = 0u;
    MMIKey.ConfirmBck = 0u;

    MMIKey.Right   = 0u;
    MMIKey.Left    = 0u;
    MMIKey.Up      = 0u;
    MMIKey.Down    = 0u;
    MMIKey.Confirm = 0u;
}

void MMI_Key_DetectHadnleCb10ms(void)
{
    OTA_Key_Detect( );
    EnergyRecovery_Key_Detect();
    EnergyRecovery0_Key_Detect();
}

void OTA_Key_Detect(void)
{
    #if 1
    if ( SYS_OPR_STAT_IGN_ON )
    {
        Key_SW_OTA = Get_LINE_IN_Sts(LINE_IN_OTA_SWITCH);
        if ( Key_SW_OTA == 1u )
        {
            if ( Key_SW_OTA_Timer < 255u )
            {
                Key_SW_OTA_Timer++;
            }

            if ( Key_SW_OTA_Timer >= 150u ) /*长按判断*/
            {
                Key_OTA = MMI_KEY_HOLD; /*长按TRIP*/
            }
            else
            {
                Key_OTA = MMI_KEY_IDLE; /*按键抬起*/
            }
        }
        else if ( Key_SW_OTA == 0u )
        {
            if ( (Key_SW_OTA_Timer > 20u) && (Key_SW_OTA_Timer < 150u) )
            {
                Key_OTA = MMI_KEY_PRESS; /*短按TRIP*/
            }
            else
            {
                Key_OTA = MMI_KEY_IDLE; /*按键抬起*/
            }
            Key_SW_OTA_Timer = 0u;
        }
        else
        {
            Key_SW_OTA_Timer = 0u;
            Key_OTA          = MMI_KEY_IDLE;
        }
    }
    else
    {
        Key_SW_OTA_Timer = 0u;
        Key_OTA          = MMI_KEY_IDLE;
    }

    OTA_Key_Status( );
    #endif
}

void EnergyRecovery_Key_Detect(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        
        Key_SW_EnergyRecovery = Get_LINE_IN_Sts(LINE_IN_OTA_SWITCH);
        if ( Key_SW_EnergyRecovery == 1u )
        {
            if ( Key_SW_EnergyRecovery_Timer < 255u )
            {
                Key_SW_EnergyRecovery_Timer++;
            }

            if ( Key_SW_EnergyRecovery_Timer >= 150u ) /*长按判断*/
            {
                 Key_EnergyRecovery = MMI_KEY_HOLD; /*长按TRIP*/
            }
            else
            {
                Key_EnergyRecovery = MMI_KEY_IDLE; /*按键抬起*/
            }
        }
        else if ( Key_SW_EnergyRecovery == 0u )
        {
            if ( (Key_SW_EnergyRecovery_Timer > 20u) && (Key_SW_EnergyRecovery_Timer < 150u) )
            {
                Key_EnergyRecovery = MMI_KEY_PRESS; /*短按TRIP*/
            }
            else
            {
                Key_EnergyRecovery = MMI_KEY_IDLE; /*按键抬起*/
            }
            Key_SW_EnergyRecovery_Timer = 0u;
        }
        else
        {
            Key_SW_EnergyRecovery_Timer = 0u;
            Key_EnergyRecovery          = MMI_KEY_IDLE;
        }
    }
    else
    {
        Key_SW_EnergyRecovery_Timer = 0u;
        Key_EnergyRecovery          = MMI_KEY_IDLE;
    }

    EnergyRecovery_Key_Status( );
}

 uint8_t EnergyRecovery_Key_val(void)
{
    if (MMI_KEY_PRESS == EnergyRecovery_Key) 
    {
        EnergyRecovery_Key = MMI_KEY_IDLE;
        EnergyRecovery_Level++;
        if (EnergyRecovery_Level >= 3)
        {
          EnergyRecovery_Level = 0;
        }
    }
    return EnergyRecovery_Level;
}

void EnergyRecovery0_Key_Detect(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        
        Key_SW_EnergyRecovery0 = Get_Line_In_Energy_Recovery0();
        if ( Key_SW_EnergyRecovery0 == 0u )
        {
            if ( Key_SW_EnergyRecovery0_Timer < 255u )
            {
                Key_SW_EnergyRecovery0_Timer++;
            }

            if ( Key_SW_EnergyRecovery0_Timer >= 200u ) /*长按判断*/
            {
                 Key_EnergyRecovery0 = MMI_KEY_HOLD; /*长按TRIP*/
            }
            else
            {
                Key_EnergyRecovery0 = MMI_KEY_IDLE; /*按键抬起*/
            }
        }
        else if ( Key_SW_EnergyRecovery0 == 1u )
        {
            if ( (Key_SW_EnergyRecovery0_Timer > 50u) && (Key_SW_EnergyRecovery0_Timer < 200u) )
            {
                Key_EnergyRecovery0 = MMI_KEY_PRESS; /*短按TRIP*/
            }
            else
            {
                Key_EnergyRecovery0 = MMI_KEY_IDLE; /*按键抬起*/
            }
            Key_SW_EnergyRecovery0_Timer = 0u;
        }
        else
        {
            Key_SW_EnergyRecovery0_Timer = 0u;
            Key_EnergyRecovery0          = MMI_KEY_IDLE;
        }
    }
    else
    {
        Key_SW_EnergyRecovery0_Timer = 0u;
        Key_EnergyRecovery0          = MMI_KEY_IDLE;
    }

    EnergyRecovery0_Key_Status( );
}


 uint8_t EnergyRecovery0_Key_val(void)
{
    if (MMI_KEY_PRESS == EnergyRecovery0_Key) 
    {
        EnergyRecovery0_Key = MMI_KEY_IDLE;
        EnergyRecovery_Level = 0;
    }
    return EnergyRecovery_Level;
}

static void btn_Ext_Trip_cb(button_event_t event)
{
    switch ( event )
    {
        case PRESS_CLICK:
            Ext_Trip = MMI_KEY_PRESS;

            break;
        case PRESS_LONG_HOLD:
            Ext_Trip = MMI_KEY_HOLD;

            break;
        default:
            Ext_Trip = MMI_KEY_IDLE;
            break;
    }
}

void HW_Key_KL30_Wakeup_Init(void)
{
    _button_para Key;
    HW_Key_Init( );
    
    /*服务函数10ms调用 时间为tick*10ms*/
    Key.Pressed_logic_level = 0u;
    /*100ms=10*10ms*/
    Key.short_press_start_tick = 20u;
    /*2000ms=200*10ms*/
    Key.long_press_start_tick = 200u;
    /*10000ms=1000*10ms*/
    Key.long_hold_start_tick = 201u;

    /*板载Trip按键初始化*/
    /*Key.usr_button_read = Get_LINE_IN_TRIP5;
    Key.cb =(button_callback)btn_Int_Trip_cb;
    (void)HW_Key_InitKey(0u, &Key);*/

    /*硬线Trip按键初始化*/
    Key.usr_button_read = Get_Line_In_TRIP_Switch;
    Key.cb              = ( button_callback )btn_Ext_Trip_cb;

    ( void )HW_Key_InitKey(2u, &Key);
}
