/*
 * File: AvgVehicleSpeed.c
 *
 * Code generated for Simulink model 'AvgVehicleSpeed'.
 *
 * Model version                  : 1.2722
 * Simulink Coder version         : 9.2 (R2019b) 18-Jul-2019
 * C/C++ source code generated on : Mon Jul 20 19:48:50 2020
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: ARM Compatible->ARM Cortex
 * Code generation objectives:
 *    1. RAM efficiency
 *    2. ROM efficiency
 *    3. MISRA C:2012 guidelines
 * Validation result: Passed (23), Warning (1), Error (0)
 */

#include "AvgVehicleSpeed.h"
#include "AvgVehicleSpeed_private.h"
#include "CAN_Communication_Matrix.h"

/* Named constants for Chart: '<S1>/AvgVehicleSpeed' */
#define AvgVeh_IN_Clear_AvgVehicleSpeed ((uint8_T)2U)
#define AvgVehi_IN_Calc_AvgVehicleSpeed ((uint8_T)1U)

/* Block signals and states (default storage) */
DW_AvgVehicleSpeed_T AvgVehicleSpeed_DW;

/* External inputs (root inport signals with default storage) */
ExtU_AvgVehicleSpeed_T AvgVehicleSpeed_U;

/* Model step function */
void AvgVehicleSpeed_step(void)
{
  real_T tmp;
  int32_T tmp_0;
  uint32_T qY;
  uint16_T IPK_AverageVehicleSpeed_0;
  uint16_T RTCRollingCounter;
  uint16_T mRollingCounter;
  PowerStatus PowerSt;
  uint16_T VehicleSpeedIn;
  uint8_T AvgVehicleSpeedValid_0;

  /* Chart: '<S1>/AvgVehicleSpeed' */
  AvgVehicleSpeedValid_0 = AvgVehicleSpeedValid;

  /* Inport: '<Root>/VehicleSpeedIn' */
  VehicleSpeedIn = AvgVehicleSpeed_U.VehicleSpeedIn;

  /* Inport: '<Root>/PowerSt' */
  PowerSt = AvgVehicleSpeed_U.PowerSt;

  /* Inport: '<Root>/mRollingCounter' */
  mRollingCounter = AvgVehicleSpeed_U.mRollingCounter;

  /* Inport: '<Root>/RTCRollingCounter' */
  RTCRollingCounter = AvgVehicleSpeed_U.RTCRollingCounter;

  /* Chart: '<S1>/AvgVehicleSpeed' incorporates:
   *  Inport: '<Root>/EngineValid'
   *  Inport: '<Root>/EngineValue'
   *  Inport: '<Root>/PowerSt'
   *  Inport: '<Root>/RTCRollingCounter'
   *  Inport: '<Root>/VSpeedValid'
   *  Inport: '<Root>/VehicleSpeedIn'
   *  Inport: '<Root>/mRollingCounter'
   *  Product: '<S3>/Divide'
   *  Product: '<S3>/Product'
   *  Product: '<S3>/Product1'
   */
  IPK_AverageVehicleSpeed_0 = IPK_AverageVehicleSpeed;
  if (((uint32_T)AvgVehicleSpeed_DW.bitsForTID0.is_active_c3_AvgVehicleSpeed) ==0U) 
  {
    AvgVehicleSpeed_DW.bitsForTID0.is_active_c3_AvgVehicleSpeed = 1U;
    AvgVehicleSpeed_DW.bitsForTID0.is_c3_AvgVehicleSpeed = 2U;
    AvgVehicleSpeed_DW.AvgVSpeedCtrl.mRollingMilleageBack = mRollingCounter;
    AvgVehicleSpeed_DW.AvgVSpeedCtrl.msRollingTRTCBack = RTCRollingCounter;
  } 
  else if (((uint32_T)AvgVehicleSpeed_DW.bitsForTID0.is_c3_AvgVehicleSpeed) == AvgVehi_IN_Calc_AvgVehicleSpeed) 
  {
    if (((int32_T)AvgVehicleSpeed_DW.AvgVSpeedCtrl.EnCalc) == 0) 
    {
      AvgVehicleSpeed_DW.bitsForTID0.is_c3_AvgVehicleSpeed = 2U;
      AvgVehicleSpeed_DW.AvgVSpeedCtrl.mRollingMilleageBack = mRollingCounter;
      AvgVehicleSpeed_DW.AvgVSpeedCtrl.msRollingTRTCBack = RTCRollingCounter;
    } 
    else if (PowerSt == PowerStatus_ON) 
    {
      if (((int32_T)AvgVehicleSpeed_U.VSpeedValid) == 0) 
      {
        AvgVehicleSpeed_DW.AvgVSpeedCtrl.UpdateTimer = 0U;
        IPK_AverageVehicleSpeed_0 = (uint16_T)0xFF;
        AvgVehicleSpeedValid_0 = 0U;
        AvgVehicleSpeed_DW.AvgVSpeedCtrl.mRollingMilleageBack = mRollingCounter;
        AvgVehicleSpeed_DW.AvgVSpeedCtrl.msRollingTRTCBack = RTCRollingCounter;
      }
      else 
      {
        if (((int32_T)AvgVehicleSpeed_DW.AvgVSpeedCtrl.VRunning) == 1) 
        {
          if (((int32_T)VehicleSpeedIn) < 20) 
          {
            AvgVehicleSpeed_DW.AvgVSpeedCtrl.VRunning = 0U;
          }
        }
        else 
        {
          if (((int32_T)VehicleSpeedIn) > 25) 
          {
            AvgVehicleSpeed_DW.AvgVSpeedCtrl.VRunning = 1U;
          }
        }

        AvgVehicleSpeed_DW.AvgVSpeedCtrl.mRollingMilleage = mRollingCounter;
        if (AvgVehicleSpeed_DW.AvgVSpeedCtrl.mRollingMilleage >= AvgVehicleSpeed_DW.AvgVSpeedCtrl.mRollingMilleageBack) 
        {
          tmp_0 = ((int32_T)AvgVehicleSpeed_DW.AvgVSpeedCtrl.mRollingMilleage) - ((int32_T)AvgVehicleSpeed_DW.AvgVSpeedCtrl.mRollingMilleageBack);
          if (tmp_0 < 0) 
          {
            tmp_0 = 0;
          }

          qY = AvgVehicleSpeed_DW.AvgVSpeedCtrl.ACCMilleage + ((uint32_T)tmp_0);
          if (qY < AvgVehicleSpeed_DW.AvgVSpeedCtrl.ACCMilleage) 
          {
            qY = MAX_uint32_T;
          }

          AvgVehicleSpeed_DW.AvgVSpeedCtrl.ACCMilleage = qY;
          AvgVehicleSpeed_DW.AvgVSpeedCtrl.mRollingMilleageBack = mRollingCounter;
        }
        else 
        {
          qY = (((uint32_T)((int32_T)(((int32_T)AvgVehicleSpeed_DW.AvgVSpeedCtrl.mRollingMilleage) - ((int32_T) AvgVehicleSpeed_DW.AvgVSpeedCtrl.mRollingMilleageBack)))) + AvgVehicleSpeed_DW.AvgVSpeedCtrl.ACCMilleage) + 65536U;
          if (qY < AvgVehicleSpeed_DW.AvgVSpeedCtrl.ACCMilleage) 
          {
            qY = MAX_uint32_T;
          }

          AvgVehicleSpeed_DW.AvgVSpeedCtrl.ACCMilleage = qY;
          AvgVehicleSpeed_DW.AvgVSpeedCtrl.mRollingMilleageBack = AvgVehicleSpeed_DW.AvgVSpeedCtrl.mRollingMilleage;
        }

        AvgVehicleSpeed_DW.AvgVSpeedCtrl.msRollingTRTC = RTCRollingCounter;
        if (AvgVehicleSpeed_DW.AvgVSpeedCtrl.msRollingTRTC >= AvgVehicleSpeed_DW.AvgVSpeedCtrl.msRollingTRTCBack) 
        {
          tmp_0 = ((int32_T)AvgVehicleSpeed_DW.AvgVSpeedCtrl.msRollingTRTC) - ((int32_T)AvgVehicleSpeed_DW.AvgVSpeedCtrl.msRollingTRTCBack);
          if (tmp_0 < 0) 
          {
            tmp_0 = 0;
          }

          qY = AvgVehicleSpeed_DW.AvgVSpeedCtrl.ACCTime + ((uint32_T)tmp_0);
          if (qY < AvgVehicleSpeed_DW.AvgVSpeedCtrl.ACCTime) 
          {
            qY = MAX_uint32_T;
          }

          AvgVehicleSpeed_DW.AvgVSpeedCtrl.ACCTime = qY;
          AvgVehicleSpeed_DW.AvgVSpeedCtrl.msRollingTRTCBack = AvgVehicleSpeed_DW.AvgVSpeedCtrl.msRollingTRTC;
        }
        else 
        {
          qY = (((uint32_T)((int32_T)(((int32_T)
                    AvgVehicleSpeed_DW.AvgVSpeedCtrl.msRollingTRTC) - ((int32_T)
                    AvgVehicleSpeed_DW.AvgVSpeedCtrl.msRollingTRTCBack)))) +
                AvgVehicleSpeed_DW.AvgVSpeedCtrl.ACCTime) + 65536U;
          if (qY < AvgVehicleSpeed_DW.AvgVSpeedCtrl.ACCTime) 
          {
            qY = MAX_uint32_T;
          }

          AvgVehicleSpeed_DW.AvgVSpeedCtrl.ACCTime = qY;
          AvgVehicleSpeed_DW.AvgVSpeedCtrl.msRollingTRTCBack = AvgVehicleSpeed_DW.AvgVSpeedCtrl.msRollingTRTC;
        }

        if (AvgVehicleSpeed_DW.AvgVSpeedCtrl.ACCMilleage < 500U) 
        {
          AvgVehicleSpeed_DW.AvgVSpeedCtrl.UpdateTimer = 0U;
          AvgVehicleSpeed_DW.AvgVSpeedCtrl.First500m = 0U;
        }
        else 
        {
          if (((int32_T)AvgVehicleSpeed_DW.AvgVSpeedCtrl.First500m) != 1) 
          {
            AvgVehicleSpeed_DW.AvgVSpeedCtrl.First500m = 0U;
            AvgVehicleSpeed_DW.AvgVSpeedCtrl.UpdateTimer = 100U;
          }
        }
        if((Get_ID_18FAB027_Sig_VCUPTReadyInd()!=1u) || (CAN_MSG_Status(ID_can0x18FAB027_Msg_Count)!=0u))
        {
          tmp_0 = 0;
        }
        else
        {
          tmp_0 = ((int32_T)AvgVehicleSpeed_DW.AvgVSpeedCtrl.UpdateTimer) + 1;
        }
        if (tmp_0 > 65535) 
        {
          tmp_0 = 65535;
        }

        AvgVehicleSpeed_DW.AvgVSpeedCtrl.UpdateTimer = (uint16_T)tmp_0;
        if (((int32_T)AvgVehicleSpeed_DW.AvgVSpeedCtrl.UpdateTimer) >= 100) 
        {
          AvgVehicleSpeed_DW.AvgVSpeedCtrl.UpdateTimer = 0U;
          AvgVehicleSpeedValid_0 = 1U;

          /* Outputs for Function Call SubSystem: '<S2>/AvgVspeedCalc' */
          tmp = (((real_T)AvgVehicleSpeed_DW.AvgVSpeedCtrl.ACCMilleage) * 3600.0) / (((real_T)AvgVehicleSpeed_DW.AvgVSpeedCtrl.ACCTime) * 100.0);

          /* End of Outputs for SubSystem: '<S2>/AvgVspeedCalc' */
          if (tmp < 65536.0) 
          {
            IPK_AverageVehicleSpeed_0 = (uint16_T)tmp;
          }
          else 
          {
            IPK_AverageVehicleSpeed_0 = MAX_uint16_T;
          }

          if (((int32_T)IPK_AverageVehicleSpeed_0) > 254) 
          {
            IPK_AverageVehicleSpeed_0 = 254U;
          }
        }
      }
    }
    else 
    {
      AvgVehicleSpeed_DW.AvgVSpeedCtrl.EnCalc = 0U;
    }
  }
  else 
  {
    /* case IN_Clear_AvgVehicleSpeed: */
    if (((int32_T)AvgVehicleSpeed_DW.AvgVSpeedCtrl.EnCalc) == 1) 
    {
      AvgVehicleSpeed_DW.bitsForTID0.is_c3_AvgVehicleSpeed = 1U;
    }
    else 
    {
      AvgVehicleSpeed_DW.AvgVSpeedCtrl.mRollingMilleageBack = mRollingCounter;
      AvgVehicleSpeed_DW.AvgVSpeedCtrl.msRollingTRTCBack = RTCRollingCounter;
      if (((int32_T)AvgVehicleSpeed_DW.AvgVSpeedCtrl.KL30Init) == 1) 
      {
        AvgVehicleSpeed_DW.AvgVSpeedCtrl.KL30Init = 0U;
        IPK_AverageVehicleSpeed_0 = (uint16_T)0xFF;
        AvgVehicleSpeedValid_0 = 0U;
        AvgVehicleSpeed_DW.AvgVSpeedCtrl.EnCalc = 0U;
        AvgVehicleSpeed_DW.AvgVSpeedCtrl.ACCMilleage = 0U;
        AvgVehicleSpeed_DW.AvgVSpeedCtrl.ACCTime = 0U;
      }

      if (((PowerSt == PowerStatus_ON) && (((int32_T)AvgVehicleSpeed_U.EngineValid) != 0)) && (((int32_T)AvgVehicleSpeed_U.EngineValue) > 300)) 
      {
        AvgVehicleSpeed_DW.AvgVSpeedCtrl.EnCalc = 1U;
        IPK_AverageVehicleSpeed_0 = (uint16_T)0xFF;
        AvgVehicleSpeedValid_0 = 0U;
        AvgVehicleSpeed_DW.AvgVSpeedCtrl.ACCMilleage = 0U;
        AvgVehicleSpeed_DW.AvgVSpeedCtrl.ACCTime = 0U;
      }
    }
  }

  IPK_AverageVehicleSpeed = IPK_AverageVehicleSpeed_0;
  AvgVehicleSpeedValid = AvgVehicleSpeedValid_0;
}

/* Model initialize function */
void AvgVehicleSpeed_initialize(void)
{
  /* SystemInitialize for Chart: '<S1>/AvgVehicleSpeed' */
  AvgVehicleSpeed_DW.AvgVSpeedCtrl.KL30Init = 0U;
  AvgVehicleSpeed_DW.AvgVSpeedCtrl.VRunning = 0U;
  AvgVehicleSpeed_DW.AvgVSpeedCtrl.First500m = 0U;
  AvgVehicleSpeed_DW.AvgVSpeedCtrl.EnCalc = 0U;
  AvgVehicleSpeed_DW.AvgVSpeedCtrl.UpdateTimer = 0U;
  AvgVehicleSpeed_DW.AvgVSpeedCtrl.mRollingMilleage = 0U;
  AvgVehicleSpeed_DW.AvgVSpeedCtrl.mRollingMilleageBack = 0U;
  AvgVehicleSpeed_DW.AvgVSpeedCtrl.msRollingTRTCBack = 0U;
  AvgVehicleSpeed_DW.AvgVSpeedCtrl.msRollingTRTC = 0U;
  AvgVehicleSpeed_DW.AvgVSpeedCtrl.ACCMilleage = 0U;
  AvgVehicleSpeed_DW.AvgVSpeedCtrl.ACCTime = 0U;
}

/* Model terminate function */
void AvgVehicleSpeed_terminate(void)
{
  /* (no terminate code required) */
}

/*
 * File trailer for generated code.
 *
 * [EOF]
 */
