#include "Telltales_Lib.h"
#include "Telltales_user.h"
#include "TYW_stdint.h"
#include "CAN_Communication_Matrix.h"
#include "PowerManagement.h"
#include "Flash_synchronizer.h"
#include "Line_In.h"
#include "Common_Interface.h"
#include "LED_Driver.h"
#include "SEG_DISPLAY.h"
#include "Sound_Scheduler.h"
#include "Gauge_Display.h"
#include "System_Status_Monitor.h"
#include "Services_ODO.h"
#include "Popup_Scheduler.h"
#include "Services_Interval.h"
#include "MBD_Model.h"





extern uint32_t Factory_ClearOdo_Display_Flag;

typedef struct
{
    uint8_t   LastLeft;
    uint8_t   LastRight;
    uint8_t   Delay;
} TelltaleLRCtrlStruct;

TelltaleLRCtrlStruct TelltaleLRCtrl;


canlib_uint16_t LED_TPMS_Fault_FlashTimer = 0;

uint32_t LED_PowerON_Timer = 0;
uint32_t LED_PowerOFF_Timer = 0;
uint32_t  i = 0;
uint32_t  j = 0;
uint32_t  Frame = 0;
uint32_t  GEAR = 0;
uint32_t  Temp = 0;

//��ȫ��
uint16_t Seatbelt_CumulativeDistance = 0;
uint32_t Seatbelt_Timer = 0;
uint32_t Seatbelt_Timer1 = 0;
uint32_t Seatbelt_Timer2 = 0;
uint8_t  Seatbelt_Accumulate_Flag = 0;
uint8_t  Seatbelt_Flag_60s = 0;
uint32_t Seatbelt_Timer_500m = 0;
uint8_t  Seatbelt_Flag = 0;
//�ſ�����
uint32_t OpenDoor_Timer = 0;
uint8_t  OpenDoor_Accumulate_Flag = 0;
extern uint16_t SelfCheck_time;

#pragma pack(8)
Tellib_uint8_t Tel_Mem [ Tel_MEM_Block_Size * LED_Max + Tel_MEM_Block_Addition ];
#pragma pack( )


const LED_Attr_st_t LED_Attr[] = {
/*  LED_TurnRight_G,           */   {  0,    0,    100,},
/*  LED_Position_G,            */   {  0,    1,    100,},
/*  LED_Daylight_G,            */   {  0,    2,    100,},
/*  LED_READY_G,               */   {  0,    3,    100,},
/*  LED_LBeam_G,               */   {  0,    4,    100,},
/*  LED_HBeam_B,               */   {  0,    5,    100,},
/*  LED_TurnLeft_G,            */   {  0,    6,    100,},
/*  LED_InsulationFault_R,     */   {  0,    7,    100,},
/*  LED_ReserveLamp_1,         */   {  0,    8,    100,},
/*  LED_SOC_CC_R,              */   {  0,    9,    100,},
/*  LED_SOC_CS_Y,              */   {  0,   10,    100,},
/*  LED_BrakeSystemFault_R,    */   {  0,   11,    100,},
/*  LED_SOC_DC_Y,              */   {  0,   12,    100,},
/*  LED_SOC_CF_R,              */   {  0,   13,    100,},
/*  LED_SOC_HT_R,              */   {  0,   14,    100,},
/*  LED_SOC_Fault_R,           */   {  0,   15,    100,},
/*  LED_SOC_LP_Y,              */   {  0,   16,    100,},
/*  LED_ESP_R,                 */   {  0,   17,    100,},
/*  LED_ABS_Y,                 */   {  0,   18,    100,},
/*  LED_EBD_fault_Y,           */   {  0,   19,    100,},
/*  LED_RemoteLocking_R,       */   {  0,   20,    100,},
/*  LED_Energy_Recovery_W,     */   {  0,   21,    100,},
/*  LED_OTA_W,                 */   {  0,   22,    100,},
/*  LED_Energy_Recovery_G,     */   {  0,   23,    100,},
/*  LED_MaintainWarning_W,     */   {  0,   24,    100,},
/*  LED_EWP_R,                 */   {  0,   25,    100,},
/*  LED_MotorFault_R,          */   {  0,   26,    100,},
/*  LED_WeightOverload_R,      */   {  0,   27,    100,},
/*  LED_WeightOverload_Y,      */   {  0,   28,    100,},
/*  LED_SystemFault_R,         */   {  0,   29,    100,},
/*  LED_PowerLimit_Y,          */   {  0,   30,    100,},
/*  LED_RearFog_Y,             */   {  0,   31,    100,},
/*  LED_EPS_Y,                 */   {  0,   32,    100,},
/*  LED_SEATBELT_DR_R,         */   {  0,   33,    100,},
/*  LED_DoorOpen_R,            */   {  0,   34,    100,},
/*  LED_ECO_G,                 */   {  0,   35,    100,},
};


static Tellib_uint16_t LED_Hbeam_Judge(void);
static void            LED_Hbeam_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Lbeam_Judge(void);
static void            LED_Lbeam_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Position_Judge(void);
static void            LED_Position_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_RearFog_Judge(void);
static void            LED_RearFog_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Daylight_Judge(void);
static void            LED_Daylight_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_ABS_Judge(void);
static void            LED_ABS_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_EBD_fault_Judge(void);
static void            LED_EBD_fault_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_BrakeSystemFault_Judge(void);
static void            LED_BrakeSystemFault_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_EPB_Status_Judge(void);
static void            LED_EPB_Status_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_EPS_Judge(void);
static void            LED_EPS_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_SEATBELT_DR_Judge(void);
static void            LED_SEATBELT_DR_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_SOC_CF_Judge(void);
static void            LED_SOC_CF_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_SOC_CC_Judge(void);
static void            LED_SOC_CC_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_SOC_CS_Judge(void);
static void            LED_SOC_CS_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_SOC_LP_Judge(void);
static void            LED_SOC_LP_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_SOC_Fault_Judge(void);
static void            LED_SOC_Fault_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_SOC_HT_Judge(void);
static void            LED_SOC_HT_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_SystemFault_Judge(void);
static void            LED_SystemFault_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_READY_Judge(void);
static void            LED_READY_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_MotorFault_Judge(void);
static void            LED_MotorFault_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_PowerLimit_Judge(void);
static void            LED_PowerLimit_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_ECO_Judge(void);
static void            LED_ECO_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_InsulationFault_Judge(void);
static void            LED_InsulationFault_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Energy_Recovery_Judge(void);
static void            LED_Energy_Recovery_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_HighPressureInterlock_Judge(void);
static void            LED_HighPressureInterlock_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_DoorOpen_Judge(void);
static void            LED_DoorOpen_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_OTA_Judge(void);
static void            LED_OTA_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_RemoteLocking_Judge(void);
static void            LED_RemoteLocking_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_MaintainWarning_Judge(void);
static void            LED_MaintainWarning_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_MotorOverheating_Judge(void);
static void            LED_MotorOverheating_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_SOC_DC_Judge(void);
static void            LED_SOC_DC_Exec(Tellib_uint16_t led_status);

//static void LED_TurnRight_Exec(Tellib_uint16_t led_status);
//static void LED_TurnLeft_Exec(Tellib_uint16_t led_status);
void delay(uint32_t z);
void SEG_DISPLAY(void);
//void LED_DISPlAY(void);
//void TYW_check(void);

const LED_Attribute_st LED_Attribute [ LED_Max ] = 
{
    // {m_LED_TurnLeft, NoSelfCheck, ExterNalCheck, LED_IGN_ON_OFF, 0ul, POWERON_SCAN_TIMER, LED_TurnLeft_Judge, LED_TurnLeft_Exec},
    // {m_LED_TurnRight, NoSelfCheck, ExterNalCheck, LED_IGN_ON_OFF, 0ul, POWERON_SCAN_TIMER, LED_TurnRight_Judge, LED_TurnRight_Exec},
    {m_LED_Hbeam                , NoSelfCheck,     NoExterNalCheck,   LED_IGN_ON,        0ul,        POWERON_SCAN_TIMER, LED_Hbeam_Judge,            LED_Hbeam_Exec                 },
    {m_LED_Lbeam                , NoSelfCheck,     NoExterNalCheck,   LED_IGN_ON,        0ul,        POWERON_SCAN_TIMER, LED_Lbeam_Judge,            LED_Lbeam_Exec                 },
    {m_LED_Position             , NoSelfCheck,     ExterNalCheck,   LED_IGN_ON_OFF,    0ul,        POWERON_SCAN_TIMER, LED_Position_Judge,         LED_Position_Exec              },
    {m_LED_RearFog              , NoSelfCheck,     NoExterNalCheck,   LED_IGN_ON,        0ul,        POWERON_SCAN_TIMER, LED_RearFog_Judge,          LED_RearFog_Exec               },
    {m_LED_Daylight             , NoSelfCheck,     NoExterNalCheck,   LED_IGN_ON,        0ul,        POWERON_SCAN_TIMER, LED_Daylight_Judge,         LED_Daylight_Exec              },
    {m_LED_ABS                  , SelfCheck,       NoExterNalCheck, LED_IGN_ON,        0ul,        POWERON_SCAN_TIMER, LED_ABS_Judge,              LED_ABS_Exec                   },
    {m_LED_EBD_fault            , SelfCheck,       NoExterNalCheck, LED_IGN_ON,        0ul,        POWERON_SCAN_TIMER, LED_EBD_fault_Judge,        LED_EBD_fault_Exec             },
    {m_LED_BrakeSystemFault     , SelfCheck,       NoExterNalCheck,   LED_IGN_ON,        0ul,        POWERON_SCAN_TIMER, LED_BrakeSystemFault_Judge, LED_BrakeSystemFault_Exec      },
    {m_LED_EPB_Status           , NoSelfCheck,     ExterNalCheck, LED_IGN_ON_OFF,    0ul,        POWERON_SCAN_TIMER, LED_EPB_Status_Judge,       LED_EPB_Status_Exec            },
    {m_LED_EPS                  , SelfCheck,       NoExterNalCheck, LED_IGN_ON,        0ul,        POWERON_SCAN_TIMER, LED_EPS_Judge,              LED_EPS_Exec                   },
    {m_LED_SEATBELT_DR          , SelfCheck,       NoExterNalCheck, LED_IGN_ON,        0ul,         4000ul,            LED_SEATBELT_DR_Judge,      LED_SEATBELT_DR_Exec           },
    {m_LED_SOC_CF               , SelfCheck,       NoExterNalCheck, LED_IGN_ON,        0ul,        POWERON_SCAN_TIMER, LED_SOC_CF_Judge,           LED_SOC_CF_Exec                },
    {m_LED_SOC_CC               , SelfCheck,       NoExterNalCheck, LED_IGN_ON_OFF,    0ul,        POWERON_SCAN_TIMER, LED_SOC_CC_Judge,           LED_SOC_CC_Exec                },
    {m_LED_SOC_CS               , SelfCheck,       NoExterNalCheck, LED_IGN_ON_OFF,    0ul,        POWERON_SCAN_TIMER, LED_SOC_CS_Judge,           LED_SOC_CS_Exec                },
    {m_LED_SOC_LP               , SelfCheck,       NoExterNalCheck, LED_IGN_ON,        0ul,        POWERON_SCAN_TIMER, LED_SOC_LP_Judge,           LED_SOC_LP_Exec                },
    {m_LED_SOC_Fault            , SelfCheck,       NoExterNalCheck, LED_IGN_ON_OFF,    0ul,        POWERON_SCAN_TIMER, LED_SOC_Fault_Judge,        LED_SOC_Fault_Exec             },
    {m_LED_SOC_HT               , SelfCheck,       NoExterNalCheck, LED_IGN_ON_OFF,    0ul,        POWERON_SCAN_TIMER, LED_SOC_HT_Judge,           LED_SOC_HT_Exec                },
    {m_LED_SystemFault          , NoSelfCheck,     NoExterNalCheck,   LED_IGN_ON,        0ul,        POWERON_SCAN_TIMER, LED_SystemFault_Judge,      LED_SystemFault_Exec           },
    {m_LED_READY                , NoSelfCheck,     NoExterNalCheck,   LED_IGN_ON,        0ul,        POWERON_SCAN_TIMER, LED_READY_Judge,            LED_READY_Exec                 },
    {m_LED_MotorFault           , NoSelfCheck,     NoExterNalCheck,   LED_IGN_ON,        0ul,        POWERON_SCAN_TIMER, LED_MotorFault_Judge,       LED_MotorFault_Exec            },
    {m_LED_PowerLimit           , NoSelfCheck,     NoExterNalCheck,   LED_IGN_ON,        0ul,        POWERON_SCAN_TIMER, LED_PowerLimit_Judge,       LED_PowerLimit_Exec            },
    {m_LED_ECO                  , NoSelfCheck,     NoExterNalCheck,   LED_IGN_ON,        0ul,        4000ul,             LED_ECO_Judge,              LED_ECO_Exec                   },
    {m_LED_InsulationFault      , SelfCheck,       NoExterNalCheck, LED_IGN_ON_OFF,    0ul,        POWERON_SCAN_TIMER, LED_InsulationFault_Judge,  LED_InsulationFault_Exec       },
    {m_LED_Energy_Recovery      , NoSelfCheck,     NoExterNalCheck,   LED_IGN_ON,        0ul,        POWERON_SCAN_TIMER, LED_Energy_Recovery_Judge,  LED_Energy_Recovery_Exec       },
    {m_LED_HighPressureInterlock  , SelfCheck,     NoExterNalCheck,   LED_IGN_ON,        0ul,        POWERON_SCAN_TIMER, LED_HighPressureInterlock_Judge,   LED_HighPressureInterlock_Exec        },
    {m_LED_DoorOpen             , NoSelfCheck,     ExterNalCheck,   LED_IGN_ON_OFF,    0ul,        POWERON_SCAN_TIMER, LED_DoorOpen_Judge,         LED_DoorOpen_Exec              },
    {m_LED_FrontFog             , NoSelfCheck,     NoExterNalCheck,   LED_IGN_ON,        0ul,        POWERON_SCAN_TIMER, LED_OTA_Judge,              LED_OTA_Exec                   },
    {m_LED_RemoteLocking        , NoSelfCheck,     NoExterNalCheck,   LED_IGN_ON,        0ul,        POWERON_SCAN_TIMER, LED_RemoteLocking_Judge,    LED_RemoteLocking_Exec         },
    {m_LED_MaintainWarning            , SelfCheck,     NoExterNalCheck,   LED_IGN_ON,        0ul,        POWERON_SCAN_TIMER, LED_MaintainWarning_Judge,        LED_MaintainWarning_Exec             },
    {m_LED_MotorOverheating     , SelfCheck,     NoExterNalCheck,   LED_IGN_ON,        0ul,        POWERON_SCAN_TIMER, LED_MotorOverheating_Judge,  LED_MotorOverheating_Exec                   },
    {m_LED_SOC_DC               , NoSelfCheck,     NoExterNalCheck,   LED_IGN_ON,        0ul,        POWERON_SCAN_TIMER, LED_SOC_DC_Judge,           LED_SOC_DC_Exec                },
};

/*must put into 10ms task*/
void Telltales_Left_Right_KL30_Init(void)
{
    TelltaleLRCtrl.LastRight = 0u;
    TelltaleLRCtrl.LastLeft = 0u;
    TelltaleLRCtrl.Delay = 0u;
}

void Telltales_Left_Right_Management_Service(void) /*10ms*/ /*830104,830204,830304*/
{
    uint8_t Edge;
    uint8_t LEFT_ST  = 0x00u;
    uint8_t RIGHT_ST = 0x00u;

    Edge = 0xFFu;
    LEFT_ST  =Get_Line_In_TurnLeft();// Get_LINE_IN_Sts(LINE_IN_TURNLEFT);
    RIGHT_ST =Get_Line_In_TurnRight();// Get_LINE_IN_Sts(LINE_IN_TURNRIGHT);
    

    /*��ת��*/
    if ( LEFT_ST == 1u )
    {
        LED_Driver_Channel_Set(LED_Attr [ LED_TurnLeft_G ].chip, LED_Attr [ LED_TurnLeft_G ].channel, LED_Attr [ LED_TurnLeft_G ].brightness);
        SEG_SET_LED_STS(SEG_LED_TurnLeft, IC_SEG_ON);
    }
    else
    {
        LED_Driver_Channel_Set(LED_Attr [ LED_TurnLeft_G ].chip, LED_Attr [ LED_TurnLeft_G ].channel, 0);
        SEG_SET_LED_STS(SEG_LED_TurnLeft, IC_SEG_OFF_LED);
    }
    if ( TelltaleLRCtrl.LastLeft != LEFT_ST )
    {
        TelltaleLRCtrl.LastLeft = LEFT_ST;
        Edge                    = LEFT_ST;
    }

    /*��ת��*/
    if ( RIGHT_ST == 1u )
    {
        LED_Driver_Channel_Set(LED_Attr [ LED_TurnRight_G ].chip, LED_Attr [ LED_TurnRight_G ].channel, LED_Attr [ LED_TurnRight_G ].brightness);
        SEG_SET_LED_STS(SEG_LED_TurnRight, IC_SEG_ON);
    }
    else
    {
        LED_Driver_Channel_Set(LED_Attr [ LED_TurnRight_G ].chip, LED_Attr [ LED_TurnRight_G ].channel, 0);
        SEG_SET_LED_STS(SEG_LED_TurnRight, IC_SEG_OFF_LED);
    }
    if ( TelltaleLRCtrl.LastRight != RIGHT_ST )
    {
        TelltaleLRCtrl.LastRight = RIGHT_ST;
        Edge                     = RIGHT_ST;
    }

    if ( TelltaleLRCtrl.Delay > 0u )
    {
        TelltaleLRCtrl.Delay--;
    }
    else
    {
        if ( Edge != 0xFFu )
        {
            if ( Edge )
            {
                Sound_Request(SND_TICK, 1);
            }
            else
            {
                Sound_Request(SND_TOCK, 1);
            }

            TelltaleLRCtrl.Delay = 6; /*200ms�ڲ������ظ���������*/
        }
        else
        {
            Sound_Delete(SND_TICK);
            Sound_Delete(SND_TOCK);
        }
    }
}
void Telltales_Init(void)
{
    
    TelExtPara m_ExtPara;
    m_ExtPara.TotalLength           = LED_Max;
    m_ExtPara.LED_PowerOFF_TimerCbk = Get_PowerOFF_Timer;
    m_ExtPara.LED_PowerON_TimerCbk  = Get_PowerON_Timer;
    m_ExtPara.LED_PowerCbk          = Common_Get_IG_Sts;

    
    Telltales_KL30_Wakeup_Init(( Tellib_uint8_t * )Tel_Mem, LED_Attribute, &m_ExtPara); 
    
   
    
    
    
}

uint32_t Get_PowerON_Timer(void)
{
    return LED_PowerON_Timer;
}

uint32_t Get_PowerOFF_Timer(void)
{
    return LED_PowerOFF_Timer;
}

void LED_PowerTimer_Service(uint32_t timer)
{
    if ( Common_Get_IG_Sts( ) == COMMON_POWER_ON )
    {
        LED_PowerON_Timer += timer;
        LED_PowerOFF_Timer = 0;
    }
    else
    {
        Seatbelt_CumulativeDistance = 0;
        Seatbelt_Accumulate_Flag    = 0;
        Seatbelt_Timer              = 0;
        LED_PowerON_Timer           = 0;
        LED_PowerOFF_Timer += timer;
        PopupAndSound_Delete(POPUP_SEATBELT_DR_1HZ);
        PopupAndSound_Delete(POPUP_SEATBELT_DR_2HZ);
    }
}

static Tellib_uint16_t LED_Hbeam_Judge(void)
{
    Tellib_uint16_t res = 0u;

    if(Get_LINE_IN_Sts(LINE_IN_HBEAM) == 1u)
    {
        res = 1u;
    }
    else
    {
        res = 0u;
    }

    return res;
}

static void LED_Hbeam_Exec(Tellib_uint16_t led_status)
{
  
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_HBeam_B].chip, LED_Attr[LED_HBeam_B].channel, LED_Attr[LED_HBeam_B].brightness);
            SEG_SET_LED_STS(SEG_LED_Hbeam, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_HBeam_B].chip, LED_Attr[LED_HBeam_B].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_Hbeam, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_HBeam_B].chip, LED_Attr[LED_HBeam_B].channel, LED_Attr[LED_HBeam_B].brightness);
            SEG_SET_LED_STS(SEG_LED_Hbeam, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_HBeam_B].chip, LED_Attr[LED_HBeam_B].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_Hbeam, IC_SEG_OFF_LED);
        }
    }
    
}

static Tellib_uint16_t LED_Lbeam_Judge(void)
{
    Tellib_uint16_t res = 0u;

    if(Get_LINE_IN_Sts(LINE_IN_LBEAM) == 1u)
    {
        res = 1u;
    }
    else
    {
        res = 0u;
    }

    return res;
}

static void LED_Lbeam_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_LBeam_G].chip, LED_Attr[LED_LBeam_G].channel, LED_Attr[LED_LBeam_G].brightness);
            SEG_SET_LED_STS(SEG_LED_Lbeam, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_LBeam_G].chip, LED_Attr[LED_LBeam_G].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_Lbeam, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_LBeam_G].chip, LED_Attr[LED_LBeam_G].channel, LED_Attr[LED_LBeam_G].brightness);
            SEG_SET_LED_STS(SEG_LED_Lbeam, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_LBeam_G].chip, LED_Attr[LED_LBeam_G].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_Lbeam, IC_SEG_OFF_LED);
        }
    }
    
}

static Tellib_uint16_t LED_Position_Judge(void)
{
    Tellib_uint16_t res = 0u;

    if(Get_LINE_IN_Sts(LINE_IN_POSITION) == 1u)
    {
        res = 1u;
    }
    else
    {
        res = 0u;
    }

    return res;
}

static void LED_Position_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Position_G].chip, LED_Attr[LED_Position_G].channel, LED_Attr[LED_Position_G].brightness);
            SEG_SET_LED_STS(SEG_LED_Position, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Position_G].chip, LED_Attr[LED_Position_G].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_Position, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Position_G].chip, LED_Attr[LED_Position_G].channel, LED_Attr[LED_Position_G].brightness);
            SEG_SET_LED_STS(SEG_LED_Position, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Position_G].chip, LED_Attr[LED_Position_G].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_Position, IC_SEG_OFF_LED);
        }
    }
    
}

static Tellib_uint16_t LED_RearFog_Judge(void)
{
    Tellib_uint16_t res = 0u;

    if(Get_LINE_IN_Sts(LINE_IN_REARFOG) == 1u)
    {
        res = 1u;
    }
    else
    {
        res = 0u;
    }

    return res;
}

static void LED_RearFog_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_RearFog_Y].chip, LED_Attr[LED_RearFog_Y].channel, LED_Attr[LED_RearFog_Y].brightness);
            SEG_SET_LED_STS(SEG_LED_RearFog, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_RearFog_Y].chip, LED_Attr[LED_RearFog_Y].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_RearFog, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_RearFog_Y].chip, LED_Attr[LED_RearFog_Y].channel, LED_Attr[LED_RearFog_Y].brightness);
            SEG_SET_LED_STS(SEG_LED_RearFog, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_RearFog_Y].chip, LED_Attr[LED_RearFog_Y].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_RearFog, IC_SEG_OFF_LED);
        }
    }
    
}

static Tellib_uint16_t LED_Daylight_Judge(void)
{
    Tellib_uint16_t res = 0u;

    if(Get_LINE_IN_Sts(LINE_IN_DAYLIGHT) == 1u)
    {
        res = 1u;
    }
    else
    {
        res = 0u;
    }

    return res;
}

static void LED_Daylight_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Daylight_G].chip, LED_Attr[LED_Daylight_G].channel, LED_Attr[LED_Daylight_G].brightness);
            SEG_SET_LED_STS(SEG_LED_Daylight, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Daylight_G].chip, LED_Attr[LED_Daylight_G].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_Daylight, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Daylight_G].chip, LED_Attr[LED_Daylight_G].channel, LED_Attr[LED_Daylight_G].brightness);
            SEG_SET_LED_STS(SEG_LED_Daylight, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Daylight_G].chip, LED_Attr[LED_Daylight_G].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_Daylight, IC_SEG_OFF_LED);
        }
    }
    
}

static Tellib_uint16_t LED_ABS_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if ( CAN_MSG_Status(ID_can0x18F0010B_Msg_Count) == 0u )
        {
            if ( (Get_ID_18F0010B_Sig_ABSABSEBSAmberWarningState( ) == 1u) )
            {
                res = 1u;
            }
            else
            {
                res = 0u;
            }
        }
        else
        {
            res = 1u;
        }
    }

    return res;
}

static void LED_ABS_Exec(Tellib_uint16_t led_status)
{
    
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_ABS_Y].chip, LED_Attr[LED_ABS_Y].channel, LED_Attr[LED_ABS_Y].brightness);
            SEG_SET_LED_STS(SEG_LED_ABS, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_ABS_Y].chip, LED_Attr[LED_ABS_Y].channel, 0);
            SEG_SET_LED_STS(SEG_LED_ABS, IC_SEG_OFF_LED);
        } 
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_ABS_Y].chip, LED_Attr[LED_ABS_Y].channel, LED_Attr[LED_ABS_Y].brightness);
            SEG_SET_LED_STS(SEG_LED_ABS, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_ABS_Y].chip, LED_Attr[LED_ABS_Y].channel, 0);
            SEG_SET_LED_STS(SEG_LED_ABS, IC_SEG_OFF_LED);
        }
    }    
    
    
}

static Tellib_uint16_t LED_EBD_fault_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if ( CAN_MSG_Status(ID_can0x18F0010B_Msg_Count) != 0u )
        {
            res = 1u;
        }
        else
        {
            if ( Get_ID_18F0010B_Sig_ABSEBDAmberWarningState( ) == 1u )
            {
                res = 1u;
            }
            else
            {
                res = 0u;
            }
        } 
    }
    
    return res;
}

static void LED_EBD_fault_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EBD_fault_Y].chip, LED_Attr[LED_EBD_fault_Y].channel, LED_Attr[LED_EBD_fault_Y].brightness);
            SEG_SET_LED_STS(SEG_LED_EBD_fault, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EBD_fault_Y].chip, LED_Attr[LED_EBD_fault_Y].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_EBD_fault, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EBD_fault_Y].chip, LED_Attr[LED_EBD_fault_Y].channel, LED_Attr[LED_EBD_fault_Y].brightness);
            SEG_SET_LED_STS(SEG_LED_EBD_fault, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EBD_fault_Y].chip, LED_Attr[LED_EBD_fault_Y].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_EBD_fault, IC_SEG_OFF_LED);
        }
    }
    
}

static Tellib_uint16_t LED_BrakeSystemFault_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(Get_LINE_IN_Sts(LINE_IN_BRAKEFLUID)==1u)
        {
            res = 1u;
        }    
        else if((Get_ID_18FAB027_Sig_VCUBrkSysErr()==1u)&&(CAN_MSG_Status(ID_can0x18FAB027_Msg_Count)==0u))
        {
            res = 1u;
        }
        else
        {
            res = 0u;
        }  
    }
    

    return res;
}

static void LED_BrakeSystemFault_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_BrakeSystemFault_R].chip, LED_Attr[LED_BrakeSystemFault_R].channel, LED_Attr[LED_BrakeSystemFault_R].brightness);
            SEG_SET_LED_STS(SEG_LED_EPB_Status, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_BrakeSystemFault_R].chip, LED_Attr[LED_BrakeSystemFault_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_EPB_Status, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_BrakeSystemFault_R].chip, LED_Attr[LED_BrakeSystemFault_R].channel, LED_Attr[LED_BrakeSystemFault_R].brightness);
            SEG_SET_LED_STS(SEG_LED_EPB_Status, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_BrakeSystemFault_R].chip, LED_Attr[LED_BrakeSystemFault_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_EPB_Status, IC_SEG_OFF_LED);
        }
    }
    
}

static Tellib_uint16_t LED_EPB_Status_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(Get_ID_18FAB027_Sig_VCUHandbrakeSts() == 1)
        {
            if((Get_DispVechileSpeed() > 50u)&&(SelfCheck_time >= 30))
            {
                res = 2; 
            }
            else
            {
                res = 1;  
            }
        }
        else
        {
            res = 0;
        }
    }
    
    
    return res;
}

static void LED_EPB_Status_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_ESP_R].chip, LED_Attr[LED_ESP_R].channel, LED_Attr[LED_ESP_R].brightness);
            SEG_SET_LED_STS(SEG_LED_BrakeSystemFault, IC_SEG_ON);
        }
        else if(led_status == 2u)
        {
            if(FLASH_SYNC_05Hz)
            {
                LED_Driver_Channel_Set(LED_Attr[LED_ESP_R].chip, LED_Attr[LED_ESP_R].channel, LED_Attr[LED_ESP_R].brightness);
                SEG_SET_LED_STS(SEG_LED_BrakeSystemFault, IC_SEG_ON);
            }
            else
            {
                LED_Driver_Channel_Set(LED_Attr[LED_ESP_R].chip, LED_Attr[LED_ESP_R].channel, 0u);
                SEG_SET_LED_STS(SEG_LED_BrakeSystemFault, IC_SEG_OFF_LED);
            }

        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_ESP_R].chip, LED_Attr[LED_ESP_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_BrakeSystemFault, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_ESP_R].chip, LED_Attr[LED_ESP_R].channel, LED_Attr[LED_ESP_R].brightness);
            SEG_SET_LED_STS(SEG_LED_BrakeSystemFault, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_ESP_R].chip, LED_Attr[LED_ESP_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_BrakeSystemFault, IC_SEG_OFF_LED);
        }
    }
    
}


static Tellib_uint16_t LED_EPS_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(CAN_MSG_Status(ID_can0x18FECA10_Msg_Count) == 0u)
        {
            if(Get_ID_18FECA10_Sig_EPSMalfunctionIndicatorLamp()==1u)
            {
                res = 1u;
            }
            else
            {
                res = 0u;
            }
        }
        else
        {
            res = 1u;
        }
    }
    

    return res;
}

static void LED_EPS_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EPS_Y].chip, LED_Attr[LED_EPS_Y].channel, LED_Attr[LED_EPS_Y].brightness);
            SEG_SET_LED_STS(SEG_LED_EPS, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EPS_Y].chip, LED_Attr[LED_EPS_Y].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_EPS, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EPS_Y].chip, LED_Attr[LED_EPS_Y].channel, LED_Attr[LED_EPS_Y].brightness);
            SEG_SET_LED_STS(SEG_LED_EPS, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EPS_Y].chip, LED_Attr[LED_EPS_Y].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_EPS, IC_SEG_OFF_LED);
        }
    }
    
}
/*
static Tellib_uint16_t LED_SEATBELT_DR_Judge(void)
{
    Tellib_uint16_t res = 0u;
    uint16_t DispSpeed = 0;
    if(Get_LINE_IN_Sts(LINE_IN_SEATBELT_DR) == 1u )
    {
        res = 1u;
    }

    if ( (Get_LINE_IN_Sts(LINE_IN_SEATBELT_DR) == 1u) && (Common_Get_Disp_V_Speed_Valid( ) == 1u) && (Common_Get_Disp_V_Speed( ) != 0u) )
    {     
        DispSpeed = Common_Get_Disp_V_Speed() / 10u;
        if (( DispSpeed > 0u )&&(DispSpeed < 10u))
        {
            if( Seatbelt_Timer <= 0xffff0000ul )
            {
                Seatbelt_Timer += 10;
            }

            if ( Seatbelt_Timer >= 180000u )
            {
                res = 1u;
                PopupAndSound_Delete(POPUP_SEATBELT_DR_1HZ);
                PopupAndSound_Delete(POPUP_SEATBELT_DR_2HZ);
            }
            else if (Seatbelt_Timer >= 60000u)
            {
                res = 2u;
                Popup_Request(POPUP_SEATBELT_DR_1HZ);
                PopupAndSound_Delete(POPUP_SEATBELT_DR_2HZ);
            }
            else
            {
                res = 1u;
                PopupAndSound_Delete(POPUP_SEATBELT_DR_1HZ);
                PopupAndSound_Delete(POPUP_SEATBELT_DR_2HZ);
            }

            if( Data_MileageRollingCounter_Read( ) > 500)
            {
                if(Seatbelt_Timer_500m < 120000)
                {
                    res = 2u;
                    Popup_Request(POPUP_SEATBELT_DR_1HZ);
                    PopupAndSound_Delete(POPUP_SEATBELT_DR_2HZ);  
                    Seatbelt_Timer_500m += 10;
                }
            }   
        }
        else if ((DispSpeed >= 10 )&&(DispSpeed < 25u ))
        {
            res = 2u;
            Popup_Request(POPUP_SEATBELT_DR_1HZ);
            PopupAndSound_Delete(POPUP_SEATBELT_DR_2HZ);
        }
        else
        {
            res = 2u;
            Popup_Request(POPUP_SEATBELT_DR_2HZ);
            PopupAndSound_Delete(POPUP_SEATBELT_DR_1HZ);
        }

        if(((CAN_MSG_Status(ID_can0x18FAB027_Msg_Count) == 0u)&&(Get_ID_18FAB027_Sig_VCUHandbrakeSts( ) == 1u))||((CAN_MSG_Status(ID_can0x18FAB027_Msg_Count) == 0u)&&(Get_ID_18FAB027_Sig_VCUGearPositionInd( ) == 0xDFu)))
        {  
            res = 1u;
            PopupAndSound_Delete(POPUP_SEATBELT_DR_1HZ);
            PopupAndSound_Delete(POPUP_SEATBELT_DR_2HZ);
        }
    }
    else if((Seatbelt_Timer < 60000)&&(Common_Get_Disp_V_Speed( ) == 0u))
    {
        Seatbelt_Timer = 0;
        PopupAndSound_Delete(POPUP_SEATBELT_DR_1HZ);
        PopupAndSound_Delete(POPUP_SEATBELT_DR_2HZ);
    }
    else
    {
        PopupAndSound_Delete(POPUP_SEATBELT_DR_1HZ);
        PopupAndSound_Delete(POPUP_SEATBELT_DR_2HZ);
    }
    return res;
}*/



static Tellib_uint16_t LED_SEATBELT_DR_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        uint16_t ActualSpeed = 0;
        if (Get_LINE_IN_Sts(LINE_IN_SEATBELT_DR) == 1u) 
        {
           if((Get_ID_18FAB027_Sig_VCUGearPositionInd( ) == 0xDFu) || (Get_ID_18FAB027_Sig_VCUHandbrakeSts( ) == 1u) )
           {
               Seatbelt_Timer              = 0;
               Seatbelt_Timer1             = 0;
               Seatbelt_Timer2             = 0;
               Seatbelt_Accumulate_Flag    = 0;
               Seatbelt_CumulativeDistance = 0;//shi
               res = 1u;
               Seatbelt_Flag_60s = 0;
               PopupAndSound_Delete(POPUP_SEATBELT_DR_1HZ);
               PopupAndSound_Delete(POPUP_SEATBELT_DR_2HZ);
           }
           ActualSpeed  = Common_Get_Disp_V_Speed( ) / 10u;//显示车速
           if ( Seatbelt_Accumulate_Flag == 0 )
           {
               Seatbelt_Accumulate_Flag    = 1;
               Seatbelt_CumulativeDistance = Data_MileageRollingCounter_Read( );
           }
           if((ActualSpeed > 0) && (ActualSpeed < 10))
           {
                if(Seatbelt_Timer <= 60000u)
                {
                    Seatbelt_Timer += 10;
                }
                if((Seatbelt_Timer >= 60000u) || (Data_MileageRollingCounter_Read( ) >= (500u + Seatbelt_CumulativeDistance)))
                {
                    if((Seatbelt_Timer >= 60000u) && (Seatbelt_Timer1 <= 120000u) && 
                       (Get_ID_18FAB027_Sig_VCUGearPositionInd( ) != 0xDFu) && (Get_ID_18FAB027_Sig_VCUHandbrakeSts( ) != 1u))
                    {  
                        Seatbelt_Timer1 += 10;
                        res = 2;
                        Popup_Request(POPUP_SEATBELT_DR_1HZ);
                        PopupAndSound_Delete(POPUP_SEATBELT_DR_2HZ);
                        Seatbelt_Flag_60s = 1;
                    }
                    else if ((Data_MileageRollingCounter_Read( ) >= (500u + Seatbelt_CumulativeDistance)) && (Seatbelt_Timer2 <= 120000u) &&
                             (Get_ID_18FAB027_Sig_VCUGearPositionInd( ) != 0xDFu) && (Get_ID_18FAB027_Sig_VCUHandbrakeSts( ) != 1u)&&(Seatbelt_Flag_60s !=1))
                    {
                        Seatbelt_Timer2 += 10;
                        res = 2;
                        Popup_Request(POPUP_SEATBELT_DR_1HZ);
                        PopupAndSound_Delete(POPUP_SEATBELT_DR_2HZ);
                    }
                    else
                    {
                        res = 1;
                        PopupAndSound_Delete(POPUP_SEATBELT_DR_1HZ);
                        PopupAndSound_Delete(POPUP_SEATBELT_DR_2HZ);
                    }
                }
                else
                {
                    res = 1;
                    PopupAndSound_Delete(POPUP_SEATBELT_DR_1HZ);
                    PopupAndSound_Delete(POPUP_SEATBELT_DR_2HZ); 
                }
            }
            else if(ActualSpeed >= 10)
            {
                Seatbelt_Timer = 0;
                Seatbelt_Timer1 = 0;
                Seatbelt_Timer2 = 0;
                Seatbelt_Accumulate_Flag = 0;
                if((ActualSpeed >= 10u) && (ActualSpeed < 25u))
                {
                    if((Get_ID_18FAB027_Sig_VCUGearPositionInd( ) != 0xDFu) && (Get_ID_18FAB027_Sig_VCUHandbrakeSts( ) != 1u) )
                    {
                         res = 2;
                         Popup_Request(POPUP_SEATBELT_DR_1HZ);
                         PopupAndSound_Delete(POPUP_SEATBELT_DR_2HZ);
                    }
                    else
                    {
                        res = 1u;
                        PopupAndSound_Delete(POPUP_SEATBELT_DR_1HZ);
                        PopupAndSound_Delete(POPUP_SEATBELT_DR_2HZ);
                    }
                }
                else if(ActualSpeed >= 25u)
                {
                    if((Get_ID_18FAB027_Sig_VCUGearPositionInd( ) != 0xDFu) && (Get_ID_18FAB027_Sig_VCUHandbrakeSts( ) != 1u) )
                    {
                         res = 2;
                         Popup_Request(POPUP_SEATBELT_DR_2HZ);
                         PopupAndSound_Delete(POPUP_SEATBELT_DR_1HZ);
                    }
                    else
                    {
                        res = 1u;
                        PopupAndSound_Delete(POPUP_SEATBELT_DR_1HZ);
                        PopupAndSound_Delete(POPUP_SEATBELT_DR_2HZ);
                    }
                }
                else
                {
                    res = 1u;
                    PopupAndSound_Delete(POPUP_SEATBELT_DR_1HZ);
                    PopupAndSound_Delete(POPUP_SEATBELT_DR_2HZ);
                }
            }
            else
            {
               Seatbelt_Timer              = 0;
               Seatbelt_Timer1             = 0;
               Seatbelt_Timer2             = 0;
               Seatbelt_Accumulate_Flag    = 0;
               Seatbelt_CumulativeDistance = 0;//shi
               res = 1u;
               Seatbelt_Flag_60s = 0;
               PopupAndSound_Delete(POPUP_SEATBELT_DR_1HZ);
               PopupAndSound_Delete(POPUP_SEATBELT_DR_2HZ);
            }
        }
        else
        {
            Seatbelt_Accumulate_Flag    = 0;
            Seatbelt_CumulativeDistance = 0;
            Seatbelt_Timer              = 0;
            Seatbelt_Timer1             = 0; 
            Seatbelt_Timer2             = 0;
            res = 0; 
            Seatbelt_Flag_60s = 0;
            PopupAndSound_Delete(POPUP_SEATBELT_DR_1HZ);
            PopupAndSound_Delete(POPUP_SEATBELT_DR_2HZ);
        }
    }
    
    return res;
}

static void LED_SEATBELT_DR_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 2u)
        {
            if(FLASH_SYNC_1Hz)
            {
                LED_Driver_Channel_Set(LED_Attr[LED_SEATBELT_DR_R].chip, LED_Attr[LED_SEATBELT_DR_R].channel, LED_Attr[LED_SEATBELT_DR_R].brightness);
                SEG_SET_LED_STS(SEG_LED_SEATBELT_DR, IC_SEG_ON);
            }
            else
            {
                LED_Driver_Channel_Set(LED_Attr[LED_SEATBELT_DR_R].chip, LED_Attr[LED_SEATBELT_DR_R].channel, 0u);
                SEG_SET_LED_STS(SEG_LED_SEATBELT_DR, IC_SEG_OFF_LED);
            }
        }
        else if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SEATBELT_DR_R].chip, LED_Attr[LED_SEATBELT_DR_R].channel, LED_Attr[LED_SEATBELT_DR_R].brightness);
            SEG_SET_LED_STS(SEG_LED_SEATBELT_DR, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SEATBELT_DR_R].chip, LED_Attr[LED_SEATBELT_DR_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_SEATBELT_DR, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SEATBELT_DR_R].chip, LED_Attr[LED_SEATBELT_DR_R].channel, LED_Attr[LED_SEATBELT_DR_R].brightness);
            SEG_SET_LED_STS(SEG_LED_SEATBELT_DR, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SEATBELT_DR_R].chip, LED_Attr[LED_SEATBELT_DR_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_SEATBELT_DR, IC_SEG_OFF_LED);
        }
    }
    
}

static Tellib_uint16_t LED_SOC_CF_Judge(void)
{
    
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        static Tellib_uint16_t temp_led_soc_cf = 0u;
        if(CAN_MSG_Status(ID_can0x18FAB027_Msg_Count) == 0)
        {
            temp_led_soc_cf = Get_ID_18FAB027_Sig_VCUDCDCWorkSts( );
        }
        else
        {
                ;
        }
        if(temp_led_soc_cf == 0)
        {
            res = 1;
        }
        else
        {
            res = 0;
        }
    }
    
    return res;
}

static void LED_SOC_CF_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_CF_R].chip, LED_Attr[LED_SOC_CF_R].channel, LED_Attr[LED_SOC_CF_R].brightness);
            SEG_SET_LED_STS(SEG_LED_SOC_CF, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_CF_R].chip, LED_Attr[LED_SOC_CF_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_SOC_CF, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_CF_R].chip, LED_Attr[LED_SOC_CF_R].channel, LED_Attr[LED_SOC_CF_R].brightness);
            SEG_SET_LED_STS(SEG_LED_SOC_CF, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_CF_R].chip, LED_Attr[LED_SOC_CF_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_SOC_CF, IC_SEG_OFF_LED);
        }
    }
    
}

static Tellib_uint16_t LED_SOC_CC_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if((CAN_MSG_Status(ID_can0x18FA3EF4_Msg_Count) == 0)||(CAN_MSG_Status(ID_can0x18FA7049_Msg_Count) == 0))
        {
            if(Get_ID_18FA3EF4_Sig_BMSDCChgPlugSts( ) == 1)
            {
                res = 1;
            }
            else
            {
                if(Get_ID_18FA7049_Sig_OBC_ChgCCSts( ) == 1)
                {
                    res = 1;
                }
                else
                {
                    res = 0;
                }
            }
        }
        else
        {
            res = 0;
        }
    }
    

    return res;
}

static void LED_SOC_CC_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_CC_R].chip, LED_Attr[LED_SOC_CC_R].channel, LED_Attr[LED_SOC_CC_R].brightness);
            SEG_SET_LED_STS(SEG_LED_SOC_CC, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_CC_R].chip, LED_Attr[LED_SOC_CC_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_SOC_CC, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_CC_R].chip, LED_Attr[LED_SOC_CC_R].channel, LED_Attr[LED_SOC_CC_R].brightness);
            SEG_SET_LED_STS(SEG_LED_SOC_CC, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_CC_R].chip, LED_Attr[LED_SOC_CC_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_SOC_CC, IC_SEG_OFF_LED);
        }
    }
}

static Tellib_uint16_t LED_SOC_CS_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if((Get_ID_18FA3EF4_Sig_BMSChgStatus()==1u)&&(CAN_MSG_Status(ID_can0x18FA3EF4_Msg_Count)==0u))
        {
            res = 1u;
        }
        else if((Get_ID_18FA3EF4_Sig_BMSChgStatus()==4u)&&(CAN_MSG_Status(ID_can0x18FA3EF4_Msg_Count)==0u))
        {
            res = 2u;
        }
        else if((Get_ID_18FA3EF4_Sig_BMSChgStatus()==5u)&&(CAN_MSG_Status(ID_can0x18FA3EF4_Msg_Count)==0u))
        {
            res = 1u;
        }
        else
        {
            res = 0u;
        }
    }
    

    return res;
}

static void LED_SOC_CS_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_CS_Y].chip, LED_Attr[LED_SOC_CS_Y].channel, LED_Attr[LED_SOC_CS_Y].brightness);
            SEG_SET_LED_STS(SEG_LED_SOC_CS, IC_SEG_ON);
        }
        else if(led_status == 2u)
        {
            if(FLASH_SYNC_05Hz)
            {
                LED_Driver_Channel_Set(LED_Attr[LED_SOC_CS_Y].chip, LED_Attr[LED_SOC_CS_Y].channel, LED_Attr[LED_SOC_CS_Y].brightness);
                SEG_SET_LED_STS(SEG_LED_SOC_CS, IC_SEG_ON);
            }
            else
            {

                LED_Driver_Channel_Set(LED_Attr[LED_SOC_CS_Y].chip, LED_Attr[LED_SOC_CS_Y].channel, 0u);
                SEG_SET_LED_STS(SEG_LED_SOC_CS, IC_SEG_OFF_LED);
            }
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_CS_Y].chip, LED_Attr[LED_SOC_CS_Y].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_SOC_CS, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_CS_Y].chip, LED_Attr[LED_SOC_CS_Y].channel, LED_Attr[LED_SOC_CS_Y].brightness);
            SEG_SET_LED_STS(SEG_LED_SOC_CS, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_CS_Y].chip, LED_Attr[LED_SOC_CS_Y].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_SOC_CS, IC_SEG_OFF_LED);
        }
    }
}

static Tellib_uint16_t LED_SOC_LP_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        static Tellib_uint16_t BattSoc = 0;
        if ( (CAN_MSG_Status(ID_can0x18FA40F4_Msg_Count) == 0u) && (Get_ID_18FA40F4_Sig_BMSBattSOC( ) != 0xff) )
        {
            BattSoc = Get_ID_18FA40F4_Sig_BMSBattSOC() * 4;

        }
        else
        {
            ;
        }
        if(BattSoc <= 208)
        {
            res = 1u;
        }
        else if(BattSoc > 220)
        {
            res = 0u;
        }
        else
        {
            res = 2;
        }
    }
    

    return res;
}

static void LED_SOC_LP_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_LP_Y].chip, LED_Attr[LED_SOC_LP_Y].channel, LED_Attr[LED_SOC_LP_Y].brightness);
            SEG_SET_LED_STS(SEG_LED_SOC_LP, IC_SEG_ON);
        }
        else if(led_status == 0u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_LP_Y].chip, LED_Attr[LED_SOC_LP_Y].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_SOC_LP, IC_SEG_OFF_LED);
        }
        else
        {
            ;
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_LP_Y].chip, LED_Attr[LED_SOC_LP_Y].channel, LED_Attr[LED_SOC_LP_Y].brightness);
            SEG_SET_LED_STS(SEG_LED_SOC_LP, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_LP_Y].chip, LED_Attr[LED_SOC_LP_Y].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_SOC_LP, IC_SEG_OFF_LED);
        }
    }
    
}

static Tellib_uint16_t LED_SOC_Fault_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        static Tellib_uint16_t temp_led_soc_fault = 0u;
        if(CAN_MSG_Status(ID_can0x18FAB027_Msg_Count) == 0u)
        {
            temp_led_soc_fault = Get_ID_18FAB027_Sig_VCUBMSFault();
        }
        else
        {
            ;
        }
        if(temp_led_soc_fault == 1)
        {
            res = 1;
        }
        else
        {
            res = 0;
        }
    }
    

    return res;
}

static void LED_SOC_Fault_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_Fault_R].chip, LED_Attr[LED_SOC_Fault_R].channel, LED_Attr[LED_SOC_Fault_R].brightness);
            SEG_SET_LED_STS(SEG_LED_SOC_Fault, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_Fault_R].chip, LED_Attr[LED_SOC_Fault_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_SOC_Fault, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_Fault_R].chip, LED_Attr[LED_SOC_Fault_R].channel, LED_Attr[LED_SOC_Fault_R].brightness);
            SEG_SET_LED_STS(SEG_LED_SOC_Fault, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_Fault_R].chip, LED_Attr[LED_SOC_Fault_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_SOC_Fault, IC_SEG_OFF_LED);
        }
    }
    
}

static Tellib_uint16_t LED_SOC_HT_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        static uint32_t temp_led_soc_ht = 0;

        if ( CAN_MSG_Status(ID_can0x18FA41F4_Msg_Count) == CAN_SIG_NORMAL )
        {
             temp_led_soc_ht = Get_ID_18FA41F4_Sig_BMSTempOutofCtr();
        }
        else
        {
            ;
        }
        if((temp_led_soc_ht == 1u))
        {
            res = 1u;
        }
        else
        {
            res = 0u;
        } 
    }
    

    return res;
}

static void LED_SOC_HT_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_HT_R].chip, LED_Attr[LED_SOC_HT_R].channel, LED_Attr[LED_SOC_HT_R].brightness);
            SEG_SET_LED_STS(SEG_LED_SOC_HT, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_HT_R].chip, LED_Attr[LED_SOC_HT_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_SOC_HT, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_HT_R].chip, LED_Attr[LED_SOC_HT_R].channel, LED_Attr[LED_SOC_HT_R].brightness);
            SEG_SET_LED_STS(SEG_LED_SOC_HT, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_HT_R].chip, LED_Attr[LED_SOC_HT_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_SOC_HT, IC_SEG_OFF_LED);
        }
    }
}

static Tellib_uint16_t LED_SystemFault_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if((Get_ID_18FAB027_Sig_VCUVehicleSysErrorLevel()==1u)&&(CAN_MSG_Status(ID_can0x18FAB027_Msg_Count)==0u))
        {
            res = 1u;
        }
        else if((Get_ID_18FAB027_Sig_VCUVehicleSysErrorLevel()==2u)&&(CAN_MSG_Status(ID_can0x18FAB027_Msg_Count)==0u))
        {
            res = 1u;
        }
        else if((Get_ID_18FAB027_Sig_VCUVehicleSysErrorLevel()==3u)&&(CAN_MSG_Status(ID_can0x18FAB027_Msg_Count)==0u))
        {
            res = 1u;
        }
        else if(CAN_MSG_Status(ID_can0x18FAB027_Msg_Count)!=0u)
        {
            res = 2u;
        }
        else
        {
           res = 0u;  
        }
    }
    

    return res;
}

static void LED_SystemFault_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SystemFault_R].chip, LED_Attr[LED_SystemFault_R].channel, LED_Attr[LED_SystemFault_R].brightness);
            SEG_SET_LED_STS(SEG_LED_SystemFault, IC_SEG_ON);
        }
        else if(led_status == 2u)
        {
            if(FLASH_SYNC_1Hz)
            {
                LED_Driver_Channel_Set(LED_Attr[LED_SystemFault_R].chip, LED_Attr[LED_SystemFault_R].channel, LED_Attr[LED_SystemFault_R].brightness);
                SEG_SET_LED_STS(SEG_LED_SystemFault, IC_SEG_ON);
            }
            else
            {
                LED_Driver_Channel_Set(LED_Attr[LED_SystemFault_R].chip, LED_Attr[LED_SystemFault_R].channel, 0u);
                SEG_SET_LED_STS(SEG_LED_SystemFault, IC_SEG_OFF_LED);
            }
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SystemFault_R].chip, LED_Attr[LED_SystemFault_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_SystemFault, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SystemFault_R].chip, LED_Attr[LED_SystemFault_R].channel, LED_Attr[LED_SystemFault_R].brightness);
            SEG_SET_LED_STS(SEG_LED_SystemFault, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SystemFault_R].chip, LED_Attr[LED_SystemFault_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_SystemFault, IC_SEG_OFF_LED);
        }
    }
    
}

static Tellib_uint16_t LED_READY_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if((Get_ID_18FAB027_Sig_VCUPTReadyInd()==1u)&&(CAN_MSG_Status(ID_can0x18FAB027_Msg_Count)==0u))
        {
            res = 1u;
        }
        else
        {
            res = 0u;
        }
    }
    

    return res;
}

static void LED_READY_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_READY_G].chip, LED_Attr[LED_READY_G].channel, LED_Attr[LED_READY_G].brightness);
            SEG_SET_LED_STS(SEG_LED_READY, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_READY_G].chip, LED_Attr[LED_READY_G].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_READY, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_READY_G].chip, LED_Attr[LED_READY_G].channel, LED_Attr[LED_READY_G].brightness);
            SEG_SET_LED_STS(SEG_LED_READY, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_READY_G].chip, LED_Attr[LED_READY_G].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_READY, IC_SEG_OFF_LED);
        }
    }
}

static Tellib_uint16_t LED_MotorFault_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        static Tellib_uint16_t temp_led_motorfault = 0u;
        if(CAN_MSG_Status(ID_can0x18FA02EF_Msg_Count)==0u)
        {
            temp_led_motorfault = Get_ID_18FA02EF_Sig_MCU_MotorFltLevel();
        }
        else
        {
            ;
        }
        if((temp_led_motorfault == 1u) || (temp_led_motorfault == 2u) || (temp_led_motorfault == 3u))
        {
            res = 1u;
        }
        else
        {
            res = 0u;
        }
    }
    

    return res;
}

static void LED_MotorFault_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_MotorFault_R].chip, LED_Attr[LED_MotorFault_R].channel, LED_Attr[LED_MotorFault_R].brightness);
            SEG_SET_LED_STS(SEG_LED_MotorFault, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_MotorFault_R].chip, LED_Attr[LED_MotorFault_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_MotorFault, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_MotorFault_R].chip, LED_Attr[LED_MotorFault_R].channel, LED_Attr[LED_MotorFault_R].brightness);
            SEG_SET_LED_STS(SEG_LED_MotorFault, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_MotorFault_R].chip, LED_Attr[LED_MotorFault_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_MotorFault, IC_SEG_OFF_LED);
        }
    }
    
}

static Tellib_uint16_t LED_PowerLimit_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        static Tellib_uint16_t temp_led_powerlimit = 0u;
        if(CAN_MSG_Status(ID_can0x18FAB027_Msg_Count)==0u)
        {
            temp_led_powerlimit = Get_ID_18FAB027_Sig_VCUTurtleLampReq();
        }
        else
        {
            ;
        }
        if(temp_led_powerlimit == 1u)
        {
            res = 1u;
        }
        else
        {
            res = 0u;
        }
    }
    

    return res;
}

static void LED_PowerLimit_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
       if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_PowerLimit_Y].chip, LED_Attr[LED_PowerLimit_Y].channel, LED_Attr[LED_PowerLimit_Y].brightness);
            SEG_SET_LED_STS(SEG_LED_PowerLimit, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_PowerLimit_Y].chip, LED_Attr[LED_PowerLimit_Y].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_PowerLimit, IC_SEG_OFF_LED);
        } 
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_PowerLimit_Y].chip, LED_Attr[LED_PowerLimit_Y].channel, LED_Attr[LED_PowerLimit_Y].brightness);
            SEG_SET_LED_STS(SEG_LED_PowerLimit, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_PowerLimit_Y].chip, LED_Attr[LED_PowerLimit_Y].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_PowerLimit, IC_SEG_OFF_LED);
        }
    }
    
}

static Tellib_uint16_t LED_ECO_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        static Tellib_uint16_t temp_led_eco = 0u;
        if(CAN_MSG_Status(ID_can0x18FAB027_Msg_Count)==0u)
        {
            temp_led_eco = Get_ID_18FAB027_Sig_VCUDriveModeInd();
        }
        else
        {
            ;
        }
        if((temp_led_eco == 1u))
        {
            res = 1u;
        }
        else
        {
            res = 0u;
        }
    }
    

    return res;
}

static void LED_ECO_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_ECO_G].chip, LED_Attr[LED_ECO_G].channel, LED_Attr[LED_ECO_G].brightness);
            SEG_SET_LED_STS(SEG_LED_ECO, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_ECO_G].chip, LED_Attr[LED_ECO_G].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_ECO, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_ECO_G].chip, LED_Attr[LED_ECO_G].channel, LED_Attr[LED_ECO_G].brightness);
            SEG_SET_LED_STS(SEG_LED_ECO, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_ECO_G].chip, LED_Attr[LED_ECO_G].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_ECO, IC_SEG_OFF_LED);
        }
    }
    
}

static Tellib_uint16_t LED_InsulationFault_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        static Tellib_uint16_t temp_led_insulationfault = 0u;
        if(CAN_MSG_Status(ID_can0x18FA41F4_Msg_Count)==0u)
        {
            temp_led_insulationfault = Get_ID_18FA41F4_Sig_BMSHVIsolationSts();
        }
        else
        {
            ;
        }
        if((temp_led_insulationfault == 1u)||(temp_led_insulationfault == 2u))
        {
            res = 1u;
        }
        else
        {
            res = 0u;
        }
    }
    

    return res;
}

static void LED_InsulationFault_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
       if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_InsulationFault_R].chip, LED_Attr[LED_InsulationFault_R].channel, LED_Attr[LED_InsulationFault_R].brightness);
            SEG_SET_LED_STS(SEG_LED_InsulationFault, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_InsulationFault_R].chip, LED_Attr[LED_InsulationFault_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_InsulationFault, IC_SEG_OFF_LED);
        } 
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_InsulationFault_R].chip, LED_Attr[LED_InsulationFault_R].channel, LED_Attr[LED_InsulationFault_R].brightness);
            SEG_SET_LED_STS(SEG_LED_InsulationFault, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_InsulationFault_R].chip, LED_Attr[LED_InsulationFault_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_InsulationFault, IC_SEG_OFF_LED);
        }
    }
    
}

static Tellib_uint16_t LED_Energy_Recovery_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        static Tellib_uint16_t temp_led_energy_recovery = 0;  
        if ( CAN_MSG_Status(ID_can0x18FAB027_Msg_Count) == 0u )
        {
            temp_led_energy_recovery = Get_ID_18FAB027_Sig_VCUPTModeInd();
        }
        else
        {
           ;
        }
        if  (temp_led_energy_recovery == 1)
        {
            res = 1;
        }
        else
        {
            res = 0;
        }
    }
    

    return res;
}

static void LED_Energy_Recovery_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Energy_Recovery_W].chip, LED_Attr[LED_Energy_Recovery_W].channel, LED_Attr[LED_Energy_Recovery_W].brightness);
            SEG_SET_LED_STS(SEG_LED_Energy_Recovery, IC_SEG_ON);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Energy_Recovery_W].chip, LED_Attr[LED_Energy_Recovery_W].channel, 0u); 
            SEG_SET_LED_STS(SEG_LED_Energy_Recovery, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Energy_Recovery_W].chip, LED_Attr[LED_Energy_Recovery_W].channel, LED_Attr[LED_Energy_Recovery_W].brightness);
            SEG_SET_LED_STS(SEG_LED_Energy_Recovery, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Energy_Recovery_W].chip, LED_Attr[LED_Energy_Recovery_W].channel, 0u); 
            SEG_SET_LED_STS(SEG_LED_Energy_Recovery, IC_SEG_OFF_LED);
        }
    }
    
}

static Tellib_uint16_t LED_HighPressureInterlock_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if ( CAN_MSG_Status(ID_can0x18FA42F4_Msg_Count) == 0u )
        {
            if(Get_ID_18FA42F4_Sig_BMS_ST1_Flt_HVIL() == 1u)
            {
                res = 1;
            }
            else
            {
                res = 0;
            }
        }  
        else
        {
            res = 0;
        }
    }
    

    return res;
}

static void LED_HighPressureInterlock_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_HighPressureInterlock_R].chip, LED_Attr[LED_HighPressureInterlock_R].channel, LED_Attr[LED_HighPressureInterlock_R].brightness);
            SEG_SET_LED_STS(SEG_LED_HighPressureInterlock, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_HighPressureInterlock_R].chip, LED_Attr[LED_HighPressureInterlock_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_HighPressureInterlock, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_HighPressureInterlock_R].chip, LED_Attr[LED_HighPressureInterlock_R].channel, LED_Attr[LED_HighPressureInterlock_R].brightness);
            SEG_SET_LED_STS(SEG_LED_HighPressureInterlock, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_HighPressureInterlock_R].chip, LED_Attr[LED_HighPressureInterlock_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_HighPressureInterlock, IC_SEG_OFF_LED);
        }
    }
    
   
}

static Tellib_uint16_t LED_DoorOpen_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        uint16_t m_V_Speed=0u;
        m_V_Speed=Common_Get_Disp_V_Speed();

        if(Get_LINE_IN_Sts(LINE_IN_DOOROPEN) == 1u)
        {
            if(SelfCheck_time >= 30)
            {
                if(m_V_Speed >= 100u)
                {
                    res =2u;
                }
                else if((m_V_Speed < 100u)&&(m_V_Speed != 0u))
                {
                    res =2u;
                }
                else
                {
                    res = 1u;
                } 
            }
            else
            {
                res = 1u;
            }
                   
        }
        else
        {
            res = 0u;
        }
    }
    

    return res;
}

static void LED_DoorOpen_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_DoorOpen_R].chip, LED_Attr[LED_DoorOpen_R].channel, LED_Attr[LED_DoorOpen_R].brightness);
            SEG_SET_LED_STS(SEG_LED_DoorOpen, IC_SEG_ON);
        }
        else if(led_status == 2u)
        {
            if(FLASH_SYNC_1Hz)
            {
                LED_Driver_Channel_Set(LED_Attr[LED_DoorOpen_R].chip, LED_Attr[LED_DoorOpen_R].channel, LED_Attr[LED_DoorOpen_R].brightness);
                SEG_SET_LED_STS(SEG_LED_DoorOpen, IC_SEG_ON);
            }
            else
            {
                LED_Driver_Channel_Set(LED_Attr[LED_DoorOpen_R].chip, LED_Attr[LED_DoorOpen_R].channel, 0u);
                SEG_SET_LED_STS(SEG_LED_DoorOpen, IC_SEG_OFF_LED);
            }
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_DoorOpen_R].chip, LED_Attr[LED_DoorOpen_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_DoorOpen, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_DoorOpen_R].chip, LED_Attr[LED_DoorOpen_R].channel, LED_Attr[LED_DoorOpen_R].brightness);
            SEG_SET_LED_STS(SEG_LED_DoorOpen, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_DoorOpen_R].chip, LED_Attr[LED_DoorOpen_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_DoorOpen, IC_SEG_OFF_LED);
        }
    }
    
}


static Tellib_uint16_t LED_OTA_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(Get_LINE_IN_Sts(LINE_IN_ENERGY_RECOVERY) == 1u)
        {

            res = 1u;
        }
        else
        {
            res = 0u;
        }
    }
    

    return res;
}

static void LED_OTA_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_FrontFog].chip, LED_Attr[LED_FrontFog].channel, LED_Attr[LED_FrontFog].brightness);
            SEG_SET_LED_STS(SEG_LED_FrontFog, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_FrontFog].chip, LED_Attr[LED_FrontFog].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_FrontFog, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_FrontFog].chip, LED_Attr[LED_FrontFog].channel, LED_Attr[LED_FrontFog].brightness);
            SEG_SET_LED_STS(SEG_LED_FrontFog, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_FrontFog].chip, LED_Attr[LED_FrontFog].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_FrontFog, IC_SEG_OFF_LED);
        } 
    }
    
}



//远程锁车
static Tellib_uint16_t LED_RemoteLocking_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        Tellib_uint16_t temp_remotelocking = 0u;
        Tellib_uint16_t temp_LockVehPerFlag = 0u;
        Tellib_uint16_t temp_VersionConversionFlag = 0u;
        Tellib_uint16_t temp_SpdLmtLevel = 0u;


        if(CAN_MSG_Status(ID_can0x18FA1727_Msg_Count) == 0)
        {
            temp_LockVehPerFlag = Get_ID_18FA1727_Sig_VCU_LockVehPerFlag();        
            temp_VersionConversionFlag = Get_ID_18FA1727_Sig_VCU_VersionConversionFlag();
            temp_SpdLmtLevel = Get_ID_18FA1727_Sig_VCU_SpdLmtLevel();
        }

        if(CAN_MSG_Status(ID_can0x18FF5D27_Msg_Count) == 0)
        {
            temp_remotelocking = Get_ID_18FF5D27_Sig_VCU_LockVehSts();
        }

        if((temp_LockVehPerFlag == 1)&&(temp_VersionConversionFlag == 1)&&(temp_SpdLmtLevel == 0))
        {
            res = 2u;
        }
        else if(temp_remotelocking == 1u)
        {
            res = 1u;
        }
        else
        {
            res = 0u;
        }
    }
    
    return res;
}

static void LED_RemoteLocking_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0) 
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_RemoteLocking_R].chip, LED_Attr[LED_RemoteLocking_R].channel, LED_Attr[LED_RemoteLocking_R].brightness);
            SEG_SET_LED_STS(SEG_LED_RemoteLocking, IC_SEG_ON);
        }
        else if(led_status == 2u)
        { 
            if(FLASH_SYNC_1Hz)
            {
                LED_Driver_Channel_Set(LED_Attr[LED_RemoteLocking_R].chip, LED_Attr[LED_RemoteLocking_R].channel, LED_Attr[LED_RemoteLocking_R].brightness);
                SEG_SET_LED_STS(SEG_LED_RemoteLocking, IC_SEG_ON); 
            }
            else
            {
                LED_Driver_Channel_Set(LED_Attr[LED_RemoteLocking_R].chip, LED_Attr[LED_RemoteLocking_R].channel, 0u);
                SEG_SET_LED_STS(SEG_LED_RemoteLocking, IC_SEG_OFF_LED);
            }     
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_RemoteLocking_R].chip, LED_Attr[LED_RemoteLocking_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_RemoteLocking, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_RemoteLocking_R].chip, LED_Attr[LED_RemoteLocking_R].channel, LED_Attr[LED_RemoteLocking_R].brightness);
            SEG_SET_LED_STS(SEG_LED_RemoteLocking, IC_SEG_ON); 
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_RemoteLocking_R].chip, LED_Attr[LED_RemoteLocking_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_RemoteLocking, IC_SEG_OFF_LED);
        } 
    }
    
}

//保养指示灯
static Tellib_uint16_t LED_MaintainWarning_Judge(void)//YUAN
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(Get_warningInterval() == 1)//sign == 1
        {
          res = 1;
        }
        else
        {
          res = 0;
        }
    }
    
    return res;
}

static void LED_MaintainWarning_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_MaintainWarning_W].chip, LED_Attr[LED_MaintainWarning_W].channel, LED_Attr[LED_MaintainWarning_W].brightness);
            SEG_SET_LED_STS(SEG_LED_MaintainWarning, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_MaintainWarning_W].chip, LED_Attr[LED_MaintainWarning_W].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_MaintainWarning, IC_SEG_OFF_LED);
        }
    }
    else 
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_MaintainWarning_W].chip, LED_Attr[LED_MaintainWarning_W].channel, LED_Attr[LED_MaintainWarning_W].brightness);
            SEG_SET_LED_STS(SEG_LED_MaintainWarning, IC_SEG_ON); 
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_MaintainWarning_W].chip, LED_Attr[LED_MaintainWarning_W].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_MaintainWarning, IC_SEG_OFF_LED);
        }
    
    }
    
    
}

static Tellib_uint16_t LED_MotorOverheating_Judge(void)//MotorOverheating
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if((Get_ID_18FAB027_Sig_VCUMotorTempHighAlarm() == 1u)&&(CAN_MSG_Status(ID_can0x18FAB027_Msg_Count)==0u))
        {
            res = 1u;
        }
        else
        {
            res = 0u;
        }
    }
    

    return res;
}

static void LED_MotorOverheating_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_MotorOverheating_R].chip, LED_Attr[LED_MotorOverheating_R].channel, LED_Attr[LED_MotorOverheating_R].brightness);
            SEG_SET_LED_STS(SEG_LED_MotorOverheating, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_MotorOverheating_R].chip, LED_Attr[LED_MotorOverheating_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_MotorOverheating, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_MotorOverheating_R].chip, LED_Attr[LED_MotorOverheating_R].channel, LED_Attr[LED_MotorOverheating_R].brightness);
            SEG_SET_LED_STS(SEG_LED_MotorOverheating, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_MotorOverheating_R].chip, LED_Attr[LED_MotorOverheating_R].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_MotorOverheating, IC_SEG_OFF_LED);
        }
    }
    
}

static Tellib_uint16_t LED_SOC_DC_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(((Get_ID_18FAB027_Sig_VCUDrivePwrCircuitInd()==0u)||(Get_ID_18FAB027_Sig_VCUDrivePwrCircuitInd()==2u))&&(CAN_MSG_Status(ID_can0x18FAB027_Msg_Count)==0u))
        {
            res = 1u;
        }
        else
        {
            res = 0u;
        }
    }
    
    return res;
}

static void LED_SOC_DC_Exec(Tellib_uint16_t led_status)
{
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        if(led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_DC_Y].chip, LED_Attr[LED_SOC_DC_Y].channel, LED_Attr[LED_SOC_DC_Y].brightness);
            SEG_SET_LED_STS(SEG_LED_SOC_DC, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_DC_Y].chip, LED_Attr[LED_SOC_DC_Y].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_SOC_DC, IC_SEG_OFF_LED);
        }
    }
    else
    {
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_DC_Y].chip, LED_Attr[LED_SOC_DC_Y].channel, LED_Attr[LED_SOC_DC_Y].brightness);
            SEG_SET_LED_STS(SEG_LED_SOC_DC, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_SOC_DC_Y].chip, LED_Attr[LED_SOC_DC_Y].channel, 0u);
            SEG_SET_LED_STS(SEG_LED_SOC_DC, IC_SEG_OFF_LED);
        }
    }
    
}


void TYW_check(void)
{
    if(Factory_ClearOdo_Display_Flag == 1)
    {   
        SEG_DISPLAY();
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr [ LED_TurnLeft_G ].chip, LED_Attr [ LED_TurnLeft_G ].channel, LED_Attr [ LED_TurnLeft_G ].brightness);
            SEG_SET_LED_STS(SEG_LED_TurnLeft, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr [ LED_TurnLeft_G ].chip, LED_Attr [ LED_TurnLeft_G ].channel, 0);
            SEG_SET_LED_STS(SEG_LED_TurnLeft, IC_SEG_OFF_LED);
        }
        if(FLASH_SYNC_05Hz)
        {
            LED_Driver_Channel_Set(LED_Attr [ LED_TurnRight_G ].chip, LED_Attr [ LED_TurnRight_G ].channel, LED_Attr [ LED_TurnRight_G ].brightness);
            SEG_SET_LED_STS(SEG_LED_TurnRight, IC_SEG_ON);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr [ LED_TurnRight_G ].chip, LED_Attr [ LED_TurnRight_G ].channel, 0);
            SEG_SET_LED_STS(SEG_LED_TurnRight, IC_SEG_OFF_LED);
        }
    }
}

void delay(uint32_t z)
{
	uint32_t x,y;
	for(x = z; x > 0; x--)
		for(y = 114; y > 0 ; y--); 		
} 

void SEG_DISPLAY(void)
{
    if(i > 9) 
    {
        i = 0;
    }
    if(j > 10) 
    {
        j = 0;
    }
    if(Frame > 1) 
    {
        Frame = 0;
    }
    if(GEAR > 3) 
    {
        GEAR = 0;
    }
    delay(50000);
    SEG_SET_Frame1(Frame);
    SEG_SET_GEAR1(1u, GEAR*1);
    SEG_SET_EleDial1(1,0,i*11);
    SEG_Scan_SET_EleDial1(j);
    SEG_SET_PowerDial1(1,0,FLASH_SYNC_5Hz,i*11);
    SEG_Scan_SET_PowerDial1(j);
    SEG_SET_DTE_NUM1(1,i*111);
    SEG_SET_VSpeed_NUM1(1,i*111);
    SEG_SET_L8_NUM1(1,i*1);
    SEG_SET_ODO_NUM1(1,i*111111);
    SEG_SET_TRIP_NUM1(1,i*1111);
    SEG_SET_Clock1(i*11, i*11, FLASH_SYNC_5Hz, 1, 1);
}

//void LED_DISPlAY(void)
//{
//        
//        
//          
//        
//        LED_SOC_DC_Exec(!Temp);
//        LED_MotorOverheating_Exec(!Temp);
//        LED_MaintainWarning_Exec(!Temp);
//        LED_RemoteLocking_Exec(!Temp);
//        LED_OTA_Exec(!Temp);
//        LED_DoorOpen_Exec(!Temp);
//        LED_HighPressureInterlock_Exec(!Temp);
//        LED_Energy_Recovery_Exec(!Temp);
//        LED_InsulationFault_Exec(!Temp);
//        LED_ECO_Exec(!Temp);
//        LED_PowerLimit_Exec(!Temp);
//        LED_MotorFault_Exec(!Temp);
//        LED_READY_Exec(!Temp);
//        LED_SystemFault_Exec(!Temp);
//        LED_SOC_HT_Exec(!Temp);
//        LED_SOC_Fault_Exec(!Temp);
//        LED_SOC_LP_Exec(!Temp);
//        LED_SOC_CS_Exec(!Temp);
//        LED_SOC_CC_Exec(!Temp);
//        LED_SOC_CF_Exec(!Temp);
//        LED_SEATBELT_DR_Exec(!Temp);
//        LED_EPS_Exec(!Temp);
//        LED_EPB_Status_Exec(!Temp);
//        LED_BrakeSystemFault_Exec(!Temp);
//        LED_EBD_fault_Exec(!Temp);
//        LED_ABS_Exec(!Temp);
//        
//        LED_Daylight_Exec(!Temp);
//        LED_RearFog_Exec(!Temp);
//        LED_Position_Exec(!Temp);
//        LED_Lbeam_Exec(!Temp);
//        LED_Hbeam_Exec(!Temp);
//        LED_TurnLeft_Exec(!Temp);
//        LED_TurnRight_Exec(!Temp);
//        
//        
//        
//}


//static void LED_TurnLeft_Exec(Tellib_uint16_t led_status)
//{
//    if(led_status == 1u)
//    {
//        LED_Driver_Channel_Set(LED_Attr [ LED_TurnLeft_G ].chip, LED_Attr [ LED_TurnLeft_G ].channel, LED_Attr [ LED_TurnLeft_G ].brightness);
//        SEG_SET_LED_STS(SEG_LED_TurnLeft, IC_SEG_ON);
//    }
//    else
//    {
//        LED_Driver_Channel_Set(LED_Attr [ LED_TurnLeft_G ].chip, LED_Attr [ LED_TurnLeft_G ].channel, 0);
//        SEG_SET_LED_STS(SEG_LED_TurnLeft, IC_SEG_OFF);
//    }
//}
//
//static void LED_TurnRight_Exec(Tellib_uint16_t led_status)
//{
//    if(led_status == 1u)
//    {
//        LED_Driver_Channel_Set(LED_Attr [ LED_TurnRight_G ].chip, LED_Attr [ LED_TurnRight_G ].channel, LED_Attr [ LED_TurnRight_G ].brightness);
//        SEG_SET_LED_STS(SEG_LED_TurnRight, IC_SEG_ON);
//    }
//    else
//    {
//        LED_Driver_Channel_Set(LED_Attr [ LED_TurnRight_G ].chip, LED_Attr [ LED_TurnRight_G ].channel, 0);
//        SEG_SET_LED_STS(SEG_LED_TurnRight, IC_SEG_OFF);
//    }
//}

 
    