#ifndef _SERVICE_INTERVAL_H_
#define _SERVICE_INTERVAL_H_

#include "stdint.h"

typedef union
{
    uint32_t DataRecord[8];
    struct
    {
        uint32_t  First_Interval;/*首保里程间隔   0.1km*/
        uint32_t  Second_Interval;/*续保里程间隔	 0.1km*/
        uint32_t  Timer_Interval;/*保养时间间隔   s */
        uint32_t  DIM_KM;/*保养里程终值 0.1km */
        uint32_t  DIM_Timer;/*保养时间终值 s */

        uint32_t  Servicekm;/*已走动里程值 0.1km */
        uint32_t  ServiceTimer;/*已走动时间 s */

        uint8_t  First_Flag;/*是否是首次保养 0  1 */
        uint8_t  Reverse1;
        uint8_t  Reverse2;
        uint8_t  Reverse3;
    } Sig;
} _DataInterVal;


typedef struct
{
    uint8_t   PowerSts;/*0-ig off ***1-ig on*/
} _DataInputInterVal;

#define Services_PowerON	  1u
#define Services_PowerOFF	  0u
#define Services_FirstFlag	  0u
#define Services_SecondFlag   1u
#define Services_ForceSave    1u
#define Services_NOForceSave  0u

extern _DataInterVal Data_Interval_Para;
extern _DataInputInterVal Data_Input_InterVal;
extern uint32_t ServiceTimer;
extern uint32_t Servicekm;

/*该服务函数首次KL30时调用一次*/
void Data_Interval_KL30_Init(_DataInterVal *m_para1, _DataInputInterVal *m_para2);
/*重置保养里程,保养里程服务之前调用*/
void Data_Interval_KMSet(uint32_t CurTotalODO,uint8_t m_IG);
void Data_Interval_TimerSleepFix(uint32_t FixTimer);/*  休眠到唤醒 把没记录的时间差 补上 */
void Data_Service_Interval_Processing(void);
void Data_Interval_TimerISR(void);
/*重置保养里程*/
void Data_Service_Interval_Reset(_DataInterVal *m_para1,uint32_t m_CurODO);
uint32_t Get_IntervalKM(void);/*获得保养里程*/
uint16_t Read_Interval_Version(void);/*读取版本号*/
void Data_Service_Interval_Save_Call(_DataInterVal *m_Para4,uint8_t ForceSave);
/*用户定义函数*/
void Data_Interval_KL30_InitShell(void);
void Data_Interval_100MS_Cbk(void);
//uint8_t Get_SERVICE_WARNING(void);
//uint8_t Get_SERVICE_WARNING_ForCan(void);
void Data_Timer_Record_Calc(void);
void Data_Timer_Record_BeforeSleep(void);
uint32_t Get_IntervalTime(void);/*获得剩余保养时间  单位100ms */
uint32_t Get_DIMIntervalTime(void);/*读保养时间间隔*/
uint32_t Get_DIMIntervalKM(void);/*读保养公里数间隔*/
void Data_interval_Geely_ReConfig(void);
void Data_interval_Geely_Reset(void);
void Data_interval_Geely_Reset_TYW(void);
void Data_interval_Geely_Write( uint8_t Flag );//设置保养里程
void Data_interval_Geely_Write1( uint8_t Flag, uint32_t data);//设置保养里程
void Data_Service_Interval_OverWriteDIM(uint8_t m_DIR);
void Data_Service_Interval_OverWriteTIMERDIM(uint32_t u32DimTimer);
void Data_interval_Geely_WriteTIMER(uint32_t data);/*设置保养时间 单位是天*/
uint32_t Get_warningInterval(void);

void ServicesMileage_DealWith(void);//lG02保养里程处理
void Maintance_7101(void);
void Maintance_7102(void);
void Maintance_7103(void);
uint32_t Get_7101_hex_Value(void);
uint32_t Get_7102_hex_Value(void);

#endif