#include "Services_ODO_Internal.h"
#include "Common_Interface.h"
#include "Work_Flash.h"
#include "Non_volatile_Memorys.h"


/*** 里程滚动计数器 ***/
#pragma location="BACKUP_RAM_CONTENT"
uint16_t                DataMileageRollingCounter1;
#pragma location="BACKUP_RAM_CONTENT"
DataMileageCalcStruct1   DataMileage1;

/*** 总计里程 ***/
#pragma location="BACKUP_RAM_CONTENT"
DataODOStruct1           DataODOCalc1;
#pragma location="BACKUP_RAM_CONTENT"
uint32_t   Data_ODO_Val1;
#pragma location="BACKUP_RAM_CONTENT"
uint8_t                 DataODOValid1;
#pragma location="BACKUP_RAM_CONTENT"
uint8_t  EEPROM_St1;
_DataODOInputStruct1 Input_ODO_Para1;
#pragma location="BACKUP_RAM_CONTENT"
uint32_t  Data_ODO_SyncCnt;
#pragma location="BACKUP_RAM_CONTENT"
uint32_t  Data_ODO_SyncKM;
#pragma location="BACKUP_RAM_CONTENT"
uint32_t  Data_ODO_SyncReason;



/*内部实际公里数*/
uint32_t Services_Read_ACT_ODO(void)
{
    return Data_ODO_Val1;
}
/*里程备份发生次数*/
uint32_t Services_Read_ODO_ClearCnt1(void)
{
    return Data_ODO_SyncCnt;
}
/*里程备份发生的原因*/
uint32_t Services_Read_ODO_SyncReason(void)
{
    return Data_ODO_SyncReason;
}

void Services_ODO_Modify_Sync(uint32_t m_SyncReason)
{
    if ( Data_ODO_SyncCnt < 0xfffffff0ul )
    {
        Data_ODO_SyncCnt++;
    }
    Data_ODO_SyncReason = m_SyncReason;
    Data_ODO_SyncKM     = NVM_ODO_VALUE;
    NVMODO_back.Sig.Value   = NVM_ODO_VALUE;
    NVMODO_back.Sig.ClrCnt  = Data_ODO_SyncReason;
    NVMODO_back.Sig.Cleared = Data_ODO_SyncCnt;

    NVM_Data_Update(NVM_ODO_back_DATA);
}

/*864007-3*/ /*864007-7*/
void Services_ODO_SaveCall1(uint32_t Val_ODO)
{

}

void Services_ODO_ClearFactory1(void)
{

}

void Services_ODO_ISR1(void)
{

}
void Services_ODO_100MS_Cbk1(void)
{

}

/*
ODO km -----------UINT32
ODO CLEAR KM     -UINT32
ODO CLEAR count---UINT32
 */
void Services_ODO_KL30Init1(void)
{
    Data_ODO_SyncCnt =   NVMODO_back.Sig.Cleared ;
    Data_ODO_SyncKM =  NVMODO_back.Sig.Value ;
    Data_ODO_SyncReason = NVMODO_back.Sig.ClrCnt ;
}



void Services_ODO_PulseCbk1(uint16_t m_Inc)
{

}
