

#include "LED_Driver.h"
#include "GPIO.h"
/*注意需将u8LEDDriverRamData定义在休眠唤醒后不会被清空的RAM区域*/
LED_Driver_uint8_t u8LEDDriverRamData[LED_DRIVER_RAM_LEN];

const LED_Driver_uint8_t u8AW21036ChipAddress[LED_DRIVER_CHIP_NUM] = {

#if (LED_DRIVER_CHIP_NUM >= 1U)
	AW21036_CHIP1_ADDRESS,
#endif

#if (LED_DRIVER_CHIP_NUM >= 2U)
	AW21036_CHIP2_ADDRESS,
#endif

#if (LED_DRIVER_CHIP_NUM >= 3U)
	AW21036_CHIP3_ADDRESS,
#endif

#if (LED_DRIVER_CHIP_NUM >= 4U)
	AW21036_CHIP4_ADDRESS,
#endif

};

const LED_Driver_uint8_t u8IS31ChipAddress[LED_DRIVER_CHIP_NUM] = {

#if (LED_DRIVER_CHIP_NUM >= 1U)
	IS31_CHIP1_ADDRESS,
#endif

#if (LED_DRIVER_CHIP_NUM >= 2U)
	IS31_CHIP2_ADDRESS,
#endif

#if (LED_DRIVER_CHIP_NUM >= 3U)
	IS31_CHIP3_ADDRESS,
#endif

#if (LED_DRIVER_CHIP_NUM >= 4U)
	IS31_CHIP4_ADDRESS,
#endif

};

/*设置shutdown引脚*/
void LED_Driver_Shutdown_Pin_Set(LED_Driver_uint8_t u8Level)
{
	LED_DRIVER_EN = u8Level;
}
