#include "Common_Interface.h"
#include "Key.h"
#include "ODOReset.h"
#include "Services_ODO.h"
#include "Services_ODO_Internal.h"
#include "Services_Interval.h"
#include "Services_TripA.h"
#include "RTE_LINE_IN.h"
#include "Communication_Over_CAN.h"
#include "Gauge_Display.h"
#include "Telltales_user.h"
#define ODO_RESET_MASK_ALL  0xFFu /*按键保持长按下 车速有效 所有门开*/
#define ODO_RESET_MASK_1    0x7Fu /*车速有效 所有门开*/
#define ODO_RESET_MASK_2    0x80u /*按键保持长按下*/
#define ODO_RESET_MASK_3    0xBFu /*按键保持长按下 所有门开*/

uint32_t Factory_ClearOdo_Display_Flag = 0;
uint8_t OEMResetReqCheck(void); /*清零触发逻辑*/
uint8_t GeelyReset(void);       /*主机厂复位(按键，报文，诊断)：返回值 0ok，1>500km,2>3time  */
/*****************非BackUp变量区******************************/
static uint8_t Mes2A4rCnt=0u;
//static uint8_t Mes2A4rCntBak=0u;
uint8_t KeepTime=0u;
uint16_t GeelyReseReq=0u;

uint8_t Req_Chk = 0u;/*请求检查标志*/
uint8_t Req_1 = 0u;/*请求计数1*/
uint8_t Req_0 = 0u;/*请求计数0*/
/*************************************************************/
void Factory_ClearOdo(void) 
{ 
  uint8_t c3,c4,k1;
  
  if(Common_Get_IG_Sts()==1u)
  {
//    c1= (Common_Get_Act_E_Speed()>=8000u)?1u:0u;
//    c2= (Common_Get_Act_E_Speed_Valid())?1u:0u;
    c3= (Common_Get_Act_V_Speed() >= 1800u)?1u:0u;
    c4= ((Get_ID_18FA40F4_Sig_BMSBattSOC( ) * 4 / 10) >= 99u)?1u:0u;
    
  if ((c3) && (c4))
   {
     k1=(Get_Line_In_TRIP_Switch())?0u:1u;

     
      if(k1) 
      {        
         if(KeepTime<=100u) /*按键保持计时*/
         {
           KeepTime++;
         }       
         if(KeepTime==100u) /*清除一次防止 反复清除*/
         { 
           Factory_ClearOdo_Display_Flag = 1;
           Data_Clear_TripA();              /*小计*/
           Services_ODO_ClearFactory();     /*总计*/
           Services_ODO_ClearFactory1();    /*程序内部使用,里程备份增加专用里程,非显示里程*/
           Data_interval_Geely_Reset_TYW(); /*保养*/
         }
      }
      else
      {
        KeepTime=0u; 
      }
   } 
   else
   {
    KeepTime=0u; 
   }
 }    
}



uint8_t OEMResetReqCheck(void)
{

  return 0;
}

/*==================================
【Geely MMI信号清零逻辑严格判断逻辑】
CAN接收到信号后会产生循环计数，如果
本函数检测到备份的值与滚动值不一致，
则判断为收到一帧有效信号，相反如果
备份值相同则代表没有收到新的信号。
【判断信号值】
如果收到的是‘1’则累计，如果收到‘0’信
号时判断收到的1的数量，只有收到连续的
3帧MMI_OdometerClearReq为1 且本帧
MMI_OdometerClearReq为0才会清零，不连
续的‘1’或信号间隔超过120ms也不清零。
==================================*/
void GeelyResetByMMI_CB20ms(void)
{
  
  
}
/*主机厂复位：总计、小计、保养、平均油耗*/
uint8_t GeelyReset(void)
{
  _DataTripAInputStruct  m_TripApara;
  uint8_t m8=0u;
  m8 = Services_ODO_Clear();
  /*清零结果 0=ok，1=500km，2=3次*/
  if(m8==0u)
  {
    /*保养里程清零*/
    Data_interval_Geely_Reset();               
    /*小计里程*/ 
    m_TripApara.V_Speed_Valid=1u;
    m_TripApara.Act_V_Speed = 0u;/*87505*/ /*87505-1*/
    m_TripApara.MileageRollingCnt = Data_MileageRollingCounter_Read();
    Data_TripA_Set_Para(&m_TripApara);
    Data_Clear_TripA();
    /*平均油耗清零*/
//    Data_Average_Fuel_Consumption_Reset();
  }
  return m8;
}


/*吉利按键清大计*/
void GeelyResetByTrip_CB50ms(uint8_t IgnSt)
{
  if(IgnSt)
  {
    if(GeelyReseReq!=0u)
    {   
      if(GeelyReseReq<80u)/*前4s*/
      {
         if(OEMResetReqCheck()&ODO_RESET_MASK_3)/*按键保持长按下 所有门开*/
         {
           GeelyReseReq++;
         }
         else
         {
           GeelyReseReq=0u;
         }
      }
      else/*4s后在检测*/
      {
        if(OEMResetReqCheck()==ODO_RESET_MASK_ALL)/*满足清零条件车速<2 所有门开 按键*/
        { 
          if(GeelyReseReq<=400u)/*持续20s*/
          {
           GeelyReseReq++;
          }  
          
          if(GeelyReseReq==400u)
          {
           (void)GeelyReset();/*主机厂清零*/
           GeelyReseReq=0u;
          }
        }
        else
        {
         GeelyReseReq=0u;
        }         
      } 

    }
  }
  else
  {
    /*OFF 下检测主机厂清零请求*/ 
    if(OEMResetReqCheck()>=ODO_RESET_MASK_2)/*OFF下判断到按键被按下*/
    {
      GeelyReseReq=1u;
    }
    else
    {
      GeelyReseReq=0u;
    }
  }
}

void CanHook_2A4(void);
void CanHook_2A4(void)
{
  /*收到报文时发出通知*/
  Mes2A4rCnt++;
}

uint8_t GetDoorSta(void)
{
  union
  {
   uint8_t req;
   struct
   {
     uint8_t bit_1 :1;
     uint8_t bit_2 :1;
     uint8_t bit_3 :1;
     uint8_t bit_4 :1;
     uint8_t bit_5 :1;
     uint8_t bit_6 :1;


   }Group;   
  }m8;
  m8.Group.bit_1 = 0;//Get_Door_Open_Stats_FL_Status();
  m8.Group.bit_2 = 0;//Get_Door_Open_Stats_FR_Status();
  m8.Group.bit_3 = 0;//Get_Door_Open_Stats_RR_Status();
  m8.Group.bit_4 = 0;//Get_Door_Open_Stats_RL_Status();
  m8.Group.bit_5 = 0;//Get_Door_Open_Stats_TR_Status();
  m8.Group.bit_6 = 0;//Get_Door_Open_Stats_HO_Status(); 
  m8.req&=0x3FU;
  return m8.req;
}


