#ifndef _EOL_Para_H_
#define _EOL_Para_H_

#include "stdint.h"

typedef struct
{
	uint8_t F101_Byte[8u];
} _EOL_F101;


typedef struct
{
	uint8_t F110_Byte[8u];
} _EOL_F110;

typedef struct
{
	uint8_t F100_Byte[16u];
} _EOL_F100;

typedef struct
{
	uint8_t F7101_Byte[3u];
} _EOL_7101;

typedef struct
{
	uint8_t F7102_Byte[3u];
} _EOL_7102;

/*BYTE0*/
uint8_t Val_EOL_F101_Engine(void);
/*BYTE1*/
uint8_t Val_EOL_F101_Radar(void);
uint8_t Val_EOL_F101_Language(void);
/*BYTE2*/
uint8_t Val_EOL_F101_Gearbox(void);
uint8_t Val_EOL_F101_OverSpeed(void);
uint8_t Val_EOL_F101_HUD(void);
/*BYTE3*/
uint8_t Val_EOL_F101_Tyre(void);
uint8_t Val_EOL_F101_Seat_O(void);
uint8_t Val_EOL_F101_EPSMod(void);
/*BYTE4*/
uint8_t Val_EOL_F101_Energy(void);
uint8_t Val_EOL_F101_FuelTank(void);
/*BYTE5*/
uint8_t Val_EOL_F101_ESCOFF(void);
uint8_t Val_EOL_F101_LIM(void);
uint8_t Val_EOL_F101_TempOut(void);
uint8_t Val_EOL_F101_LightReg(void);
/*BYTE6*/
uint8_t Val_EOL_F101_HBB(void);
uint8_t Val_EOL_F101_Cruise(void);
uint8_t Val_EOL_F101_Vehicle(void);
/*BYTE7*/
uint8_t Val_EOL_F101_SLIF(void);
uint8_t Val_EOL_F101_AEB(void);
uint8_t Val_EOL_F101_LKSLDW(void);
uint8_t Val_EOL_F101_BSD(void);
/*BYTE8*/
uint8_t Val_EOL_F101_HDC(void);
uint8_t Val_EOL_F101_RCTA(void);
uint8_t Val_EOL_F101_RCW(void);
uint8_t Val_EOL_F101_IHBC(void);
/*BYTE9*/
uint8_t Val_EOL_F101_LCA(void);
uint8_t Val_EOL_F101_DOW(void);
uint8_t Val_EOL_F101_DriverPos(void);
uint8_t Val_EOL_F101_APA(void);
uint8_t Val_EOL_F101_Seat(void);
/*BYTE10*/
uint8_t Val_EOL_F101_Sunroof(void);
uint8_t Val_EOL_F101_Skin(void);
uint8_t Val_EOL_F101_FuelInit(void);
/*BYTE11*/
uint8_t Val_EOL_F101_FCW(void);
uint8_t Val_EOL_F101_ODOBack(void);
uint8_t Val_EOL_F101_BeltDisp(void);
uint8_t Val_EOL_F101_IPKGear(void);
uint8_t Val_EOL_F101_MMIKey(void);
uint8_t Val_EOL_F101_Phone(void);
uint8_t Val_EOL_F101_Music(void);
uint8_t Val_EOL_F101_Nav(void);
/*BYTE12*/
uint8_t Val_EOL_F101_Bat(void);
uint8_t Val_EOL_F101_PEPS(void);
uint8_t Val_EOL_F101_OilPress(void);
uint8_t Val_EOL_F101_WipInd(void);
/*BYTE13*/
uint8_t Val_EOL_F101_ADAS(void);
uint8_t Val_EOL_F101_Guid(void);
/*BYTE15*/
uint8_t Val_EOL_F101_TPMS(void);
uint8_t Val_EOL_F101_MaintainTimeDispiay(void);
uint8_t Val_EOL_F101_Jion_P_Gear(void);


/****F110***/

/**byte0*/
uint8_t Val_EOL_F110_EPS(void);
uint8_t Val_EOL_F110_PEPS(void);
uint8_t Val_EOL_F110_ESC(void);
uint8_t Val_EOL_F110_ACU(void);
uint8_t Val_EOL_F110_TCU(void);
uint8_t Val_EOL_F110_BCM(void);
uint8_t Val_EOL_F110_IPK(void);
uint8_t Val_EOL_F110_EMS(void);
/**byte1**/
uint8_t Val_EOL_F110_ESCL(void);
uint8_t Val_EOL_F110_TBOX(void);
uint8_t Val_EOL_F110_TPMS(void);
uint8_t Val_EOL_F110_PAS(void);
uint8_t Val_EOL_F110_MMI(void);
uint8_t Val_EOL_F110_AC(void);
uint8_t Val_EOL_F110_FRS(void);
uint8_t Val_EOL_F110_SAS(void);
/**BYTE2*/
uint8_t Val_EOL_F110_4WD(void);
uint8_t Val_EOL_F110_IMMO(void);
uint8_t Val_EOL_F110_ABS(void);
uint8_t Val_EOL_F110_ADB(void);
uint8_t Val_EOL_F110_DSCU2(void);
uint8_t Val_EOL_F110_PTG(void);
uint8_t Val_EOL_F110_FCS(void);
uint8_t Val_EOL_F110_EPB(void);
/*byte3**/
uint8_t Val_EOL_F110_IPU(void);
uint8_t Val_EOL_F110_OBC(void);
uint8_t Val_EOL_F110_VCU(void);
uint8_t Val_EOL_F110_DCDC(void);
uint8_t Val_EOL_F110_BMSH(void);
uint8_t Val_EOL_F110_BSG(void);
uint8_t Val_EOL_F110_EGSM(void);
uint8_t Val_EOL_F110_PTGW(void);
/**BYTE4*/
uint8_t Val_EOL_F110_RSRS(void);
uint8_t Val_EOL_F110_GW(void);
uint8_t Val_EOL_F110_DMS(void);
uint8_t Val_EOL_F110_HVSM(void);
uint8_t Val_EOL_F110_DVR(void);
uint8_t Val_EOL_F110_AVAS(void);
uint8_t Val_EOL_F110_DSCU4(void);
uint8_t Val_EOL_F110_ACCM(void);
/**byte5*/
uint8_t Val_EOL_F110_BSD(void);
uint8_t Val_EOL_F110_TSU(void);
uint8_t Val_EOL_F110_PCU(void);
uint8_t Val_EOL_F110_PDM(void);
uint8_t Val_EOL_F110_DDM(void);
uint8_t Val_EOL_F110_HUD(void);
uint8_t Val_EOL_F110_AVM(void);
uint8_t Val_EOL_F110_AGS(void);
/**byte6*/
uint8_t Val_EOL_F110_IB(void);
uint8_t Val_EOL_F110_SUM(void);
uint8_t Val_EOL_F110_RML(void);
uint8_t Val_EOL_F110_ECS(void);
uint8_t Val_EOL_F110_TACM(void);
uint8_t Val_EOL_F110_BMSL(void);



/*下线配置初始化*/
void EOL_InitVal(void);
/*设置下线配置F101*/
void EOL_SetF101(uint8_t EOL[], uint8_t len);
/*设置下线配置F110*/
void EOL_SetF110(uint8_t EOL[], uint8_t len);
/*设置网络拓扑配置F110*/
void EOL_SetF100(uint8_t EOL[], uint8_t len);
void EOL_Set7101(uint8_t EOL[], uint8_t len);
void EOL_Set7102(uint8_t EOL[], uint8_t len);
/*获取下线配置F101*/
_EOL_F101 EOL_GetF101(void);
/*获取下线配置F110*/
_EOL_F110 EOL_GetF110(void);
/*获取网络拓扑*/
_EOL_F100 EOL_GetF100(void);
_EOL_7101 EOL_Get7101(void);
_EOL_7102 EOL_Get7102(void);

#endif