#include "UDS_Common.h"

uint8_t  SessionType = DefaultSession;

uint16_t S3_ServerCnt = S3_SERVER;
uint8_t  S3_ServerClear = 0u;
uint8_t  S3_ServerTimeOut = 1u;

uint8_t  UDSKL15Status = 0u;
uint8_t  UDSSleepStatus = 0u;

uint16_t UDSTimer10ms = 0u;

uint8_t  S31DID62F3RequestStatus = 0u;

uint8_t  isDTCOpen = 1u;
uint8_t  isReceive = 1u;
uint8_t  isEnable = 0u;
uint16_t enableTimer = 0u;
uint16_t enableMaxTimer = KL15DTCEnableTimer;

DiagMSGUnion DiagMSG;
DiagFlagUnion DiagFlag;
Ser27_FlowCtrlUnion Ser27_FlowCtrl;
Ser27_FlowCtrlCntUnion Ser27_FlowCtrlCnt;
BootToDFlashInfoUnion BootToDFlashInfo;
Ser2EToDFlashInfoUnion Ser2EToDFlashInfo;
DTCToDFlashInfoUnion DTCToDFlashInfo;
 const uint8_t DID_F180[16]= {'1','0','3',0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20};
 const uint8_t DID_F187[21]={'9','9','0','0','1','6','2','7','4','4',0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20};
 const uint8_t DID_F189[16]={'0','0','1','.','0','0','1',0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20};//主机厂定义的软件版本编号
 const uint8_t DID_F191[16]={'0','0','1','.','0','0','1',0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20};//主机厂定义的硬件版本编号
 const uint8_t DID_F193[16]={'H','V','0','0','1','.','0','0','1',0x20,0x20,0x20,0x20,0x20,0x20,0x20};//供应商定义的硬件版本编号
 const uint8_t DID_F199[4]={0x20u,0x23u,0x02u,0x24u};
 const uint8_t DID_F112[8]={'L','E','1','9',0x20,0x20,0x20,0x20};

 const uint8_t Ser22_DID_F113[4] = {0x04, 0x04, 0x04, 0x04};       
 const uint8_t Ser22_DID_F182[16] = "0100000000000000";            
 const uint8_t Ser22_DID_F18A[6] = {'4', '5', '1', '0', '0', '3'}; 
 const uint8_t Ser22_DID_F18B[4] = {0x20, 0x23, 0x02, 0x24};       
 const uint8_t Ser22_DID_F18C[24] = "0000";                          
 const uint8_t Ser22_DID_F195[16] = "SV001.001       ";//供应商定义的软件版本编号                 	 
 const uint8_t Ser22_DID_F1A2[4] ={0x20,0x23,0x02,0x24};
 /*const uint8_t Ser22_DID_F1AA[8];                                  
 const uint8_t Ser22_DID_F1AE[] = "";                              
 const uint8_t Ser22_DID_6209[16] = "";                            
 const uint8_t Ser22_DID_6983[3] = "";                             
 const uint8_t Ser22_DID_6984[2] = "";                             
 const uint8_t Ser22_DID_6985[3] = "";    */                         
/**
  *设置会话类型
  *@param status 会话类型
  */
void setSessionType(uint8_t status)
{
    if ((status == DefaultSession) || (status == ProgrammingSession) || (status == ExtendedDiagnosticSession))
    {
        SessionType = status;
    }
    else
    {
        SessionType = DefaultSession;
    }
}

/**
  *获取会话类型
  *@return 当前会话类型
  */
uint8_t getSessionType(void)
{
    return SessionType;
}

/**
  *设置诊断信息
  *@param Identifier 收到的诊断报文ID
  *@param dlc 收到的诊断报文长度
  *@param Data 收到的诊断报文数据
  */
void setDiagMSG(uint32_t Identifier, uint16_t dlc, uint8_t Data[])
{
    uint16_t i;
    DiagMSG.msgID = Identifier;
    DiagMSG.msgDLC = dlc;
    for (i = 0u; i < dlc; ++i)
    {
        DiagMSG.msgData.Data[i] = Data[i];
    }
}

/**
  *清除诊断信息
  */
void clearDiagMSG(void)
{
    uint16_t i;
    DiagMSG.msgID = 0u;
    DiagMSG.msgDLC = 0u;
    for (i = 0u; i < DIM(DiagMSG.msgData.Data); ++i)
    {
        DiagMSG.msgData.Data[i] = 0u;
    }
}

/**
  *获取当前车速
  *@return 返回当前车速
  */
uint16_t getSpeed(void)
{
    uint16_t VSpeed = Common_Get_Act_V_Speed();
    if(VSpeed == 0xFFFFu)
    {
        VSpeed = 0u;
    }
    return (VSpeed / 10u);
}

/**
  *获取当前转速
  *@return 返回当前转速
  */
uint16_t getESpeed(void)
{
    uint16_t ESpeed = 0;//Common_Get_Act_E_Speed();
    if((Get_ID_18FAB027_Sig_VCUPTReadyInd()==1u)&&(CAN_MSG_Status(ID_can0x18FAB027_Msg_Count)==0u))
    {
        ESpeed = 500u;
    }
    return ESpeed;
}

/**
  *获取当前30电压
  *@return 返回当前30电压
  */
uint16_t getKL30Voltage(void)
{
    return ADC_Read_Signal(ADC_CH_KL30_VOLTAGE);
}

/**
  *获取15电状态
  *@return 15点状态 0为IGN OFF,1为IGN ON
  */
uint8_t getKL15Status(void)
{
    return GPIO_KL15;
}

/**
  *获取当前安全级别
  *@return 返回当前安全级别
  */
uint8_t getSecurityLevel(void)
{
    return Ser27_FlowCtrl.LV1SafetyStatus;
}

/**
  *重置安全等级
  */
void Ser27_ChangeSessionHandle(void)
{
    Ser27_FlowCtrl.LV1Ctrl = SER27_CLEAR_REQ_SEEDED;
    Ser27_FlowCtrl.LV1Key[0]  = 0x00u;
    Ser27_FlowCtrl.LV1Key[1]  = 0x00u;
    Ser27_FlowCtrl.LV1Key[2]  = 0x00u;
    Ser27_FlowCtrl.LV1Key[3]  = 0x00u;
    Ser27_FlowCtrl.LV1SafetyStatus = NormalKeyLock;
    Ser27_FlowCtrl.LV1Seed[0] = 0x00u;
    Ser27_FlowCtrl.LV1Seed[1] = 0x00u;
    Ser27_FlowCtrl.LV1Seed[2] = 0x00u;
    Ser27_FlowCtrl.LV1Seed[3] = 0x00u;
}

/**
  *复位函数
  */
void UDS_RESET(void)
{
    ControlMessageCommunication(networkManagementMsgAndnormalMsg, disableRxAndTx);
    UDS_Delay(3000u);
    RESET();
}

/**
  *诊断延时
  *@param count 延时次数
  */
void UDS_Delay(uint16_t count)
{
    uint16_t tmpcnt;
    tmpcnt = count;
    WDT_Clear();
    while (tmpcnt--)
    {
        NOP();
    }
    WDT_Clear();
}

/**
  *发送诊断11服务正反馈
  */
void UDS_S11_Sand(uint8_t subid)
{
    _CAN_Msg canMag;
    canMag.MsgID = DIAG_ID_Tx;
    canMag.Msg[0] = 0x02u;
    canMag.Msg[1] = 0x51u;
    canMag.Msg[2] = subid;
    canMag.Msg[3] = FILLER_BYTE;
    canMag.Msg[4] = FILLER_BYTE;
    canMag.Msg[5] = FILLER_BYTE;
    canMag.Msg[6] = FILLER_BYTE;
    canMag.Msg[7] = FILLER_BYTE;
    canMag.MsgDLC = 8u;
    canMag.MsgPro = 25u;
    Can_Write(&canMag);
}

/**
  *诊断11服务正反馈确认
  */
void UDS_S11_Confirm(void)
{
    UDS_RESET();
}

/**
  *发送诊断78负反馈
  */
void UDS_NRC78_Sand(uint8_t sid)
{
    _CAN_Msg canMag;
    canMag.MsgID = DIAG_ID_Tx;
    canMag.Msg[0] = 0x03u;
    canMag.Msg[1] = 0x7Fu;
    canMag.Msg[2] = sid;
    canMag.Msg[3] = 0x78u;
    canMag.Msg[4] = FILLER_BYTE;
    canMag.Msg[5] = FILLER_BYTE;
    canMag.Msg[6] = FILLER_BYTE;
    canMag.Msg[7] = FILLER_BYTE;
    canMag.MsgDLC = 8u;
    canMag.MsgPro = 26u;
    Can_Write(&canMag);
}

/**
  *发送诊断78负反馈
  */
void UDS_14_SendRsp(uint8_t sid)
{
    _CAN_Msg canMag;
    canMag.MsgID = DIAG_ID_Tx;
    canMag.Msg[0] = 0x01u;
    canMag.Msg[1] = 0x54u;
    canMag.Msg[2] = FILLER_BYTE;
    canMag.Msg[3] = FILLER_BYTE;
    canMag.Msg[4] = FILLER_BYTE;
    canMag.Msg[5] = FILLER_BYTE;
    canMag.Msg[6] = FILLER_BYTE;
    canMag.Msg[7] = FILLER_BYTE;
    canMag.MsgDLC = 8u;
    canMag.MsgPro = 27u;
    Can_Write(&canMag);
}

/**
  *发送负反馈
  */
void UDS_SendNRCRsp(uint8_t sid,uint8_t status)
{
    _CAN_Msg canMag;
    canMag.MsgID = DIAG_ID_Tx;
    canMag.Msg[0] = 0x03u;
    canMag.Msg[1] = 0x7fu;
    canMag.Msg[2] = sid;
    canMag.Msg[3] = status;
    canMag.Msg[4] = FILLER_BYTE;
    canMag.Msg[5] = FILLER_BYTE;
    canMag.Msg[6] = FILLER_BYTE;
    canMag.Msg[7] = FILLER_BYTE;
    canMag.MsgDLC = 8u;
    canMag.MsgPro = 26u;
    Can_Write(&canMag);
}

/**
  *诊断50us任务
  */
void UDS_50us_Service(void)
{
    if(UDSSleepStatus == 1u)
    {
        ++UDSTimer10ms;
    }
}

/**
  *诊断10ms任务
  */
void UDS_10ms_Service(void)
{
    uint16_t count;
    if(UDSTimer10ms >= 200u)
    {
        count = UDSTimer10ms / 200u;
        UDSTimer10ms %= 200u;
        enableDTCTimer(count * 10u);
        MsgLostTimer(count * 10u);
        TestDTC(count * 10u);
        S3_Service(count * 10u);
        Ser27_ErrDelayTimerService(count * 10u);
    }
}

/**
  *诊断KL15init
  */
void UDS_KL15_init(void)
{
    uint8_t KL15Status = getKL15Status();
    if(UDSKL15Status == 0u)
    {
        if((KL15Status == 1u))
        {
            UDSKL15Status = 1u;
            UDSSleepStatus = 1u;
            setDTCEnableTimer(KL15DTCEnableTimer);
            S3_ServiceTimeOut();
            DTCAgeing();
        }
    }
    else
    {
        if(KL15Status == 0u)
        {
            UDSKL15Status = 0u;
            setDTCEnableTimer(KL15DTCEnableTimer);
        }
    }
}

void UDS_Slepp(void)
{
    UDSSleepStatus = 0u;
    UDSTimer10ms = 0u;
}

/**
  *报文掉线计时器
  *@param timer 计时器增加的时间，单位：ms
  */
void MsgLostTimer(uint16_t timer)
{
    uint8_t i;
    uint8_t BUS_OFF_Status = getBusoffStatus();
    if((isEnable == 1u) && (isReceive == 1u) && (UDSKL15Status == 1u) && (BUS_OFF_Status == 0u) && (HVoltageStatus == 0u) && (LVoltageStatus == 0u))
    {
        for(i = 0u; i < (sizeof(msgList) / sizeof(msgList[0u])); ++i)
        {
            if(msgList[i][2u] < 50u)
            {
                if(msgList[i][3u] < 50u * OfflineLoopMultiple)
                {
                    msgList[i][3u] += timer;
                }
            }
            else
            {
                if(msgList[i][3u] < msgList[i][2u] * OfflineLoopMultiple)
                {
                    msgList[i][3u] += timer;
                }
            }
        }
    }
}

/**
  *收到报文清除计时器
  *@param MsgID 报文ID
  *@param DLC   报文长度
  */
void ReceivedMsg(uint32_t MsgID, uint8_t DLC)
{
    uint8_t i;
    if(isReceive == 1u)
    {
        for(i = 0u; i < (sizeof(msgList) / sizeof(msgList[0u])); ++i)
        {
            if((MsgID == msgList[i][0u]) && (DLC == msgList[i][1u]))
            {
                msgList[i][3] = 0u;
                break;
            }
        }
    }
}

/**
  *S3服务
  */
void S3_Service(uint16_t timer)
{
    if (S3_ServerClear == 1u)
    {
        S3_ServerClear = 0u;
        S3_ServerCnt = 0u;
        S3_ServerTimeOut = 0u;
    }
    else
    {
        if (S3_ServerCnt < S3_SERVER)
        {
            S3_ServerCnt += timer;
        }
        else
        {
            if (S3_ServerTimeOut == 0u)
            {
                S3_ServerTimeOut = 1u;
                S3_ServiceTimeOut();
            }
        }
    }
}

/**
  *S3重置服务
  */
void S3_ServiceClear(void)
{
    S3_ServerClear = 1u;
}

/**
  *S3等待服务
  */
void S3_ServiceWait(void)
{
    S3_ServerClear = 0u;
    S3_ServerCnt = S3_SERVER;
    S3_ServerTimeOut = 1u;
}

/**
  *S3超时服务
  */
void S3_ServiceTimeOut(void)
{
    /*10服务重置*/
    setSessionType(DefaultSession);
    /*27服务重置*/
    Ser27_ChangeSessionHandle();
    /*28服务重置*/
    ControlMessageCommunication(networkManagementMsgAndnormalMsg, enableRxAndTx);
    /*2F服务重置*/
    UDS_10Service_S2FInit();
    /*85服务重置*/
    OpenDTCTest();
    /*诊断发送重置*/
    clearDiagMSG();
}

/**
  *27服务10s延时
  */
void Ser27_ErrDelayTimerService(uint16_t timer)
{
    if ( ( Ser27_FlowCtrl.LV1DelayCtrl == SER27_ERR_DELAY_TIMER_EN ) )
    {
        if (Ser27_FlowCtrl.LV1DelayTimer < 0xfff0u )
        {
            Ser27_FlowCtrl.LV1DelayTimer += timer;
            if (Ser27_FlowCtrl.LV1DelayTimer >= SER27_ERR_DELAY_TIMEOUT)
            {
                if (Ser27_FlowCtrlCnt.LV1ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM )
                {
                    Ser27_FlowCtrlCnt.LV1ReqSeedCnt  = SER27_MAX_REQ_SEED_NUM - 1u;
                }
                if (Ser27_FlowCtrlCnt.LV11_ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM)
                {
                    Ser27_FlowCtrlCnt.LV11_ReqSeedCnt  = SER27_MAX_REQ_SEED_NUM - 1u;
                }
                Ser27_FlowCtrl.LV1Ctrl = SER27_CLEAR_REQ_SEEDED;
                Ser27_FlowCtrl.LV1DelayTimer = 0u;
                Ser27_FlowCtrl.LV1DelayCtrl = 0u;
                /*调用向DFlash写入函数。*/
                WriteDFlashData(0x02u, (uint32_t *)&Ser27_FlowCtrlCnt.Flag, sizeof(Ser27_FlowCtrlCnt) / 4u, NoNeedWait);
            }
        }
    }
}

/**
  *控制报文通信
  *@param Type 控制报文的类型
  *@param Status 控制的标志位
  */
void ControlMessageCommunication(uint8_t Type, uint8_t Status)
{
    if ((uint8_t)(Type & normalMsg) == normalMsg)
    {
        if ((uint8_t)(Status & enableRxAndDisableTx) == enableRxAndDisableTx)
        {
            Can_SetTx_St(CAN_N_F_TX);
        }
        else
        {
            Can_SetTx_St(CAN_N_TX);
            Can_SetTx_St(CAN_Y_TX);
        }
        if ((uint8_t)(Status & disableRxAndEnableTx) == disableRxAndEnableTx)
        {
            Can_SetRx_St(CAN_N_F_RX);
            isReceive = 0u;
        }
        else
        {
            isReceive = 1u;
            Can_SetRx_St(CAN_N_RX);
            Can_SetRx_St(CAN_Y_RX);
        }
    }
    if ((uint8_t)(Type & networkManagementMsg) == networkManagementMsg)
    {
    }
}

/**
  *DTC使能定时
  */
void enableDTCTimer(uint16_t Timer)
{
    uint8_t BUS_OFF_Status = getBusoffStatus();
    if((UDSKL15Status == 1u) && (BUS_OFF_Status == 0u) && (HVoltageStatus == 0u) && (LVoltageStatus == 0u))
    {
        if(isEnable == 0u)
        {
            if(enableTimer >= enableMaxTimer)
            {
                isEnable = 1u;
                enableTimer = 0u;
            }
            else
            {
                enableTimer += Timer;
            }
        }
    }
}

/**
  *DTC是否使能
  *@return DTC使能状态 0为未使能,1为使能
  */
uint8_t isDTCEnable(void)
{
    return isEnable;
}

/**
  *设置DTC使能时间
  */
void setDTCEnableTimer(uint16_t Timer)
{
    uint8_t i;
    if(isEnable == 1u)
    {
        isEnable = 0u;
        enableTimer = 0u;
        enableMaxTimer = Timer;
        for(i = 0u; i < (sizeof(msgList) / sizeof(msgList[0u])); ++i)
        {
            msgList[i][3] = 0u;
        }
    }
    else
    {
        if(enableMaxTimer == Timer)
        {
            enableTimer = 0u;
        }
        else
        {
            if(enableMaxTimer < enableTimer + Timer)
            {
                enableMaxTimer = enableTimer + Timer;
            }
        }
    }
}

/**
  *开启DTC检测
  */
void OpenDTCTest(void)
{
    isDTCOpen = 1u;
}

/**
  *关闭DTC检测
  */
void CloseDTCTest(void)
{
    isDTCOpen = 0u;
}

/**
  *DTC是否开启
  *@return DTC状态 0关闭,1开启
  */
uint8_t DTCTestIsOpen(void)
{
    return isDTCOpen;
}

/**
  *DTC老化
  */
void DTCAgeing(void)
{
    uint8_t i;
    for (i = 0u; i < sizeof(DTCToDFlashInfo.DTC) / sizeof(DTCUnion); ++i)
    {
        DTCToDFlashInfo.DTC[i].DTCStatus |= (DTCNoTestThisCycle);
        if ((uint8_t)(DTCToDFlashInfo.DTC[i].DTCStatus & DTCErrorThisCycle) != DTCErrorThisCycle)
        {
            DTCToDFlashInfo.DTC[i].DTCStatus &= (~DTCPending);
            DTCToDFlashInfo.DTC[i].DTCPendingCount = 0u;
            if ((uint8_t)(DTCToDFlashInfo.DTC[i].DTCStatus & DTCConfirmed) == DTCConfirmed)
            {
                DTCToDFlashInfo.DTC[i].DTCAgeing++;
                if (DTCToDFlashInfo.DTC[i].DTCAgeing >= AgeingCount)
                {
                    DTCToDFlashInfo.DTC[i].DTCStatus &= (~DTCConfirmed);
                }
            }
        }
        else
        {
            DTCToDFlashInfo.DTC[i].DTCStatus &= (~DTCErrorThisCycle);
        }
        DTCToDFlashInfo.DTC[i].DTCStatus &= DTCNoError;
    }
}

/**
  *读取所有的诊断信息
  */   uint32_t Sizetest[15];
void ReadAllDFlashData(void)
{

 uint8_t i,flagboot=0;
 uint8_t flag2E=0;
    ReadDFlashData(0x01u, (uint32_t *)&DiagFlag.Flag         , sizeof(DiagFlag)          / 4u, AllFlagInit);
    ReadDFlashData(0x02u, (uint32_t *)&Ser27_FlowCtrlCnt.Flag, sizeof(Ser27_FlowCtrlCnt) / 4u, Ser27ToDFlashInfoInit);
    ReadDFlashData(0x03u, (uint32_t *)&BootToDFlashInfo.Flag , sizeof(BootToDFlashInfo)  / 4u, BootToDFlashInfoInit);
    ReadDFlashData(0x04u, (uint32_t *)&Ser2EToDFlashInfo.Flag, sizeof(Ser2EToDFlashInfo) / 4u, Ser2EToDFlashInfoInit);
    ReadDFlashData(0x05u, (uint32_t *)&DTCToDFlashInfo.Flag  , sizeof(DTCToDFlashInfo)   / 4u, DTCToDFlashInfoInit);
  Sizetest[0]=sizeof(DiagFlag);
  Sizetest[1]=sizeof(Ser27_FlowCtrlCnt);
  Sizetest[2]=sizeof(BootToDFlashInfo);
  Sizetest[3]=sizeof(Ser2EToDFlashInfo);
  Sizetest[4]=sizeof(DTCToDFlashInfo);

/*
  Sizetest[6]=sizeof(DTCToDFlashInfo.DTC);
  Sizetest[7]=sizeof(DTCToDFlashInfo.DTC[0].Snapshot);

  Sizetest[8]=sizeof(DTCToDFlashInfo.DTC[0].Snapshot.ECUPowerVoltage);
  Sizetest[9]=sizeof(DTCToDFlashInfo.DTC[0].Snapshot.VehicleSpeed);
  Sizetest[10]=sizeof(DTCToDFlashInfo.DTC[0].Snapshot.OccurrenceCounter);
  Sizetest[11]=sizeof(DTCToDFlashInfo.DTC[0].Snapshot.FirstMalfunction);
  Sizetest[12]=sizeof(DTCToDFlashInfo.DTC[0].Snapshot.LastMalfunction);
  Sizetest[13]=sizeof(DTCToDFlashInfo.DTC[0]);*/


    for ( i = 0; i < sizeof(DID_F180); i++)
    {
       if(BootToDFlashInfo.DID_F180[i]!=DID_F180[i]) 
       {
          flagboot=1;
            memset(BootToDFlashInfo.DID_F180, 0x20, 16u);
            memcpy(BootToDFlashInfo.DID_F180,DID_F180,sizeof(DID_F180));
          break;
       }
    }

    for ( i = 0; i < sizeof(DID_F187); i++)
    {
       if(BootToDFlashInfo.DID_F187[i]!=DID_F187[i]) 
       {
          flagboot=1; 
            memset(BootToDFlashInfo.DID_F187, 0x20, 21u);
            memcpy(BootToDFlashInfo.DID_F187,DID_F187,sizeof(DID_F187));
          break;
       }
    }

    for ( i = 0; i < sizeof(DID_F189); i++)
    {
       if(BootToDFlashInfo.DID_F189[i]!=DID_F189[i]) 
       {
          flagboot=1;
            memset(BootToDFlashInfo.DID_F189, 0x20, 16u);
            memcpy(BootToDFlashInfo.DID_F189,DID_F189,sizeof(DID_F189));
          break;
       }
    }

/*    for ( i = 0; i < sizeof(DID_F191); i++)
    {
        if(BootToDFlashInfo.DID_F191[i]!=DID_F191[i]) 
        {
            flagboot=1;
            memset(BootToDFlashInfo.DID_F191, 0x20, 16u);
            memcpy(BootToDFlashInfo.DID_F191,DID_F191,sizeof(DID_F191));
            break;
        }
    }*/
    for ( i = 0; i < sizeof(DID_F193); i++)
    {
       if(BootToDFlashInfo.DID_F193[i]!=DID_F193[i]) 
       {
          flagboot=1;
            memset(BootToDFlashInfo.DID_F193, 0x20, 16u);
            memcpy(BootToDFlashInfo.DID_F193,DID_F193,sizeof(DID_F193));
          break;
       }
    }

    /*if (memcmp(BootToDFlashInfo.DID_F199,DID_F199,sizeof(DID_F199)!=0))
    {
        flagboot=1;
        memcpy(BootToDFlashInfo.DID_F199,DID_F199,sizeof(DID_F199));
    }*/
    

    
    if (flagboot)
    {
         WriteDFlashData(0x03u, (uint32_t *)&BootToDFlashInfo.Flag, sizeof(BootToDFlashInfo)  / 4u, NeedWait);
    }


    if(memcmp(Ser2EToDFlashInfo.DID_F112,DID_F112,sizeof(DID_F112))!=0)
    {
        flag2E=1;
        memset(Ser2EToDFlashInfo.DID_F112, 0x20, 8u);
        memcpy(Ser2EToDFlashInfo.DID_F112,DID_F112,sizeof(DID_F112));
    }
    /*if(memcmp(Ser2EToDFlashInfo.DID_F1A2,Ser22_DID_F1A2,sizeof(Ser22_DID_F1A2))!=0)
    {   
        flag2E=1;
        memcpy(Ser2EToDFlashInfo.DID_F1A2,Ser22_DID_F1A2,4);
    }*/

    if (flag2E==1)
    {
       WriteDFlashData(0x04u, (uint32_t *)&Ser2EToDFlashInfo.Flag, sizeof(Ser2EToDFlashInfo) / 4u, NeedWait);
    }
    
    if (Ser27_FlowCtrlCnt.LV1ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM )
    {
        Ser27_FlowCtrl.LV1DelayCtrl = SER27_ERR_DELAY_TIMER_EN;
    }
    if (Ser27_FlowCtrlCnt.LV11_ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM)
    {
        Ser27_FlowCtrl.LV1DelayCtrl = SER27_ERR_DELAY_TIMER_EN;
    }
    EOL_SetF101(Ser2EToDFlashInfo.DID_F101, 16u);
    EOL_SetF110(Ser2EToDFlashInfo.DID_F110, 8u);

    
    DTCConfigurationInit();
}

/**
  *读取信息
  */
uint8_t ReadDFlashData(uint8_t u8BlockNum, uint32_t u32Data[], uint16_t u16Len, InitFunction initFunction)
{
    uint8_t enResult = WFLASH_RW_FAIL;
    enResult = WFlash_Get_Block_Status(u8BlockNum);
    if (enResult == WFLASH_STAT_BLANK)
    {
        initFunction();
        enResult = WriteDFlashData(u8BlockNum, u32Data, u16Len, NeedWait);
    }
    else if (enResult == WFLASH_STAT_ACTIVE)
    {
        enResult = WFlash_Read_Block_Data(u8BlockNum, u32Data, u16Len);
        if (enResult == WFLASH_RW_PASS)
        {
            while (WFlash_Get_Controller_Status() == WFLASH_STAT_BUSY)
            {
                WDT_Clear();
            }
            if (u32Data[0] != 0x7AA7A55Au)
            {
                initFunction();
                enResult = WriteDFlashData(u8BlockNum, u32Data, u16Len, NeedWait);
            }
        }
    }
    else
    {
        initFunction();
        enResult = WriteDFlashData(u8BlockNum, u32Data, u16Len, NeedWait);
    }
    return enResult;
}

/**
  *写入信息
  */
uint8_t WriteDFlashData(uint8_t u8BlockNum, uint32_t u32Data[], uint16_t u16Len, uint8_t isWait)
{
    uint8_t enResult = WFLASH_RW_FAIL;
    if (WFlash_Get_Block_Status(u8BlockNum) != WFLASH_STAT_DISABLE)
    {
        while (WFlash_Get_Controller_Status() == WFLASH_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = WFlash_Write_Block_Data(u8BlockNum, u32Data, u16Len);
        if (isWait == 1u)
        {
            while (WFlash_Get_Controller_Status() == WFLASH_STAT_BUSY)
            {
                WDT_Clear();
            }
        }
    }
    return enResult;
}

/**
  *所有标志位初始化
  */
void AllFlagInit(void)
{
    DiagFlag.Flag = 0x7AA7A55Au;
    DiagFlag.JumpToBootFlag = 0x00000000u;
    DiagFlag.AppValidFlag = 0x00000000u;
    DiagFlag.S11Flag = 0x00000000u;
}

/**
  *27信息初始化
  */
void Ser27ToDFlashInfoInit(void)
{
    Ser27_FlowCtrlCnt.Flag = 0x7AA7A55Au;
    Ser27_FlowCtrlCnt.LV11_InvaidKyeCnt = 0u;
    Ser27_FlowCtrlCnt.LV11_ReqSeedCnt = 0u;
    Ser27_FlowCtrlCnt.LV1InvaidKyeCnt = 0u;
    Ser27_FlowCtrlCnt.LV1ReqSeedCnt = 0u;
    Ser27_FlowCtrlCnt.RandNum = 0u;
}

/**
  *boot信息初始化
  */
void BootToDFlashInfoInit(void)
{
    BootToDFlashInfo.Flag = 0x7AA7A55Au;
    BootToDFlashInfo.DID_0200 = 0u;
    BootToDFlashInfo.DID_0201 = 0u;
    
    memset(BootToDFlashInfo.DID_F180, 0x20, 16u);
    memcpy(BootToDFlashInfo.DID_F180,DID_F180,sizeof(DID_F180));
    
    memset(BootToDFlashInfo.DID_F187, 0x20, 10u);
    memcpy(BootToDFlashInfo.DID_F187,DID_F187,sizeof(DID_F187));

    
    memset(BootToDFlashInfo.DID_F189, 0x20, 16u);
    memcpy(BootToDFlashInfo.DID_F189,DID_F189,sizeof(DID_F189));

    //memset(BootToDFlashInfo.DID_F191, 0x20, 16u);
    //memcpy(BootToDFlashInfo.DID_F191,DID_F191,sizeof(DID_F191));
    
    memset(BootToDFlashInfo.DID_F193, 0x20, 16u);
    memcpy(BootToDFlashInfo.DID_F193,DID_F193,sizeof(DID_F193));

    memset(BootToDFlashInfo.DID_F198, 0x20, 16u);

    memcpy(BootToDFlashInfo.DID_F199,DID_F199,4); 
    
}

/**
  *2E信息初始化
  */
void Ser2EToDFlashInfoInit(void)
{
    uint8_t i;
    _EOL_F101 EOL_F101;
    _EOL_F110 EOL_F110;
    Ser2EToDFlashInfo.Flag = 0x7AA7A55Au;
    
    memset(Ser2EToDFlashInfo.DID_DFEC, 0, 64u);

    memset(Ser2EToDFlashInfo.DID_DFED, 0, 64u);
    
    memset(Ser2EToDFlashInfo.DID_DFEE, 0, 64u);
    
    memset(Ser2EToDFlashInfo.DID_DFEF, 0, 64u);
    
    memset(Ser2EToDFlashInfo.DID_F112, 0x20, 8u);
    memcpy(Ser2EToDFlashInfo.DID_F112,DID_F112,sizeof(DID_F112));
    
    memset(Ser2EToDFlashInfo.DID_F190, 0x20, 17u);

    memset(Ser2EToDFlashInfo.DID_F197, 0x20, 8u);
    Ser2EToDFlashInfo.DID_F197[0] = 'I';
    Ser2EToDFlashInfo.DID_F197[1] = 'P';
    Ser2EToDFlashInfo.DID_F197[2] = 'K';
    
    memcpy(Ser2EToDFlashInfo.DID_F1A2,Ser22_DID_F1A2,4);

    
    EOL_InitVal();
    EOL_F101 = EOL_GetF101();
    EOL_F110 = EOL_GetF110();
    for (i = 0u; i < 16u; ++i)
    {
        Ser2EToDFlashInfo.DID_F101[i] = EOL_F101.F101_Byte[i];
    }
    for (i = 0u; i < 8u; ++i)
    {
        Ser2EToDFlashInfo.DID_F110[i] = EOL_F110.F110_Byte[i];
    }

    Ser2EToDFlashInfo.DID_7101[0] = 0x00u;
    Ser2EToDFlashInfo.DID_7101[1] = 0x30u;
    Ser2EToDFlashInfo.DID_7101[2] = 0x00u;

    Ser2EToDFlashInfo.DID_7102[0] = 0x01u;
    Ser2EToDFlashInfo.DID_7102[1] = 0x00u;
    Ser2EToDFlashInfo.DID_7102[2] = 0x00u;

    Ser2EToDFlashInfo.DID_7103[0] = 0x00u;

}

/**
  *DTC信息初始化
  */
void DTCToDFlashInfoInit(void)
{
    uint8_t i;
    DTCToDFlashInfo.Flag = 0x7AA7A55Au;
    for (i = 0u; i < sizeof(DTCToDFlashInfo.DTC) / sizeof(DTCUnion); ++i)
    {
        DTCToDFlashInfo.DTC[i].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[i].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[i].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[i].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[i].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[i].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[i].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[i].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[i].Snapshot.LastMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[i].Snapshot.Time.min   = 0x00u;
        DTCToDFlashInfo.DTC[i].Snapshot.Time.sec   = 0x00u;
        DTCToDFlashInfo.DTC[i].Snapshot.Time.hour  = 0x00u;
        DTCToDFlashInfo.DTC[i].Snapshot.Time.month = 0x01u;
        DTCToDFlashInfo.DTC[i].Snapshot.Time.day   = 0x01u;
        DTCToDFlashInfo.DTC[i].Snapshot.Time.year  = 0x00u;
    }
    for(i = 0u; i < (sizeof(msgList) / sizeof(msgList[0u])); ++i)
    {
        msgList[i][3] = 0u;
    }
    for(i = 0u; i < (sizeof(DTCTimerList) / sizeof(DTCTimerList[0u])); ++i)
    {
        DTCTimerList[i] = 0u;
    }
}

/**
  *DTC信息配置初始化
  */
void DTCConfigurationInit(void)
{
    /*if(!Val_EOL_F110_EMS())
    {
        DTCToDFlashInfo.DTC[cnU010087].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU010087].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU010087].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU010087].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU010087].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU010087].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU010087].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU010087].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU010087].Snapshot.LastMalfunction = 0x00000000u;
    }
    if(!Val_EOL_F110_TCU())
    {
        DTCToDFlashInfo.DTC[cnU010187].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU010187].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU010187].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU010187].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU010187].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU010187].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU010187].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU010187].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU010187].Snapshot.LastMalfunction = 0x00000000u;
    }
    if(!Val_EOL_F110_ESC())
    {
        DTCToDFlashInfo.DTC[cnU012287].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU012287].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU012287].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU012287].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU012287].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU012287].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU012287].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU012287].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU012287].Snapshot.LastMalfunction = 0x00000000u;
    }
    if(!Val_EOL_F110_EPS())
    {
        DTCToDFlashInfo.DTC[cnU013187].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU013187].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU013187].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU013187].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU013187].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU013187].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU013187].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU013187].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU013187].Snapshot.LastMalfunction = 0x00000000u;
    }
    if(!Val_EOL_F110_GW())
    {
        DTCToDFlashInfo.DTC[cnU014687].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU014687].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU014687].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU014687].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU014687].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU014687].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU014687].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU014687].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU014687].Snapshot.LastMalfunction = 0x00000000u;
    }
    if(!Val_EOL_F110_BCM())
    {
        DTCToDFlashInfo.DTC[cnU014087].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU014087].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU014087].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU014087].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU014087].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU014087].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU014087].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU014087].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU014087].Snapshot.LastMalfunction = 0x00000000u;
    }
    if(!Val_EOL_F110_ACU())
    {
        DTCToDFlashInfo.DTC[cnU015187].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU015187].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU015187].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU015187].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU015187].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU015187].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU015187].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU015187].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU015187].Snapshot.LastMalfunction = 0x00000000u;
    }
    if(!Val_EOL_F110_AC())
    {
        DTCToDFlashInfo.DTC[cnU016487].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU016487].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU016487].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU016487].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU016487].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU016487].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU016487].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU016487].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU016487].Snapshot.LastMalfunction = 0x00000000u;
    }
    if(!Val_EOL_F110_PEPS())
    {
        DTCToDFlashInfo.DTC[cnU021487].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU021487].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU021487].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU021487].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU021487].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU021487].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU021487].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU021487].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU021487].Snapshot.LastMalfunction = 0x00000000u;
    }
    if(!Val_EOL_F110_BMSH())
    {
        DTCToDFlashInfo.DTC[cnU011287].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU011287].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU011287].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU011287].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU011287].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU011287].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU011287].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU011287].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU011287].Snapshot.LastMalfunction = 0x00000000u;
    }
    if(!Val_EOL_F110_AVAS())
    {
        DTCToDFlashInfo.DTC[cnU016087].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU016087].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU016087].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU016087].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU016087].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU016087].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU016087].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU016087].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU016087].Snapshot.LastMalfunction = 0x00000000u;
    }
    if(!Val_EOL_F110_VCU())
    {
        DTCToDFlashInfo.DTC[cnU111487].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU111487].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU111487].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU111487].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU111487].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU111487].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU111487].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU111487].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU111487].Snapshot.LastMalfunction = 0x00000000u;
    }
    if(!Val_EOL_F110_OBC())
    {
        DTCToDFlashInfo.DTC[cnU111587].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU111587].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU111587].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU111587].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU111587].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU111587].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU111587].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU111587].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU111587].Snapshot.LastMalfunction = 0x00000000u;
    }
    if(!Val_EOL_F110_IPU())
    {
        DTCToDFlashInfo.DTC[cnU011087].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU011087].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU011087].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU011087].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU011087].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU011087].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU011087].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU011087].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU011087].Snapshot.LastMalfunction = 0x00000000u;
    }
    if(!Val_EOL_F110_MMI())
    {
        DTCToDFlashInfo.DTC[cnU015687].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU015687].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU015687].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU015687].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU015687].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU015687].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU015687].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU015687].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU015687].Snapshot.LastMalfunction = 0x00000000u;
    }
    if(!Val_EOL_F110_DSCU4())
    {
        DTCToDFlashInfo.DTC[cnU020887].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU020887].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU020887].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU020887].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU020887].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU020887].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU020887].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU020887].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU020887].Snapshot.LastMalfunction = 0x00000000u;
    }
    if(!Val_EOL_F110_IB())
    {
        DTCToDFlashInfo.DTC[cnU111A87].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU111A87].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU111A87].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU111A87].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU111A87].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU111A87].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU111A87].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU111A87].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU111A87].Snapshot.LastMalfunction = 0x00000000u;
    }
    if(!Val_EOL_F110_ESCL())
    {
        DTCToDFlashInfo.DTC[cnU023687].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU023687].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU023687].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU023687].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU023687].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU023687].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU023687].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU023687].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU023687].Snapshot.LastMalfunction = 0x00000000u;
    }
    if(!Val_EOL_F110_EGSM())
    {
        DTCToDFlashInfo.DTC[cnU010387].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU010387].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU010387].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU010387].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU010387].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU010387].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU010387].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU010387].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU010387].Snapshot.LastMalfunction = 0x00000000u;
    }
    if(!Val_EOL_F110_FRS())
    {
        DTCToDFlashInfo.DTC[cnU023587].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU023587].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU023587].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU023587].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU023587].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU023587].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU023587].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU023587].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU023587].Snapshot.LastMalfunction = 0x00000000u;
    }
    if(!Val_EOL_F110_FCS())
    {
        DTCToDFlashInfo.DTC[cnU120387].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU120387].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU120387].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU120387].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU120387].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU120387].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU120387].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU120387].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU120387].Snapshot.LastMalfunction = 0x00000000u;
    }
    if(!Val_EOL_F110_PAS())
    {
        DTCToDFlashInfo.DTC[cnU017087].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU017087].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU017087].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU017087].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU017087].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU017087].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU017087].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU017087].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU017087].Snapshot.LastMalfunction = 0x00000000u;
    }*/
}




