#include "UDS_31Service_Filter.h"

const uint16_t S31DLC[] = {3, 3, 3};
const uint16_t S31DID[] = {WriteMaintenanceODO, OdometerZeroClearing, TestMode};

/**
  *31服务是否支持功能寻址
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_31Service_NRC11(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgID == DIAG_ID_Rx_FUN)
    {
        NRC = serviceNotSupported;
    }
    return NRC;
}

/**
  *31服务会话是否支持验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_31Service_NRC7F(void)
{
    uint8_t NRC = positiveResponse;
    if(getSessionType() == DefaultSession)
    {
        NRC = serviceNotSupportedInActiveSession;
        if(DiagMSG.msgID == DIAG_ID_Rx_PHY)
        {
            UDS_Service_Response(0x31u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *31服务解锁等级验证
  *@return 负反馈编号
  */
uint8_t UDS_31Service_NRC33(void)
{
    uint8_t NRC = positiveResponse;
    if(getSecurityLevel() == NormalKeyUnlock)
    {
        NRC = positiveResponse;
    }
    else
    {
        NRC = securityAccessDenied;
        UDS_Service_Response(0x31u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }  
    return NRC;
}

/**
  *31服务最小长度验证
  *@return 负反馈编号
  */
uint8_t UDS_31Service_NRC13_MinLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgDLC < 3u)
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x31u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *31服务超出请求范围验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_31Service_NRC31(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *31服务总长度长度验证
  *@return 负反馈编号
  */
uint8_t UDS_31Service_NRC13_TotalLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *31服务条件验证
  *@return 负反馈编号
  */
uint8_t UDS_31Service_NRC22(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *31服务子功能最小长度验证
  *@return 负反馈编号
  */
uint8_t UDS_31Service_Sub_NRC13_MinLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgData.S31Detail.SubID == startRoutine)
    {
        if(DiagMSG.msgDLC < 3u)
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x31u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }
    if(DiagMSG.msgData.S31Detail.SubID == stopRoutine)
    {
        if(DiagMSG.msgDLC < 3u)
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x31u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }
    if(DiagMSG.msgData.S31Detail.SubID == requestRoutineResults)
    {
        if(DiagMSG.msgDLC < 3u)
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x31u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }
    return NRC;
}

/**
  *31服务子功能是否支持验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_31Service_Sub_NRC12(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgData.S31Detail.SubID == startRoutine)
    {
        NRC = positiveResponse;
    }
    else
    {
        NRC = subFunctionNotSupported;
        if(DiagMSG.msgID == DIAG_ID_Rx_PHY)
        {
            UDS_Service_Response(0x31u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
    }
    return NRC;
}

/**
  *31服务子功能会话是否支持验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_31Service_Sub_NRC7E(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *31服务子功能超出请求范围验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_31Service_Sub_NRC31(void)
{
    uint8_t  i;
    uint8_t  NRC = requestOutOfRange;
 //   uint16_t temp = 0u;
    uint8_t count = 0u;
    
    if(GetDoorSta())
    {
        count = DIM(S31DID);
    }
    else
    {
        count = DIM(S31DID) - 1u;
    }
    
    for(i = 0u; i < count; ++i)
    {

      if(getDID(DiagMSG.msgData.S31Detail.DID_H, DiagMSG.msgData.S31Detail.DID_L) == S31DID[i])
        {
           // if(S31DID[i] == WriteMaintenanceODO)
            {
              //  if(DiagMSG.msgDLC == S31DLC[i])
               /* {
                    temp = toUint16_t(DiagMSG.msgData.S31Detail.Data[0], DiagMSG.msgData.S31Detail.Data[1]);
                    if((5000u <= temp) && (temp <= 10000u))
                    {
                        NRC = positiveResponse;
                    }
                }
                else*/
                {
                    NRC = positiveResponse;
                }
            }
           /* else if(S31DID[i] == WriteMaintenanceTime)
            {
                if(DiagMSG.msgDLC == S31DLC[i])
                {
                    temp = toUint16_t(DiagMSG.msgData.S31Detail.Data[0], DiagMSG.msgData.S31Detail.Data[1]);
                    if((90u <= temp) && (temp <= 360u))
                    {
                        NRC = positiveResponse;
                    }
                }
                else
                {
                    NRC = positiveResponse;
                }
            }
            else
            {
                NRC = positiveResponse;
            }
            break;*/
        }
    }
    if((NRC == requestOutOfRange) && (DiagMSG.msgID == DIAG_ID_Rx_PHY))
    {
        UDS_Service_Response(0x31u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    
    return NRC;
}

/**
  *31服务子功能总长度长度验证
  *@return 负反馈编号
  */
uint8_t UDS_31Service_Sub_NRC13_TotalLengthCheck(void)
{
    uint8_t i;
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgData.S31Detail.SubID == startRoutine)
    {
        for(i = 0u; i < DIM(S31DID); ++i)
        {
            if(getDID(DiagMSG.msgData.S31Detail.DID_H, DiagMSG.msgData.S31Detail.DID_L) == S31DID[i])
            {
                if(DiagMSG.msgDLC != S31DLC[i])
                {
                    NRC = incorrectMessageLength;
                    UDS_Service_Response(0x31u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
                }
                else
                {
                    NRC = positiveResponse;
                }
                break;
            }
        }
    }
    if(DiagMSG.msgData.S31Detail.SubID == stopRoutine)
    {
        if(DiagMSG.msgDLC != 3u)
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x31u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }
    if(DiagMSG.msgData.S31Detail.SubID == requestRoutineResults)
    {
        if(DiagMSG.msgDLC != 3u)
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x31u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }
    return NRC;
}

/**
  *31服务子功能请求顺序验证
  *@return 负反馈编号
  */
uint8_t UDS_31Service_Sub_NRC24(void)
{
    uint8_t NRC = positiveResponse;
    if((DiagMSG.msgData.S31Detail.SubID == stopRoutine) && (getDID(DiagMSG.msgData.S31Detail.DID_H, DiagMSG.msgData.S31Detail.DID_L) == 0x62F3u) && (S31DID62F3RequestStatus == 0u))
    {
        NRC = requestSequenceError;
    }
    if((DiagMSG.msgData.S31Detail.SubID == requestRoutineResults) && (getDID(DiagMSG.msgData.S31Detail.DID_H, DiagMSG.msgData.S31Detail.DID_L) == 0x62F3u) && (S31DID62F3RequestStatus == 0u))
    {
        NRC = requestSequenceError;
    }
    return NRC;
}

/**
  *31服务子功能条件验证
  *@return 负反馈编号
  */
uint8_t UDS_31Service_Sub_NRC22(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgData.S31Detail.SubID == startRoutine)
    {
        if(getSpeed() >= 3u)
        {
            NRC = conditionsNotCorrect;
            UDS_Service_Response(0x31u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
        else if(getESpeed() > 400u)
        {
            NRC = conditionsNotCorrect;
            UDS_Service_Response(0x31u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }
    return NRC;
}
