

#ifndef _SOUND_LIST_H_
#define _SOUND_LIST_H_

#include "Sound_Source.h"

/*#define   SND_TOTAL_NUMBER                  89*/

/******************************************************************************
声音列表
******************************************************************************/
enum SoundName
{
    SND_TICK,              /*  tick             */
    SND_TOCK,              /*  tock             */
    SND_RADAR_Changming,   /*  雷达 长鸣        */
    SND_RADAR_1HZ,         /*  雷达 1HZ         */
    SND_RADAR_2HZ,         /*  雷达 2HZ         */
    SND_RADAR_4HZ,         /*  雷达 4HZ         */
    SND_RADAR_2S,          /*  雷达 2S          */
    SND_RADAR_4S,          /*  雷达 4S          */
    SND_RADAR_0S,          /*  雷达 0.5S        */
    SND_RADAR_OK0S,          /*  雷达 0.5S        */
    SND_EPB_Status,        /*  制动液位低       */
    SND_SEATBELT_DR_1HZ,   /*  安全带未系 1HZ   */
    SND_SEATBELT_DR_2HZ,   /*  安全带未系 2HZ   */
    SND_DoorOpen,          /*  车门开报警       */
    SND_DoorOpen_1HZ,      /*  车门开报警 1HZ   */
    SND_EBD_fault,         /*  EBD故障          */
    SND_ABS,               /*  ABS故障          */
    SND_EPS,               /*  EPS故障          */
    SND_Park_Brak,         /*  驻车制动故障          */
    SND_MotorFault,        /*  电机故障         */
    SND_SOC_Fault,         /*  动力电池报警     */
    SND_InsulationFault,   /*  高压绝缘故障     */
    SND_SOC_HT,            /*  电池热失控       */
    SND_Energy_Recovery,   /*  单踏板功能激活   */
    SND_Energy_Recovery_1, /*  单踏板功能激活 1 */
    SND_ECO,               /*  ECO状态激活      */
    SND_READY,             /*  READY状态激活    */
    SND_PowerLimit,        /*  限功率报警       */
    SND_SOC_LP,            /*  蓄电池电量低     */
    SND_SOC_CF,            /*  蓄电池充电故障   */
    SND_SystemFault,       /*  动力系统故障     */
    SND_SystemFault1,       /*  动力系统故障     */
    SND_GearFault,         /*  换挡错误         */
    SND_WeightOverload,    /*  超载报警         */
    SND_WeightOverload2,    /*  超载报警         */
    SND_RemoteLocking,     /*  远程锁车         */
    SND_PositionNotClosed, /*  小灯未关         */
    SND_DepartureReminder, /*  驾驶员离车提醒   */
    SND_OTA_0,             /*  OTA 报警0        */
    SND_OTA_1,             /*  OTA 报警1        */
    SND_OTA_2,             /*  OTA 报警2        */
    SND_OTA_3,             /*  OTA 报警3        */
    SND_OTA_4,             /*  OTA 报警4        */
    SND_OTA_5,             /*  OTA 报警5        */
    SND_ESC,
    SND_Over_Speed,         /*超速报警*/
    SND_TOTAL_NUM,
};

enum
{
    RADAR_SND_MUTE = 0u,
    RADAR_SND_2Hz,
    RADAR_SND_4Hz,
    RADAR_SND_CONTINUOUS,
    RADAR_SND_500MS,
    RADAR_SND_OK500MS,
    RADAR_SND_2S,
    RADAR_SND_Fault,
};
/******************************************************************************
伪声音列表
******************************************************************************/
#define SND_NONE  0xFFu         /*无报警 */
#define SND_RADAR SND_RADAR_2HZ /*雷达音*/

#define SND_TYPE_NORMAL 0x00u /*普通声音类型     */
#define SND_TYPE_MULTI  0x01u /*可多次触发的声音 */
#define SND_TYPE_RADAR  0x02u /*雷达声音         */

#endif