

#ifndef _SOUND_SOURCE_H_
#define _SOUND_SOURCE_H_

#include "stdint.h"

/******************************************************************************
音源名称列表

注意：音源名称所指代的序号应与该声音位于声音属性表中的序号一一对应
******************************************************************************/
enum
{
    SND_SRC_TICK = 0x00u,      /*  tick            */
    SND_SRC_TOCK,              /*  tock            */
    SND_SRC_Radar_Changming,   /*  雷达长鸣         */
    SND_SRC_Radar_1HZ,         /*  雷达 1HZ        */
    SND_SRC_Radar_2HZ,         /*  雷达 2HZ        */
    SND_SRC_Radar_4HZ,         /*  雷达 4HZ        */
    SND_SRC_Radar_2S,          /*  雷达 2S        */
    SND_SRC_Radar_4S,          /*  雷达 4S        */   
    SND_SRC_Radar_0S,          /*  雷达 0S        */ 
    SND_SRC_Radar_OK0S,          /*  雷达 0S        */ 
    SND_SRC_EPB_Status,        /*  制动液位低       */
    SND_SRC_SEATBELT_DR_1HZ,   /*  安全带未系 1HZ   */
    SND_SRC_SEATBELT_DR_2HZ,   /*  安全带未系 2HZ   */
    SND_SRC_DoorOpen,          /*  车门开报警       */
    SND_SRC_DoorOpen_1HZ,      /*  车门开报警 1HZ   */
    SND_SRC_EBD_fault,         /*  EBD故障         */
    SND_SRC_ABS,               /*  ABS故障         */
    SND_SRC_EPS,               /*  EPS故障          */
    SND_SRC_Park_Brak,               /*  驻车制动         */
    SND_SRC_MotorFault,        /*  电机故障         */
    SND_SRC_SOC_Fault,         /*  动力电池报警     */
    SND_SRC_InsulationFault,   /*  高压绝缘故障     */
    SND_SRC_SOC_HT,            /*  电池热失控       */
    SND_SRC_Energy_Recovery,   /*  单踏板功能激活   */
    SND_SRC_Energy_Recovery_1, /*  单踏板功能激活 1HZ 3次  1.4变更新增*/
    SND_SRC_ECO,               /*  ECO状态激活      */
    SND_SRC_READY,             /*  READY状态激活    */
    SND_SRC_PowerLimit,        /*  限功率报警       */
    SND_SRC_SOC_LP,            /*  蓄电池电量低     */
    SND_SRC_SOC_CF,            /*  蓄电池充电故障   */
    SND_SRC_SystemFault,       /*  动力系统故障     */
    SND_SRC_SystemFault1,       /*  动力系统故障     */

    SND_SRC_GearFault,         /*  换挡错误         */
    SND_SRC_WeightOverload,    /*  超载报警         */
    SND_SRC_WeightOverload2,    /*  超载报警         */
    SND_SRC_RemoteLocking,     /*  远程锁车         */
    SND_SRC_PositionNotClosed, /*  小灯未关         */
    SND_SRC_DepartureReminder, /*  驾驶员离车提醒   */
    SND_SRC_OTA_0,             /*  OTA 报警0       */
    SND_SRC_OTA_1,             /*  OTA 报警1       */
    SND_SRC_OTA_2,             /*  OTA 报警2       */
    SND_SRC_OTA_3,             /*  OTA 报警3       */
    SND_SRC_OTA_4,             /*  OTA 报警4       */
    SND_SRC_OTA_5,             /*  OTA 报警5       */
    SND_SRC_ESC,               /*  OTA 报警5       */
    SND_SRC_Over_Speed,        /*  超速报警       */
    SND_SRC_TOTAL_NUM,
};

/******************************************************************************
伪音源名称列表
******************************************************************************/
#define SND_SRC_NONE    0xFFu /*没有声音*/
#define SND_SRC_CURRENT 0xFEu /*当前播放的声音*/

/******************************************************************************
音源循环次数
******************************************************************************/
#define SND_CYCLE_NONSTOP 0xFFu /*不停播放*/

/******************************************************************************
音源播放模式
******************************************************************************/
#define SND_MODE_SINGLE 0x00u /*使用ISD_Play_Vp方法播放*/
#define SND_MODE_LOOP   0x01u /*使用ISD_Play_Vp_Loop方法播放*/

#endif
