#include "Services_Interval.h"
#include "Services_ODO.h"
#include "Common_Interface.h"
#include "Work_Flash.h"
#include "Services_UTC.h"
#include "RTE_TIME.h"
#include "Service_OFF_Time.h"
#include "EOL_Para.h"
#include "CAN_Communication_Matrix.h"
#include "Maintenance.h"
#include "UDS_2EService_Main.h"
#include "Non_volatile_Memorys.h"

_DataInputInterVal Data_Input_InterVal;
#pragma location="BACKUP_RAM_CONTENT"
_DataInterVal Data_Interval_Para;
#pragma location="BACKUP_RAM_CONTENT"
_MYTIME_STRUCT TimerRecord;

#pragma location="BACKUP_RAM_CONTENT"
uint32_t ServiceTimer;
#pragma location="BACKUP_RAM_CONTENT"
uint32_t Servicekm;

uint32_t Services_KM_Back;
uint32_t Services_Timer_Back;

void Data_interval_Geely_Reset(void)
{
    Maintenance_Current_ODO_Set(NVM_ODO_VALUE);
    Maintenance_Reset();
    Maintenance_Flag_Set(0);
}

void Data_interval_Geely_Reset_TYW(void)
{
    Maintenance_Current_ODO_Set(NVM_ODO_VALUE);
    Maintenance_Reset();
    Maintenance_Flag_Set(0);
    Maintenance_First_Interval_Mileage_Set(30000);
    Maintenance_Second_Interval_Mileage_Set(100000 );
}

void Data_Interval_100MS_Cbk(void)
{
    Data_Service_Interval_Processing(); 

    if( Get_7103_Value( ) == 0x01 )
    {
        Maintenance_Reset();
        if ( Data_ODO_Read( ) < 5000 )
        {
            Maintenance_Flag_Set(0);  
        }
        else
        {
            Maintenance_Flag_Set(1);
        }
        Clear7103_Cbk();
    }
}


/* 系统进入休眠之前调用,用于存储系统工作状态下最后的时间,或者首次上电同步 */
void Data_Timer_Record_BeforeSleep(void)
{
    TimerRecord.nYear  = Get_RTC_YEAR();
    TimerRecord.nMonth = Get_RTC_MONTH();
    TimerRecord.nDay   = Get_RTC_DATE();
    TimerRecord.nHour  = Get_RTC_HOUR();
    TimerRecord.nMin   = Get_RTC_MINUTE();
    TimerRecord.nSec   = Get_RTC_SECOND();
}
/*每次唤醒之后,进入主循环之前调用,如果涉及到下电计时,这里可能还要往前提*/
void Data_Timer_Record_Calc(void)
{
    unsigned long int    time1 = 0u;/*其实就是uint32*/
    unsigned long int    time2 = 0u;
    unsigned long int TotalOFFSecond = 0u;
    _MYTIME_STRUCT my_time;

    my_time.nYear  = TimerRecord.nYear;
    my_time.nMonth = TimerRecord.nMonth;
    my_time.nDay   = TimerRecord.nDay;
    my_time.nHour  = TimerRecord.nHour;
    my_time.nMin   = TimerRecord.nMin;
    my_time.nSec   = TimerRecord.nSec;

    time1 = mytime_2_utc_sec(&my_time);

    my_time.nYear  = Get_RTC_YEAR();
    my_time.nMonth = Get_RTC_MONTH();
    my_time.nDay   = Get_RTC_DATE();
    my_time.nHour  = Get_RTC_HOUR();
    my_time.nMin   = Get_RTC_MINUTE();
    my_time.nSec   = Get_RTC_SECOND();

    time2 = mytime_2_utc_sec(&my_time);

    if (time2 >= time1)
    {
        TotalOFFSecond = time2 - time1;
        TotalOFFSecond *= 10u;
        Data_Interval_TimerSleepFix(TotalOFFSecond);
        Service_OFF_Timing_WakeupInit(TotalOFFSecond);
    }

}