#include "MBD_Model.h"
#include "Communication_Over_CAN.h"
#include "EOL_Para.h"
#include "System_Status_Monitor.h"
#include "Common_Interface.h"
#include "Services_ODO.h"
#include "SEG_DISPLAY.h"
#include "AvgVehicleSpeed.h"
#include "Analog_Signals.h"
#include "CAN_APP.h" 



#pragma location ="BACKUP_RAM_CONTENT"
uint16_T IPK_AverageVehicleSpeed;/* '<S1>/AvgVehicleSpeed' */
#pragma location ="BACKUP_RAM_CONTENT"
uint8_T AvgVehicleSpeedValid;   /* '<S1>/AvgVehicleSpeed' */
uint16_T AvgVSpeedTimeCounter = 0u;
extern uint32_t ActualVechileSpeed;

uint8_T Get_EngineValid(void)
{
  return (1u);
}

uint16_T Get_ActualEngineSpeed(void)
{   
    return (1000u);
}
uint16_T Get_DispEngineSpeed(void)
{
    return (1000u);
}

/*车速有效位：有效=1，无效=0*/
uint8_T Get_VechileSpeedValid(void)
{
    uint8_t res;
    uint32_t val;   
    //if((SYS_OPR_STAT_IGN_ON) && \
    //   (CAN_MSG_Status(ID_can0x18FEBF0B_Msg_Count)==0u) && \
    //   (Get_ID_18FEBF0B_Sig_ABSFrontAxleSpeed() <= 0xBC00u))
    //{
    //    val = Get_ID_18FEBF0B_Sig_ABSFrontAxleSpeed() * 10;
    //    val >>= 8;
    //}
    //else
    //{
    //    val = 0u;
    //}  

    if ( (SYS_OPR_STAT_IGN_ON) && (CAN_MSG_Status(ID_can0x18FEBF0B_Msg_Count) == 0u) && (Get_ID_18FEBF0B_Sig_ABSFrontAxleSpeed( ) <= 0xBC00u) )
    {
         
        val = ActualVechileSpeed ;
        if(val >= 1835)
        {
            res = 0u;
        }
        else
        {
            res = 1;
        }
        
    }
    else
    {
        res = 0u;
    }

    return res;
}
/*真实的车速，精度10倍,*/
uint16_T Get_ActualVechileSpeed(void)
{
    uint32_t val;   
    if((SYS_OPR_STAT_IGN_ON) && \
       (CAN_MSG_Status(ID_can0x18FEBF0B_Msg_Count)==0u) && \
       (Get_ID_18FEBF0B_Sig_ABSFrontAxleSpeed() <= 0xBC00u))
    {
        val = Get_ID_18FEBF0B_Sig_ABSFrontAxleSpeed() * 10;
        val >>= 8;
    }
    else
    {
        val = 0u;
    } 
    if(val < 20u)
    {
        val = 0;
    }
    return (uint16_t)val;
}
/*显示车速，精度10倍，取整，舍去小数点*/
uint16_T Get_DispVechileSpeed(void)
{
    uint32_t val = 0;
    if(Get_VechileSpeedValid() == 1u)
    {
        val = ( ActualVechileSpeed * 103u )  / 100u;
    }
    else
    {
        val = 0u;
    }
    if(val >= 1880u)
    {
        val = 1880u;
    }
    return val;
}

/****************平均车速*****************************/
void MBD_AvgVSpeed_KL30Init(void)
{
    AvgVehicleSpeed_initialize(); 
    AvgVehicleSpeed_DW.AvgVSpeedCtrl.KL30Init = 1U;    
}

void AvgVSpeedTimeCounter_100ms(void)
{
    AvgVSpeedTimeCounter++;
}
void MBD_AvgVSpeed_Data_100ms(void)
{
    AvgVehicleSpeed_U.VehicleSpeedIn = Common_Get_Act_V_Speed();
    AvgVehicleSpeed_U.VSpeedValid = Common_Get_Act_V_Speed_Valid();
    
    if(Common_Get_IG_Sts() && (Get_ID_18FAB027_Sig_VCUPTReadyInd()==1u) && (CAN_MSG_Status(ID_can0x18FAB027_Msg_Count)==0u))
    {
        AvgVehicleSpeed_U.EngineValid = Common_Get_Act_E_Speed_Valid();
        AvgVehicleSpeed_U.EngineValue = Common_Get_Act_E_Speed();
    }
    else
    {
        AvgVehicleSpeed_U.EngineValid = 0u;//Common_Get_Act_E_Speed_Valid();
        AvgVehicleSpeed_U.EngineValue = 0u;//Common_Get_Act_E_Speed();
    }
    AvgVehicleSpeed_U.mRollingCounter = Data_MileageRollingCounter_Read();
    AvgVehicleSpeed_U.RTCRollingCounter = AvgVSpeedTimeCounter;
     
    if (Common_Get_IG_Sts())
    {
        AvgVehicleSpeed_U.PowerSt = PowerStatus_ON;
    }
    else
    {
        AvgVehicleSpeed_U.PowerSt = PowerStatus_OFF;
    }
    
    AvgVehicleSpeed_step();   
}

/************* 外发平均车速: 1倍车速 *************/
uint16_T Get_IPK_AverageVehicleSpeed(void)
{
    return IPK_AverageVehicleSpeed;
}
/**** 平均车速有效性：  有效=1，无效=0 **********/
uint8_T Get_AverageVehicleSpeed_Valid(void)
{
    return AvgVehicleSpeedValid;
}








