#ifndef TELLTALES_USER_H
#define TELLTALES_USER_H


#include "stdint.h"


typedef enum
{
    // m_LED_TurnLeft,
    // m_LED_TurnRight,
    m_LED_Hbeam,
    m_LED_Lbeam,
    m_LED_Position,
    m_LED_RearFog,
    m_LED_Daylight,
    m_LED_ABS,
    m_LED_EBD_fault,
    m_LED_BrakeSystemFault,
    m_LED_EPB_Status,
    m_LED_EPS,
    m_LED_SEATBELT_DR,
    m_LED_SOC_CF,
    m_LED_SOC_CC,
    m_LED_SOC_CS,
    m_LED_SOC_LP,
    m_LED_SOC_Fault,
    m_LED_SOC_HT,
    m_LED_SystemFault,
    m_LED_READY,
    m_LED_MotorFault,
    m_LED_PowerLimit,
    m_LED_ECO,
    m_LED_InsulationFault,
    m_LED_Energy_Recovery,
    m_LED_HighPressureInterlock,
    m_LED_DoorOpen,
    m_LED_FrontFog,
    m_LED_RemoteLocking,
    m_LED_MaintainWarning,
    m_LED_MotorOverheating,
    m_LED_SOC_DC,

    LED_Max,
} LED_Idx_t;

typedef enum {
    LED_TurnRight_G = 0u, 
    LED_Position_G,
    LED_Daylight_G,
    LED_READY_G,
    LED_LBeam_G,
    LED_HBeam_B,
    LED_TurnLeft_G,
    LED_InsulationFault_R,
    LED_ReserveLamp_1,
    LED_SOC_CC_R,
    LED_SOC_CS_Y,
    LED_BrakeSystemFault_R,
    LED_SOC_DC_Y,
    LED_SOC_CF_R,
    LED_SOC_HT_R,
    LED_SOC_Fault_R,
    LED_SOC_LP_Y,
    LED_ESP_R,
    LED_ABS_Y,
    LED_EBD_fault_Y,
    LED_RemoteLocking_R,
    LED_Energy_Recovery_W,
    LED_FrontFog,
    LED_Energy_Recovery_G,
    LED_MaintainWarning_W,
    LED_MotorOverheating_R,
    LED_MotorFault_R,
    LED_HighPressureInterlock_R,
    LED_HighPressureInterlock_Y,
    LED_SystemFault_R,
    LED_PowerLimit_Y,
    LED_RearFog_Y,
    LED_EPS_Y,
    LED_SEATBELT_DR_R,
    LED_DoorOpen_R,
    LED_ECO_G,

    LED_NumMax,
}LED_Attr_en_t;

typedef struct 
{
    uint8_t chip;
    uint8_t channel;
    uint8_t brightness;
}LED_Attr_st_t;



void Telltales_Init(void);
uint32_t Get_PowerON_Timer(void);
uint32_t Get_PowerOFF_Timer(void);
void LED_PowerTimer_Service(uint32_t timer);
void Telltales_Left_Right_Management_Service(void);
void TYW_check(void);
#endif

