#include "Include.h"

BL_PWMCaptureStruct  BL_PWMCapture;
BlPWMFilterStruct   BlPWMFilter;
BlOFFCtrlStruct     BlOFFCtrl;
BackLightCtrlStruct BackLightCtrl ; 

volatile uint8_t    BLPWMDutyCycle;
uint8_t             BlTurnOnDelay;
uint8_t Bl_Time = 0;
void Backlight_Init(void )
{
	BLPWMDutyCycle      = 53;
	BlPWMFilter.Current = 53 ;
	BlPWMFilter.Current_Last = 53;
	BlPWMFilter.Current_Dir = 0;
	BlPWMFilter.InitTimer  = 0;
//	BlPWMFilter.Backup     = 0xFF;
	BlPWMFilter.BackupCnt  = 0;
	BlPWMFilter.Ptr        = 0;
	BlPWMFilter.Cnt        = 0;

	BL_PWMCapture.Backup    = 0;
	BL_PWMCapture.Timer     = 0;
	BL_PWMCapture.HiLvTimer = 0;
}

void Dial_Backlight_Set(INT8U duty)
{
    PWM_Channel_Set_Duty(PWM_CH7_PIN36_PP7, duty);
}

void TFT_Backlight_Set(INT8U duty)
{
    PWM_Channel_Set_Duty(PWM_CH5_PIN34_PP5, duty);
}


void BL_PWM_Duty_Cycle_Capture_ISR(void)
{
	uint16_t Time = 0;
	uint16_t HiLvTime = 0;

	if ((Get_CAN_CH0_ID_18FE4021_Sig_BCM_TractorMarkerLight() ==1) ||(Get_CAN_CH0_ID_18FE4021_Sig_BCM_TractorMarkerLight() == 2))    //λ�õƴ�ʱ�Ž���PWM
	{
		BL_PWMCapture.Timer++;	     //50us��1��	100HZ ����   ��¼��ʱ��

		if ( BACKLIGHT_IN_P )
		{
			BL_PWMCapture.HiLvTimer++;  //������ʱ���ʱ����

			if ( BL_PWMCapture.Backup == 0 )//��1���0��ʱ�򣬼�¼�����صĴ�������ʱ��
			{
				Time = BL_PWMCapture.Timer;
				HiLvTime = BL_PWMCapture.HiLvTimer;

				HiLvTime *= 100;
				HiLvTime /= Time;

				if ( HiLvTime > 100 )
				HiLvTime = 100;

				BLPWMDutyCycle = ( uint8_t ) HiLvTime;

				BL_PWMCapture.Timer = 0;
				BL_PWMCapture.HiLvTimer = 0;
			}
		}

		BL_PWMCapture.Backup = BACKLIGHT_IN_P;
	}
	else
	{
		BL_PWMCapture.Backup    = 0;
		BL_PWMCapture.Timer     = 0;
		BL_PWMCapture.HiLvTimer = 0;
	}
}



INT8U Bl_Buf[15] = {0};
INT8U k = 0;
INT8U Get_Filter = 0;
void BL_PWMDutyCycle_Filter_Get(void)
{
	if((Get_CAN_CH0_ID_18FE4021_Sig_BCM_TractorMarkerLight() ==1) ||(Get_CAN_CH0_ID_18FE4021_Sig_BCM_TractorMarkerLight() == 2))
	{
		INT8U i = 0;
		INT8U j = 0;
		INT8U temp = 0;
		Bl_Buf[k] = BL_PWM_DUTY_CYCLE;
		k++;
		if(k >= 14)
		{
			k = 0;
		}
		for (i = 0; i < 14; i++)
		{
			for (j = 0; j < (15 - i - 1); j++)
        	{
        	    if (Bl_Buf[j] > Bl_Buf[j + 1]) 
				{
        	        temp = Bl_Buf[j]; 
					Bl_Buf[j] = Bl_Buf[j + 1]; 
					Bl_Buf[j + 1] = temp;
        	    }
        	}
		}
		Get_Filter = (Bl_Buf[4] + Bl_Buf[5] + Bl_Buf[6]) / 3;
		if((Bl_Time++) >= 20)
		{
			if((Get_Filter - BlPWMFilter.Current) >= 2)
			{	
				BlPWMFilter.Current = Get_Filter;	
			}
			if((BlPWMFilter.Current - Get_Filter) >= 2)
			{	
				BlPWMFilter.Current = Get_Filter;	
			}	
			
			Bl_Time = 0;
		}
		

		if(BlPWMFilter.Current < 10)	
		{
			BlPWMFilter.Current = 10;
		}
		if(BlPWMFilter.Current > 95)	
		{
			BlPWMFilter.Current = 95;
		}
	}
}

INT8U BL_PWM_Duty_Get(INT8U Level)
{
	INT8U  Duty;
	if(Level == 0)
	{
		Duty = 10;	
	}
	else if((Level <= 7 ) &&(Level > 0))
	{
		Duty = Level*10;				
	}
	else
	{
		Duty = 100;		
	}
	
	return Duty;
}

INT8U BL_PWM_Level_Get(INT8U Duty)
{
	INT8U Level; 
	
	if(BlPWMFilter.Current_Last != Duty )
	{
		if(Duty > BlPWMFilter.Current_Last )
		{
			BlPWMFilter.Current_Dir = 0;	
		}
		else
		{
			BlPWMFilter. Current_Dir= 1;	
		}
		BlPWMFilter.Current_Last = Duty ;
	}

	if(BlPWMFilter. Current_Dir)//��С
	{
		if(Duty <= 18+1)
		{
			Level = 1;	
		}
		else if(Duty <= 28+2)
		{
			Level = 2;		
		}
		else if(Duty <= 38+3)
		{
			Level = 3;		
		}
		else if(Duty <= 48+3)
		{
			Level = 4;		
		}
		else if(Duty <= 58+3)
		{
			Level = 5;		
		}
		else if(Duty <= 68+5)
		{
			Level = 6;		
		}
		else if(Duty <= 78+5)
		{
			Level = 7;		
		}
		else 
		{
			Level = 8;		
		}
	}
	else //����
	{
		if(Duty >= 80+4)
		{
			Level = 8;	
		}
		else if(Duty >= 70+4)
		{
			Level = 7;		
		}
		else if(Duty >= 60+3)
		{
			Level = 6;		
		}
		else if(Duty >= 50+3)
		{
			Level = 5;		
		}
		else if(Duty >= 40+3)
		{
			Level = 4;		
		}
		else if(Duty >= 30+2)
		{
			Level = 3;		
		}
		else if(Duty >= 20+2)
		{
			Level = 2;		
		}
		else if(Duty >= 19+1)
		{
			Level = 1;		
		}
		else  
		{
			Level = 1;		
		}	
	}

	return Level;
}  
INT16U PopupAlarm_Cur ;
void BL_Management_service(void)
{
 
       	PopupAlarm_Cur = Popup_Get_Current_Message(); 
	if(SYS_OPR_STAT_HALT)
	{
		Dial_Backlight_Set(0);
		TFT_Backlight_Set(0);
		
		return;
	}
	
	BL_PWMDutyCycle_Filter_Get();
	BackLightCtrl.Level = BL_PWM_Level_Get(BlPWMFilter.Current);
	BackLightCtrl.Duty = BL_PWM_Duty_Get(BackLightCtrl.Level);
	
 	if(SYS_OPR_STAT_IGN_ON)
 	{
 		if((Get_CAN_CH0_ID_18FE4021_Sig_BCM_TractorMarkerLight() ==1) ||(Get_CAN_CH0_ID_18FE4021_Sig_BCM_TractorMarkerLight() == 2))
 		{
 			Dial_Backlight_Set(	BackLightCtrl.Duty );
 			TFT_Backlight_Set(	BackLightCtrl.Duty );
 		}
 		else
 		{
			Dial_Backlight_Set(100);
			TFT_Backlight_Set(100);	
 		}
 	}
 	else
 	{
 		if(PopupAlarm_Cur < POPUP_MSG_MAX)      //��ǰ����
 		{ 			
 		
				if((Get_CAN_CH0_ID_18FE4021_Sig_BCM_TractorMarkerLight() ==1) ||(Get_CAN_CH0_ID_18FE4021_Sig_BCM_TractorMarkerLight() == 2))
				{
					Dial_Backlight_Set(0);
					TFT_Backlight_Set(	BackLightCtrl.Duty );

				}
				else
				{
 				         Dial_Backlight_Set(0);
 					TFT_Backlight_Set(100);
 					
				}
 		
 		}
 		else
 		{
 			Dial_Backlight_Set(0);
 			TFT_Backlight_Set(0);	
 		}   
 	}
}