#ifndef _POWER_MANAGEMENT_H_
#define _POWER_MANAGEMENT_H_

typedef unsigned char INT8U;
typedef unsigned int INT16U;
typedef unsigned long INT32U;

  #define BusSleep_Wait_Mode_Time 50//1    00MSΪ��λ      5S


typedef enum
{
    _Power_Normal = 0, //ѹ״̬Χ
    _Power_High,       //ѹ
    _Power_Low,        //ѹ
} _Power_Status;

typedef enum
{
    _IGN_OFF = 0,
    _IGN_Sleep,
    _IGN_ON,

} _IGN_Status;
typedef struct
{
	_Power_Status Mode;
	INT16U Low_Vo_Timer;
	INT16U Normal_Vo_Timer;
	INT16U High_Vo_Timer;
} SysPwrModeStruct;
extern SysPwrModeStruct SysPwrMode;


extern _IGN_Status g_PowerIGN;

#define   SYS_OPR_STAT_HALT                 (SysPwrMode.Mode != _Power_Normal)
#define   SYS_OPR_Noraml                 (SysPwrMode.Mode == _Power_Normal)



#define   SYS_OPR_STAT_IGN_ON               (g_PowerIGN == _IGN_ON)       
#define   SYS_OPR_STAT_IGN_OFF         (g_PowerIGN == _IGN_OFF)




extern     volatile uint16_t AnalogKL30Voltage;
extern     volatile uint16_t AnalogKL15Voltage;



extern INT16U Power_OFF_Delay_Time;//OFFʱߵģʱ  
extern uint8_t  LAST_SYS_OPR_STAT_HALT;
extern INT16U Bus_Sleep_Mode_Delay_Time ;


//extern SysSignalStatusStruct SysKL15Signal;

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 //Դʼ
extern void Power_Management_Init(void);
// ѭʵʱ
extern void Power_Management_Service(void);
//ֱ3015ѹֵ//mvλ
extern void Power_Status_Update_Service(INT16U Voltage_KL30, INT16U Voltage_KL15);
//extern INT8U Power_Get_KL15signal(void);
extern void Power_Management_Time_Handle(void);
extern void Power_KL15_Voltage_Conversion(void);
extern void Power_KL30_Voltage_Conversion(void);
extern void Power_HALT_Service(void) ;

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
       
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////////

#endif