/************************************************ ******************************
  Flash_synchronizer.h
˸ͬźŷļ
    ߣ
    V1.0
    ڣ2017.04.02
******************************************************************************/
#include "Include.h"



const uint8_t FlashSync1HzTable[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                     1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                                     0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                     1, 1, 1, 1, 1, 1, 1, 1, 1, 1,};
                                     
const uint8_t FlashSync2HzTable[] = {0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
                                     0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
                                     0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
                                     0, 0, 0, 0, 0, 1, 1, 1, 1, 1,};
                                     
const uint8_t FlashSync5HzTable[] = {0, 0, 1, 1, 0, 0, 1, 1, 0, 0,
                                     1, 1, 0, 0, 1, 1, 0, 0, 1, 1,
                                     0, 0, 1, 1, 0, 0, 1, 1, 0, 0,
                                     1, 1, 0, 0, 1, 1, 0, 0, 1, 1,};
                                     
const uint8_t FlashSync0_5HzTable[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                     0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                     1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                                     1, 1, 1, 1, 1, 1, 1, 1, 1, 1,};                                   

uint8_t FlashTimer;

/******************************************************************************
Flash_Sync_Signal_Generation_Service
  ܣ˸ͬźŷ
  
ֵ
*******************************************************************************
ע  ⣺÷ÿ50msһ
******************************************************************************/
void Flash_Sync_Signal_Generation_Service(void)      
{
	FlashTimer++;       //50msһ   1
	if (FlashTimer >= 40)
	FlashTimer = 0;
  
	FLASH_SYNC_1Hz = FlashSync1HzTable[FlashTimer]; //500ms
	FLASH_SYNC_2Hz = FlashSync2HzTable[FlashTimer]; //250ms
	FLASH_SYNC_5Hz = FlashSync5HzTable[FlashTimer]; //100ms
	FLASH_SYNC_0_5Hz = FlashSync0_5HzTable[FlashTimer];
  
	if(FLASH_SYNC_1Hz)
	{
		g_u8LampBlink_1HZ = Lamp_On;
		g_u8LampBlink_fuel_1HZ	 = Lamp_FuelOn;
	}
	else
	{
		g_u8LampBlink_1HZ = Lamp_Off;	
		g_u8LampBlink_fuel_1HZ	 = Lamp_Off;
	}
	
	if(FLASH_SYNC_2Hz)
	{
		g_u8LampBlink_2HZ = Lamp_On;
	}
	else
	{
		g_u8LampBlink_2HZ = Lamp_Off;	
	}
	
	if(FLASH_SYNC_5Hz)
	{
		g_u8LampBlink_5HZ = Lamp_On;
	}
	else
	{
		g_u8LampBlink_5HZ = Lamp_Off;	
	}
	
	if(FLASH_SYNC_5Hz)
	{
		g_u8LampBlink_0_5HZ = Lamp_On;
	}
	else
	{
		g_u8LampBlink_0_5HZ = Lamp_Off;	
	}

	


}