#include "UDS_2FService_Filter.h"

const uint8_t  S2FDLC[] = {4, 5, 4};
const uint16_t S2FDID[] = {0x62E1u, 0x62E2u, 0x62E4u};

/**
  *2FǷֹ֧Ѱַ
  *Ѱַθø
  *@return 
  */
uint8_t UDS_2FService_NRC11(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgID == DIAG_ID_Rx_FUN)
    {
        NRC = serviceNotSupported;
    }
    return NRC;
}

/**
  *2FỰǷ֧֤
  *Ѱַθø
  *@return 
  */
uint8_t UDS_2FService_NRC7F(void)
{
    uint8_t NRC = positiveResponse;
    if(getSessionType() == DefaultSession)
    {
        NRC = serviceNotSupportedInActiveSession;
        if(DiagMSG.msgID == DIAG_ID_Rx_PHY)
        {
            UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *2Fȼ֤
  *@return 
  */
uint8_t UDS_2FService_NRC33(void)
{
    uint8_t NRC = positiveResponse;
    if(getSecurityLevel() == NormalKeyUnlock)
    {
        NRC = positiveResponse;
    }
    else
    {
        NRC = securityAccessDenied;
        UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }  
    return NRC;
}

/**
  *2FС֤
  *@return 
  */
uint8_t UDS_2FService_NRC13_MinLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgDLC < 3u)
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *2F񳬳Χ֤
  *Ѱַθø
  *@return 
  */
uint8_t UDS_2FService_NRC31(void)
{
    uint8_t NRC = requestOutOfRange;
    /*if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0x62E1u)
    {
        if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
        {
            NRC = positiveResponse;
        }
        if(DiagMSG.msgData.DidDetail.Data[0] == 3u)
        {
            if((DiagMSG.msgData.DidDetail.Data[1] == 0x00u) || (DiagMSG.msgData.DidDetail.Data[1] == 0xFFu))
            {
                NRC = positiveResponse;
            }
        }
    }
    if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0x62E2u)
    {
        if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
        {
             NRC = positiveResponse;
        }
        if(DiagMSG.msgData.DidDetail.Data[0] == 3u)
        {
            if((DiagMSG.msgData.DidDetail.Data[1] >= 0x01u) && (DiagMSG.msgData.DidDetail.Data[1] <= 0x04u))
            {
                if(DiagMSG.msgData.DidDetail.Data[2] <= 0x02u)
                {
                    NRC = positiveResponse;
                }
            }
        }
    }
    if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0x62E4u)
    {
        if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
        {
            NRC = positiveResponse;
        }
        if(DiagMSG.msgData.DidDetail.Data[0] == 3u)
        {
            if((DiagMSG.msgData.DidDetail.Data[1] == 0x00u) || (DiagMSG.msgData.DidDetail.Data[1] == 0xFFu))
            {
                NRC = positiveResponse;
            }
        }
    }
    if((NRC == requestOutOfRange) && (DiagMSG.msgID == DIAG_ID_Rx_PHY))
    {
        UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }*/
    return NRC;
}

/**
  *2Fܳȳ֤
  *@return 
  */
uint8_t UDS_2FService_NRC13_TotalLengthCheck(void)
{
    uint8_t i;
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
    {
        if(DiagMSG.msgDLC != 3u)
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
    }
    else
    {
        /*for(i = 0u; i < DIM(S2FDID); ++i)
        {
            if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == S2FDID[i])
            {
                if(DiagMSG.msgDLC != S2FDLC[i])
                {
                    NRC = incorrectMessageLength;
                    UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
                }
                else
                {
                    NRC = positiveResponse;
                }
                break;
            }
        } */
    }
    return NRC;
}

/**
  *2F֤
  *@return 
  */
uint8_t UDS_2FService_NRC22(void)
{
    uint8_t NRC = positiveResponse;
    if(getSpeed() > 0u)
    {
        NRC = conditionsNotCorrect;
        UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    return NRC;
}
