/******************************************************************************
�� �� ����CLOCK.h
����������ʱ��ϵͳ���ü���ʼ��ͷ�ļ�
��    �ߣ�����
��    ����V1.0
��    �ڣ�2016.11.2
******************************************************************************/

#ifndef _CRG_H_
#define _CRG_H_

/******************************************************************************
ʱ��Ƶ��
******************************************************************************/
#define    OSCCLK                        8000000             /* ����Ƶ�� */
#define    BUSCLK                       32000000             /* ����Ƶ�� */
#define    PLLCLK                     BUSCLK * 2             /* PLL Ƶ�� */

/******************************************************************************
αͣ��(Pseudo Stop)ģʽʹ��
******************************************************************************/
#define    CRG_USE_PSEUDO_STOP_MODE            1

/******************************************************************************
ͣ��״̬��־
******************************************************************************/
//EXTERN    volatile uint8_t CRGStopMode;
//#define    CRG_STOP_MODE                       CRGStopMode

/******************************************************************************
���Ź���ʱ����ѡ��
******************************************************************************/
#define   WDT_PERIOD     WDT_PERIOD_4194304xTosc


/******************************************************************************
���Ź���ʱ����
******************************************************************************/
#define    WDT_PERIOD_INVALID               0x00     /* ��Ч����,�ر� WDT */
#define    WDT_PERIOD_16384xTosc            0x01     /* 2^14 ��OSCCLK���� */
#define    WDT_PERIOD_65536xTosc            0x02     /* 2^16 ��OSCCLK���� */
#define    WDT_PERIOD_262144xTosc           0x03     /* 2^18 ��OSCCLK���� */
#define    WDT_PERIOD_1048576xTosc          0x04     /* 2^20 ��OSCCLK���� */
#define    WDT_PERIOD_4194304xTosc          0x05     /* 2^22 ��OSCCLK���� */
#define    WDT_PERIOD_8388608xTosc          0x06     /* 2^23 ��OSCCLK���� */
#define    WDT_PERIOD_16777216xTosc         0x07     /* 2^24 ��OSCCLK���� */

/******************************************************************************
ʱ��Ƶ��������,��оƬ�ͺŶ���
******************************************************************************/
//����Ƶ��������
#define    OSCCLK_MIN                    4000000
#define    OSCCLK_MAX                   16000000

//PLL�ο�Ƶ��������
#define    REFCLK_MIN                    1000000
#define    REFCLK_MAX                   40000000

//PLLѹ������Ƶ��������
#define    VCOCLK_MIN                   32000000
#define    VCOCLK_MAX                  120000000

/******************************************************************************
���Ź���λ�궨��
******************************************************************************/
#define    wdt_reset()        __RESET_WATCHDOG()

/******************************************************************************
RTI��ʱ�ṹ
******************************************************************************/
typedef struct
{
  uint16_t  RollingCounter;
  uint16_t  BackupCounter;
  uint16_t  Year;
  uint16_t  BackupYear;
  uint8_t   Month;
  uint8_t   Date;
  uint8_t   Hour;
  uint8_t   Minute;
  uint8_t   Second;
  uint8_t   LeapYear;
}RTITimingStruct;



#define   RTC_ROLLING_COUNTER               RealTimeClock.RollingCounter
#define   RTC_YEAR                          RealTimeClock.Year
#define   RTC_MONTH                         RealTimeClock.Month
#define   RTC_DATE                          RealTimeClock.Date
#define   RTC_HOUR                          RealTimeClock.Hour
#define   RTC_MINUTE                        RealTimeClock.Minute
#define   RTC_SECOND                        RealTimeClock.Second
#define   RTC_LEAP_YEAR                     RealTimeClock.LeapYear

/******************************************************************************
ʱ��Ĭ��ʱ��
******************************************************************************/
#define   RTC_DEFAULT_YEAR                  1985
#define   RTC_DEFAULT_MONTH               1
#define   RTC_DEFAULT_DATE                  1
#define   RTC_DEFAULT_HOUR                  0
#define   RTC_DEFAULT_MINUTE                0
#define   RTC_DEFAULT_SECOND                0

EXTERN   volatile RTITimingStruct RealTimeClock;
EXTERN  uint8_t TIME_100MS;      
/******************************************************************************
��������
******************************************************************************/
void WDT_Init(void);
void Clock_Init(void);
void CheckOSC(void);
void Enter_Stop_Mode(void);
void RTI_Init(void);
void RTI_Timing_Service(void);
uint8_t Determine_Leap_Year(uint16_t Year);
void WDT_Reset_Service(void);
#endif
